/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

public class MakeOverriddenMemberOpenFix
extends JetIntentionAction<JetDeclaration> {
    private final List<JetCallableDeclaration> overriddenNonOverridableMembers;
    private final List<String> containingDeclarationsNames;

    public MakeOverriddenMemberOpenFix(@NotNull JetDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/quickfix/MakeOverriddenMemberOpenFix", "<init>"));
        }
        super(declaration);
        this.overriddenNonOverridableMembers = new ArrayList<JetCallableDeclaration>();
        this.containingDeclarationsNames = new ArrayList<String>();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/MakeOverriddenMemberOpenFix", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, file) || !(file instanceof JetFile)) {
            return false;
        }
        this.overriddenNonOverridableMembers.clear();
        this.containingDeclarationsNames.clear();
        DeclarationDescriptor descriptor2 = ResolvePackage.resolveToDescriptor((JetDeclaration)this.element);
        if (!(descriptor2 instanceof CallableMemberDescriptor)) {
            return false;
        }
        for (CallableMemberDescriptor overriddenDescriptor : MakeOverriddenMemberOpenFix.getAllDeclaredNonOverridableOverriddenDescriptors((CallableMemberDescriptor)descriptor2)) {
            assert (overriddenDescriptor.getKind() == CallableMemberDescriptor.Kind.DECLARATION) : "Can only be applied to declarations.";
            PsiElement overriddenMember = DescriptorToSourceUtils.descriptorToDeclaration(overriddenDescriptor);
            if (overriddenMember == null || !QuickFixUtil.canModifyElement(overriddenMember) || !(overriddenMember instanceof JetCallableDeclaration)) {
                return false;
            }
            String containingDeclarationName = overriddenDescriptor.getContainingDeclaration().getName().asString();
            this.overriddenNonOverridableMembers.add((JetCallableDeclaration)overriddenMember);
            this.containingDeclarationsNames.add(containingDeclarationName);
        }
        return this.overriddenNonOverridableMembers.size() > 0;
    }

    @NotNull
    private static Collection<CallableMemberDescriptor> getAllDeclaredNonOverridableOverriddenDescriptors(@NotNull CallableMemberDescriptor callableMemberDescriptor) {
        if (callableMemberDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMemberDescriptor", "org/jetbrains/kotlin/idea/quickfix/MakeOverriddenMemberOpenFix", "getAllDeclaredNonOverridableOverriddenDescriptors"));
        }
        HashSet result2 = Sets.newHashSet();
        Collection<CallableMemberDescriptor> nonOverridableOverriddenDescriptors = MakeOverriddenMemberOpenFix.retainNonOverridableMembers(callableMemberDescriptor.getOverriddenDescriptors());
        for (CallableMemberDescriptor overriddenDescriptor : nonOverridableOverriddenDescriptors) {
            CallableMemberDescriptor.Kind kind2 = overriddenDescriptor.getKind();
            if (kind2 == CallableMemberDescriptor.Kind.DECLARATION) {
                result2.add(overriddenDescriptor);
                continue;
            }
            if (kind2 == CallableMemberDescriptor.Kind.FAKE_OVERRIDE || kind2 == CallableMemberDescriptor.Kind.DELEGATION) {
                result2.addAll(MakeOverriddenMemberOpenFix.getAllDeclaredNonOverridableOverriddenDescriptors(overriddenDescriptor));
                continue;
            }
            if (kind2 == CallableMemberDescriptor.Kind.SYNTHESIZED) continue;
            throw new UnsupportedOperationException("Unexpected callable kind " + (Object)((Object)kind2));
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/MakeOverriddenMemberOpenFix", "getAllDeclaredNonOverridableOverriddenDescriptors"));
        }
        return hashSet;
    }

    @NotNull
    private static Collection<CallableMemberDescriptor> retainNonOverridableMembers(@NotNull Collection<? extends CallableMemberDescriptor> callableMemberDescriptors) {
        if (callableMemberDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMemberDescriptors", "org/jetbrains/kotlin/idea/quickfix/MakeOverriddenMemberOpenFix", "retainNonOverridableMembers"));
        }
        List list = ContainerUtil.filter(callableMemberDescriptors, (Condition)new Condition<CallableMemberDescriptor>(){

            public boolean value(CallableMemberDescriptor descriptor2) {
                return !descriptor2.getModality().isOverridable();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/MakeOverriddenMemberOpenFix", "retainNonOverridableMembers"));
        }
        return list;
    }

    @NotNull
    public String getText() {
        if (this.overriddenNonOverridableMembers.size() == 1) {
            String string = JetBundle.message("make.element.modifier", new Object[]{this.containingDeclarationsNames.get(0) + "." + ((JetDeclaration)this.element).getName(), JetTokens.OPEN_KEYWORD});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/MakeOverriddenMemberOpenFix", "getText"));
            }
            return string;
        }
        StringBuilder declarations2 = new StringBuilder();
        Collections.sort(this.containingDeclarationsNames);
        for (int i = 0; i < this.containingDeclarationsNames.size() - 2; ++i) {
            declarations2.append(this.containingDeclarationsNames.get(i));
            declarations2.append(", ");
        }
        declarations2.append(this.containingDeclarationsNames.get(this.containingDeclarationsNames.size() - 2));
        declarations2.append(" and ");
        declarations2.append(this.containingDeclarationsNames.get(this.containingDeclarationsNames.size() - 1));
        String string = JetBundle.message("make.element.in.classifiers.open", ((JetDeclaration)this.element).getName(), declarations2.toString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/MakeOverriddenMemberOpenFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("add.modifier.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/MakeOverriddenMemberOpenFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/MakeOverriddenMemberOpenFix", "invoke"));
        }
        for (JetCallableDeclaration overriddenMember : this.overriddenNonOverridableMembers) {
            overriddenMember.addModifier(JetTokens.OPEN_KEYWORD);
        }
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactory() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/MakeOverriddenMemberOpenFix$2", "createAction"));
                }
                JetDeclaration declaration = QuickFixUtil.getParentElementOfType(diagnostic, JetDeclaration.class);
                assert (declaration != null);
                return new MakeOverriddenMemberOpenFix(declaration);
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/MakeOverriddenMemberOpenFix", "createFactory"));
        }
        return jetSingleIntentionActionFactory;
    }
}

