/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class KotlinFileStubImpl
extends PsiFileStubImpl<JetFile>
implements KotlinFileStub,
PsiClassHolderFileStub<JetFile> {
    private final StringRef packageName;
    private final boolean isScript;

    public KotlinFileStubImpl(JetFile jetFile, @NotNull StringRef packageName, boolean isScript) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl", "<init>"));
        }
        super((PsiFile)jetFile);
        this.packageName = packageName;
        this.isScript = isScript;
    }

    public KotlinFileStubImpl(JetFile jetFile, @NotNull String packageName, boolean isScript) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl", "<init>"));
        }
        this(jetFile, StringRef.fromString((String)packageName), isScript);
    }

    @Override
    @NotNull
    public FqName getPackageFqName() {
        FqName fqName2 = new FqName(StringRef.toString((StringRef)this.packageName));
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl", "getPackageFqName"));
        }
        return fqName2;
    }

    @Override
    public boolean isScript() {
        return this.isScript;
    }

    public IStubFileElementType getType() {
        return JetStubElementTypes.FILE;
    }

    public String toString() {
        return "PsiJetFileStubImpl[package=" + this.getPackageFqName().asString() + "]";
    }

    public PsiClass[] getClasses() {
        ArrayList result2 = Lists.newArrayList();
        for (StubElement child : this.getChildrenStubs()) {
            if (!(child instanceof PsiClassStub)) continue;
            result2.add((PsiClass)child.getPsi());
        }
        return result2.toArray(new PsiClass[result2.size()]);
    }
}

