/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.types.JetType;

public class CharValue
extends IntegerValueConstant<Character> {
    public CharValue(char value2, boolean canBeUsedInAnnotations, boolean pure, boolean usesVariableAsConstant) {
        super(Character.valueOf(value2), canBeUsedInAnnotations, pure, usesVariableAsConstant);
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "org/jetbrains/kotlin/resolve/constants/CharValue", "getType"));
        }
        JetType jetType = kotlinBuiltIns.getCharType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/CharValue", "getType"));
        }
        return jetType;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor2, D data2) {
        return visitor2.visitCharValue(this, data2);
    }

    public String toString() {
        return String.format("\\u%04X ('%s')", ((Character)this.value).charValue(), CharValue.getPrintablePart(((Character)this.value).charValue()));
    }

    private static String getPrintablePart(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
        }
        return CharValue.isPrintableUnicode(c) ? Character.toString(c) : "?";
    }

    private static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }
}

