/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.SvnEditCommitMessageAction;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;

public class SvnEditCommitMessageFromFileHistoryAction
extends AnAction {
    public SvnEditCommitMessageFromFileHistoryAction() {
        super("Edit Revision Comment", "Edit revision comment. Previous message is rewritten.", AllIcons.Actions.Edit);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        final VcsKey vcsKey = (VcsKey)e.getData(VcsDataKeys.VCS);
        if (vcsKey == null || !SvnVcs.getKey().equals((Object)vcsKey)) {
            return;
        }
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        final VirtualFile revisionVirtualFile = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        if (revision == null || revisionVirtualFile == null) {
            return;
        }
        final SvnFileRevision svnFileRevision = (SvnFileRevision)revision;
        final Consumer listener = (Consumer)VcsDataKeys.REMOTE_HISTORY_CHANGED_LISTENER.getData(e.getDataContext());
        SvnEditCommitMessageAction.askAndEditRevision(svnFileRevision.getRevision().getNumber(), svnFileRevision.getCommitMessage(), (SvnRepositoryLocation)svnFileRevision.getChangedRepositoryPath(), project, new Consumer<String>(){

            public void consume(final String newMessage) {
                svnFileRevision.setCommitMessage(newMessage);
                if (listener != null) {
                    listener.consume((Object)newMessage);
                }
                ProjectLevelVcsManager.getInstance((Project)project).getVcsHistoryCache().editCached(VcsUtil.getFilePath((VirtualFile)revisionVirtualFile), vcsKey, (Consumer)new Consumer<List<VcsFileRevision>>(){

                    public void consume(List<VcsFileRevision> revisions) {
                        for (VcsFileRevision fileRevision : revisions) {
                            if (!(fileRevision instanceof SvnFileRevision) || ((SvnFileRevision)fileRevision).getRevision().getNumber() != svnFileRevision.getRevision().getNumber()) continue;
                            ((SvnFileRevision)fileRevision).setCommitMessage(newMessage);
                            break;
                        }
                    }
                });
            }
        }, true);
    }

    public void update(AnActionEvent e) {
        VcsKey vcsKey = (VcsKey)e.getData(VcsDataKeys.VCS);
        boolean isSvn = SvnVcs.getKey().equals((Object)vcsKey);
        e.getPresentation().setVisible(isSvn);
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        e.getPresentation().setEnabled(isSvn && revision != null);
    }
}

