/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl.configuration;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.config.impl.AntReference;
import com.intellij.lang.ant.config.impl.GlobalAntConfiguration;
import com.intellij.lang.ant.config.impl.configuration.AnActionListEditor;
import com.intellij.lang.ant.config.impl.configuration.AntClasspathEditorPanel;
import com.intellij.lang.ant.config.impl.configuration.AntUIUtil;
import com.intellij.lang.ant.config.impl.configuration.EditPropertyContainer;
import com.intellij.lang.ant.config.impl.configuration.UIPropertyBinding;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBSplitter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.HashMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AntSetPanel {
    private final Form myForm;
    private final GlobalAntConfiguration myAntConfiguration;

    public AntSetPanel() {
        this(GlobalAntConfiguration.getInstance());
    }

    AntSetPanel(GlobalAntConfiguration antConfiguration) {
        this.myAntConfiguration = antConfiguration;
        this.myForm = new Form(antConfiguration);
    }

    @Nullable
    public AntInstallation showDialog(JComponent parent) {
        MyDialog dialog = new MyDialog(parent);
        if (!dialog.showAndGet()) {
            return null;
        }
        this.apply();
        return this.myForm.getSelectedAnt();
    }

    void reset() {
        this.myForm.setAnts(this.myAntConfiguration.getConfiguredAnts().values());
    }

    void apply() {
        for (AntInstallation ant : this.myForm.getRemovedAnts()) {
            this.myAntConfiguration.removeConfiguration(ant);
        }
        Map<AntReference, AntInstallation> currentAnts = this.myAntConfiguration.getConfiguredAnts();
        for (AntInstallation installation : currentAnts.values()) {
            installation.updateClasspath();
        }
        for (AntInstallation ant : this.myForm.getAddedAnts()) {
            this.myAntConfiguration.addConfiguration(ant);
        }
        this.myForm.applyModifications();
    }

    public void setSelection(AntInstallation antInstallation) {
        this.myForm.selectAnt(antInstallation);
    }

    public JComponent getComponent() {
        return this.myForm.getComponent();
    }

    private class MyDialog
    extends DialogWrapper {
        public MyDialog(JComponent parent) {
            super((Component)parent, true);
            this.setTitle(AntBundle.message("configure.ant.dialog.title", new Object[0]));
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return AntSetPanel.this.myForm.getComponent();
        }

        @NonNls
        protected String getDimensionServiceKey() {
            return "antSetDialogDimensionKey";
        }

        public JComponent getPreferredFocusedComponent() {
            return AntSetPanel.this.myForm.getAntsList();
        }

        protected void doOKAction() {
            HashSet<String> names = new HashSet<String>();
            ListModel model = AntSetPanel.this.myForm.getAntsList().getModel();
            for (int idx = 0; idx < model.getSize(); ++idx) {
                AntInstallation inst = (AntInstallation)model.getElementAt(idx);
                String name = (String)AntInstallation.NAME.get((AbstractProperty.AbstractPropertyContainer)AntSetPanel.this.myForm.getProperties(inst));
                if (names.contains(name)) {
                    Messages.showErrorDialog((String)("Duplicate ant installation name: \"" + name + "\""), (String)this.getTitle());
                    return;
                }
                names.add(name);
            }
            super.doOKAction();
        }
    }

    private static class NewAntFactory
    implements Factory<AntInstallation> {
        private final AnActionListEditor<AntInstallation> myParent;

        public NewAntFactory(AnActionListEditor<AntInstallation> parent) {
            this.myParent = parent;
        }

        public AntInstallation create() {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, this.myParent, null, null);
            if (file == null) {
                return null;
            }
            try {
                AntInstallation inst = AntInstallation.fromHome(file.getPresentableUrl());
                this.adjustName(inst);
                return inst;
            }
            catch (AntInstallation.ConfigurationException e) {
                Messages.showErrorDialog(this.myParent, (String)e.getMessage(), (String)AntBundle.message("ant.setup.dialog.title", new Object[0]));
                return null;
            }
        }

        private void adjustName(AntInstallation justCreated) {
            int nameIndex = 0;
            String adjustedName = justCreated.getName();
            ListModel model = this.myParent.getList().getModel();
            int idx = 0;
            while (idx < model.getSize()) {
                AntInstallation inst;
                if (!adjustedName.equals((inst = (AntInstallation)model.getElementAt(idx++)).getName())) continue;
                adjustedName = justCreated.getName() + " (" + ++nameIndex + ")";
                idx = 0;
            }
            if (!adjustedName.equals(justCreated.getName())) {
                justCreated.setName(adjustedName);
            }
        }
    }

    private static class Form
    implements AntUIUtil.PropertiesEditor<AntInstallation> {
        private final Splitter mySplitter = new JBSplitter("antConfigurations.splitter", 3.0f);
        private final RightPanel myRightPanel;
        private final AnActionListEditor<AntInstallation> myAnts = new AnActionListEditor();
        private final UIPropertyBinding.Composite myBinding = new UIPropertyBinding.Composite();
        private final EditPropertyContainer myGlobalWorkingProperties;
        private final Map<AntInstallation, EditPropertyContainer> myWorkingProperties = new HashMap();
        private AntInstallation myCurrent;
        private final PropertyChangeListener myImmediateUpdater = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Form.this.myBinding.apply(Form.this.getProperties(Form.this.myCurrent));
                Form.this.myAnts.updateItem(Form.this.myCurrent);
            }
        };

        public Form(final GlobalAntConfiguration antInstallation) {
            this.mySplitter.setShowDividerControls(true);
            this.mySplitter.setFirstComponent(this.myAnts);
            this.myGlobalWorkingProperties = new EditPropertyContainer(antInstallation.getProperties());
            this.myRightPanel = new RightPanel(this.myBinding, this.myImmediateUpdater);
            this.mySplitter.setSecondComponent((JComponent)this.myRightPanel.myWholePanel);
            this.myAnts.addAddAction(new NewAntFactory(this.myAnts));
            this.myAnts.addRemoveButtonForAnt(antInstallation.IS_USER_ANT, AntBundle.message("remove.action.name", new Object[0]));
            this.myAnts.actionsBuilt();
            JList list = this.myAnts.getList();
            list.setCellRenderer(new AntUIUtil.AntInstallationRenderer(this));
            list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (Form.this.myCurrent != null) {
                        Form.this.myBinding.apply(Form.this.getProperties(Form.this.myCurrent));
                    }
                    Form.this.myCurrent = (AntInstallation)Form.this.myAnts.getSelectedItem();
                    if (Form.this.myCurrent == null) {
                        Form.this.myBinding.loadValues(AbstractProperty.AbstractPropertyContainer.EMPTY);
                        Form.this.myBinding.beDisabled();
                    } else {
                        if (antInstallation.IS_USER_ANT.value((Object)Form.this.myCurrent)) {
                            Form.this.myBinding.beEnabled();
                        } else {
                            Form.this.myBinding.beDisabled();
                        }
                        Form.this.myBinding.loadValues(Form.this.getProperties(Form.this.myCurrent));
                    }
                }
            });
        }

        public JList getAntsList() {
            return this.myAnts.getList();
        }

        public JComponent getComponent() {
            return this.mySplitter;
        }

        public AntInstallation getSelectedAnt() {
            return this.myAnts.getSelectedItem();
        }

        public void setAnts(Collection<AntInstallation> antInstallations) {
            this.myAnts.setItems(antInstallations);
        }

        public void applyModifications() {
            if (this.myCurrent != null) {
                this.myBinding.apply(this.getProperties(this.myCurrent));
            }
            ArrayList<AbstractProperty> properties = new ArrayList<AbstractProperty>();
            this.myBinding.addAllPropertiesTo(properties);
            for (AntInstallation ant : this.myWorkingProperties.keySet()) {
                EditPropertyContainer container = this.myWorkingProperties.get(ant);
                container.apply();
            }
            this.myGlobalWorkingProperties.apply();
        }

        public void selectAnt(AntInstallation antInstallation) {
            this.myAnts.setSelection(antInstallation);
        }

        public ArrayList<AntInstallation> getAddedAnts() {
            return this.myAnts.getAdded();
        }

        public ArrayList<AntInstallation> getRemovedAnts() {
            return this.myAnts.getRemoved();
        }

        public EditPropertyContainer getProperties(AntInstallation ant) {
            EditPropertyContainer properties = this.myWorkingProperties.get(ant);
            if (properties != null) {
                return properties;
            }
            properties = new EditPropertyContainer(this.myGlobalWorkingProperties, ant.getProperties());
            this.myWorkingProperties.put(ant, properties);
            return properties;
        }

        private static class RightPanel {
            private JLabel myNameLabel;
            private JLabel myHome;
            private JTextField myName;
            private AntClasspathEditorPanel myClasspath;
            private JPanel myWholePanel;

            public RightPanel(UIPropertyBinding.Composite binding, PropertyChangeListener immediateUpdater) {
                this.$$$setupUI$$$();
                this.myNameLabel.setLabelFor(this.myName);
                binding.addBinding(this.myClasspath.setClasspathProperty(AntInstallation.CLASS_PATH));
                binding.bindString(this.myHome, (AbstractProperty<String>)AntInstallation.HOME_DIR);
                binding.bindString(this.myName, AntInstallation.NAME).addChangeListener(immediateUpdater);
            }

            private /* synthetic */ void $$$setupUI$$$() {
                JLabel jLabel;
                JTextField jTextField;
                AntClasspathEditorPanel antClasspathEditorPanel;
                JLabel jLabel2;
                JPanel jPanel;
                this.myWholePanel = jPanel = new JPanel();
                jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
                this.myNameLabel = jLabel2 = new JLabel();
                this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/AntBundle").getString("ant.settings.name.label"));
                jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
                JLabel jLabel3 = new JLabel();
                this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/AntBundle").getString("ant.settings.home.label"));
                jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
                this.myClasspath = antClasspathEditorPanel = new AntClasspathEditorPanel();
                ((Component)antClasspathEditorPanel).setEnabled(true);
                jPanel.add((Component)antClasspathEditorPanel, new GridConstraints(2, 0, 1, 2, 8, 3, 7, 7, null, null, null));
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
                jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
                this.myName = jTextField = new JTextField();
                jPanel2.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
                this.myHome = jLabel = new JLabel();
                jLabel.setText("");
                jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            }

            public /* synthetic */ JComponent $$$getRootComponent$$$() {
                return this.myWholePanel;
            }

            private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                char c = '\u0000';
                int n = -1;
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) == '&') {
                        if (++i == string.length()) break;
                        if (!bl && string.charAt(i) != '&') {
                            bl = true;
                            c = string.charAt(i);
                            n = stringBuffer.length();
                        }
                    }
                    stringBuffer.append(string.charAt(i));
                }
                jLabel.setText(stringBuffer.toString());
                if (bl) {
                    jLabel.setDisplayedMnemonic(c);
                    jLabel.setDisplayedMnemonicIndex(n);
                }
            }
        }
    }
}

