/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.TargetAwareRunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunConfigurationBase
extends UserDataHolderBase
implements RunConfiguration,
TargetAwareRunProfile {
    private static final String LOG_FILE = "log_file";
    private static final String PREDEFINED_LOG_FILE_ELEMENT = "predefined_log_file";
    private static final String FILE_OUTPUT = "output_file";
    private static final String SAVE = "is_save";
    private static final String OUTPUT_FILE = "path";
    private static final String SHOW_CONSOLE_ON_STD_OUT = "show_console_on_std_out";
    private static final String SHOW_CONSOLE_ON_STD_ERR = "show_console_on_std_err";
    private final ConfigurationFactory myFactory;
    private final Project myProject;
    private String myName;
    private final Icon myIcon;
    private ArrayList<LogFileOptions> myLogFiles;
    private ArrayList<PredefinedLogFile> myPredefinedLogFiles;
    private boolean mySaveOutput;
    private boolean myShowConsoleOnStdOut;
    private boolean myShowConsoleOnStdErr;
    private String myFileOutputPath;

    protected RunConfigurationBase(Project project, @NotNull ConfigurationFactory factory, String name) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/execution/configurations/RunConfigurationBase", "<init>"));
        }
        this.myName = "";
        this.myLogFiles = new ArrayList();
        this.myPredefinedLogFiles = new ArrayList();
        this.mySaveOutput = false;
        this.myShowConsoleOnStdOut = false;
        this.myShowConsoleOnStdErr = false;
        this.myFileOutputPath = null;
        this.myProject = project;
        this.myFactory = factory;
        this.myName = name;
        this.myIcon = factory.getIcon();
    }

    @Override
    public int getUniqueID() {
        return System.identityHashCode(this);
    }

    @Override
    public final ConfigurationFactory getFactory() {
        return this.myFactory;
    }

    @Override
    public final void setName(String name) {
        this.myName = name;
    }

    @Override
    public final Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public ConfigurationType getType() {
        ConfigurationType configurationType = this.myFactory.getType();
        if (configurationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/RunConfigurationBase", "getType"));
        }
        return configurationType;
    }

    @Override
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    @Transient
    public final String getName() {
        return this.myName;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public void checkRunnerSettings(@NotNull ProgramRunner runner, @Nullable RunnerSettings runnerSettings, @Nullable ConfigurationPerRunnerSettings configurationPerRunnerSettings) throws RuntimeConfigurationException {
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/execution/configurations/RunConfigurationBase", "checkRunnerSettings"));
        }
    }

    public void checkSettingsBeforeRun() throws RuntimeConfigurationException {
    }

    @Override
    public boolean canRunOn(@NotNull ExecutionTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/execution/configurations/RunConfigurationBase", "canRunOn"));
        }
        return true;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public RunConfiguration clone() {
        RunConfigurationBase runConfiguration = (RunConfigurationBase)super.clone();
        runConfiguration.myLogFiles = new ArrayList<LogFileOptions>(this.myLogFiles);
        runConfiguration.myPredefinedLogFiles = new ArrayList<PredefinedLogFile>(this.myPredefinedLogFiles);
        runConfiguration.myFileOutputPath = this.myFileOutputPath;
        runConfiguration.mySaveOutput = this.mySaveOutput;
        runConfiguration.myShowConsoleOnStdOut = this.myShowConsoleOnStdOut;
        runConfiguration.myShowConsoleOnStdErr = this.myShowConsoleOnStdErr;
        this.copyCopyableDataTo(runConfiguration);
        return runConfiguration;
    }

    @Nullable
    public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
        return null;
    }

    public void removeAllPredefinedLogFiles() {
        this.myPredefinedLogFiles.clear();
    }

    public void addPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
        this.myPredefinedLogFiles.add(predefinedLogFile);
    }

    public ArrayList<PredefinedLogFile> getPredefinedLogFiles() {
        return this.myPredefinedLogFiles;
    }

    @NotNull
    public ArrayList<LogFileOptions> getAllLogFiles() {
        ArrayList<LogFileOptions> list = new ArrayList<LogFileOptions>(this.myLogFiles);
        for (PredefinedLogFile predefinedLogFile : this.myPredefinedLogFiles) {
            LogFileOptions options = this.getOptionsForPredefinedLogFile(predefinedLogFile);
            if (options == null) continue;
            list.add(options);
        }
        ArrayList<LogFileOptions> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/RunConfigurationBase", "getAllLogFiles"));
        }
        return arrayList;
    }

    public ArrayList<LogFileOptions> getLogFiles() {
        return this.myLogFiles;
    }

    public void addLogFile(String file, String alias, boolean checked) {
        this.myLogFiles.add(new LogFileOptions(alias, file, checked, true, false));
    }

    public void addLogFile(String file, String alias, boolean checked, boolean skipContent, boolean showAll) {
        this.myLogFiles.add(new LogFileOptions(alias, file, checked, skipContent, showAll));
    }

    public void removeAllLogFiles() {
        this.myLogFiles.clear();
    }

    public void createAdditionalTabComponents(AdditionalTabComponentManager manager, ProcessHandler startedProcess) {
    }

    public void customizeLogConsole(LogConsole console) {
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myLogFiles.clear();
        for (Object o : element.getChildren(LOG_FILE)) {
            LogFileOptions logFileOptions = new LogFileOptions();
            logFileOptions.readExternal((Element)o);
            this.myLogFiles.add(logFileOptions);
        }
        this.myPredefinedLogFiles.clear();
        List list = element.getChildren(PREDEFINED_LOG_FILE_ELEMENT);
        for (Object fileElement : list) {
            PredefinedLogFile logFile = new PredefinedLogFile();
            logFile.readExternal((Element)fileElement);
            this.myPredefinedLogFiles.add(logFile);
        }
        Element fileOutputElement = element.getChild(FILE_OUTPUT);
        if (fileOutputElement != null) {
            this.myFileOutputPath = fileOutputElement.getAttributeValue(OUTPUT_FILE);
            String isSave = fileOutputElement.getAttributeValue(SAVE);
            boolean bl = this.mySaveOutput = isSave != null && Boolean.parseBoolean(isSave);
        }
        if (!this.isNewSerializationUsed()) {
            this.myShowConsoleOnStdOut = Boolean.parseBoolean(element.getAttributeValue(SHOW_CONSOLE_ON_STD_OUT));
            this.myShowConsoleOnStdErr = Boolean.parseBoolean(element.getAttributeValue(SHOW_CONSOLE_ON_STD_ERR));
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        JDOMExternalizerUtil.addChildren((Element)element, (String)LOG_FILE, this.myLogFiles);
        JDOMExternalizerUtil.addChildren((Element)element, (String)PREDEFINED_LOG_FILE_ELEMENT, this.myPredefinedLogFiles);
        if (this.myFileOutputPath != null || this.mySaveOutput) {
            Element fileOutputPathElement = new Element(FILE_OUTPUT);
            if (this.myFileOutputPath != null) {
                fileOutputPathElement.setAttribute(OUTPUT_FILE, this.myFileOutputPath);
            }
            if (this.mySaveOutput) {
                fileOutputPathElement.setAttribute(SAVE, String.valueOf(this.mySaveOutput));
            }
            element.addContent(fileOutputPathElement);
        }
        if (!this.isNewSerializationUsed()) {
            if (this.myShowConsoleOnStdOut) {
                element.setAttribute(SHOW_CONSOLE_ON_STD_OUT, String.valueOf(true));
            }
            if (this.myShowConsoleOnStdErr) {
                element.setAttribute(SHOW_CONSOLE_ON_STD_ERR, String.valueOf(true));
            }
        }
    }

    protected boolean isNewSerializationUsed() {
        return false;
    }

    @Transient
    public boolean isSaveOutputToFile() {
        return this.mySaveOutput;
    }

    public void setSaveOutputToFile(boolean redirectOutput) {
        this.mySaveOutput = redirectOutput;
    }

    @Attribute(value="show_console_on_std_out")
    public boolean isShowConsoleOnStdOut() {
        return this.myShowConsoleOnStdOut;
    }

    public void setShowConsoleOnStdOut(boolean showConsoleOnStdOut) {
        this.myShowConsoleOnStdOut = showConsoleOnStdOut;
    }

    @Attribute(value="show_console_on_std_err")
    public boolean isShowConsoleOnStdErr() {
        return this.myShowConsoleOnStdErr;
    }

    public void setShowConsoleOnStdErr(boolean showConsoleOnStdErr) {
        this.myShowConsoleOnStdErr = showConsoleOnStdErr;
    }

    @Transient
    public String getOutputFilePath() {
        return this.myFileOutputPath;
    }

    public void setFileOutputPath(String fileOutputPath) {
        this.myFileOutputPath = fileOutputPath;
    }

    public boolean collectOutputFromProcessHandler() {
        return true;
    }

    public boolean excludeCompileBeforeLaunchOption() {
        return false;
    }

    public boolean isCompileBeforeLaunchAddedByDefault() {
        return true;
    }

    public String toString() {
        return this.getType().getDisplayName() + ": " + this.getName();
    }

    @Override
    public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider) {
        return null;
    }

    @Override
    public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
        return null;
    }
}

