/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XLineBreakpointType<P extends XBreakpointProperties>
extends XBreakpointType<XLineBreakpoint<P>, P> {
    protected XLineBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/xdebugger/breakpoints/XLineBreakpointType", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/xdebugger/breakpoints/XLineBreakpointType", "<init>"));
        }
        super(id, title);
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/breakpoints/XLineBreakpointType", "canPutAt"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/breakpoints/XLineBreakpointType", "canPutAt"));
        }
        return false;
    }

    @Nullable
    public abstract P createBreakpointProperties(@NotNull VirtualFile var1, int var2);

    @Override
    public String getDisplayText(XLineBreakpoint<P> breakpoint) {
        return XLineBreakpointType.fileLineDisplayText(breakpoint.getPresentableFilePath(), breakpoint.getLine());
    }

    private static String fileLineDisplayText(String path, int line) {
        return XDebuggerBundle.message("xbreakpoint.default.display.text", line + 1, path);
    }

    @Override
    public final XSourcePosition getSourcePosition(@NotNull XBreakpoint<P> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/breakpoints/XLineBreakpointType", "getSourcePosition"));
        }
        return null;
    }

    @Override
    public String getShortText(XLineBreakpoint<P> breakpoint) {
        return XLineBreakpointType.fileLineDisplayText(breakpoint.getShortFilePath(), breakpoint.getLine());
    }

    @Override
    public final XLineBreakpoint<P> createDefaultBreakpoint(@NotNull XBreakpointType.XBreakpointCreator<P> creator) {
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creator", "com/intellij/xdebugger/breakpoints/XLineBreakpointType", "createDefaultBreakpoint"));
        }
        return null;
    }

    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XLineBreakpoint<P> breakpoint, @Nullable XDebugSession currentSession) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/breakpoints/XLineBreakpointType", "getAdditionalPopupMenuActions"));
        }
        return Collections.emptyList();
    }

    public Icon getTemporaryIcon() {
        return AllIcons.Debugger.Db_temporary_breakpoint;
    }

    public int getPriority() {
        return 0;
    }

    public boolean canBeHitInOtherPlaces() {
        return false;
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<P> breakpoint) {
        return null;
    }

    @NotNull
    public List<? extends XLineBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/breakpoints/XLineBreakpointType", "computeVariants"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/breakpoints/XLineBreakpointType", "computeVariants"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/breakpoints/XLineBreakpointType", "computeVariants"));
        }
        return list;
    }

    public abstract class XLineBreakpointVariant {
        public abstract String getText();

        @Nullable
        public abstract Icon getIcon();

        @Nullable
        public abstract TextRange getHighlightRange();

        @Nullable
        public abstract P createProperties();
    }
}

