/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.breadcrumbs.BreadcrumbsItem;
import com.intellij.xml.breadcrumbs.BreadcrumbsItemListener;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreadcrumbsComponent<T extends BreadcrumbsItem>
extends JComponent
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.breadcrumbs.BreadcrumbsComponent");
    private static final Painter DEFAULT_PAINTER = new DefaultPainter(new ButtonSettings());
    private List<BreadcrumbsItemListener<T>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private Crumb myHovered;
    private PagedImage myBuffer;
    private List<Crumb> myCrumbs = new ArrayList<Crumb>();
    private final CrumbLineMouseListener myMouseListener = new CrumbLineMouseListener(this);
    private List<T> myItems;
    private int myOffset;

    public BreadcrumbsComponent() {
        this.addMouseListener(this.myMouseListener);
        this.addMouseMotionListener(this.myMouseListener);
        this.setToolTipText("");
    }

    public void setItems(@Nullable List<T> itemsList) {
        if (this.myItems != itemsList) {
            this.myItems = itemsList;
            this.myCrumbs = null;
        }
        this.repaint();
    }

    public void setOffset(int offset) {
        if (this.myOffset != offset) {
            this.myOffset = offset;
            this.repaint();
        }
    }

    public void addBreadcrumbsItemListener(@NotNull BreadcrumbsItemListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent", "addBreadcrumbsItemListener"));
        }
        this.myListeners.add(listener);
    }

    public void removeBreadcrumbsItemListener(@NotNull BreadcrumbsItemListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent", "removeBreadcrumbsItemListener"));
        }
        this.myListeners.remove(listener);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Crumb c = this.getCrumb(event.getPoint());
        if (c != null) {
            String text = c.getTooltipText();
            return text == null ? super.getToolTipText(event) : text;
        }
        return super.getToolTipText(event);
    }

    @Nullable
    public Crumb getCrumb(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent", "getCrumb"));
        }
        if (this.myCrumbs != null) {
            Rectangle r = this.getBounds();
            p.translate(r.x, r.y);
            if (!r.contains(p)) {
                return null;
            }
            if (this.myBuffer == null) {
                return null;
            }
            int offset = this.myBuffer.getPageOffset();
            for (Crumb each : this.myCrumbs) {
                if (p.x + offset < each.getOffset() || p.x + offset >= each.getOffset() + each.getWidth()) continue;
                return each;
            }
        }
        return null;
    }

    public void setHoveredCrumb(@Nullable Crumb crumb) {
        if (crumb != null) {
            crumb.setHovered(true);
        }
        if (this.myHovered != null) {
            this.myHovered.setHovered(false);
        }
        this.myHovered = crumb;
        for (BreadcrumbsItemListener<BreadcrumbsItem> breadcrumbsItemListener : this.myListeners) {
            breadcrumbsItemListener.itemHovered(this.myHovered != null ? this.myHovered.myItem : null);
        }
        this.repaint();
    }

    public void nextPage() {
        int page;
        if (this.myBuffer != null && (page = this.myBuffer.getPage()) + 1 < this.myBuffer.getPageCount()) {
            this.myBuffer.setPage(page + 1);
        }
        this.repaint();
    }

    public void previousPage() {
        int page;
        if (this.myBuffer != null && (page = this.myBuffer.getPage()) - 1 >= 0) {
            this.myBuffer.setPage(page - 1);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension d = this.getSize();
        FontMetrics fm = g2.getFontMetrics();
        if (this.myItems != null) {
            List<Crumb> crumbList;
            boolean veryDirty = this.myCrumbs == null || this.myBuffer != null && !this.myBuffer.isValid(d.width);
            List<Crumb> list = crumbList = veryDirty ? this.createCrumbList(fm, this.myItems, d.width) : this.myCrumbs;
            if (crumbList != null) {
                if (veryDirty) {
                    this.myBuffer = new PagedImage(BreadcrumbsComponent.getTotalWidth(crumbList), d.width);
                    this.myBuffer.setPage(this.myBuffer.getPageCount() - 1);
                }
                assert (this.myBuffer != null);
                super.paint(g2);
                this.myBuffer.paintPage(g2, crumbList, DEFAULT_PAINTER, d.height);
                this.myCrumbs = crumbList;
            }
        } else {
            super.paint(g2);
        }
    }

    private void setSelectedCrumb(@NotNull Crumb<T> c, int modifiers) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent", "setSelectedCrumb"));
        }
        T selectedElement = c.getItem();
        HashSet items = new HashSet();
        boolean light = false;
        for (Crumb each : this.myCrumbs) {
            Object item = each.getItem();
            if (item != null && items.contains(item)) {
                light = false;
            }
            each.setLight(light);
            if (item != null && !light) {
                items.add(item);
            }
            if (selectedElement == item) {
                each.setSelected(true);
                light = true;
                continue;
            }
            each.setSelected(false);
        }
        this.fireItemSelected(selectedElement, modifiers);
        this.repaint();
    }

    private void fireItemSelected(@Nullable T item, int modifiers) {
        if (item != null) {
            for (BreadcrumbsItemListener<T> listener : this.myListeners) {
                listener.itemSelected(item, modifiers);
            }
        }
    }

    @Nullable
    private List<Crumb> createCrumbList(@NotNull FontMetrics fm, @NotNull List<T> elements, int width) {
        if (fm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fm", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent", "createCrumbList"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent", "createCrumbList"));
        }
        if (elements.size() == 0) {
            return null;
        }
        LinkedList<Crumb> result = new LinkedList<Crumb>();
        int screenWidth = 0;
        Crumb<BreadcrumbsItem> rightmostCrumb = null;
        for (int i = elements.size() - 1; i >= 0; --i) {
            NavigationCrumb forward = new NavigationCrumb(this, fm, true, DEFAULT_PAINTER);
            NavigationCrumb backward = new NavigationCrumb(this, fm, false, DEFAULT_PAINTER);
            BreadcrumbsItem element = (BreadcrumbsItem)elements.get(i);
            String s = element.getDisplayText();
            Dimension d = DEFAULT_PAINTER.getSize(s, fm, width - forward.getWidth() - backward.getWidth());
            Crumb<BreadcrumbsItem> crumb = new Crumb<BreadcrumbsItem>(this, s, d.width, element);
            if (screenWidth + d.width > width) {
                Crumb<BreadcrumbsItem> first = null;
                if (screenWidth + backward.getWidth() > width && !result.isEmpty()) {
                    first = result.removeFirst();
                    screenWidth -= first.getWidth();
                }
                result.addFirst(backward);
                int dummyWidth = width - (screenWidth += backward.getWidth());
                if (dummyWidth > 0) {
                    DummyCrumb dummy = new DummyCrumb(dummyWidth);
                    if (rightmostCrumb != null) {
                        result.add(result.indexOf(rightmostCrumb) + 1, dummy);
                    } else {
                        result.addLast(dummy);
                    }
                }
                screenWidth = forward.getWidth();
                result.addFirst(forward);
                if (first != null) {
                    result.addFirst(first);
                    screenWidth += first.getWidth();
                }
                rightmostCrumb = first != null ? first : crumb;
            }
            result.addFirst(crumb);
            screenWidth += d.width;
        }
        if (rightmostCrumb != null && screenWidth < width) {
            int index = result.indexOf(rightmostCrumb);
            for (int i = index + 1; i < result.size(); ++i) {
                Crumb crumb = result.get(i);
                if (crumb instanceof NavigationCrumb || crumb instanceof DummyCrumb) continue;
                if (screenWidth + crumb.getWidth() >= width) break;
                result.add(++index, new Crumb(this, crumb.getString(), crumb.getWidth(), crumb.getItem()));
                screenWidth += crumb.getWidth();
                ++i;
            }
            if (screenWidth < width) {
                result.add(index + 1, new DummyCrumb(width - screenWidth));
            }
        }
        int offset = this.myOffset;
        for (Crumb each : result) {
            each.setOffset(offset);
            offset += each.getWidth();
        }
        if (result.size() > 0) {
            for (int i = result.size() - 1; i >= 0; --i) {
                Crumb c = result.get(i);
                if (c instanceof DummyCrumb) continue;
                c.setSelected(true);
                break;
            }
        }
        return result;
    }

    private static int getTotalWidth(@NotNull List<Crumb> crumbList) {
        if (crumbList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "crumbList", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent", "getTotalWidth"));
        }
        int totalWidth = 0;
        for (Crumb each : crumbList) {
            totalWidth += each.getWidth();
        }
        return totalWidth;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        return new Dimension(Integer.MAX_VALUE, g2 != null ? BreadcrumbsComponent.DEFAULT_PAINTER.getSize((String)"DUMMY", (FontMetrics)g2.getFontMetrics(), (int)Integer.MAX_VALUE).height + 1 : 1);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void dispose() {
        this.removeMouseListener(this.myMouseListener);
        this.removeMouseMotionListener(this.myMouseListener);
        this.myListeners = null;
    }

    private static class DefaultPainter
    extends Painter {
        public DefaultPainter(@NotNull PainterSettings s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$DefaultPainter", "<init>"));
            }
            super(s);
        }

        @Override
        public void paint(@NotNull Crumb c, @NotNull Graphics2D g2, int height, int pageOffset) {
            String string;
            FontMetrics fm;
            Font font;
            Color textColor;
            Color borderColor;
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$DefaultPainter", "paint"));
            }
            if (g2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$DefaultPainter", "paint"));
            }
            PainterSettings s = this.getSettings();
            Font oldFont = g2.getFont();
            int offset = c.getOffset() - pageOffset;
            Color bg = s.getBackgroundColor(c);
            int width = c.getWidth();
            if (bg != null) {
                g2.setColor(bg);
                g2.fillRoundRect(offset + 2, 0, width - 4, height - 3, ROUND_VALUE, ROUND_VALUE);
            }
            if ((borderColor = s.getBorderColor(c)) != null) {
                g2.setColor(borderColor);
                g2.drawRoundRect(offset + 1, 0, width - 2, height - 3, ROUND_VALUE, ROUND_VALUE);
            }
            if ((textColor = s.getForegroundColor(c)) != null) {
                g2.setColor(textColor);
            }
            if ((font = s.getFont(g2, c)) != null) {
                g2.setFont(font);
            }
            if ((fm = g2.getFontMetrics()).stringWidth(string = c.getString()) > width) {
                int charWidth;
                int dotsWidth = fm.stringWidth("...");
                StringBuilder sb = new StringBuilder();
                int length = 0;
                for (int i = 0; i < string.length() && length + (charWidth = fm.charWidth(string.charAt(i))) + dotsWidth <= width; ++i) {
                    length += charWidth;
                    sb.append(string.charAt(i));
                }
                string = sb.append("...").toString();
            }
            UISettings.setupAntialiasing(g2);
            g2.drawString(string, offset + ROUND_VALUE, height - fm.getDescent() - 4);
            g2.setFont(oldFont);
        }

        @Override
        @NotNull
        Dimension getSize(@NotNull @NonNls String s, @NotNull FontMetrics fm, int maxWidth) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$DefaultPainter", "getSize"));
            }
            if (fm == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fm", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$DefaultPainter", "getSize"));
            }
            int width = fm.stringWidth(s) + ROUND_VALUE * 2;
            Dimension dimension = new Dimension(width > maxWidth ? maxWidth : width, fm.getHeight() + 4);
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$DefaultPainter", "getSize"));
            }
            return dimension;
        }
    }

    static abstract class Painter {
        public static final int ROUND_VALUE = SystemInfo.isMac ? 3 : 2;
        private final PainterSettings mySettings;

        public Painter(@NotNull PainterSettings s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$Painter", "<init>"));
            }
            this.mySettings = s;
        }

        protected PainterSettings getSettings() {
            return this.mySettings;
        }

        abstract void paint(@NotNull Crumb var1, @NotNull Graphics2D var2, int var3, int var4);

        @NotNull
        Dimension getSize(@NotNull @NonNls String s, @NotNull FontMetrics fm, int maxWidth) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$Painter", "getSize"));
            }
            if (fm == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fm", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$Painter", "getSize"));
            }
            int w = fm.stringWidth(s);
            Dimension dimension = new Dimension(w > maxWidth ? maxWidth : w, fm.getHeight());
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$Painter", "getSize"));
            }
            return dimension;
        }
    }

    static class ButtonSettings
    extends PainterSettings {
        protected static final Color DEFAULT_BG_COLOR = new JBColor((Color)Gray._245, new Color(101, 104, 106));
        private static final Color LIGHT_BG_COLOR = new JBColor((Color)Gray._253, (Color)Gray._130);
        private static final Color CURRENT_BG_COLOR = new JBColor(new Color(250, 250, 220), new Color(97, 97, 75));
        protected static final Color HOVERED_BG_COLOR = new JBColor((Color)Gray._220, ColorUtil.shift((Color)DEFAULT_BG_COLOR, (double)1.2));
        private static final Color LIGHT_TEXT_COLOR = new JBColor((Color)Gray._170, UIUtil.getListForeground());
        protected static final Color DEFAULT_BORDER_COLOR = new JBColor((Color)Gray._90, (Color)Gray._50);
        private static final Color LIGHT_BORDER_COLOR = new JBColor((Color)Gray._170, (Color)Gray._70);

        ButtonSettings() {
        }

        static Color getBackgroundColor(boolean selected, boolean hovered, boolean light, boolean navigationCrumb) {
            if (hovered) {
                return HOVERED_BG_COLOR;
            }
            if (selected) {
                return CURRENT_BG_COLOR;
            }
            if (light && !navigationCrumb) {
                return LIGHT_BG_COLOR;
            }
            return DEFAULT_BG_COLOR;
        }

        @Override
        @Nullable
        Color getBackgroundColor(@NotNull Crumb c) {
            CrumbPresentation presentation;
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$ButtonSettings", "getBackgroundColor"));
            }
            Object item = c.getItem();
            if (item != null && (presentation = ((BreadcrumbsItem)item).getPresentation()) != null) {
                return presentation.getBackgroundColor(c.isSelected(), c.isHovered(), c.isLight());
            }
            return ButtonSettings.getBackgroundColor(c.isSelected(), c.isHovered(), c.isLight(), c instanceof NavigationCrumb);
        }

        @Override
        @Nullable
        Color getForegroundColor(@NotNull Crumb c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$ButtonSettings", "getForegroundColor"));
            }
            if (c.isLight() && !c.isHovered() && !(c instanceof NavigationCrumb)) {
                return LIGHT_TEXT_COLOR;
            }
            return super.getForegroundColor(c);
        }

        @Override
        @Nullable
        Color getBorderColor(@NotNull Crumb c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$ButtonSettings", "getBorderColor"));
            }
            return c.isLight() && !c.isHovered() && !(c instanceof NavigationCrumb) ? LIGHT_BORDER_COLOR : DEFAULT_BORDER_COLOR;
        }
    }

    static abstract class PainterSettings {
        private static final Color DEFAULT_FOREGROUND_COLOR = new JBColor((Color)Gray._50, UIUtil.getListForeground());

        PainterSettings() {
        }

        @Nullable
        Color getBackgroundColor(@NotNull Crumb c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$PainterSettings", "getBackgroundColor"));
            }
            return null;
        }

        @Nullable
        Color getForegroundColor(@NotNull Crumb c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$PainterSettings", "getForegroundColor"));
            }
            return DEFAULT_FOREGROUND_COLOR;
        }

        @Nullable
        Color getBorderColor(@NotNull Crumb c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$PainterSettings", "getBorderColor"));
            }
            return null;
        }

        @Nullable
        Font getFont(@NotNull Graphics g2, @NotNull Crumb c) {
            if (g2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$PainterSettings", "getFont"));
            }
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$PainterSettings", "getFont"));
            }
            return null;
        }
    }

    private static class DummyCrumb
    extends Crumb {
        public DummyCrumb(int width) {
            super(null, width);
        }

        @Override
        public void paint(@NotNull Graphics2D g2, @NotNull Painter painter, int height, int pageOffset) {
            if (g2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$DummyCrumb", "paint"));
            }
            if (painter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$DummyCrumb", "paint"));
            }
        }

        @Override
        public void performAction(int modifiers) {
        }

        @Override
        public String toString() {
            return "DUMMY";
        }
    }

    private static class NavigationCrumb
    extends Crumb {
        @NonNls
        private static final String FORWARD = ">>";
        @NonNls
        private static final String BACKWARD = "<<";
        private final boolean myForward;
        private final BreadcrumbsComponent myLine;

        public NavigationCrumb(@NotNull BreadcrumbsComponent line, @NotNull FontMetrics fm, boolean forward, @NotNull Painter p) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$NavigationCrumb", "<init>"));
            }
            if (fm == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fm", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$NavigationCrumb", "<init>"));
            }
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$NavigationCrumb", "<init>"));
            }
            super(forward ? FORWARD : BACKWARD, p.getSize((String)(forward ? FORWARD : BACKWARD), (FontMetrics)fm, (int)Integer.MAX_VALUE).width);
            this.myForward = forward;
            this.myLine = line;
        }

        @Override
        public void performAction(int modifiers) {
            if (this.myForward) {
                this.myLine.nextPage();
            } else {
                this.myLine.previousPage();
            }
        }
    }

    private static class Crumb<T extends BreadcrumbsItem> {
        private final String myString;
        private int myOffset = -1;
        private final int myWidth;
        private T myItem;
        private BreadcrumbsComponent myLine;
        private boolean mySelected;
        private boolean myHovered;
        private boolean myLight;

        public Crumb(BreadcrumbsComponent line, String string, int width, T item) {
            this(string, width);
            this.myLine = line;
            this.myItem = item;
        }

        public Crumb(String string, int width) {
            this.myString = string;
            this.myWidth = width;
        }

        public String getString() {
            return this.myString;
        }

        public int getOffset() {
            LOG.assertTrue(this.myOffset != -1, (Object)("Negative offet for crumb: " + this.myString));
            return this.myOffset;
        }

        public int getWidth() {
            return this.myWidth;
        }

        public void setOffset(int offset) {
            this.myOffset = offset;
        }

        public String toString() {
            return this.getString();
        }

        public void setSelected(boolean selected) {
            this.mySelected = selected;
        }

        public void setLight(boolean light) {
            this.myLight = light;
        }

        public boolean isHovered() {
            return this.myHovered;
        }

        public boolean isSelected() {
            return this.mySelected;
        }

        public boolean isLight() {
            return this.myLight;
        }

        public void paint(@NotNull Graphics2D g2, @NotNull Painter painter, int height, int pageOffset) {
            if (g2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$Crumb", "paint"));
            }
            if (painter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$Crumb", "paint"));
            }
            painter.paint(this, g2, height, pageOffset);
        }

        @Nullable
        public String getTooltipText() {
            T element = this.getItem();
            if (element != null) {
                return ((BreadcrumbsItem)element).getTooltip();
            }
            return null;
        }

        public T getItem() {
            return this.myItem;
        }

        public void performAction(int modifiers) {
            this.myLine.setSelectedCrumb(this, modifiers);
        }

        public void setHovered(boolean b) {
            this.myHovered = b;
        }
    }

    private static class CrumbLineMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private final BreadcrumbsComponent myBreadcrumbs;
        private Crumb myHoveredCrumb;

        public CrumbLineMouseListener(@NotNull BreadcrumbsComponent line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$CrumbLineMouseListener", "<init>"));
            }
            this.myBreadcrumbs = line;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Crumb crumb = this.myBreadcrumbs.getCrumb(e.getPoint());
            if (crumb != this.myHoveredCrumb) {
                this.myBreadcrumbs.setHoveredCrumb(crumb);
                this.myHoveredCrumb = crumb;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Crumb crumb = this.myBreadcrumbs.getCrumb(e.getPoint());
            if (crumb != null) {
                crumb.performAction(e.getModifiers());
            }
        }
    }

    private static class PagedImage {
        private final int myPageWidth;
        private int myPage;
        private final int myTotalWidth;

        public PagedImage(int totalWidth, int pageWidth) {
            this.myPageWidth = pageWidth;
            this.myTotalWidth = totalWidth;
        }

        public int getPageCount() {
            if (this.myTotalWidth < this.myPageWidth) {
                return 1;
            }
            return this.myTotalWidth / this.myPageWidth;
        }

        public void setPage(int page) {
            assert (page >= 0);
            assert (page < this.getPageCount());
            this.myPage = page;
        }

        public int getPage() {
            return this.myPage;
        }

        private void repaint(@NotNull Graphics2D g2, @NotNull List<Crumb> crumbList, @NotNull Painter painter, int height) {
            if (g2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$PagedImage", "repaint"));
            }
            if (crumbList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "crumbList", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$PagedImage", "repaint"));
            }
            if (painter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$PagedImage", "repaint"));
            }
            int pageOffset = this.getPageOffset();
            for (Crumb each : crumbList) {
                if (each.getOffset() < pageOffset || each.getOffset() >= pageOffset + this.myPageWidth) continue;
                each.paint(g2, painter, height, pageOffset);
            }
        }

        public int getPageOffset() {
            return this.myPage * this.myPageWidth;
        }

        public void paintPage(@NotNull Graphics2D g2, @NotNull List<Crumb> list, @NotNull Painter p, int height) {
            if (g2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$PagedImage", "paintPage"));
            }
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$PagedImage", "paintPage"));
            }
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/xml/breadcrumbs/BreadcrumbsComponent$PagedImage", "paintPage"));
            }
            this.repaint(g2, list, p, height);
        }

        public boolean isValid(int width) {
            return width == this.myPageWidth;
        }
    }
}

