/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command.mq;

import com.intellij.openapi.project.Project;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgQGotoCommand {
    @NotNull
    private final HgRepository myRepository;

    public HgQGotoCommand(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/command/mq/HgQGotoCommand", "<init>"));
        }
        this.myRepository = repository;
    }

    public HgCommandResult executeInCurrentThread(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/zmlx/hg4idea/command/mq/HgQGotoCommand", "executeInCurrentThread"));
        }
        Project project = this.myRepository.getProject();
        HgCommandResult result = new HgCommandExecutor(project).executeInCurrentThread(this.myRepository.getRoot(), "qgoto", Collections.singletonList(name));
        if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
            new HgCommandResultNotifier(project).notifyError(result, "QGoto command failed", "Could not go to patch " + name);
        }
        this.myRepository.update();
        return result;
    }
}

