/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentsPackage;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundle;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage;

public class CommitToIcsDialog
extends DialogWrapper {
    private final ChangesBrowser browser;
    private final Project project;
    private final String projectId;

    public CommitToIcsDialog(Project project, String projectId, List<Change> projectFileChanges) {
        super(project, true);
        this.project = project;
        this.projectId = projectId;
        this.browser = new ChangesBrowser(project, Collections.emptyList(), projectFileChanges, null, true, false, null, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
        this.browser.setChangesToDisplay(projectFileChanges);
        this.setTitle(IcsBundle.message("action.CommitToIcs.text", new Object[0]));
        this.setOKButtonText(IcsBundle.message("action.CommitToIcs.text", new Object[0]));
        this.init();
    }

    protected void doOKAction() {
        List selectedChanges = this.browser.getSelectedChanges();
        if (!selectedChanges.isEmpty()) {
            this.commitChanges(selectedChanges);
        }
        super.doOKAction();
    }

    private void commitChanges(List<Change> changes) {
        StateStorageManager storageManager = ComponentsPackage.getStateStore((ComponentManager)this.project).getStateStorageManager();
        TrackingPathMacroSubstitutor macroSubstitutor = storageManager.getMacroSubstitutor();
        assert (macroSubstitutor != null);
        IcsManager icsManager2 = SettingsRepositoryPackage.getIcsManager();
        SmartList addToIcs = new SmartList();
        for (Change change : changes) {
            VirtualFile file = change.getVirtualFile();
            assert (file != null);
            String fileSpec = macroSubstitutor.collapsePath(file.getPath());
            String repoPath = SettingsRepositoryPackage.buildPath(fileSpec, RoamingType.DEFAULT, this.projectId);
            addToIcs.add((Object)repoPath);
            if (icsManager2.getRepositoryManager().has(repoPath)) continue;
        }
        icsManager2.getRepositoryManager().commit((List<? extends String>)addToIcs);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.browser;
    }
}

