/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.util.SmartList;
import java.io.File;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.ReadonlySource;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$IcsManager$d5f67752;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"(\u0006)1\"+Z1e\u001f:d\u0017pU8ve\u000e,7/T1oC\u001e,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b%M,G\u000f^5oON\u0014V\r]8tSR|'/\u001f\u0006\u0004\u0003:L(BB6pi2LgN\u0003\u0004=S:LGO\u0010\u0006\tg\u0016$H/\u001b8hg*Y\u0011jY:TKR$\u0018N\\4t\u0015\u001d\u0011xn\u001c;ESJTAAR5mK*!!.\u0019<b\u0015\tIwNC\u0007`e\u0016\u0004xn]5u_JLWm\u001d\u0006\u0005\u0019&\u001cHO\u0003\u0006SKB|7/\u001b;pefTq!Z2mSB\u001cXM\u0003\u0003kO&$(b\u00017jE*!Q\u000f^5m\u00151\u0011X\r]8tSR|'/[3t\u0015=9W\r\u001e*fa>\u001c\u0018\u000e^8sS\u0016\u001c(BC4fiJ{w\u000e\u001e#je*Q1/\u001a;T_V\u00148-Z:\u000b\u000fM|WO]2fg*q!+Z1e_:d\u0017pU8ve\u000e,'\u0002B+oSRT1b]8ve\u000e,Gk\u001c#je*11o\\;sG\u0016t\u0019A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\r!\u0011\u0001\u0003\u0001\r\u0001\u0015\t\u0001RA\u0003\u0004\t\tA!\u0001\u0004\u0001\u0006\u0007\u0011\t\u0001\u0002\u0002\u0007\u0001\u000b\u0005AY!\u0002\u0002\u0005\b!1Qa\u0001\u0003\u0005\u0011\u0015a\u0001!\u0002\u0002\u0005\u0003!!QA\u0001\u0003\u0005\u0011\u0015)1\u0001\u0002\u0002\t\u000f1\u0001QA\u0001\u0003\u0001\u0011!)!\u0001\"\u0004\t\u0012\u0015\u0011Aa\u0002\u0005\n\u000b\r!y\u0001c\u0004\r\u0001\u0015\u0011Aq\u0001E\n\u000b\t!\t\u0002C\u0004\u0006\u0007\u0011\t\u0001\u0012\u0004\u0007\u0001\u000b\r!!\u0001C\u0007\r\u0001\u0015\u0011A!\u0001E\r\t\u0001a\u0019!\u0007\u0002\u0006\u0003!\u0015Q\u0006\u0005\u0003B\u001aa5\u0011eB\u0003\u0002\u0011\u0019I1!\u0003\u0002\u0006\u0003!AA\u0012A+\u0004\t\u0015\u0019AQB\u0005\u0002\u0011%i\u0003\u0003\u00021\u00051)\tc!B\u0001\t\r%\u0019\u0011BA\u0003\u0002\u0011!!\u0003%V\u0002\u0005\u001b\r!)\"C\u0001\t\u00135zAa\u0019\u0003\u0019\n\u0005\u0012Q!\u0001E\u0005+\u000eAQa\u0001C\u0005\u0013\u0005AY!D\u0002\u0005\u0017%\t\u00012B\u0017\f\t\u0005$\u0001tA\u0011\u0003\u000b\u0005A1!V\u0002\u0005\u000b\r!9!C\u0001\t\u000b5:B\u0001\u0001M\f;+!\u0001\u0001\u0003\u0007\u000e\r\u0015\t\u0001BB\u0005\u0004\u0013\t)\u0011\u0001c\u0005Q\u0007\u0001\t#!B\u0001\t\u0015E\u001bQ\u0001b\u0006\n\u0003\u0011\u0001Q\"\u0001\u0005\n[M!\t\u0001g\u0007\u001e\u000e\u0011\u0001\u0001BD\u0007\u0003\u000b\u0005A\u0019\u0002U\u0002\u0001C\t)\u0011\u0001#\u0003R\u0007\u0015!Y\"C\u0001\t\f5\t\u0001RC\u001b\u001f\u000bu!1\u001d\u0001\r\u0004;\u001b!\u0001\u0001c\u0002\u000e\u0005\u0015\t\u0001b\u0001)\u0004\u0001u5A\u0001\u0001E\u0005\u001b\t)\u0011\u0001#\u0003Q\u0007\u0003\t#!B\u0001\t\u0004E\u001bq\u0001B\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\u0006\u001b\u0005AY\u0001"})
public final class ReadOnlySourcesManager {
    public static final /* synthetic */ KClass $kotlinClass;
    private List<? extends Repository> _repositories;
    private final IcsSettings settings;
    @NotNull
    private final File rootDir;

    static {
        $kotlinClass = Reflection.createKotlinClass(ReadOnlySourcesManager.class);
    }

    @NotNull
    public final List<Repository> getRepositories() {
        List r = this._repositories;
        if (r == null) {
            if (this.settings.getReadOnlySources().isEmpty()) {
                r = KotlinPackage.emptyList();
            } else {
                r = (List)new SmartList();
                for (ReadonlySource source : this.settings.getReadOnlySources()) {
                    try {
                        String path;
                        if (source.getPath() == null) {
                            continue;
                        }
                        File dir = new File(this.rootDir, path);
                        if (dir.exists()) {
                            ((SmartList)r).add((Object)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setBare()).setGitDir(dir)).build());
                            continue;
                        }
                        SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().warn("Skip read-only source " + source.getUrl() + " because dir doesn't exists");
                    }
                    catch (Exception e) {
                        SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().error((Throwable)e);
                    }
                }
            }
            this._repositories = r;
        }
        return r;
    }

    public final void setSources(@JetValueParameter(name="sources") @NotNull List<? extends ReadonlySource> sources) {
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        this.settings.setReadOnlySources(sources);
        this._repositories = null;
    }

    @NotNull
    public final File sourceToDir(@JetValueParameter(name="source") @NotNull ReadonlySource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        String string = source.getPath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return new File(this.rootDir, string);
    }

    @NotNull
    public final File getRootDir() {
        return this.rootDir;
    }

    public ReadOnlySourcesManager(@JetValueParameter(name="settings") @NotNull IcsSettings settings, @JetValueParameter(name="rootDir") @NotNull File rootDir) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        this.settings = settings;
        this.rootDir = rootDir;
    }
}

