/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.ui.Messages;
import com.intellij.util.io.URLUtil;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundle;
import org.jetbrains.settingsRepository.RepositoryService;
import org.jetbrains.settingsRepository.git.GitPackage$GitEx$3dc0a22d;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.TRAIT_IMPL)
public final class RepositoryService$$TImpl {
    public static boolean checkUrl(@JetValueParameter(name="$this", type="?") @NotNull RepositoryService $this, @JetValueParameter(name="uriString") @Nullable String uriString, @JetValueParameter(name="messageParent", type="?") Container messageParent) {
        boolean isFile;
        Intrinsics.checkParameterIsNotNull((Object)uriString, (String)"uriString");
        URIish uri = new URIish(uriString);
        if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)URLUtil.FILE_PROTOCOL)) {
            isFile = true;
        } else {
            boolean bl = isFile = uri.getScheme() == null && uri.getHost() == null;
        }
        return messageParent == null || !isFile || $this.checkFileRepo(uriString, messageParent);
    }

    public static /* synthetic */ boolean checkUrl$default(RepositoryService repositoryService, String string, Container container, int n) {
        if ((n & 2) != 0) {
            container = null;
        }
        return repositoryService.checkUrl(string, container);
    }

    public static boolean checkFileRepo(@JetValueParameter(name="$this", type="?") @NotNull RepositoryService $this, @JetValueParameter(name="url") @NotNull String url, @JetValueParameter(name="messageParent") Container messageParent) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)messageParent, (String)"messageParent");
        String suffix = KotlinPackage.plus((char)'/', (String)Constants.DOT_GIT);
        File file = new File(KotlinPackage.endsWith$default((String)url, (String)suffix, (boolean)false, (int)2) ? KotlinPackage.substring((String)url, (int)0, (int)(url.length() - suffix.length())) : url);
        if (file.exists()) {
            if (!file.isDirectory()) {
                Messages.showErrorDialog((Component)messageParent, (String)"Specified path is not a directory", (String)"Specified Path is Invalid");
                return false;
            }
            if ($this.isValidRepository(file)) {
                return true;
            }
        } else if (!file.isAbsolute()) {
            Messages.showErrorDialog((Component)messageParent, (String)IcsBundle.Companion.message("specify.absolute.path.dialog.message", new Object[0]), (String)"");
            return false;
        }
        if (Messages.showYesNoDialog((Component)messageParent, (String)IcsBundle.Companion.message("init.dialog.message", new Object[0]), (String)IcsBundle.Companion.message("init.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            try {
                GitPackage$GitEx$3dc0a22d.createBareRepository(file);
                return true;
            }
            catch (IOException e) {
                Messages.showErrorDialog((Component)messageParent, (String)IcsBundle.Companion.message("init.failed.message", e.getMessage()), (String)IcsBundle.Companion.message("init.failed.title", new Object[0]));
                return false;
            }
        }
        return false;
    }
}

