/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.zip.ZipShort;
import com.intellij.util.lang.MemoryResource;
import gnu.trove.THashMap;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Nullable;
import sun.misc.Resource;

public class JarMemoryLoader {
    private final Map<String, Resource> myResources = new THashMap<String, Resource>();

    private JarMemoryLoader() {
    }

    public Resource getResource(String entryName) {
        return this.myResources.remove(entryName);
    }

    @Nullable
    public static JarMemoryLoader load(ZipFile zipFile, URL baseUrl) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        if (!entries.hasMoreElements()) {
            return null;
        }
        ZipEntry sizeEntry = entries.nextElement();
        if (sizeEntry == null || !sizeEntry.getName().equals("META-INF/jb/$$size$$")) {
            return null;
        }
        byte[] bytes = FileUtil.loadBytes(zipFile.getInputStream(sizeEntry), 2);
        int size = ZipShort.getValue(bytes);
        JarMemoryLoader loader = new JarMemoryLoader();
        for (int i = 0; i < size && entries.hasMoreElements(); ++i) {
            ZipEntry entry = entries.nextElement();
            MemoryResource resource = MemoryResource.load(baseUrl, zipFile, entry);
            loader.myResources.put(entry.getName(), resource);
        }
        return loader;
    }
}

