/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsPackage;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetIsExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.JetType;

public final class PatternTranslator
extends AbstractTranslator {
    @NotNull
    public static PatternTranslator newInstance(@NotNull TranslationContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "newInstance"));
        }
        PatternTranslator patternTranslator = new PatternTranslator(context2);
        if (patternTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "newInstance"));
        }
        return patternTranslator;
    }

    private PatternTranslator(@NotNull TranslationContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "<init>"));
        }
        super(context2);
    }

    @NotNull
    public JsExpression translateIsExpression(@NotNull JetIsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsExpression"));
        }
        JsExpression left = Translation.translateAsExpression(expression.getLeftHandSide(), this.context());
        JetTypeReference typeReference = expression.getTypeReference();
        assert (typeReference != null);
        JsExpression result2 = this.translateIsCheck(left, typeReference);
        if (expression.isNegated()) {
            JsPrefixOperation jsPrefixOperation = JsAstUtils.negated(result2);
            if (jsPrefixOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsExpression"));
            }
            return jsPrefixOperation;
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression translateIsCheck(@NotNull JsExpression subject, @NotNull JetTypeReference typeReference) {
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsCheck"));
        }
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsCheck"));
        }
        JetType type2 = BindingUtils.getTypeByReference(this.bindingContext(), typeReference);
        JsExpression checkFunReference = this.getIsTypeCheckCallable(type2);
        JsInvocation isCheck = new JsInvocation(checkFunReference, subject);
        if (this.isNullable(typeReference)) {
            JsExpression jsExpression = PatternTranslator.addNullCheck(subject, isCheck);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsCheck"));
            }
            return jsExpression;
        }
        JsInvocation jsInvocation = isCheck;
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateIsCheck"));
        }
        return jsInvocation;
    }

    @NotNull
    public JsExpression getIsTypeCheckCallable(@NotNull JetType type2) {
        TypeParameterDescriptor typeParameterDescriptor;
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallable"));
        }
        JsExpression builtinCheck = this.getIsTypeCheckCallableForBuiltin(type2);
        if (builtinCheck != null) {
            JsExpression jsExpression = builtinCheck;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallable"));
            }
            return jsExpression;
        }
        ClassifierDescriptor typeDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (typeDescriptor instanceof TypeParameterDescriptor && (typeParameterDescriptor = (TypeParameterDescriptor)typeDescriptor).isReified()) {
            JsExpression jsExpression = this.getIsTypeCheckCallableForReifiedType(typeParameterDescriptor);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallable"));
            }
            return jsExpression;
        }
        JsNameRef typeName = this.getClassNameReference(type2);
        JsExpression jsExpression = this.namer().isInstanceOf(typeName);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallable"));
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression getIsTypeCheckCallableForBuiltin(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallableForBuiltin"));
        }
        Name typeName = DescriptorUtilsPackage.getNameIfStandardType(type2);
        if (NamePredicate.STRING.apply(typeName)) {
            return this.namer().isTypeOf(this.program().getStringLiteral("string"));
        }
        if (NamePredicate.BOOLEAN.apply(typeName)) {
            return this.namer().isTypeOf(this.program().getStringLiteral("boolean"));
        }
        if (NamePredicate.LONG.apply(typeName)) {
            return this.namer().isInstanceOf(Namer.KOTLIN_LONG_NAME_REF);
        }
        if (NamePredicate.NUMBER.apply(typeName)) {
            return this.namer().kotlin("isNumber");
        }
        if (NamePredicate.CHAR.apply(typeName)) {
            return this.namer().kotlin("isChar");
        }
        if (NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS.apply(typeName)) {
            return this.namer().isTypeOf(this.program().getStringLiteral("number"));
        }
        return null;
    }

    @NotNull
    private JsExpression getIsTypeCheckCallableForReifiedType(@NotNull TypeParameterDescriptor typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallableForReifiedType"));
        }
        assert (typeParameter.isReified()) : "Expected reified type, actual: " + typeParameter;
        DeclarationDescriptor containingDeclaration = typeParameter.getContainingDeclaration();
        assert (containingDeclaration instanceof CallableDescriptor) : "Expected type parameter " + typeParameter + " to be contained in CallableDescriptor, actual: " + containingDeclaration.getClass();
        JsExpression alias = this.context().getAliasForDescriptor(typeParameter);
        assert (alias != null) : "No alias found for reified type parameter: " + typeParameter;
        JsExpression jsExpression = alias;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getIsTypeCheckCallableForReifiedType"));
        }
        return jsExpression;
    }

    @NotNull
    private static JsExpression addNullCheck(@NotNull JsExpression expressionToMatch, @NotNull JsInvocation isCheck) {
        if (expressionToMatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToMatch", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "addNullCheck"));
        }
        if (isCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isCheck", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "addNullCheck"));
        }
        JsBinaryOperation jsBinaryOperation = JsAstUtils.or(TranslationUtils.isNullCheck(expressionToMatch), isCheck);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "addNullCheck"));
        }
        return jsBinaryOperation;
    }

    private boolean isNullable(JetTypeReference typeReference) {
        return BindingUtils.getTypeByReference(this.bindingContext(), typeReference).isMarkedNullable();
    }

    @NotNull
    private JsNameRef getClassNameReference(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getClassNameReference"));
        }
        ClassDescriptor referencedClass = DescriptorUtils.getClassDescriptorForType(type2);
        JsNameRef jsNameRef = this.context().getQualifiedReference(referencedClass);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "getClassNameReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression translateExpressionPattern(@NotNull JsExpression expressionToMatch, @NotNull JetExpression patternExpression) {
        if (expressionToMatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToMatch", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionPattern"));
        }
        if (patternExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternExpression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionPattern"));
        }
        JsExpression expressionToMatchAgainst = this.translateExpressionForExpressionPattern(patternExpression);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(expressionToMatch, expressionToMatchAgainst);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionPattern"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public JsExpression translateExpressionForExpressionPattern(@NotNull JetExpression patternExpression) {
        if (patternExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternExpression", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionForExpressionPattern"));
        }
        JsExpression jsExpression = Translation.translateAsExpression(patternExpression, this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/PatternTranslator", "translateExpressionForExpressionPattern"));
        }
        return jsExpression;
    }
}

