/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.xml.bind.DatatypeConverter;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.LibraryUtils;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"e\n)i2j\u001c;mS:T\u0015M^1tGJL\u0007\u000f^'fi\u0006$\u0017\r^1Vi&d7OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0015)H/\u001b7t\u0015\r\te.\u001f\u0006\f\u0003\nKuLV#S'&{eJC\u0002J]RTaAS*`\u000bb#&BB*ue&twM\u0003\u0003kCZ\f'\u0002\u00027b]\u001eT\u0011bZ3u\u0015N{V\t\u0017+\u000b;-{E\u000bT%O?*\u000be+Q*D%&\u0003FkX'F)\"{Ei\u0018(B\u001b\u0016SQeS(U\u0019&suLS!W\u0003N\u001b%+\u0013)U?6+E\u000bS(E?:\u000bU*R0Q\u0003R#VI\u0015(\u000b\u000bI+w-\u001a=\u000b\tQ,\u0007\u0010\u001e\u0006\u0004\u0019>;%B\u0002'pO\u001e,'OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015)!\u0017.Y4o_N$\u0018n\u0019\u0006\b\u001d>$h*\u001e7m\u0015-\tgN\\8uCRLwN\\:\u000b/-|G\u000f\\5o])4XN\f)mCR4wN]7UsB,'\u0002E'F)\u0006#\u0015\tV!`!\u0006#F+\u0012*O\u00159iU\tV!`\u0015N{6+\u0016$G\u0013bS\u0011cZ3u\u001b\u0016#\u0016i\u0018&T?N+fIR%Y\u001511fiU0Q%>#vjQ(M\u0015=9W\r\u001e,G'~\u0003&k\u0014+P\u0007>c%B\u00064pe6\fG/T3uC\u0012\fG/Y!t'R\u0014\u0018N\\4\u000b\u00155|G-\u001e7f\u001d\u0006lWMC\u0004d_:$XM\u001c;\u000b\u0013\tKH/Z!se\u0006L(b\u00035bg6+G/\u00193bi\u0006TqAQ8pY\u0016\fgN\u0003\u0007m_\u0006$W*\u001a;bI\u0006$\u0018M\u0003\u0003gS2,'\u0002\u0002$jY\u0016T!![8\u000b\t1K7\u000f\u001e\u0006\u0019\u0017>$H.\u001b8KCZ\f7o\u0019:jaRlU\r^1eCR\f'\u0002B;uS2TA\u0001]1uQ*i\u0001/\u0019:tK6+G/\u00193bi\u0006TA\"\\3uC\u0012\fG/\u0019'jgRT1\"T;uC\ndW\rT5ti*!QK\\5u\u00155\u0011X\r\u001d7bG\u0016\u001cVO\u001a4jq*Aa-\u001b7f!\u0006$\b\u000ey\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0019A1\u0001\u0005\u0001\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011\u0015\u0001R\u0001\u0007\u0001\u000b\r!)\u0001c\u0002\r\u0001\u0015\u0019AQ\u0001E\u0005\u0019\u0001)\u0011\u0001C\u0003\u0006\u0005\u0011%\u00012B\u0003\u0003\t\u0015AI!\u0002\u0002\u0005\u0006!AQa\u0001\u0003\u0007\u0011\u001fa\u0001!\u0002\u0002\u0005\r!=Q!\u0001E\n\u000b\t!y\u0001\u0003\u0006\u0006\u0005\u0011A\u0001RC\u0003\u0003\t#A1\"B\u0002\u0005\u0013!IA\u0002A\u0003\u0003\t\u0003AA\"B\u0002\u0005\u0015!]A\u0002A\u0003\u0003\t%A\u0011\"B\u0002\u0005\u0006!\tB\u0002A\u0003\u0004\t\u000bA!\u0003\u0004\u0001\u0006\u0005\u0011%\u0001\u0002F\u0003\u0004\t3A9\u0003\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0012\u0006\u0007\u0001\u000b\r!\u0019\u0001C\u000b\r\u0001\u0015\u0011A\u0011\u0002E\u0016\u000b\t!i\u0002#\u000b\u0006\u0005\u0011e\u0001rE\u0003\u0004\t\u000bAy\u0003\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0002\u0007\u0007\u0001\t\r\fABA\r\u0003\u000b\u0005A1!L\u0006\u0005CRA2!\t\u0002\u0006\u0003!\u001dQk\u0001\u0003\u0006\u0007\u0011\u0019\u0011\"\u0001C\u0003[=!1\r\u0006\r\u0005C\t)\u0011\u0001\u0003\u0003V\u0007!)1\u0001\u0002\u0003\n\u0003!-Qb\u0001\u0003\u0007\u0013\u0005AY!L\u0006\u0005CRAj!\t\u0002\u0006\u0003!!Qk\u0001\u0003\u0006\u0007\u00115\u0011\"\u0001E\u0006[-!\u0011\r\u0002\r\bC\t)\u0011\u0001#\u0004V\u0007\u0011)1\u0001B\u0004\n\u0003!9Q&\u0006\u0003b\taE\u0011\u0005D\u0003\u0002\u0011'\u0001J\"f\u0003\u0006\u0003!MA\u0012A)\u0004\u0003\u0011U\u0011kA\u0001\u0005\u0016U\u001bA!B\u0002\u0005\u0012%\t\u0001bC\u0017\f\t\u0005$\u0001$D\u0011\u0003\u000b\u0005Ai!V\u0002\u0005\u000b\r!Q\"C\u0001\t\u000f5zAa\u0019\u000b\u0019\u001c\u0005\u0012Q!\u0001\u0005\u0005+\u000eAQa\u0001C\u000e\u0013\u0005AY!D\u0002\u0005\u001d%\t\u00012B\u0017\u0010\t\r$\u0002TD\u0011\u0003\u000b\u0005AA!V\u0002\t\u000b\r!i\"C\u0001\t\f5\u0019AaD\u0005\u0002\u0011\u0017i[\u0004B\u0002\u0019 u5A\u0001\u0001\u0005\u0011\u001b\t)\u0011\u0001\u0003\u0003Q\u0007\u0001ij\u0001\u0002\u0001\t\"5\u0011Q!\u0001E\f!\u000e\u0005\u0011EA\u0003\u0002\u0011\u0011\t6\u0001\u0003C\u0010\u0013\u0005AY!D\u0001\t\f5\u0011A1\u0001G\u0001[M!9\u0001g\t\u001e\u000e\u0011\u0001\u0001\u0002C\u0007\u0003\u000b\u0005AA\u0001U\u0002\u0001C\t)\u0011\u0001\u0003\u0007R\u0007\u0015!\u0019#C\u0001\u0005\u00025\t\u00012B\u0017\u0018\t\u000fA*#(\u0004\u0005\u0001!\u0019RBA\u0003\u0002\u00115\u00016\u0001A\u0011\u0007\u000b\u0005AY\"C\u0002\n\u0005\u0015\t\u0001BD)\u0004\u000b\u0011\u0015\u0012\"\u0001\u0005\u0010\u001b\u0005Ay\"L\f\u0005\ba\u0015RT\u0002\u0003\u0001\u0011Yi!!B\u0001\t\tA\u001b\u0001!\t\u0004\u0006\u0003!m\u0011bA\u0005\u0003\u000b\u0005Aa\"U\u0002\u0006\tKI\u0011\u0001C\b\u000e\u0003!-QF\u000b\u0003\u00021[ij\u0001\u0002\u0001\t\u00115\u0011Q!\u0001\u0005\u0005!\u000e\u0001QT\u0002\u0003\u0001\u0011Yi!!B\u0001\t\tA\u001b\t!(\u0006\u0005\u0001!9RBB\u0003\u0002\u0011AI1!\u0003\u0002\u0006\u0003!q\u0001kA\u0001\"\u0005\u0015\t\u0001\u0012E)\u0004\u0013\u00115\u0012\"\u0001\u0003\u0001\u001b\u0005AY!D\u0001\t\f5\t\u0001bD\u0017\u0014\t\rA\n$(\u0004\u0005\u0001!IRBA\u0003\u0002\u0011\u0011\u00016\u0001A\u0011\u0003\u000b\u0005AA!U\u0002\u0006\tcI\u0011\u0001c\u0003\u000e\u0003!-Q\u0007\u0001"})
public final class KotlinJavascriptMetadataUtils {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Logger LOG;
    @NotNull
    public static final String JS_EXT = ".js";
    @NotNull
    public static final String META_JS_SUFFIX = ".meta.js";
    @NotNull
    public static final String VFS_PROTOCOL = "kotlin-js-meta";
    private static final String KOTLIN_JAVASCRIPT_METHOD_NAME = "kotlin_module_metadata";
    private static final Regex KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN;
    private static final Regex METADATA_PATTERN;
    private static final int ABI_VERSION = 2;
    public static final KotlinJavascriptMetadataUtils INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinJavascriptMetadataUtils.class);
        new KotlinJavascriptMetadataUtils();
    }

    @NotNull
    public final String getJS_EXT() {
        return JS_EXT;
    }

    @NotNull
    public final String getMETA_JS_SUFFIX() {
        return META_JS_SUFFIX;
    }

    @NotNull
    public final String getVFS_PROTOCOL() {
        return VFS_PROTOCOL;
    }

    @NotNull
    public final String replaceSuffix(@JetValueParameter(name="filePath") @NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull(filePath, "filePath");
        return KotlinPackage.substringBeforeLast$default(filePath, JS_EXT, null, 2) + META_JS_SUFFIX;
    }

    @platformStatic
    public static final boolean hasMetadata(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return METADATA_PATTERN.matcher(text).find();
    }

    @NotNull
    public final String formatMetadataAsString(@JetValueParameter(name="moduleName") @NotNull String moduleName, @JetValueParameter(name="content") @NotNull byte[] content) {
        Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
        Intrinsics.checkParameterIsNotNull(content, "content");
        return "// Kotlin." + KOTLIN_JAVASCRIPT_METHOD_NAME + "(" + ABI_VERSION + ", " + "\"" + moduleName + "\"" + ", " + "\"" + DatatypeConverter.printBase64Binary((byte[])content) + "\"" + ");" + "\n";
    }

    @platformStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@JetValueParameter(name="file") @NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        boolean value = file.exists();
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
            String message = "Library " + file + " not found";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        ArrayList<KotlinJavascriptMetadata> metadataList = KotlinPackage.arrayListOf(new KotlinJavascriptMetadata[0]);
        LibraryUtils.traverseJsLibrary(file, (Function2<? super String, ? super String, ? extends Unit>)new Function2<String, String, Unit>(file, metadataList){
            final /* synthetic */ File $file;
            final /* synthetic */ ArrayList $metadataList;

            public final void invoke(@JetValueParameter(name="content") @NotNull String content, @JetValueParameter(name="relativePath") @NotNull String relativePath) {
                Intrinsics.checkParameterIsNotNull(content, "content");
                Intrinsics.checkParameterIsNotNull(relativePath, "relativePath");
                String path = this.$file.getPath();
                if (KotlinPackage.isNotBlank(relativePath)) {
                    path = path + ("/" + relativePath);
                }
                String string = path;
                Intrinsics.checkExpressionValueIsNotNull(string, "path");
                KotlinJavascriptMetadataUtils.access$parseMetadata$0(KotlinJavascriptMetadataUtils.INSTANCE$, content, string, this.$metadataList);
            }
            {
                this.$file = file;
                this.$metadataList = arrayList;
                super(2);
            }
        });
        return metadataList;
    }

    @platformStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@JetValueParameter(name="path") @NotNull String path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return KotlinJavascriptMetadataUtils.loadMetadata(new File(path));
    }

    private final void parseMetadata(@JetValueParameter(name="text") String text, @JetValueParameter(name="path") String path, @JetValueParameter(name="metadataList") List<KotlinJavascriptMetadata> metadataList) {
        if (!KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN.matcher(text).find()) {
            return;
        }
        Matcher matcher = METADATA_PATTERN.matcher(text);
        while (matcher.find()) {
            int abiVersion = Integer.parseInt(matcher.group(1));
            if (abiVersion != ABI_VERSION) {
                LOG.error("Unsupported abi version in " + path + ", expected " + ABI_VERSION + ", but " + abiVersion);
            }
            String moduleName = matcher.group(3);
            String data2 = matcher.group(5);
            String string = moduleName;
            Intrinsics.checkExpressionValueIsNotNull(string, "moduleName");
            byte[] byArray = DatatypeConverter.parseBase64Binary((String)data2);
            Intrinsics.checkExpressionValueIsNotNull(byArray, "parseBase64Binary(data)");
            metadataList.add(new KotlinJavascriptMetadata(string, byArray));
        }
    }

    KotlinJavascriptMetadataUtils() {
        INSTANCE$ = this;
        LOG = Logger.getInstance(KotlinJavascriptMetadataUtils.class);
        JS_EXT = JS_EXT;
        META_JS_SUFFIX = META_JS_SUFFIX;
        VFS_PROTOCOL = VFS_PROTOCOL;
        KOTLIN_JAVASCRIPT_METHOD_NAME = KOTLIN_JAVASCRIPT_METHOD_NAME;
        KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN = KotlinPackage.toRegex("\\.kotlin_module_metadata\\(");
        METADATA_PATTERN = KotlinPackage.toRegex("(?m)" + "\\" + "w+" + "\\" + "." + KOTLIN_JAVASCRIPT_METHOD_NAME + "\\" + "((" + "\\" + "d+)," + "\\" + "s*(['" + "\"" + "])([^'" + "\"" + "]*)" + "\\" + "2," + "\\" + "s*(['" + "\"" + "])([^'" + "\"" + "]*)" + "\\" + "4" + "\\" + ")");
        ABI_VERSION = 2;
    }

    public static final /* synthetic */ void access$parseMetadata$0(@JetValueParameter(name="$this", type="?") KotlinJavascriptMetadataUtils $this, @JetValueParameter(name="text") @NotNull String text, @JetValueParameter(name="path") @NotNull String path, @JetValueParameter(name="metadataList") @NotNull List<KotlinJavascriptMetadata> metadataList) {
        $this.parseMetadata(text, path, metadataList);
    }
}

