/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.ui.DvcsStatusWidget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.util.ObjectUtils;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.ui.branch.GitBranchPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchWidget
extends DvcsStatusWidget<GitRepository> {
    private final GitVcsSettings mySettings;

    public GitBranchWidget(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchWidget", "<init>"));
        }
        super(project, "Git");
        this.mySettings = GitVcsSettings.getInstance(project);
    }

    public StatusBarWidget copy() {
        return new GitBranchWidget((Project)ObjectUtils.assertNotNull((Object)this.getProject()));
    }

    @Nullable
    protected GitRepository guessCurrentRepository(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchWidget", "guessCurrentRepository"));
        }
        return GitBranchUtil.getCurrentRepository(project);
    }

    @NotNull
    protected String getFullBranchName(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/ui/branch/GitBranchWidget", "getFullBranchName"));
        }
        String string = GitBranchUtil.getDisplayableBranchText(repository);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchWidget", "getFullBranchName"));
        }
        return string;
    }

    protected boolean isMultiRoot(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchWidget", "isMultiRoot"));
        }
        return !GitUtil.justOneGitRepository(project);
    }

    @NotNull
    protected ListPopup getPopup(@NotNull Project project, @NotNull GitRepository repository) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchWidget", "getPopup"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/ui/branch/GitBranchWidget", "getPopup"));
        }
        ListPopup listPopup = GitBranchPopup.getInstance(project, repository).asListPopup();
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchWidget", "getPopup"));
        }
        return listPopup;
    }

    protected void subscribeToRepoChangeEvents(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchWidget", "subscribeToRepoChangeEvents"));
        }
        project.getMessageBus().connect().subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(){

            @Override
            public void repositoryChanged(@NotNull GitRepository repository) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/ui/branch/GitBranchWidget$1", "repositoryChanged"));
                }
                LOG.debug("repository changed");
                GitBranchWidget.this.updateLater();
            }
        });
    }

    protected void rememberRecentRoot(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/ui/branch/GitBranchWidget", "rememberRecentRoot"));
        }
        this.mySettings.setRecentRoot(path);
    }
}

