/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibrarySupportInModuleConfigurable;

public class RepositoryAddLibraryAction
extends IntentionAndQuickFixAction {
    private final Module module;
    @NotNull
    private final RepositoryLibraryDescription libraryDescription;

    public RepositoryAddLibraryAction(Module module, @NotNull RepositoryLibraryDescription libraryDescription) {
        if (libraryDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDescription", "org/jetbrains/idea/maven/utils/library/RepositoryAddLibraryAction", "<init>"));
        }
        this.module = module;
        this.libraryDescription = libraryDescription;
    }

    @NotNull
    public String getName() {
        String string = ProjectBundle.message("maven.add.to.module.dependencies", this.libraryDescription.getDisplayName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryAddLibraryAction", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = ProjectBundle.message("maven.library.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryAddLibraryAction", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryAddLibraryAction", "applyFix"));
        }
        RepositoryLibrarySupportInModuleConfigurable mavenSupport = new RepositoryLibrarySupportInModuleConfigurable(this.module.getProject(), this.libraryDescription);
        if (mavenSupport.showEditorAndGet()) {
            IdeaModifiableModelsProvider modifiableModelsProvider = new IdeaModifiableModelsProvider();
            final ModifiableRootModel modifiableModel = modifiableModelsProvider.getModuleModifiableModel(this.module);
            assert (modifiableModel != null);
            mavenSupport.addSupport(this.module, modifiableModel, (ModifiableModelsProvider)modifiableModelsProvider);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    modifiableModel.commit();
                }
            });
        }
    }
}

