/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.google.common.base.Strings;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class RepositoryLibraryPropertiesEditor
extends DialogWrapper {
    @NotNull
    private final Project project;
    State currentState;
    List<String> versions;
    private VersionKind versionKind;
    private RepositoryLibraryProperties initialProperties;
    private RepositoryLibraryProperties properties;
    private boolean initialDownloadSources;
    private boolean downloadSources;
    private boolean initialDownloadJavaDocs;
    private boolean downloadJavaDocs;
    private RepositoryLibraryDescription repositoryLibraryDescription;
    private ComboBox versionKindSelector;
    private ComboBox versionSelector;
    private JPanel mainPanel;
    private JButton myReloadButton;
    private JPanel versionPanel;
    private JPanel failedToLoadPanel;
    private JPanel loadingPanel;
    private JBCheckBox downloadSourcesCheckBox;
    private JBCheckBox downloadJavaDocsCheckBox;

    public RepositoryLibraryPropertiesEditor(@Nullable Project project, boolean downloadSources, boolean downloadJavaDocs, @NotNull RepositoryLibraryProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryPropertiesEditor", "<init>"));
        }
        super(project);
        this.downloadJavaDocs = this.initialDownloadJavaDocs = downloadJavaDocs;
        this.downloadSources = this.initialDownloadSources = downloadSources;
        this.$$$setupUI$$$();
        this.project = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        this.initialProperties = properties;
        this.properties = new RepositoryLibraryProperties();
        this.properties.loadState(properties);
        this.repositoryLibraryDescription = RepositoryLibraryDescription.findDescription(properties);
        this.myReloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryLibraryPropertiesEditor.this.reloadVersionsAsync();
            }
        });
        this.reloadVersionsAsync();
    }

    private static VersionKind getVersionKind(String version) {
        if (Strings.isNullOrEmpty((String)version)) {
            return VersionKind.Unselected;
        }
        if (version.equals("RELEASE")) {
            return VersionKind.Release;
        }
        if (version.equals("LATEST")) {
            return VersionKind.Latest;
        }
        return VersionKind.Select;
    }

    private static int getSelection(String selectedVersion, List<String> versions) {
        VersionKind versionKind = RepositoryLibraryPropertiesEditor.getVersionKind(selectedVersion);
        switch (versionKind) {
            case Unselected: {
                return -1;
            }
            case Release: {
                return JBIterable.from(versions).takeWhile((Condition)new Condition<String>(){

                    public boolean value(String version) {
                        return version.endsWith("-SNAPSHOT");
                    }
                }).size();
            }
            case Latest: {
                return 0;
            }
            case Select: {
                if (versions.indexOf(selectedVersion) == -1) {
                    versions.add(0, selectedVersion);
                }
                return versions.indexOf(selectedVersion);
            }
        }
        return -1;
    }

    private void initVersionKindSelector() {
        List<String> versionKinds = Arrays.asList(ProjectBundle.message("maven.version.kind.selector.release", new Object[0]), ProjectBundle.message("maven.version.kind.selector.latest", new Object[0]), ProjectBundle.message("maven.version.kind.selector.select", new Object[0]));
        CollectionComboBoxModel versionKindSelectorModel = new CollectionComboBoxModel(versionKinds);
        this.versionKindSelector.setModel((ComboBoxModel)versionKindSelectorModel);
        this.versionKindSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VersionKind newVersionKind = RepositoryLibraryPropertiesEditor.this.getSelectedVersionKind();
                if (newVersionKind != RepositoryLibraryPropertiesEditor.this.versionKind) {
                    RepositoryLibraryPropertiesEditor.this.versionKind = newVersionKind;
                    RepositoryLibraryPropertiesEditor.this.versionKindChanged();
                }
            }
        });
        this.setSelectedVersionKind(RepositoryLibraryPropertiesEditor.getVersionKind(this.properties.getVersion()));
    }

    private void checkOkButtonState() {
        this.setOKActionEnabled(this.currentState == State.Loaded && (!this.properties.equals((Object)this.initialProperties) || this.downloadSources != this.initialDownloadSources || this.downloadJavaDocs != this.initialDownloadJavaDocs));
    }

    private void versionKindChanged() {
        this.versionSelector.setEnabled(this.versionKind == VersionKind.Select);
        this.properties.changeVersion(this.getSelectedVersion());
        int selection = RepositoryLibraryPropertiesEditor.getSelection(this.properties.getVersion(), this.versions);
        this.versionSelector.setSelectedIndex(selection);
        this.checkOkButtonState();
    }

    private VersionKind getSelectedVersionKind() {
        switch (this.versionKindSelector.getSelectedIndex()) {
            case 0: {
                return VersionKind.Release;
            }
            case 1: {
                return VersionKind.Latest;
            }
            case 2: {
                return VersionKind.Select;
            }
        }
        return VersionKind.Unselected;
    }

    private void setSelectedVersionKind(VersionKind versionKind) {
        this.versionSelector.setEnabled(versionKind == VersionKind.Select);
        switch (versionKind) {
            case Unselected: {
                this.versionKindSelector.setSelectedIndex(-1);
                break;
            }
            case Release: {
                this.versionKindSelector.setSelectedItem((Object)0);
                break;
            }
            case Latest: {
                this.versionKindSelector.setSelectedIndex(1);
                break;
            }
            case Select: {
                this.versionKindSelector.setSelectedIndex(2);
            }
        }
    }

    private void setState(State state) {
        this.currentState = state;
        this.versionPanel.setVisible(state == State.Loaded);
        this.failedToLoadPanel.setVisible(state == State.FailedToLoad);
        this.loadingPanel.setVisible(state == State.Loading);
        this.checkOkButtonState();
    }

    private void reloadVersionsAsync() {
        this.setState(State.Loading);
        Task.Backgroundable task = new Task.Backgroundable(this.project, ProjectBundle.message("maven.loading.library.version.hint", this.repositoryLibraryDescription.getDisplayName()), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryPropertiesEditor$4", "run"));
                }
                try {
                    List<String> versions = RepositoryAttachHandler.retrieveVersions(RepositoryLibraryPropertiesEditor.this.project, RepositoryLibraryPropertiesEditor.this.properties.getGroupId(), RepositoryLibraryPropertiesEditor.this.properties.getArtifactId(), RepositoryLibraryPropertiesEditor.this.repositoryLibraryDescription.getRemoteRepositories());
                    RepositoryLibraryPropertiesEditor.this.versionsLoaded(versions);
                }
                catch (Exception e) {
                    RepositoryLibraryPropertiesEditor.this.versionsFailedToLoad();
                }
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private void initVersionsPanel() {
        int selection = RepositoryLibraryPropertiesEditor.getSelection(this.properties.getVersion(), this.versions);
        CollectionComboBoxModel versionSelectorModel = new CollectionComboBoxModel(this.versions);
        this.versionSelector.setModel((ComboBoxModel)versionSelectorModel);
        this.versionSelector.setSelectedIndex(selection);
        this.setState(State.Loaded);
        this.initVersionKindSelector();
        this.versionSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RepositoryLibraryPropertiesEditor.this.properties.changeVersion(RepositoryLibraryPropertiesEditor.this.getSelectedVersion());
                RepositoryLibraryPropertiesEditor.this.checkOkButtonState();
            }
        });
        this.downloadSourcesCheckBox.setSelected(this.downloadSources);
        this.downloadSourcesCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryLibraryPropertiesEditor.this.downloadSources = RepositoryLibraryPropertiesEditor.this.downloadSourcesCheckBox.isSelected();
                RepositoryLibraryPropertiesEditor.this.checkOkButtonState();
            }
        });
        this.downloadJavaDocsCheckBox.setSelected(this.downloadJavaDocs);
        this.downloadJavaDocsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryLibraryPropertiesEditor.this.downloadJavaDocs = RepositoryLibraryPropertiesEditor.this.downloadJavaDocsCheckBox.isSelected();
                RepositoryLibraryPropertiesEditor.this.checkOkButtonState();
            }
        });
    }

    private void versionsLoaded(List<String> versions) {
        this.versions = versions;
        if (versions == null || versions.isEmpty()) {
            this.versionsFailedToLoad();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RepositoryLibraryPropertiesEditor.this.initVersionsPanel();
            }
        });
    }

    private void versionsFailedToLoad() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RepositoryLibraryPropertiesEditor.this.setState(State.FailedToLoad);
            }
        });
    }

    public String getSelectedVersion() {
        switch (this.versionKind) {
            case Unselected: {
                return null;
            }
            case Release: {
                return "RELEASE";
            }
            case Latest: {
                return "LATEST";
            }
            case Select: {
                return (String)this.versionSelector.getSelectedItem();
            }
        }
        return null;
    }

    public RepositoryLibraryProperties getProperties() {
        return this.properties;
    }

    public boolean downloadSources() {
        return this.downloadSources;
    }

    public boolean downloadJavaDocs() {
        return this.downloadJavaDocs;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    public void init() {
        super.init();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        ComboBox comboBox;
        ComboBox comboBox2;
        JPanel jPanel;
        JPanel jPanel2;
        JButton jButton;
        JPanel jPanel3;
        JPanel jPanel4;
        this.mainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setMinimumSize(new Dimension(400, 128));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.failedToLoadPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Failed to load versions");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myReloadButton = jButton = new JButton();
        jButton.setText("Reload");
        jButton.setMnemonic('R');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.loadingPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Loading available versions...");
        jBLabel2.setInheritsPopupMenu(true);
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.versionPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel5.add((Component)spacer4, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Version:");
        jBLabel3.setDisplayedMnemonic('V');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.versionSelector = comboBox2 = new ComboBox();
        jPanel5.add((Component)comboBox2, new GridConstraints(0, 2, 1, 1, 0, 0, 2, 0, null, null, null));
        this.versionKindSelector = comboBox = new ComboBox();
        jPanel5.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel.add((Component)spacer5, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.downloadSourcesCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setLabel("Download Sources");
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("ProjectBundle").getString("maven.property.download.sources"));
        jPanel6.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel6.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.downloadJavaDocsCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setLabel("Download JavaDocs");
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("ProjectBundle").getString("maven.property.download.javadocs"));
        jPanel6.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jBLabel2.setLabelFor((Component)comboBox2);
        jBLabel3.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static enum State {
        Loading,
        FailedToLoad,
        Loaded;

    }

    private static enum VersionKind {
        Unselected,
        Release,
        Latest,
        Select;

    }
}

