/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryDependencyScopeSuggester;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.util.Comparing;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryPropertiesEditor;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryType;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;

public class RepositoryLibrarySupportInModuleConfigurable
extends FrameworkSupportInModuleConfigurable {
    @NotNull
    private final RepositoryLibraryDescription libraryDescription;
    @Nullable
    private final Project project;
    private RepositoryLibraryPropertiesEditor editor;

    public RepositoryLibrarySupportInModuleConfigurable(@Nullable Project project, @NotNull RepositoryLibraryDescription libraryDescription) {
        if (libraryDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDescription", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupportInModuleConfigurable", "<init>"));
        }
        this.libraryDescription = libraryDescription;
        this.project = project;
    }

    @Nullable
    public JComponent createComponent() {
        if (this.editor == null) {
            this.editor = new RepositoryLibraryPropertiesEditor(this.project, false, false, this.libraryDescription.createDefaultProperties());
        }
        return this.editor.getMainPanel();
    }

    public boolean showEditorAndGet() {
        if (this.editor == null) {
            this.editor = new RepositoryLibraryPropertiesEditor(this.project, false, false, this.libraryDescription.createDefaultProperties());
        }
        this.editor.setTitle(ProjectBundle.message("maven.add.library.support", this.libraryDescription.getDisplayName()));
        this.editor.init();
        return this.editor.showAndGet();
    }

    public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupportInModuleConfigurable", "addSupport"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupportInModuleConfigurable", "addSupport"));
        }
        if (modifiableModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupportInModuleConfigurable", "addSupport"));
        }
        LibraryTable.ModifiableModel modifiableModel = modifiableModelsProvider.getLibraryTableModifiableModel(module.getProject());
        Library library = (Library)Iterables.find(Arrays.asList(modifiableModel.getLibraries()), (Predicate)new Predicate<Library>(){

            public boolean apply(@Nullable Library library) {
                return RepositoryLibrarySupportInModuleConfigurable.this.isLibraryEqualsToSelected(library);
            }
        }, null);
        if (library == null) {
            library = this.createNewLibrary(module, modifiableModel);
        }
        final DependencyScope dependencyScope = LibraryDependencyScopeSuggester.getDefaultScope((Library)library);
        ModifiableRootModel moduleModifiableModel = modifiableModelsProvider.getModuleModifiableModel(module);
        LibraryOrderEntry foundEntry = (LibraryOrderEntry)Iterables.find(Arrays.asList(moduleModifiableModel.getOrderEntries()), (Predicate)new Predicate<OrderEntry>(){

            public boolean apply(@Nullable OrderEntry entry) {
                return entry instanceof LibraryOrderEntry && ((LibraryOrderEntry)entry).getScope() == dependencyScope && RepositoryLibrarySupportInModuleConfigurable.this.isLibraryEqualsToSelected(((LibraryOrderEntry)entry).getLibrary());
            }
        }, null);
        if (foundEntry == null) {
            rootModel.addLibraryEntry(library).setScope(dependencyScope);
        }
    }

    private LibraryEx createNewLibrary(final @NotNull Module module, final LibraryTable.ModifiableModel modifiableModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupportInModuleConfigurable", "createNewLibrary"));
        }
        final LibraryEx library = (LibraryEx)modifiableModel.createLibrary(LibraryEditingUtil.suggestNewLibraryName((LibraryTable.ModifiableModel)modifiableModel, (String)RepositoryLibraryType.getInstance().getDescription(this.editor.getProperties())), RepositoryLibraryType.REPOSITORY_LIBRARY_KIND);
        RepositoryLibraryProperties libraryProperties = (RepositoryLibraryProperties)library.getProperties();
        libraryProperties.setMavenId(this.editor.getProperties().getMavenId());
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                modifiableModel.commit();
            }
        });
        Task.Backgroundable task = new Task.Backgroundable(this.project, "Maven", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupportInModuleConfigurable$4", "run"));
                }
                RepositoryUtils.loadDependencies(indicator, module.getProject(), library, RepositoryLibrarySupportInModuleConfigurable.this.editor.downloadSources(), RepositoryLibrarySupportInModuleConfigurable.this.editor.downloadJavaDocs());
            }
        };
        ProgressManager.getInstance().run((Task)task);
        return library;
    }

    private boolean isLibraryEqualsToSelected(Library library) {
        if (!(library instanceof LibraryEx)) {
            return false;
        }
        LibraryEx libraryEx = (LibraryEx)library;
        if (!RepositoryLibraryType.REPOSITORY_LIBRARY_KIND.equals((Object)libraryEx.getKind())) {
            return false;
        }
        LibraryProperties libraryProperties = libraryEx.getProperties();
        if (libraryProperties == null || !(libraryProperties instanceof RepositoryLibraryProperties)) {
            return false;
        }
        RepositoryLibraryProperties repositoryLibraryProperties = (RepositoryLibraryProperties)libraryProperties;
        RepositoryLibraryDescription description = RepositoryLibraryDescription.findDescription(repositoryLibraryProperties);
        if (!description.equals(this.libraryDescription)) {
            return false;
        }
        return Comparing.equal((String)repositoryLibraryProperties.getVersion(), (String)this.editor.getSelectedVersion());
    }
}

