/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;

public class GrTraitUtil {
    private static final Logger LOG = Logger.getInstance(GrTraitUtil.class);
    private static final PsiTypeMapper ID_MAPPER = new PsiTypeMapper(){

        public PsiType visitClassType(PsiClassType classType) {
            return classType;
        }
    };

    @Contract(value="null -> false")
    public static boolean isInterface(@Nullable PsiClass aClass) {
        return aClass != null && aClass.isInterface() && !GrTraitUtil.isTrait(aClass);
    }

    public static boolean isMethodAbstract(PsiMethod method) {
        if (method.getModifierList().hasExplicitModifier("abstract")) {
            return true;
        }
        PsiClass aClass = method.getContainingClass();
        return GrTraitUtil.isInterface(aClass);
    }

    @NotNull
    public static String getTraitFieldPrefix(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/psi/util/GrTraitUtil", "getTraitFieldPrefix"));
        }
        String qname = aClass.getQualifiedName();
        LOG.assertTrue(qname != null, aClass.getClass());
        String[] idents = qname.split("\\.");
        StringBuilder buffer = new StringBuilder();
        for (String ident : idents) {
            buffer.append(ident).append("_");
        }
        buffer.append("_");
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrTraitUtil", "getTraitFieldPrefix"));
        }
        return string;
    }

    @Contract(value="null -> false")
    public static boolean isTrait(@Nullable PsiClass containingClass) {
        return containingClass instanceof GrTypeDefinition && ((GrTypeDefinition)containingClass).isTrait() || containingClass instanceof ClsClassImpl && containingClass.isInterface() && AnnotationUtil.isAnnotated((PsiModifierListOwner)containingClass, (String)"groovy.transform.Trait", (boolean)false);
    }

    public static PsiMethod createTraitMethodFromCompiledHelperMethod(PsiMethod compiledMethod, PsiClass trait) {
        assert (compiledMethod.getParameterList().getParametersCount() > 0);
        GrLightMethodBuilder result = new GrLightMethodBuilder(compiledMethod.getManager(), compiledMethod.getName());
        result.setNavigationElement((PsiElement)compiledMethod);
        result.setOriginInfo("via @Trait");
        result.addModifier("static");
        for (PsiTypeParameter parameter : compiledMethod.getTypeParameters()) {
            result.getTypeParameterList().addParameter(parameter);
        }
        PsiTypeMapper corrector = GrTraitUtil.createCorrector(compiledMethod, trait);
        PsiParameter[] methodParameters = compiledMethod.getParameterList().getParameters();
        for (int i = 1; i < methodParameters.length; ++i) {
            PsiParameter originalParameter = methodParameters[i];
            PsiType correctedType = (PsiType)originalParameter.getType().accept((PsiTypeVisitor)corrector);
            result.addParameter(originalParameter.getName(), correctedType, false);
        }
        for (PsiClassType type : compiledMethod.getThrowsList().getReferencedTypes()) {
            PsiType correctedType = (PsiType)type.accept((PsiTypeVisitor)corrector);
            result.getThrowsList().addReference(correctedType instanceof PsiClassType ? (PsiClassType)correctedType : type);
        }
        PsiType originalType = compiledMethod.getReturnType();
        result.setReturnType(originalType == null ? null : (PsiType)originalType.accept((PsiTypeVisitor)corrector));
        return result;
    }

    @NotNull
    private static PsiTypeMapper createCorrector(final PsiMethod compiledMethod, PsiClass trait) {
        PsiTypeParameter[] traitTypeParameters = trait.getTypeParameters();
        if (traitTypeParameters.length == 0) {
            PsiTypeMapper psiTypeMapper = ID_MAPPER;
            if (psiTypeMapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrTraitUtil", "createCorrector"));
            }
            return psiTypeMapper;
        }
        THashMap substitutionMap = ContainerUtil.newTroveMap();
        for (PsiTypeParameter parameter : traitTypeParameters) {
            substitutionMap.put(parameter.getName(), parameter);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)trait.getProject()).getElementFactory();
        PsiTypeMapper psiTypeMapper = new PsiTypeMapper((Map)substitutionMap, elementFactory){
            final /* synthetic */ Map val$substitutionMap;
            final /* synthetic */ PsiElementFactory val$elementFactory;
            {
                this.val$substitutionMap = map;
                this.val$elementFactory = psiElementFactory;
            }

            @Nullable
            public PsiType visitClassType(PsiClassType originalType) {
                PsiClass resolved = originalType.resolve();
                if (resolved instanceof PsiTypeParameter && compiledMethod.equals(((PsiTypeParameter)resolved).getOwner())) {
                    return originalType;
                }
                Object[] typeParameters = originalType.getParameters();
                PsiTypeParameter byName = (PsiTypeParameter)this.val$substitutionMap.get(originalType.getCanonicalText());
                if (byName != null) {
                    assert (typeParameters.length == 0);
                    return this.val$elementFactory.createType((PsiClass)byName);
                }
                if (resolved == null) {
                    return originalType;
                }
                if (typeParameters.length == 0) {
                    return originalType;
                }
                Ref hasChanges = Ref.create((Object)false);
                2 $this = this;
                PsiType[] substitutes = (PsiType[])ContainerUtil.map2Array((Object[])typeParameters, PsiType.class, (Function)new Function<PsiType, PsiType>((PsiTypeVisitor)$this, hasChanges){
                    final /* synthetic */ PsiTypeVisitor val$$this;
                    final /* synthetic */ Ref val$hasChanges;
                    {
                        this.val$$this = psiTypeVisitor;
                        this.val$hasChanges = ref;
                    }

                    public PsiType fun(PsiType type) {
                        PsiType mapped = (PsiType)type.accept(this.val$$this);
                        this.val$hasChanges.set((Object)(mapped != type ? 1 : 0));
                        return mapped;
                    }
                });
                return (Boolean)hasChanges.get() != false ? this.val$elementFactory.createType(resolved, substitutes) : originalType;
            }
        };
        if (psiTypeMapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrTraitUtil", "createCorrector"));
        }
        return psiTypeMapper;
    }
}

