/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.theme.ColorPalette;
import com.android.tools.idea.editors.theme.ProjectThemeResolver;
import com.android.tools.idea.editors.theme.ThemeEditorTable;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class AttributesPanel {
    public static final Border BORDER = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    private JComboBox myThemeCombo;
    private JCheckBox myAdvancedFilterCheckBox;
    private JButton myBackButton;
    private JBLabel mySubStyleLabel;
    private ThemeEditorTable myAttributesTable;
    private JBScrollPane myAttributesScrollPane;
    private JPanel myConfigToolbar;
    private JPanel myRightPanel;
    private JComboBox myAttrGroupCombo;
    private ColorPalette myPalette;
    private JBScrollPane myPaletteScrollPane;

    public AttributesPanel() {
        this.$$$setupUI$$$();
        this.myBackButton.setIcon(AllIcons.Actions.Back);
        this.myBackButton.setBorder(BORDER);
        this.myPaletteScrollPane.setVisible(false);
        this.myAdvancedFilterCheckBox.setVisible(false);
        this.myAttrGroupCombo.setVisible(false);
        new ComboboxSpeedSearch(this.myThemeCombo);
        this.myBackButton.setToolTipText("Back to the theme");
        this.myAttributesTable.setSelectionMode(0);
        this.myAttributesTable.setTableHeader(null);
        new TableSpeedSearch((JTable)((Object)this.myAttributesTable)){

            protected int getElementCount() {
                return ((JTable)this.myComponent).getRowCount() * ((JTable)this.myComponent).getColumnCount();
            }
        };
        this.mySubStyleLabel.setVisible(false);
        this.mySubStyleLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.myPalette.setShowCheckeredBackground(true);
        this.myThemeCombo.setMinimumSize(new Dimension(10, this.myThemeCombo.getMinimumSize().height));
        this.myThemeCombo.setPreferredSize(new Dimension(10, this.myThemeCombo.getPreferredSize().height));
    }

    public void setSelectedTheme(ThemeEditorStyle theme) {
        this.myThemeCombo.getModel().setSelectedItem(theme);
    }

    public boolean isCreateNewThemeSelected() {
        return "Create New Theme".equals(this.myThemeCombo.getSelectedItem());
    }

    public boolean isShowAllThemesSelected() {
        return "Show all themes".equals(this.myThemeCombo.getSelectedItem());
    }

    public boolean isRenameSelected() {
        Object selectedItem = this.myThemeCombo.getSelectedItem();
        if (!(selectedItem instanceof String)) {
            return false;
        }
        return ((String)selectedItem).startsWith("Rename ");
    }

    public ThemeEditorStyle getSelectedTheme() {
        Object item = this.myThemeCombo.getSelectedItem();
        if (item instanceof ThemeEditorStyle) {
            return (ThemeEditorStyle)item;
        }
        if (item instanceof ProjectThemeResolver.ThemeWithSource) {
            return ((ProjectThemeResolver.ThemeWithSource)item).getTheme();
        }
        throw new IllegalStateException("getSelectedTheme() is requested on themes combo while selected item is not theme");
    }

    public void setAdvancedMode(boolean isAdvanced) {
        this.myAdvancedFilterCheckBox.setSelected(isAdvanced);
    }

    public boolean isAdvancedMode() {
        return this.myAdvancedFilterCheckBox.isSelected();
    }

    public void setSubstyleName(@Nullable String substyleName) {
        if (substyleName == null) {
            this.mySubStyleLabel.setVisible(false);
        } else {
            this.mySubStyleLabel.setVisible(true);
            this.mySubStyleLabel.setText("\u27a5 " + substyleName);
        }
    }

    public JComboBox getThemeCombo() {
        return this.myThemeCombo;
    }

    public JComboBox getAttrGroupCombo() {
        return this.myAttrGroupCombo;
    }

    public ThemeEditorTable getAttributesTable() {
        return this.myAttributesTable;
    }

    public JButton getBackButton() {
        return this.myBackButton;
    }

    public JCheckBox getAdvancedFilterCheckBox() {
        return this.myAdvancedFilterCheckBox;
    }

    public JBScrollPane getAttributesScrollPane() {
        return this.myAttributesScrollPane;
    }

    public JPanel getRightPanel() {
        return this.myRightPanel;
    }

    public JPanel getConfigToolbar() {
        return this.myConfigToolbar;
    }

    public JBScrollPane getPaletteScrollPane() {
        return this.myPaletteScrollPane;
    }

    public ColorPalette getPalette() {
        return this.myPalette;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ColorPalette colorPalette;
        JBScrollPane jBScrollPane;
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JButton jButton;
        ThemeEditorTable themeEditorTable;
        JBScrollPane jBScrollPane2;
        JBLabel jBLabel;
        JComboBox jComboBox2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRightPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(22, 15, 0, 22), null, 0, 0, null, null));
        this.myConfigToolbar = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel2.add((Component)jPanel3, "Center");
        this.myThemeCombo = jComboBox2 = new JComboBox();
        jPanel3.add(jComboBox2, new GridConstraints(0, 0, 1, 3, 8, 1, 6, 0, null, null, null));
        this.mySubStyleLabel = jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(2);
        jBLabel.setHorizontalTextPosition(2);
        jBLabel.setText("Dummy text");
        jBLabel.setEnabled(true);
        jPanel3.add((Component)jBLabel, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myAttributesScrollPane = jBScrollPane2 = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane2, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myAttributesTable = themeEditorTable = new ThemeEditorTable();
        ((JTable)((Object)themeEditorTable)).setShowVerticalLines(false);
        ((JTable)((Object)themeEditorTable)).setShowHorizontalLines(false);
        jBScrollPane2.setViewportView((Component)((Object)themeEditorTable));
        this.myBackButton = jButton = new JButton();
        jButton.setText("");
        jPanel3.add((Component)jButton, new GridConstraints(3, 0, 1, 1, 0, 3, 1, 0, null, null, null));
        this.myAdvancedFilterCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Advanced");
        jPanel3.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAttrGroupCombo = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(3, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myPaletteScrollPane = jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, new GridConstraints(4, 1, 1, 2, 0, 0, 3, 0, null, null, null));
        this.myPalette = colorPalette = new ColorPalette();
        jBScrollPane.setViewportView(colorPalette);
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 14), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRightPanel;
    }
}

