/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleResolver {
    private static final Logger LOG = Logger.getInstance(StyleResolver.class);
    private final Cache<String, ThemeEditorStyle> myStylesCache;
    private final Configuration myConfiguration;

    public StyleResolver(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/StyleResolver", "<init>"));
        }
        this.myStylesCache = CacheBuilder.newBuilder().build();
        this.myConfiguration = configuration;
    }

    @NotNull
    public static String getQualifiedStyleName(@NotNull StyleResourceValue style) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/editors/theme/StyleResolver", "getQualifiedStyleName"));
        }
        String string = (style.isFramework() ? "@android:style/" : "@style/") + style.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/StyleResolver", "getQualifiedStyleName"));
        }
        return string;
    }

    @NotNull
    public static String getQualifiedItemName(@NotNull ItemResourceValue item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/StyleResolver", "getQualifiedItemName"));
        }
        String string = (item.isFrameworkAttr() ? "android:" : "") + item.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/StyleResolver", "getQualifiedItemName"));
        }
        return string;
    }

    @NotNull
    public static String getQualifiedValue(@NotNull ItemResourceValue item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/StyleResolver", "getQualifiedValue"));
        }
        ResourceUrl url = ResourceUrl.parse((String)item.getRawXmlValue(), (boolean)item.isFramework());
        String string = url == null ? item.getRawXmlValue() : url.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/StyleResolver", "getQualifiedValue"));
        }
        return string;
    }

    @NotNull
    public ThemeEditorStyle getStyle(final @NotNull String qualifiedStyleName) {
        ThemeEditorStyle themeEditorStyle;
        if (qualifiedStyleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedStyleName", "com/android/tools/idea/editors/theme/StyleResolver", "getStyle"));
        }
        try {
            themeEditorStyle = (ThemeEditorStyle)this.myStylesCache.get((Object)qualifiedStyleName, (Callable)new Callable<ThemeEditorStyle>(){

                @Override
                public ThemeEditorStyle call() throws Exception {
                    if (qualifiedStyleName.startsWith("@android:style/")) {
                        String styleName = qualifiedStyleName.substring("@android:style/".length());
                        return new ThemeEditorStyle(StyleResolver.this, StyleResolver.this.myConfiguration, styleName, true);
                    }
                    String styleName = qualifiedStyleName;
                    if (qualifiedStyleName.startsWith("@style/")) {
                        styleName = qualifiedStyleName.substring("@style/".length());
                    }
                    return new ThemeEditorStyle(StyleResolver.this, StyleResolver.this.myConfiguration, styleName, false);
                }
            });
        }
        catch (ExecutionException e) {
            LOG.warn("Unable to retrieve style", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        if (themeEditorStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/StyleResolver", "getStyle"));
        }
        return themeEditorStyle;
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Configuration configuration, @NotNull ItemResourceValue itemResValue) {
        AttributeDefinitions definitions;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/StyleResolver", "getAttributeDefinition"));
        }
        if (itemResValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemResValue", "com/android/tools/idea/editors/theme/StyleResolver", "getAttributeDefinition"));
        }
        Module module = configuration.getModule();
        if (itemResValue.isFrameworkAttr()) {
            IAndroidTarget target = configuration.getTarget();
            assert (target != null);
            AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, module);
            assert (androidTargetData != null);
            definitions = androidTargetData.getAllAttrDefs(module.getProject());
        } else {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null) : String.format("Module %s is not an Android module", module.getName());
            definitions = facet.getLocalResourceManager().getAttributeDefinitions();
        }
        if (definitions == null) {
            return null;
        }
        return definitions.getAttrDefByName(itemResValue.getName());
    }
}

