/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.ChooseGradleHomeDialog;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

final class PreSyncChecks {
    private static final Logger LOG = Logger.getInstance(PreSyncChecks.class);
    private static final String GRADLE_SYNC_MSG_TITLE = "Gradle Sync";
    private static final String PROJECT_SYNCING_ERROR_GROUP = "Project syncing error";
    @NonNls
    private static final String SHOW_DO_NOT_ASK_TO_COPY_PROXY_SETTINGS_PROPERTY_NAME = "show.do.not.copy.http.proxy.settings.to.gradle";

    private PreSyncChecks() {
    }

    @NotNull
    static PreSyncCheckResult canSync(@NotNull Project project) {
        boolean usingWrapper;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PreSyncChecks", "canSync"));
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.success();
            if (preSyncCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks", "canSync"));
            }
            return preSyncCheckResult;
        }
        if (AndroidStudioSpecificInitializer.isAndroidStudio()) {
            PreSyncChecks.checkHttpProxySettings(project);
        }
        ProjectSyncMessages syncMessages = ProjectSyncMessages.getInstance(project);
        syncMessages.removeMessages(PROJECT_SYNCING_ERROR_GROUP);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            GradleUtil.attemptToUseEmbeddedGradle(project);
        }
        GradleProjectSettings gradleSettings = GradleUtil.getGradleProjectSettings(project);
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        DistributionType distributionType = gradleSettings != null ? gradleSettings.getDistributionType() : null;
        boolean bl = usingWrapper = (distributionType == null || distributionType == DistributionType.DEFAULT_WRAPPED) && wrapperPropertiesFile != null;
        if (usingWrapper && gradleSettings != null) {
            gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        } else if (!ApplicationManager.getApplication().isUnitTestMode() && wrapperPropertiesFile == null && gradleSettings != null) {
            PreSyncChecks.createWrapperIfNecessary(project, gradleSettings, distributionType);
        }
        PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.success();
        if (preSyncCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks", "canSync"));
        }
        return preSyncCheckResult;
    }

    private static void checkHttpProxySettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PreSyncChecks", "checkHttpProxySettings"));
        }
        boolean performCheck = PropertiesComponent.getInstance().getBoolean(SHOW_DO_NOT_ASK_TO_COPY_PROXY_SETTINGS_PROPERTY_NAME, true);
        if (!performCheck) {
            return;
        }
        HttpConfigurable ideProxySettings = HttpConfigurable.getInstance();
        if (ideProxySettings.USE_HTTP_PROXY && StringUtil.isNotEmpty((String)ideProxySettings.PROXY_HOST)) {
            GradleProperties properties;
            try {
                properties = new GradleProperties(project);
            }
            catch (IOException e) {
                LOG.info("Failed to read gradle.properties file", (Throwable)e);
                return;
            }
            GradleProperties.ProxySettings proxySettings = properties.getProxySettings();
            if (!ideProxySettings.PROXY_HOST.equals(proxySettings.getHost())) {
                String msg = "Android Studio is configured to use a HTTP proxy. Gradle may need these proxy settings to access the Internet (e.g. for downloading dependencies.)\n\nWould you like to have the IDE's proxy configuration be set in the project's gradle.properties file?";
                PropertyDoNotAskOption doNotAskOption = new PropertyDoNotAskOption(SHOW_DO_NOT_ASK_TO_COPY_PROXY_SETTINGS_PROPERTY_NAME);
                int result = Messages.showYesNoDialog((Project)project, (String)msg, (String)"Proxy Settings", (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption);
                if (result == 0) {
                    proxySettings.copyFrom(ideProxySettings);
                    properties.setProxySettings(proxySettings);
                    try {
                        properties.save();
                    }
                    catch (IOException e) {
                        Throwable root = ExceptionUtil.getRootCause((Throwable)e);
                        String cause = root.getMessage();
                        String errMsg = "Failed to save changes to gradle.properties file.";
                        if (StringUtil.isNotEmpty((String)cause)) {
                            if (!cause.endsWith(".")) {
                                cause = cause + ".";
                            }
                            errMsg = errMsg + String.format("\nCause: %1$s", cause);
                        }
                        AndroidGradleNotification notification = AndroidGradleNotification.getInstance(project);
                        notification.showBalloon("Proxy Settings", errMsg, NotificationType.ERROR);
                        LOG.info("Failed to save changes to gradle.properties file", (Throwable)e);
                    }
                }
            }
        }
    }

    private static boolean createWrapperIfNecessary(@NotNull Project project, @NotNull GradleProjectSettings gradleSettings, @Nullable DistributionType distributionType) {
        ChooseGradleHomeDialog dialog;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PreSyncChecks", "createWrapperIfNecessary"));
        }
        if (gradleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleSettings", "com/android/tools/idea/gradle/project/PreSyncChecks", "createWrapperIfNecessary"));
        }
        boolean createWrapper = false;
        boolean chooseLocalGradleHome = false;
        if (distributionType == null) {
            String msg = PreSyncChecks.createUseWrapperQuestion("Gradle settings for this project are not configured yet.");
            int answer = Messages.showOkCancelDialog((Project)project, (String)msg, (String)GRADLE_SYNC_MSG_TITLE, (Icon)Messages.getQuestionIcon());
            createWrapper = answer == 0;
        } else if (distributionType == DistributionType.DEFAULT_WRAPPED) {
            createWrapper = true;
        } else if (distributionType == DistributionType.LOCAL) {
            String gradleHome = gradleSettings.getGradleHome();
            String msg = null;
            if (StringUtil.isEmpty((String)gradleHome)) {
                msg = PreSyncChecks.createUseWrapperQuestion("The path of the local Gradle distribution to use is not set.");
            } else {
                File gradleHomePath = new File(FileUtil.toSystemDependentName((String)gradleHome));
                if (!gradleHomePath.isDirectory()) {
                    String reason = String.format("The path\n'%1$s'\n, set as a local Gradle distribution, does not belong to an existing directory.", gradleHomePath.getPath());
                    msg = PreSyncChecks.createUseWrapperQuestion(reason);
                } else {
                    FullRevision gradleVersion = GradleUtil.getGradleVersion(gradleHomePath);
                    if (gradleVersion == null) {
                        String reason = String.format("The path\n'%1$s'\n, does not belong to a Gradle distribution.", gradleHomePath.getPath());
                        msg = PreSyncChecks.createUseWrapperQuestion(reason);
                    } else if (!GradleUtil.isSupportedGradleVersion(gradleVersion)) {
                        String reason = String.format("Gradle version %1$s is not supported.", gradleHomePath.getPath());
                        msg = PreSyncChecks.createUseWrapperQuestion(reason);
                    }
                }
            }
            if (msg != null) {
                int answer = Messages.showOkCancelDialog((Project)project, (String)msg, (String)GRADLE_SYNC_MSG_TITLE, (Icon)Messages.getQuestionIcon());
                createWrapper = answer == 0;
                boolean bl = chooseLocalGradleHome = !createWrapper;
            }
        }
        if (createWrapper) {
            File projectDirPath = Projects.getBaseDirPath(project);
            File gradleDirPath = new File(projectDirPath, "gradle");
            if (!FileUtil.delete((File)gradleDirPath)) {
                return true;
            }
            try {
                GradleUtil.createGradleWrapper(projectDirPath);
                if (distributionType == null) {
                    gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
                }
                return true;
            }
            catch (IOException e) {
                LOG.info("Failed to create Gradle wrapper for project '" + project.getName() + "'", (Throwable)e);
            }
        } else if ((distributionType == null || chooseLocalGradleHome) && (dialog = new ChooseGradleHomeDialog()).showAndGet()) {
            String enteredGradleHomePath = dialog.getEnteredGradleHomePath();
            gradleSettings.setGradleHome(enteredGradleHomePath);
            gradleSettings.setDistributionType(DistributionType.LOCAL);
            return true;
        }
        return false;
    }

    @NotNull
    private static String createUseWrapperQuestion(@NotNull String reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/android/tools/idea/gradle/project/PreSyncChecks", "createUseWrapperQuestion"));
        }
        String string = reason + "\n\n" + "Would you like the project to use the Gradle wrapper?\n" + "(The wrapper will automatically download the latest supported Gradle version).\n\n" + "Click 'OK' to use the Gradle wrapper, or 'Cancel' to manually set the path of a local Gradle distribution.";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks", "createUseWrapperQuestion"));
        }
        return string;
    }

    private static class PropertyDoNotAskOption
    implements DialogWrapper.DoNotAskOption {
        @NotNull
        private final String myProperty;

        PropertyDoNotAskOption(@NotNull String property) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/project/PreSyncChecks$PropertyDoNotAskOption", "<init>"));
            }
            this.myProperty = property;
        }

        public boolean isToBeShown() {
            return PropertiesComponent.getInstance().getBoolean(this.myProperty, true);
        }

        public void setToBeShown(boolean toBeShown, int exitCode) {
            PropertiesComponent.getInstance().setValue(this.myProperty, String.valueOf(toBeShown));
        }

        public boolean canBeHidden() {
            return true;
        }

        public boolean shouldSaveOptionsOnCancel() {
            return true;
        }

        @NotNull
        public String getDoNotShowMessage() {
            String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks$PropertyDoNotAskOption", "getDoNotShowMessage"));
            }
            return string;
        }
    }

    static class PreSyncCheckResult {
        private final boolean mySuccess;
        @Nullable
        private final String myFailureCause;

        @NotNull
        private static PreSyncCheckResult success() {
            PreSyncCheckResult preSyncCheckResult = new PreSyncCheckResult(true, null);
            if (preSyncCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks$PreSyncCheckResult", "success"));
            }
            return preSyncCheckResult;
        }

        @NotNull
        private static PreSyncCheckResult failure(@NotNull String cause) {
            if (cause == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "com/android/tools/idea/gradle/project/PreSyncChecks$PreSyncCheckResult", "failure"));
            }
            PreSyncCheckResult preSyncCheckResult = new PreSyncCheckResult(false, cause);
            if (preSyncCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks$PreSyncCheckResult", "failure"));
            }
            return preSyncCheckResult;
        }

        private PreSyncCheckResult(boolean success, @Nullable String failureCause) {
            this.mySuccess = success;
            this.myFailureCause = failureCause;
        }

        public boolean isSuccess() {
            return this.mySuccess;
        }

        @Nullable
        public String getFailureCause() {
            return this.myFailureCause;
        }
    }
}

