/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.JavaModel;
import com.android.tools.idea.gradle.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.dependency.DependencySetupErrors;
import com.android.tools.idea.gradle.dependency.LibraryDependency;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.JavaGradleFacet;
import com.android.tools.idea.gradle.facet.JavaGradleFacetConfiguration;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.project.PostProjectSetupTasksExecutor;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public final class Projects {
    private static final Key<String> GRADLE_VERSION = Key.create((String)"project.gradle.version");
    private static final Key<LibraryDependency> MODULE_COMPILED_ARTIFACT = Key.create((String)"module.compiled.artifact");
    private static final Key<Boolean> HAS_SYNC_ERRORS = Key.create((String)"project.has.sync.errors");
    private static final Key<Boolean> HAS_WRONG_JDK = Key.create((String)"project.has.wrong.jdk");
    private static final Key<DependencySetupErrors> DEPENDENCY_SETUP_ERRORS = Key.create((String)"project.dependency.setup.errors");

    private Projects() {
    }

    @NotNull
    public static File getBaseDirPath(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getBaseDirPath"));
        }
        String basePath = project.getBasePath();
        assert (basePath != null);
        File file = new File(FileUtil.toCanonicalPath((String)basePath));
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getBaseDirPath"));
        }
        return file;
    }

    public static void setGradleVersionUsed(@NotNull Project project, @Nullable String gradleVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "setGradleVersionUsed"));
        }
        project.putUserData(GRADLE_VERSION, (Object)gradleVersion);
    }

    @Nullable
    public static String getGradleVersionUsed(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getGradleVersionUsed"));
        }
        return (String)project.getUserData(GRADLE_VERSION);
    }

    public static void removeAllModuleCompiledArtifacts(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "removeAllModuleCompiledArtifacts"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            Projects.setModuleCompiledArtifact(module, null);
        }
    }

    public static void setModuleCompiledArtifact(@NotNull Module module, @Nullable LibraryDependency compiledArtifact) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "setModuleCompiledArtifact"));
        }
        module.putUserData(MODULE_COMPILED_ARTIFACT, (Object)compiledArtifact);
    }

    @Nullable
    public static LibraryDependency getModuleCompiledArtifact(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "getModuleCompiledArtifact"));
        }
        return (LibraryDependency)module.getUserData(MODULE_COMPILED_ARTIFACT);
    }

    public static void populate(final @NotNull Project project, final @NotNull Collection<DataNode<ModuleData>> modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "populate"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/util/Projects", "populate"));
        }
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ProjectSyncMessages messages = ProjectSyncMessages.getInstance(project);
                messages.removeMessages("Project structure issues", "Missing dependencies between modules", "Failed to set up dependencies", "Variant selection conflicts", "Source folders generated at incorrect location");
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        if (!project.isDisposed()) {
                            ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(new Runnable(){

                                @Override
                                public void run() {
                                    ProjectDataManager dataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
                                    dataManager.importData(ProjectKeys.MODULE, modules, project, true);
                                }
                            });
                        }
                    }
                });
                PostProjectSetupTasksExecutor.getInstance(project).onProjectSyncCompletion();
            }
        });
    }

    public static void executeProjectChanges(final @NotNull Project project, final @NotNull Runnable changes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "executeProjectChanges"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/android/tools/idea/gradle/util/Projects", "executeProjectChanges"));
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        if (!project.isDisposed()) {
                            ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(changes);
                        }
                    }
                });
            }
        };
        UIUtil.invokeAndWaitIfNeeded((Runnable)task);
    }

    public static void setHasSyncErrors(@NotNull Project project, boolean hasSyncErrors) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "setHasSyncErrors"));
        }
        project.putUserData(HAS_SYNC_ERRORS, (Object)hasSyncErrors);
    }

    public static void setHasWrongJdk(@NotNull Project project, boolean hasWrongJdk) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "setHasWrongJdk"));
        }
        project.putUserData(HAS_WRONG_JDK, (Object)hasWrongJdk);
    }

    public static boolean lastGradleSyncFailed(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "lastGradleSyncFailed"));
        }
        return !GradleSyncState.getInstance(project).isSyncInProgress() && Projects.isGradleProjectWithoutModel(project);
    }

    public static boolean hasErrors(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "hasErrors"));
        }
        if (Projects.hasSyncErrors(project) || Projects.hasWrongJdk(project)) {
            return true;
        }
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(project);
        int errorCount = messages.getErrorCount();
        if (errorCount > 0) {
            return false;
        }
        int variantSelectionErrorCount = messages.getMessageCount("Variant selection conflicts");
        return errorCount != variantSelectionErrorCount;
    }

    private static boolean hasSyncErrors(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "hasSyncErrors"));
        }
        return Projects.getBoolean(project, HAS_SYNC_ERRORS);
    }

    private static boolean hasWrongJdk(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "hasWrongJdk"));
        }
        return Projects.getBoolean(project, HAS_WRONG_JDK);
    }

    private static boolean getBoolean(@NotNull Project project, @NotNull Key<Boolean> key) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getBoolean"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/gradle/util/Projects", "getBoolean"));
        }
        Boolean val = (Boolean)project.getUserData(key);
        return val != null && val != false;
    }

    public static boolean isGradleProjectWithoutModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isGradleProjectWithoutModel"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || !facet.isGradleProject() || facet.getIdeaAndroidProject() != null) continue;
            return true;
        }
        return false;
    }

    public static void open(@NotNull Project project) {
        boolean fullScreen;
        IdeFocusManager instance;
        IdeFrame lastFocusedFrame;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "open"));
        }
        ProjectUtil.updateLastProjectLocation((String)project.getBasePath());
        if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && (lastFocusedFrame = (instance = IdeFocusManager.findInstance()).getLastFocusedFrame()) instanceof IdeFrameEx && (fullScreen = ((IdeFrameEx)lastFocusedFrame).isInFullScreen())) {
            project.putUserData(IdeFrameImpl.SHOULD_OPEN_IN_FULL_SCREEN, (Object)Boolean.TRUE);
        }
        ProjectManagerEx.getInstanceEx().openProject(project);
    }

    public static boolean isDirectGradleInvocationEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isDirectGradleInvocationEnabled"));
        }
        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
        return buildConfiguration.USE_EXPERIMENTAL_FASTER_BUILD;
    }

    public static boolean isOfflineBuildModeEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isOfflineBuildModeEnabled"));
        }
        return GradleSettings.getInstance((Project)project).isOfflineWork();
    }

    public static boolean isGradleProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isGradleProject"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet == null || !androidFacet.isGradleProject()) continue;
            return true;
        }
        return false;
    }

    public static boolean isIdeaAndroidProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isIdeaAndroidProject"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            if (AndroidFacet.getInstance(module) == null || Projects.isBuildWithGradle(module)) continue;
            return true;
        }
        return false;
    }

    public static void enforceExternalBuild(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "enforceExternalBuild"));
        }
        if (Projects.isGradleProject(project) && !AndroidStudioSpecificInitializer.isAndroidStudio()) {
            AndroidGradleBuildConfiguration.getInstance((Project)project).USE_EXPERIMENTAL_FASTER_BUILD = false;
        }
    }

    @NotNull
    public static Module[] getModulesToBuildFromSelection(@NotNull Project project, @Nullable DataContext dataContext) {
        Module[] modules;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
        }
        if (dataContext == null) {
            ProjectView projectView = ProjectView.getInstance((Project)project);
            AbstractProjectViewPane pane = projectView.getCurrentProjectViewPane();
            if (pane != null) {
                JComponent treeComponent = pane.getComponentToFocus();
                dataContext = DataManager.getInstance().getDataContext((Component)treeComponent);
            } else {
                if (Module.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
                }
                return Module.EMPTY_ARRAY;
            }
        }
        if ((modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext)) != null) {
            if (modules.length == 1 && Projects.isProjectModule(modules[0])) {
                Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
                if (moduleArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
                }
                return moduleArray;
            }
            if (modules == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
            }
            return modules;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module != null) {
            Module[] moduleArray;
            if (Projects.isProjectModule(module)) {
                moduleArray = ModuleManager.getInstance((Project)project).getModules();
            } else {
                Module[] moduleArray2 = new Module[1];
                moduleArray = moduleArray2;
                moduleArray2[0] = module;
            }
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
            }
            return moduleArray;
        }
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/Projects", "getModulesToBuildFromSelection"));
        }
        return Module.EMPTY_ARRAY;
    }

    public static boolean isProjectModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "isProjectModule"));
        }
        File moduleFilePath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
        File moduleRootDirPath = moduleFilePath.getParentFile();
        if (moduleRootDirPath == null) {
            return false;
        }
        String basePath = module.getProject().getBasePath();
        return basePath != null && FileUtil.filesEqual((File)moduleRootDirPath, (File)new File(basePath)) && !Projects.isBuildWithGradle(module);
    }

    public static boolean isBuildWithGradle(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "isBuildWithGradle"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            if (!Projects.isBuildWithGradle(module)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBuildWithGradle(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "isBuildWithGradle"));
        }
        return AndroidGradleFacet.getInstance(module) != null;
    }

    @Nullable
    public static Module findGradleProjectModule(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "findGradleProjectModule"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Module[] modules = moduleManager.getModules();
        if (modules.length == 1) {
            return modules[0];
        }
        for (Module module : modules) {
            if (!Projects.isGradleProjectModule(module)) continue;
            return module;
        }
        return null;
    }

    public static boolean isGradleProjectModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "isGradleProjectModule"));
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet != null && androidFacet.isGradleProject()) {
            File moduleRootDirPath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath())).getParentFile();
            return FileUtil.pathsEqual((String)moduleRootDirPath.getPath(), (String)module.getProject().getBasePath());
        }
        return !Projects.isBuildWithGradle(module);
    }

    @Nullable
    public static File getBuildFolderPath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Projects", "getBuildFolderPath"));
        }
        if (module.isDisposed() || !Projects.isGradleProject(module.getProject())) {
            return null;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet != null && androidFacet.getIdeaAndroidProject() != null) {
            return androidFacet.getIdeaAndroidProject().getDelegate().getBuildFolder();
        }
        JavaGradleFacet javaFacet = JavaGradleFacet.getInstance(module);
        if (javaFacet != null) {
            JavaModel javaModel = javaFacet.getJavaModel();
            if (javaModel != null) {
                return javaFacet.getJavaModel().getBuildFolderPath();
            }
            String path = ((JavaGradleFacetConfiguration)javaFacet.getConfiguration()).BUILD_FOLDER_PATH;
            if (StringUtil.isNotEmpty((String)path)) {
                return new File(FileUtil.toSystemDependentName((String)path));
            }
        }
        return null;
    }

    @Nullable
    public static DependencySetupErrors getDependencySetupErrors(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "getDependencySetupErrors"));
        }
        return (DependencySetupErrors)project.getUserData(DEPENDENCY_SETUP_ERRORS);
    }

    public static void setDependencySetupErrors(@NotNull Project project, @Nullable DependencySetupErrors errors) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/Projects", "setDependencySetupErrors"));
        }
        project.putUserData(DEPENDENCY_SETUP_ERRORS, (Object)errors);
    }
}

