/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import java.util.List;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.AstPackage$ASTUtil$f270b16f;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.html.EntityConverter;
import org.intellij.markdown.html.HtmlGenerator;
import org.jetbrains.annotations.NotNull;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"'\b)i\u0001\n^7m\u000f\u0016tWM]1u_JT1a\u001c:h\u0015!Ig\u000e^3mY&T'\u0002C7be.$wn\u001e8\u000b\t!$X\u000e\u001c\u0006\u0004\u0003:L(BB6pi2LgN\u0003\u0004=S:LGO\u0010\u0006\r[\u0006\u00148\u000eZ8x]R+\u0007\u0010\u001e\u0006\u0007'R\u0014\u0018N\\4\u000b\tI|w\u000e\u001e\u0006\b\u0003N#fj\u001c3f\u0015\r\t7\u000f\u001e\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'B\u00035u[2\u001cFO]5oO*i1\u000b\u001e:j]\u001e\u0014U/\u001b7eKJT\u0011\u0002\u001d:pm&$WM]:\u000b\u00075\u000b\u0007O\u0003\u0007J\u000b2,W.\u001a8u)f\u0004XM\u0003\nHK:,'/\u0019;j]\u001e\u0004&o\u001c<jI\u0016\u0014(\u0002B;uS2TAbZ3oKJ\fG/\u001a%u[2T\u0011bQ8na\u0006t\u0017n\u001c8\u000b+!#X\u000e\\$f]\u0016\u0014\u0018\r^5oOZK7/\u001b;pe*q\u0012J\u001c7j]\u0016Du\u000e\u001c3fe\u001e+g.\u001a:bi&tw\r\u0015:pm&$WM\u001d\u0006\u001f\u001d>t'+Z2veNLg/Z$f]\u0016\u0014\u0018\r^5oOB\u0013xN^5eKJT1d\u00149f]\u000ecwn]3HK:,'/\u0019;j]\u001e\u0004&o\u001c<jI\u0016\u0014(bF*j[BdW-\u00138mS:,G+Y4Qe>4\u0018\u000eZ3s\u0015E\u0019\u0016.\u001c9mKR\u000bw\r\u0015:pm&$WM\u001d\u0006 )J\fgn\u001d9be\u0016tG/\u00138mS:,\u0007j\u001c7eKJ\u0004&o\u001c<jI\u0016\u0014\b2\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\r!\u0019\u0001\u0003\u0001\r\u0001\u0015\t\u0001bA\u0003\u0004\t\u000bA)\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0012\u0002\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0004\u0006\u0007\u0011!\u00012\u0002\u0007\u0001\u000b\u0005Ai!\u0002\u0002\u0005\u000b!9QA\u0001C\u0006\u0011\u0013)!\u0001\u0002\u0003\t\f\u0015\u0019A1\u0002\u0005\t\u0019\u0001)!\u0001b\u0003\t\u0011\u0015\u0019AQ\u0001\u0005\n\u0019\u0001)1\u0001B\u0001\t\u00141\u0001Qa\u0001\u0003\u0003\u0011)a\u0001!\u0002\u0002\u0005\u000b!UQA\u0001C\n\u0011%!1\u0001\u0004\u0002\u0011\u0018e\u0019Q!\u0001\u0005\u00041\riJq\u0003\u0006\r\u001a5maRD\b.\u0019\u0011\tG\u0001g\u0004\"\u0007\u0015\t\u0001b\u0002\r\b+\u000e!Qa\u0001C\b\u0013\u0005Ay!\f\u0007\u0005C\u0012AB!I\u0002\u0006\u0003!\u001d\u0001tA+\u0004\t\u0015\u0019A\u0001B\u0005\u0002\u0011\u0019ic\u0003B1\u00051#\tS\"B\u0001\t\u0011%!\u0011bA\u0003\u0002\u0011#A\n\"\u0003\u0003\n\u0007\u0015\t\u0001\"\u0003\r\n1!)6\u0001B\u0003\u0004\t#I\u0011\u0001\u0003\u0006.\u0019\u0011\tG\u0001G\u0003\"\u0007\u0015\t\u0001\u0012\u0002M\u0005+\u000e!Qa\u0001\u0003\u0006\u0013\u0005Ai!,\u0006\u0005\u0007aY\u0011eA\u0003\u0002\u0011\u000fA:!U\u0002\u0004\t-I\u0011\u0001\u0003\u00046C\u0015\u0001Ca9\u0001\u0019\bu=A\u0001\u0001\u0005\u0005\u001b\r)\u0011\u0001c\u0002\u0019\bA\u001b\u0001!h\u0004\u0005\u0001!)QbA\u0003\u0002\u0011\u0013AJ\u0001UB\u0001C\r)\u0011\u0001\u0003\u0002\u0019\u0005E\u001bq\u0001b\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\u0007\u001b\u0005Ai\u0001"})
public final class HtmlGenerator {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final EntityConverter entityConverter;
    private final StringBuilder htmlString;
    private final Map<IElementType, ? extends GeneratingProvider> providers;
    private final String markdownText;
    private final ASTNode root;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(HtmlGenerator.class);
        Companion companion = Companion = new Companion(null);
        entityConverter = new EntityConverter();
    }

    @NotNull
    public final String generateHtml() {
        new HtmlGeneratingVisitor().visitNode(this.root);
        String string = this.htmlString.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"htmlString.toString()");
        return string;
    }

    public HtmlGenerator(@NotNull String markdownText, @NotNull ASTNode root) {
        Intrinsics.checkParameterIsNotNull((Object)markdownText, (String)"markdownText");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        this.markdownText = markdownText;
        this.root = root;
        this.htmlString = new StringBuilder();
        this.providers = Companion.initProviders();
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={">\u0004))\u0002\n^7m\u000f\u0016tWM]1uS:<g+[:ji>\u0014(\"\u0004%u[2<UM\\3sCR|'OC\u0002pe\u001eT\u0001\"\u001b8uK2d\u0017N\u001b\u0006\t[\u0006\u00148\u000eZ8x]*!\u0001\u000e^7m\u0015A\u0011VmY;sg&4XMV5tSR|'OC\u0002bgRT\u0001B^5tSR|'o\u001d\u0006\u0007y%t\u0017\u000e\u001e \u000b\u0017\r|gn];nK\"#X\u000e\u001c\u0006\r\u0007\"\f'oU3rk\u0016t7-\u001a\u0006\u0007W>$H.\u001b8\u000b\tUs\u0017\u000e\u001e\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'\"\u0003<jg&$hj\u001c3f\u0015\u0011qw\u000eZ3\u000b\u000f\u0005\u001bFKT8eKJT!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!B\u0002\u0005\u0004!\u0005A\u0002A\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001rA\u0003\u0003\t\rAA!B\u0002\u0005\b!\u0019A\u0002A\u0003\u0003\t\u0007A\t!B\u0001\t\r\u0015\u0019A!\u0002E\u0006\u0019\u0001)1\u0001B\u0003\t\u000e1\u0001Q!\u0001\u0005\b\u000b\t!i\u0001c\u0004\u0006\u0005\u00119\u00012B\u0003\u0004\t\rA\u0011\u0002\u0004\u0001\u0006\u0005\u0011\u0019\u0001\"\u0003\u0003A\u00051\u0015\u0011dA\u0003\u0002\u0011\u0011AB!L\u000b\u0005\u0007a)Qt\u0002\u0003\u0001\u0011\u000bi1!B\u0001\t\fa-\u0001k\u0001\u0001\"\u0007\u0015\t\u0001B\u0002\r\u0007#\u000e)A!B\u0005\u0002\t\u0001i\u0011\u0001c\u0004.+\u0011A\u0001\u0004CO\b\t\u0001A\t\"D\u0002\u0006\u0003!A\u0001\u0004\u0003)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u00071\u0019\t6!\u0002\u0003\t\u0013\u0005!\u0001!D\u0001\t\u0012UrQ!\u0004\u0003d\u0002a%\u0011eA\u0003\u0002\u0011\u000bA*!U\u0002\u0006\t\u0013I\u0011\u0001\u0002\u0001\u000e\u0003!%\u0001"})
    public final class HtmlGeneratingVisitor
    extends RecursiveVisitor {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(HtmlGeneratingVisitor.class);
        }

        @Override
        public void visitNode(@NotNull ASTNode node) {
            block3: {
                GeneratingProvider generatingProvider;
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    generatingProvider = HtmlGenerator.this.providers.get(node.getType());
                    if (generatingProvider == null) break block2;
                    generatingProvider.processNode(this, HtmlGenerator.this.markdownText, node);
                    generatingProvider = Unit.INSTANCE$;
                    if (generatingProvider != null) break block3;
                }
                node.acceptChildren(this);
                generatingProvider = Unit.INSTANCE$;
            }
        }

        public final void consumeHtml(@NotNull CharSequence html) {
            Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
            HtmlGenerator.this.htmlString.append(html);
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"V\u0004)\u0011r)\u001a8fe\u0006$\u0018N\\4Qe>4\u0018\u000eZ3s\u00155AE/\u001c7HK:,'/\u0019;pe*\u0019qN]4\u000b\u0011%tG/\u001a7mS*T\u0001\"\\1sW\u0012|wO\u001c\u0006\u0005QRlGNC\u0002B]fTaa[8uY&t'b\u00039s_\u000e,7o\u001d(pI\u0016TqA^5tSR|'OC\u000bIi6dw)\u001a8fe\u0006$\u0018N\\4WSNLGo\u001c:\u000b\tQ,\u0007\u0010\u001e\u0006\u0007'R\u0014\u0018N\\4\u000b\t9|G-\u001a\u0006\b\u0003N#fj\u001c3f\u0015\r\t7\u000f\u001e\u0006\u0005+:LGOC\u0012Ii6dw)\u001a8fe\u0006$xN\u001d\u0013Ii6dw)\u001a8fe\u0006$\u0018N\\4WSNLGo\u001c:\u000b\t)\fg/\u0019\u0006\u0005Y\u0006tw\r\u001e\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\r!\u0019\u0001#\u0001\r\u0001\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)\u0011\u0001c\u0002\u0006\u0007\u0011\u0019\u0001b\u0001\u0007\u0001\u000b\r!!\u0001C\u0003\r\u0001\u0015\u0019Aa\u0001\u0005\u0007\u0019\u0001)!\u0001B\u0001\t\u0010\u0015\u0019A!\u0002\u0005\b\u0019\u0001)1\u0001B\u0002\t\u00111\u0001QA\u0001C\u0002\u0011#)\u0011\u0001C\u0005\u0006\u0005\u00119\u00012C\u0003\u0003\t\u001fAa!\u0002\u0002\u0005\u000b!9A\u0001\rG\u00033\r)\u0011\u0001c\u0002\u0019\b5RC\u0001\u0005\r\u0005;\u001f!\u0001\u0001#\u0003\u000e\u0007\u0015\t\u0001\u0002\u0002\r\u0005!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u0017i1!B\u0001\t\na%\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001RB\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0005\t3!B\u0001\t\ra1\u0011kA\u0005\u0005\t%\tA\u0001A\u0007\u0002\u0011\u001bi\u0011\u0001\u0003\u0005\u000e\u0003!E\u0001"})
    public static interface GeneratingProvider {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(GeneratingProvider.class);
        }

        public void processNode(@NotNull HtmlGeneratingVisitor var1, @NotNull String var2, @NotNull ASTNode var3);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\t\u0006)Yr\n]3o\u00072|7/Z$f]\u0016\u0014\u0018\r^5oOB\u0013xN^5eKJTQ\u0002\u0013;nY\u001e+g.\u001a:bi>\u0014(bA8sO*A\u0011N\u001c;fY2L'N\u0003\u0005nCJ\\Gm\\<o\u0015\u0011AG/\u001c7\u000b%\u001d+g.\u001a:bi&tw\r\u0015:pm&$WM\u001d\u0006\u0007y%t\u0017\u000e\u001e \u000b\u0011\rdwn]3UC\u001eTA\u0001^3yi*11\u000b\u001e:j]\u001eTaa[8uY&t'\u0002\u00028pI\u0016Tq!Q*U\u001d>$WMC\u0002bgRTAA[1wC*!A.\u00198h\u0015\u001dy\u0007/\u001a8UC\u001eT1\u0002\u001d:pG\u0016\u001c8OT8eK*9a/[:ji>\u0014(\"\u0006%u[2<UM\\3sCRLgn\u001a,jg&$xN\u001d\u0006\u0005+:LGOC\u0012Ii6dw)\u001a8fe\u0006$xN\u001d\u0013Ii6dw)\u001a8fe\u0006$\u0018N\\4WSNLGo\u001c:u\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)1\u0001b\u0001\t\u00021\u0001Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0002\u0005\u0005!\u0019A\u0002A\u0003\u0002\u0011\u0017)1\u0001b\u0002\t\u000b1\u0001QA\u0001\u0003\u0002\u0011\u001d)1\u0001\"\u0003\t\u000e1\u0001Q!\u0001E\b\u000b\t!Y\u0001\u0003\u0005\u0006\u0005\u00111\u0001\"B\u0003\u0003\t\u0013Ai!B\u0002\u0005\u0005!QA\u0002A\u0003\u0004\t\u000fA)\u0002\u0004\u0001\u0006\u0005\u0011\r\u0001b\u0003\u0003\u0011\u0019\u000bI2!B\u0001\t\u0007a\u0019Qv\b\u0003\u00111\u0011iz\u0001\u0002\u0001\t\n5\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0001AO\b\t\u0001Aa!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00051\u0011\t6a\u0002\u0003\u0005\u0013\u0005Ai!D\u0001\t\u000e5\t\u0001bBW \tAA\n\"h\u0004\u0005\u0001!%QbA\u0003\u0002\u0011\u0011AB\u0001U\u0002\u0001;\u001f!\u0001\u0001\u0003\u0004\u000e\u0007\u0015\t\u0001\"\u0002\r\u0006!\u000e\u0005\u0011eA\u0003\u0002\u0011\u0011AB!U\u0002\b\t#I\u0011\u0001#\u0004\u000e\u0003!5Q\"\u0001\u0005\b[)\"\u0001\u0002G\u0005\u001e\u0010\u0011\u0001\u00012C\u0007\u0004\u000b\u0005Ay\u0001g\u0004Q\u0007\u0001iz\u0001\u0002\u0001\t\n5\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0011AO\b\t\u0001Aa!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0003\u0005\u001aQ!\u0001\u0005\t1!\t6!\u0003\u0003\n\u0013\u0005!\u0001!D\u0001\t\u00125\t\u0001RB\u0007\u0002\u0011\u001d)D\"B\u0006\u0005G\u0004A:!I\u0002\u0006\u0003!\u0015\u0001TA)\u0004\u0007\u0011\u001d\u0011\"\u0001\u0003\u0001"})
    public static abstract class OpenCloseGeneratingProvider
    implements GeneratingProvider {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(OpenCloseGeneratingProvider.class);
        }

        @NotNull
        public abstract String openTag(@NotNull String var1, @NotNull ASTNode var2);

        @NotNull
        public abstract String closeTag(@NotNull String var1, @NotNull ASTNode var2);

        @Override
        public void processNode(@NotNull HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            visitor.consumeHtml(this.openTag(text, node));
            node.acceptChildren(visitor);
            visitor.consumeHtml(this.closeTag(text, node));
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0014\u0006)qbj\u001c8SK\u000e,(o]5wK\u001e+g.\u001a:bi&tw\r\u0015:pm&$WM\u001d\u0006\u000e\u0011RlGnR3oKJ\fGo\u001c:\u000b\u0007=\u0014xM\u0003\u0005j]R,G\u000e\\5k\u0015!i\u0017M]6e_^t'\u0002\u00025u[2T!cR3oKJ\fG/\u001b8h!J|g/\u001b3fe*1A(\u001b8jizR1bZ3oKJ\fG/\u001a+bO*!A/\u001a=u\u0015\u0019\u0019FO]5oO*11n\u001c;mS:TAA\\8eK*9\u0011i\u0015+O_\u0012,'bA1ti*a1\t[1s'\u0016\fX/\u001a8dK*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b\u0017A\u0014xnY3tg:{G-\u001a\u0006\bm&\u001c\u0018\u000e^8s\u0015UAE/\u001c7HK:,'/\u0019;j]\u001e4\u0016n]5u_JTA!\u00168ji*\u0019\u0003\n^7m\u000f\u0016tWM]1u_J$\u0003\n^7m\u000f\u0016tWM]1uS:<g+[:ji>\u0014(1\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\r!\u0019\u0001#\u0001\r\u0001\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)1\u0001\u0002\u0002\t\u00071\u0001Q!\u0001E\u0006\u000b\r!9\u0001C\u0003\r\u0001\u0015\u0011A!\u0001\u0005\b\u000b\r!I\u0001#\u0004\r\u0001\u0015\u0019Aq\u0001E\b\u0019\u0001)\u0011\u0001\u0003\u0005\u0006\u0005\u00111\u0001\u0012C\u0003\u0003\t\u001bAy!\u0002\u0002\u0005\u000e!)QA\u0001C\u0005\u0011\u001b)1\u0001\u0002\u0002\t\u00151\u0001Qa\u0001C\u0004\u0011+a\u0001!\u0002\u0002\u0005\u0004!YA\u0001\u0005G\u00033\r)\u0011\u0001C\u0002\u0019\u00075~B\u0001\u0005\r\u0005;\u001f!\u0001\u0001#\u0003\u000e\u0007\u0015\t\u0001\u0002\u0002\r\u0005!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u0019i1!B\u0001\t\u000ba)\u0001k!\u0001\"\u0007\u0015\t\u00012\u0002M\u0006#\u000e9A\u0001B\u0005\u0002\u0011\u001di\u0011\u0001c\u0004\u000e\u0003!AQF\u000b\u0003\u00011%iz\u0001\u0002\u0001\t\u00145\u0019Q!\u0001E\t1#\u00016\u0001AO\b\t\u0001AI!D\u0002\u0006\u0003!!\u0001\u0004\u0002)\u0004\u0002u=A\u0001\u0001\u0005\u0007\u001b\r)\u0011\u0001C\u0003\u0019\u000bA\u001b\u0011!I\u0002\u0006\u0003!I\u0001$C)\u0004\u0013\u0011I\u0011\"\u0001\u0003\u0001\u001b\u0005A\u0019\"D\u0001\t\u00105\t\u0001\u0002C\u001b\r\u000b-!1\u001d\u0001M\u0004C\r)\u0011\u0001#\u0002\u0019\u0006E\u001b1\u0001b\u0002\n\u0003\u0011\u0001\u0001"})
    public static abstract class NonRecursiveGeneratingProvider
    implements GeneratingProvider {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(NonRecursiveGeneratingProvider.class);
        }

        @NotNull
        public abstract CharSequence generateTag(@NotNull String var1, @NotNull ASTNode var2);

        @Override
        public final void processNode(@NotNull HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            visitor.consumeHtml(this.generateTag(text, node));
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={" \u0006)q\u0012J\u001c7j]\u0016Du\u000e\u001c3fe\u001e+g.\u001a:bi&tw\r\u0015:pm&$WM\u001d\u0006\u000e\u0011RlGnR3oKJ\fGo\u001c:\u000b\u0007=\u0014xM\u0003\u0005j]R,G\u000e\\5k\u0015!i\u0017M]6e_^t'\u0002\u00025u[2T1d\u00149f]\u000ecwn]3HK:,'/\u0019;j]\u001e\u0004&o\u001c<jI\u0016\u0014(B\u0002\u001fj]&$hH\u0003\tdQ&dGM]3o)>\u0014VM\u001c3fe*!an\u001c3f\u0015\u001d\t5\u000b\u0016(pI\u0016T1!Y:u\u0015\u0011a\u0015n\u001d;\u000b\r-|G\u000f\\5o\u0015\u0011Q\u0017M^1\u000b\tU$\u0018\u000e\u001c\u0006\faJ|7-Z:t\u001d>$WMC\u0004wSNLGo\u001c:\u000b+!#X\u000e\\$f]\u0016\u0014\u0018\r^5oOZK7/\u001b;pe*!A/\u001a=u\u0015\u0019\u0019FO]5oO*!QK\\5u\u0015\rBE/\u001c7HK:,'/\u0019;pe\u0012BE/\u001c7HK:,'/\u0019;j]\u001e4\u0016n]5u_JTA\u0001\\1oO\"\r!B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0004\t\u0007A\t\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\r!!\u0001C\u0002\r\u0001\u0015\u0011A!\u0001E\u0006\u000b\r!9\u0001C\u0003\r\u0001\u0015\t\u0001RB\u0003\u0004\t\u0013Aa\u0001\u0004\u0001\u0006\u0003!9QA\u0001C\u0006\u0011\u001f)!\u0001\u0002\u0004\t\r\u0015\u0011Aq\u0001\u0005\u0006\u000b\r!!\u0001C\u0005\r\u0001\u0015\u0019A\u0011\u0002\u0005\u000b\u0019\u0001)1\u0001\"\u0003\t\u00161\u0001QA\u0001C\u0002\u0011-)!\u0001b\u0003\t\u0018\u0015\u0011A1\u0003\u0005\u000b\tAa)!G\u0002\u0006\u0003!\u0019\u0001dA\u0017\u001b\t!AB!h\u0004\u0005\u0001!%QbA\u0003\u0002\u0011\u0011AB\u0001U\u0002\u0001C!)\u0011\u0001C\u0003\n\t%\u0019Q!\u0001\u0005\u00051\u0011AR!U\u0002\u0006\t\u0011I\u0011\u0001#\u0004\u000e\u0003!9QF\u000b\u0003\t1!iz\u0001\u0002\u0001\t\u00125\u0019Q!\u0001E\b1\u001f\u00016\u0001AO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!A\u0001\u0004\u0003)\u0004\u0002u=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001\u0003\u0003\u0019\tA\u001b\u0011!I\u0002\u0006\u0003!E\u0001\u0014C)\u0004\u0013\u0011A\u0011\"\u0001\u0003\u0001\u001b\u0005A\u0011\"D\u0001\t\u00155\t\u0001bB\u001b\r\u000b-!1\u001d\u0001M\u0004C\r)\u0011\u0001#\u0002\u0019\u0006E\u001b1\u0001b\u0002\n\u0003\u0011\u0001\u0001"})
    public static abstract class InlineHolderGeneratingProvider
    extends OpenCloseGeneratingProvider {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(InlineHolderGeneratingProvider.class);
        }

        @NotNull
        public List<ASTNode> childrenToRender(@NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return node.getChildren();
        }

        @Override
        public void processNode(@NotNull HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            visitor.consumeHtml(this.openTag(text, node));
            for (ASTNode child : this.childrenToRender(node)) {
                if (child instanceof LeafASTNode) {
                    visitor.consumeHtml(Companion.leafText(text, child));
                    continue;
                }
                child.accept(visitor);
            }
            visitor.consumeHtml(this.closeTag(text, node));
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"E\u0004)\t2+[7qY\u0016$\u0016m\u001a)s_ZLG-\u001a:\u000b\u001b!#X\u000e\\$f]\u0016\u0014\u0018\r^8s\u0015\ry'o\u001a\u0006\tS:$X\r\u001c7jU*AQ.\u0019:lI><hN\u0003\u0003ii6d'bG(qK:\u001cEn\\:f\u000f\u0016tWM]1uS:<\u0007K]8wS\u0012,'O\u0003\u0004=S:LGO\u0010\u0006\bi\u0006<g*Y7f\u0015\u0019\u0019FO]5oO*11n\u001c;mS:TAA[1wC*!A.\u00198h\u0015)9W\r\u001e+bO:\u000bW.\u001a\u0006\tG2|7/\u001a+bO*!A/\u001a=u\u0015\u0011qw\u000eZ3\u000b\u000f\u0005\u001bFKT8eK*\u0019\u0011m\u001d;\u000b\u000f=\u0004XM\u001c+bOzS!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!B\u0002\u0005\u0004!\u0005A\u0002A\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001b\u0001\u0007\u0001\u000b\u0005AQ!B\u0002\u0005\b!%A\u0002A\u0003\u0002\u0011\u0017)!\u0001\"\u0003\t\r\u0015\u0011A!\u0002E\u0005\u000b\t!\u0011\u0001C\u0005\u0006\u0007\u00111\u0001\u0012\u0003\u0007\u0001\u000b\t!a\u0001#\u0005\u0005\u00011\u0015\u0011dA\u0003\u0002\u0011\rA2!\f\t\u0005A\u0012AB!I\u0002\u0006\u0003!!\u0001\u0004B+\u0004\u0011\u0015\u0019A\u0001B\u0005\u0002\u0011\u0017i1\u0001\"\u0004\n\u0003!-Qv\b\u0003\t1\u001diz\u0001\u0002\u0001\t\u00105\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0001AO\b\t\u0001A\u0001\"D\u0002\u0006\u0003!5\u0001T\u0002)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00051\u0011\t6a\u0002\u0003\b\u0013\u0005AY!D\u0001\t\f5\t\u0001bBW \t!A\u001a\"h\u0004\u0005\u0001!=QbA\u0003\u0002\u0011\u0011AB\u0001U\u0002\u0001;\u001f!\u0001\u0001\u0003\u0005\u000e\u0007\u0015\t\u0001R\u0002M\u0007!\u000e\u0005\u0011eA\u0003\u0002\u0011\u0011AB!U\u0002\b\t'I\u0011\u0001c\u0003\u000e\u0003!-Q\"\u0001\u0005\bk[)Y\u0003Br\u00011\u000fiz\u0001\u0002\u0001\t\t5\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0001A\u0011\u0004\u000b\u0005A)\u0001'\u0002R\u0007\u0015!9!C\u0001\u0005\u00015\t\u00012\u0002"})
    public static final class SimpleTagProvider
    extends OpenCloseGeneratingProvider {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final String tagName;

        static {
            $kotlinClass = Reflection.createKotlinClass(SimpleTagProvider.class);
        }

        @Override
        @NotNull
        public String openTag(@NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return "<" + this.tagName + ">";
        }

        @Override
        @NotNull
        public String closeTag(@NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return "</" + this.tagName + ">";
        }

        @NotNull
        public final String getTagName() {
            return this.tagName;
        }

        public SimpleTagProvider(@NotNull String tagName) {
            Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
            this.tagName = tagName;
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"#\u0006)92+[7qY\u0016Le\u000e\\5oKR\u000bw\r\u0015:pm&$WM\u001d\u0006\u000e\u0011RlGnR3oKJ\fGo\u001c:\u000b\u0007=\u0014xM\u0003\u0005j]R,G\u000e\\5k\u0015!i\u0017M]6e_^t'\u0002\u00025u[2Ta$\u00138mS:,\u0007j\u001c7eKJ<UM\\3sCRLgn\u001a)s_ZLG-\u001a:\u000b\rqJg.\u001b;?\u0015\u001d!\u0018m\u001a(b[\u0016Taa\u0015;sS:<'BB6pi2LgN\u0003\u0006sK:$WM\u001d$s_6T1!\u00138u\u0015!\u0011XM\u001c3feR{'\u0002\u00026bm\u0006TA\u0001\\1oO*iq-\u001a;SK:$WM\u001d$s_6T1bZ3u%\u0016tG-\u001a:U_*Qq-\u001a;UC\u001et\u0015-\\3\u000b!\rD\u0017\u000e\u001c3sK:$vNU3oI\u0016\u0014(\u0002\u00028pI\u0016Tq!Q*U\u001d>$WMC\u0002bgRTA\u0001T5ti*!Q\u000f^5m\u0015!\u0019Gn\\:f)\u0006<'\u0002\u0002;fqRTqa\u001c9f]R\u000bwM\u001f\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\r!\u0019\u0001#\u0001\r\u0001\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)1\u0001\u0002\u0002\t\u00071\u0001Q!\u0001\u0005\u0006\u000b\r!9\u0001#\u0003\r\u0001\u0015\u0019Aq\u0001\u0005\u0007\u0019\u0001)\u0011\u0001C\u0004\u0006\u0005\u0011)\u0001rB\u0003\u0003\t\u0017AI!\u0002\u0002\u0005\u0003!YQa\u0001C\u0007\u0011+a\u0001!B\u0002\u0005\b!]A\u0002A\u0003\u0003\t\u0015AA\"\u0002\u0002\u0005\u0011!]QA\u0001C\u0007\u0011+!\u0001\u0002$\u0002\u001a\u0007\u0015\t\u0001b\u0001\r\u0004[A!\u0001\r\u0002M\u0006C\r)\u0011\u0001#\u0003\u0019\nU\u001b\u0001\"B\u0002\u0005\f%\tAQA\u0007\u0004\t!I\u0011\u0001\"\u0002.!\u0011\u0001G\u0001'\u0004\"\u0007\u0015\t\u0001\u0012\u0002M\u0005+\u000eAQa\u0001C\u0007\u0013\u0005!)!D\u0002\u0005\u0012%\tAQA\u0017\u0011\t\u0001$\u0001\u0004B\u0011\u0004\u000b\u0005AA\u0001\u0007\u0003V\u0007!)1\u0001\u0002\u0003\n\u0003!1Qb\u0001\u0003\n\u0013\u0005Aa!\f\u000e\u0005\u0011aMQt\u0002\u0003\u0001\u0011)i1!B\u0001\t\u000fa9\u0001k\u0001\u0001\"\u0011\u0015\t\u0001rB\u0005\u0005\u0013\r)\u0011\u0001C\u0004\u0019\u000fa=\u0011kA\u0003\u0005\u0014%\t\u0001\u0012C\u0007\u0002\u0011%i{\u0004\u0002\u0005\u0019\u001au=A\u0001\u0001\u0005\u000e\u001b\r)\u0011\u0001\u0003\u0003\u0019\tA\u001b\u0001!h\u0004\u0005\u0001!QQbA\u0003\u0002\u0011\u001dAr\u0001UB\u0001C\r)\u0011\u0001\u0003\u0003\u0019\tE\u001bq\u0001\"\u0007\n\u0003!1Q\"\u0001\u0005\u0007\u001b\u0005A\u0011\"l\u0010\u0005\u0011amQt\u0002\u0003\u0001\u00115i1!B\u0001\t\ta!\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001BC\u0007\u0004\u000b\u0005Aq\u0001G\u0004Q\u0007\u0003\t3!B\u0001\t\ta!\u0011kA\u0004\u0005\u001c%\t\u0001BB\u0007\u0002\u0011\u0019i\u0011\u0001C\u00056X\u0015UCa9\u0001\u0019\bu=A\u0001\u0001\u0005\u0005\u001b\r)\u0011\u0001\u0003\u0003\u0019\tA\u001b\u0001!h\u0004\u0005\u0003!-QbA\u0003\u0002\u0011\u0013AJ\u0001UB\u0001;\u001f!\u0011\u0001#\u0004\u000e\u0007\u0015\t\u0001\u0012\u0002M\u0005!\u000e\t\u0011eA\u0003\u0002\u0011\u000bA*!U\u0002\n\t\u000fI\u0011\u0001\u0002\u0001\u000e\u0003!1Q\"\u0001C\u0003\u001b\u0005!)\u0001"})
    public static class SimpleInlineTagProvider
    extends InlineHolderGeneratingProvider {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final String tagName;
        private final int renderFrom;
        private final int renderTo;

        static {
            $kotlinClass = Reflection.createKotlinClass(SimpleInlineTagProvider.class);
        }

        @Override
        @NotNull
        public List<ASTNode> childrenToRender(@NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return node.getChildren().subList(this.renderFrom, node.getChildren().size() + this.renderTo);
        }

        @Override
        @NotNull
        public String openTag(@NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return "<" + this.tagName + ">";
        }

        @Override
        @NotNull
        public String closeTag(@NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return "</" + this.tagName + ">";
        }

        @NotNull
        public final String getTagName() {
            return this.tagName;
        }

        public final int getRenderFrom() {
            return this.renderFrom;
        }

        public final int getRenderTo() {
            return this.renderTo;
        }

        public SimpleInlineTagProvider(@NotNull String tagName, int renderFrom, int renderTo) {
            Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
            this.tagName = tagName;
            this.renderFrom = renderFrom;
            this.renderTo = renderTo;
        }

        public /* synthetic */ SimpleInlineTagProvider(String string, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            this(string, n, n2);
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"U\u0004)yBK]1ogB\f'/\u001a8u\u0013:d\u0017N\\3I_2$WM\u001d)s_ZLG-\u001a:\u000b\u001b!#X\u000e\\$f]\u0016\u0014\u0018\r^8s\u0015\ry'o\u001a\u0006\tS:$X\r\u001c7jU*AQ.\u0019:lI><hN\u0003\u0003ii6d'bF*j[BdW-\u00138mS:,G+Y4Qe>4\u0018\u000eZ3s\u0015\u0019a\u0014N\\5u})Q!/\u001a8eKJ4%o\\7\u000b\u0007%sGO\u0003\u0004l_Rd\u0017N\u001c\u0006\te\u0016tG-\u001a:U_*A1\r\\8tKR\u000bwM\u0003\u0003uKb$(BB*ue&twM\u0003\u0003o_\u0012,'bB!T):{G-\u001a\u0006\u0004CN$(\u0002\u00026bm\u0006TA\u0001\\1oO*9q\u000e]3o)\u0006<gM\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!\u0011\u0001#\u0002\u0006\u0007\u0011\r\u0001\u0012\u0001\u0007\u0001\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\u0019AA\u0001\u0005\u0004\u0019\u0001)\u0011\u0001C\u0003\u0006\u0007\u0011\u001d\u0001\u0012\u0002\u0007\u0001\u000b\r!9\u0001C\u0004\r\u0001\u0015\u0011A!\u0001E\t\u000b\r!Q\u0001\u0003\u0005\r\u0001\u0015\t\u0001\"C\u0003\u0003\t\u0019A\u0019\"\u0002\u0002\u0005\u000e!9QA\u0001\u0003\u0006\u0011!!\u0001\u0002$\u0002\u001a\u0007\u0015\t\u0001b\u0001\r\u0004[\u007f!\u0001\u0002\u0007\u0004\u001e\u0010\u0011\u0001\u0001RB\u0007\u0004\u000b\u0005AI\u0001'\u0003Q\u0007\u0001iz\u0001\u0002\u0001\t\u00105\u0019Q!\u0001E\u00061\u0017\u00016\u0011A\u0011\u0004\u000b\u0005AI\u0001'\u0003R\u0007\u001d!a!C\u0001\t\u000f5\t\u0001bB\u0007\u0002\u0011\u001fi{\u0004\u0002\u0005\u0019\u0015u=A\u0001\u0001E\u0007\u001b\r)\u0011\u0001#\u0003\u0019\nA\u001b\u0001!h\u0004\u0005\u0001!=QbA\u0003\u0002\u0011\u0017AZ\u0001UB\u0001C\r)\u0011\u0001#\u0003\u0019\nE\u001bq\u0001\u0002\u0006\n\u0003!9Q\"\u0001\u0005\b\u001b\u0005Ay!N\u0011\u0006A\u0011\u0019\u000f\u0001g\u0002\u001e\u0010\u0011\t\u0001\u0002B\u0007\u0004\u000b\u0005AA\u0001\u0007\u0003Q\u0007\u0001iz\u0001B\u0001\t\f5\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0011A\u0011\u0004\u000b\u0005A)\u0001'\u0002R\u0007\u001d!9!C\u0001\u0005\u00015\tAQA\u0007\u0002\t\u000b\u0001"})
    public static class TransparentInlineHolderProvider
    extends SimpleInlineTagProvider {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(TransparentInlineHolderProvider.class);
        }

        @Override
        @NotNull
        public String openTag(@NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return "";
        }

        @Override
        @NotNull
        public String closeTag(@NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return "";
        }

        public TransparentInlineHolderProvider(int renderFrom, int renderTo) {
            super("", renderFrom, renderTo);
        }

        public /* synthetic */ TransparentInlineHolderProvider(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public TransparentInlineHolderProvider() {
            this(0, 0, 3, null);
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u007f\u0004)I1i\\7qC:LwN\u001c\u0006\u000e\u0011RlGnR3oKJ\fGo\u001c:\u000b\u0007=\u0014xM\u0003\u0005j]R,G\u000e\\5k\u0015!i\u0017M]6e_^t'\u0002\u00025u[2T1!\u00118z\u0015\u0019Yw\u000e\u001e7j]*yQM\u001c;jif\u001cuN\u001c<feR,'OC\bF]RLG/_\"p]Z,'\u000f^3s\u0015I9W\r^#oi&$\u0018pQ8om\u0016\u0014H/\u001a:\u000b\u001b%t\u0017\u000e\u001e)s_ZLG-\u001a:t\u0015\ri\u0015\r\u001d\u0006\r\u0013\u0016cW-\\3oiRK\b/\u001a\u0006\u0013\u000f\u0016tWM]1uS:<\u0007K]8wS\u0012,'O\u0003\u0003kCZ\f'\u0002B;uS2T\u0001\u0002\\3bMR+\u0007\u0010\u001e\u0006\u0005i\u0016DHO\u0003\u0004TiJLgn\u001a\u0006\u0005]>$WMC\u0004B'Rsu\u000eZ3\u000b\u0007\u0005\u001cHO\u0003\u0007DQ\u0006\u00148+Z9vK:\u001cWM\u0003\u0003mC:<g4\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\r!\u0019\u0001#\u0001\r\u0001\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)\u0011\u0001c\u0002\u0006\u0007\u0011\u0019\u0001b\u0001\u0007\u0001\u000b\r!\u0019\u0001#\u0003\r\u0001\u0015\u0011A1\u0001E\u0005\u000b\r!1\u0001\u0003\u0004\r\u0001\u0015\u0019A!\u0001E\u0007\u0019\u0001)1\u0001\u0002\u0002\t\u000f1\u0001Q!\u0001E\b\u000b\t!i\u0001\u0003\u0005\u0006\u0005\u00119\u0001BB\u0003\u0004\t\rA\u0019\u0002\u0004\u0001\u0006\u0005\u0011\t\u0001bC\u0003\u0004\t#A)\u0002\u0004\u0001\u0006\u0007\u0011\u0019\u0001r\u0003\u0007\u0001\u000b\t!i\u0001\u0003\u0007\u0006\u0005\u0011Q\u0001rC\u0003\u0003\t)A\u0019\"\u0002\u0002\u0005\u0012!UAaq\u0001\r\u0006e\u0019Q!\u0001E\u00041\u000fi\u0013\u0003B1\u00051\u0011\t3!B\u0001\t\ta!QkA\u0005\u0006\t\u0011!\u0011\"\u0001E\u0005\u0019\u0003i1\u0001B\u0003\n\u0003!%Q\u0016\u0006\u0003\u00011\u0017\tS\"B\u0001\t\u000b%!\u0011bA\u0003\u0002\u0011\u0017AZ!\u0003\u0003\n\u0007\u0015\t\u0001B\u0002\r\u00071\u0015\t6a\u0001C\u0006\u0013\u0005Ay!l\u0010\u0005\u0001aEQt\u0002\u0003\u0001\u0011%i1!B\u0001\t\u0011aA\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001BC\u0007\u0004\u000b\u0005A\u0011\u0002G\u0005Q\u0007\u0003\t3!B\u0001\t\u0014aM\u0011kA\u0004\u0005\u0012%\t\u0001RC\u0007\u0002\u0011-i\u0011\u0001c\u00066\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        private final EntityConverter getEntityConverter() {
            return entityConverter;
        }

        @NotNull
        public final CharSequence leafText(@NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.Companion.getBLOCK_QUOTE())) {
                return "";
            }
            return this.getEntityConverter().replaceEntities(AstPackage$ASTUtil$f270b16f.getTextInNode(node, text));
        }

        @NotNull
        public final Map<IElementType, GeneratingProvider> initProviders() {
            MarkdownTokenTypes.Companion.getClass().getDeclaredFields();
            return KotlinPackage.hashMapOf((Pair[])new Pair[]{KotlinPackage.to((Object)MarkdownElementTypes.Companion.getMARKDOWN_FILE(), (Object)new SimpleTagProvider("body")), KotlinPackage.to((Object)MarkdownTokenTypes.Companion.getHTML_BLOCK(), (Object)new GeneratingProvider(){
                public static final /* synthetic */ KClass $kotlinClass;

                static {
                    $kotlinClass = Reflection.createKotlinClass(initProviders.1.class);
                }

                public void processNode(@NotNull HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                    Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                    Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    visitor.consumeHtml(AstPackage$ASTUtil$f270b16f.getTextInNode(node, text));
                }
            }), KotlinPackage.to((Object)MarkdownTokenTypes.Companion.getHTML_TAG(), (Object)new GeneratingProvider(){
                public static final /* synthetic */ KClass $kotlinClass;

                static {
                    $kotlinClass = Reflection.createKotlinClass(initProviders.2.class);
                }

                public void processNode(@NotNull HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                    Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                    Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    visitor.consumeHtml(AstPackage$ASTUtil$f270b16f.getTextInNode(node, text));
                }
            }), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getBLOCK_QUOTE(), (Object)new SimpleTagProvider("blockquote")), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getORDERED_LIST(), (Object)new SimpleTagProvider("ol")), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getUNORDERED_LIST(), (Object)new SimpleTagProvider("ul")), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getLIST_ITEM(), (Object)new SimpleTagProvider("li")), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getSETEXT_1(), (Object)new SimpleInlineTagProvider("h1", 0, -2)), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getSETEXT_2(), (Object)new SimpleInlineTagProvider("h2", 0, -2)), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getATX_1(), (Object)new SimpleInlineTagProvider("h1", 1, 0, 4, null)), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getATX_2(), (Object)new SimpleInlineTagProvider("h2", 1, 0, 4, null)), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getATX_3(), (Object)new SimpleInlineTagProvider("h3", 1, 0, 4, null)), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getATX_4(), (Object)new SimpleInlineTagProvider("h4", 1, 0, 4, null)), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getATX_5(), (Object)new SimpleInlineTagProvider("h5", 1, 0, 4, null)), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getATX_6(), (Object)new SimpleInlineTagProvider("h6", 1, 0, 4, null)), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getAUTOLINK(), (Object)new NonRecursiveGeneratingProvider(){
                public static final /* synthetic */ KClass $kotlinClass;

                static {
                    $kotlinClass = Reflection.createKotlinClass(initProviders.3.class);
                }

                @NotNull
                public String generateTag(@NotNull String text, @NotNull ASTNode node) {
                    Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    CharSequence linkText = AstPackage$ASTUtil$f270b16f.getTextInNode(node, text);
                    String link = org.intellij.markdown.html.HtmlGenerator$Companion.access$getEntityConverter$0(HtmlGenerator.Companion).replaceEntities(linkText.subSequence(1, linkText.length() - 1));
                    return "<a href=" + "\"" + link + "\"" + ">" + link + "</a>";
                }
            }), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getLINK_LABEL(), (Object)new TransparentInlineHolderProvider(0, 0, 3, null)), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getLINK_DESTINATION(), (Object)new TransparentInlineHolderProvider(1, -1){
                public static final /* synthetic */ KClass $kotlinClass;

                static {
                    $kotlinClass = Reflection.createKotlinClass(initProviders.4.class);
                }

                @NotNull
                public List<ASTNode> childrenToRender(@NotNull ASTNode node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    if (Intrinsics.areEqual((Object)((ASTNode)KotlinPackage.first(node.getChildren())).getType(), (Object)MarkdownTokenTypes.Companion.getLT())) {
                        return super.childrenToRender(node);
                    }
                    return node.getChildren();
                }
            }), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getLINK_TITLE(), (Object)new TransparentInlineHolderProvider(1, -1)), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getLINK_TEXT(), (Object)new TransparentInlineHolderProvider(1, -1)), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getINLINE_LINK(), (Object)new GeneratingProvider(){
                public static final /* synthetic */ KClass $kotlinClass;

                static {
                    $kotlinClass = Reflection.createKotlinClass(initProviders.5.class);
                }

                public void processNode(@NotNull HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                    Unit unit;
                    Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                    Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    ASTNode destinationNode = AstPackage$ASTUtil$f270b16f.findChildOfType(node, MarkdownElementTypes.Companion.getLINK_DESTINATION());
                    ASTNode titleNode = AstPackage$ASTUtil$f270b16f.findChildOfType(node, MarkdownElementTypes.Companion.getLINK_TITLE());
                    Object object = destinationNode;
                    if (object == null || (object = AstPackage$ASTUtil$f270b16f.getTextInNode((ASTNode)object, text)) == null) {
                        object = "";
                    }
                    Object destinationText = object;
                    String titleText = titleNode != null ? " title=" + "\"" + HtmlGenerator.Companion.leafText(text, titleNode) + "\"" : "";
                    visitor.consumeHtml("<a href=" + "\"" + (CharSequence)destinationText + "\"" + titleText + ">");
                    ASTNode aSTNode = AstPackage$ASTUtil$f270b16f.findChildOfType(node, MarkdownElementTypes.Companion.getLINK_TEXT());
                    if (aSTNode != null) {
                        aSTNode.accept(visitor);
                        unit = Unit.INSTANCE$;
                    } else {
                        unit = null;
                    }
                    visitor.consumeHtml("</a>");
                }
            }), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getCODE_FENCE(), (Object)new GeneratingProvider(){
                public static final /* synthetic */ KClass $kotlinClass;

                static {
                    $kotlinClass = Reflection.createKotlinClass(initProviders.6.class);
                }

                public void processNode(@NotNull HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                    Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                    Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    visitor.consumeHtml("<pre><code>");
                    boolean state = false;
                    List<ASTNode> childrenToConsider = node.getChildren();
                    if (Intrinsics.areEqual((Object)((ASTNode)KotlinPackage.last(childrenToConsider)).getType(), (Object)MarkdownTokenTypes.Companion.getCODE_FENCE_END())) {
                        childrenToConsider = childrenToConsider.subList(0, childrenToConsider.size() - 2);
                    }
                    for (ASTNode child : childrenToConsider) {
                        if (state) {
                            visitor.consumeHtml(HtmlGenerator.Companion.leafText(text, child));
                        }
                        if (state || !Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownTokenTypes.Companion.getEOL())) continue;
                        state = true;
                    }
                    visitor.consumeHtml("</code></pre>");
                }
            }), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getCODE_BLOCK(), (Object)new GeneratingProvider(){
                public static final /* synthetic */ KClass $kotlinClass;

                static {
                    $kotlinClass = Reflection.createKotlinClass(initProviders.7.class);
                }

                public void processNode(@NotNull HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                    Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                    Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    visitor.consumeHtml("<pre><code>");
                    for (ASTNode child : node.getChildren()) {
                        CharSequence html = HtmlGenerator.Companion.leafText(text, child);
                        if (Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownTokenTypes.Companion.getEOL())) {
                            html = KotlinPackage.replace((String)((Object)html).toString(), (Regex)KotlinPackage.toRegex((String)"\n(    |\t)"), (String)"\n");
                        }
                        visitor.consumeHtml(html);
                    }
                    visitor.consumeHtml("</code></pre>");
                }
            }), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getPARAGRAPH(), (Object)new SimpleInlineTagProvider("p", 0, 0, 6, null)), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getEMPH(), (Object)new SimpleInlineTagProvider("em", 1, -1)), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getSTRONG(), (Object)new SimpleInlineTagProvider("strong", 2, -2)), KotlinPackage.to((Object)MarkdownElementTypes.Companion.getCODE_SPAN(), (Object)new SimpleInlineTagProvider("code", 1, -1))});
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ EntityConverter access$getEntityConverter$0(Companion $this) {
            return $this.getEntityConverter();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

