/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import kotlin.KotlinPackage;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.TokensCache;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"u\b)\u0019R*\u0019:lI><hnQ8ogR\u0014\u0018-\u001b8ug*\u0019qN]4\u000b\u0011%tG/\u001a7mS*T\u0001\"\\1sW\u0012|wO\u001c\u0006\u0007a\u0006\u00148/\u001a:\u000b\u0007\u0005s\u0017P\u0003\u0004l_Rd\u0017N\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\u000f%tG-\u001a8ug*A\u0011J\u001c;BeJ\f\u0017PC\u0003usB,7OC\u0005DQ\u0006\u0014\u0018I\u001d:bs*Q\u0011n]#ya2L7-\u001b;\u000b\u0019\t{w\u000e\\3b]\u0006\u0013(/Y=\u000b\u0017\u0005$G-T8eS\u001aLWM\u001d\u0006\u0005if\u0004XM\u0003\u0007J\u000b2,W.\u001a8u)f\u0004XM\u0003\u0005ji\u0016\u0014\u0018\r^8s\u0015!IE/\u001a:bi>\u0014(b\u0003+pW\u0016t7oQ1dQ\u0016T\u0011B]1x\u001f\u001a47/\u001a;\u000b\u0007%sGO\u0003\u000bU_.,gn]\"bG\",G%\u0013;fe\u0006$xN\u001d\u0006\u0014C\u0012$Wj\u001c3jM&,'/\u00134OK\u0016$W\r\u001a\u0006\u001aG\u0006d7-\u00138eK:$\u0018\t\u001a3ji&|gNR8s\u0019&\u001cHOC\nd_:$\u0018-\u001b8t\u0019&\u001cH/T1sW\u0016\u00148OC\u0004C_>dW-\u00198\u000b\u0013U\u0004Hk\\%oI\u0016D(bC3yi\u0016tGm\u001d'jgRTQa\u001c;iKJT1\"\u001a=uK:$7\u000f\u0015:fm*Ib-\u001b7m\u00136\u0004H.[2jiN|en\u00165ji\u0016\u001c\u0006/Y2f\u0015!\u0011\u0018m^%oI\u0016D(b\u00059sKZd\u0015N\\3D_:\u001cHO]1j]R\u001c(\"C4fi&sG-\u001a8u\u0015)\u0019H/\u0019:ug^KG\u000f\u001b\u0006\ti>\u001cFO]5oO*11\u000b\u001e:j]\u001eTAA[1wC*!A.\u00198h\u00151)\bo\u001d;sK\u0006lw+\u001b;i\u0015%\u0019u.\u001c9b]&|g\u000ef\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0019A1\u0001\u0005\u0001\u0019\u0001)\u0011\u0001C\u0002\u0006\u0007\u0011\u0015\u0001R\u0001\u0007\u0001\u000b\r!)\u0001#\u0003\r\u0001\u0015\u0019AQ\u0001E\u0006\u0019\u0001)1\u0001\"\u0002\t\u000e1\u0001Qa\u0001\u0003\u0002\u0011!a\u0001!B\u0002\u0005\u0004!MA\u0002A\u0003\u0004\t\u0017A\u0011\u0002\u0004\u0001\u0006\u0007\u0011\u0015\u0001R\u0003\u0007\u0001\u000b\t!\u0019\u0001\u0003\u0001\u0006\u0005\u0011\t\u0001\u0002C\u0003\u0003\t\u0007A1\"B\u0002\u0005\u0006!iA\u0002A\u0003\u0004\t\u000bA)\u0003\u0004\u0001\u0006\u0003!\u0019RA\u0001C\n\u0011O)!\u0001\u0002\u0006\t&\u0011\u0019AB\u0001I\u00153\r)\u0011\u0001C\u0002\u0019\u0007u\u0005I#L\u0007\u0005\u00034AB!I\u0002\u0006\u0003!\u001d\u0001tA+\u0004\u000b\u0015!A\u0001B\u0005\u0003\t\u000ba\t!L\u0007\u0005\u00034Ab!I\u0002\u0006\u0003!%\u0001\u0014B+\u0004\u000b\u0015!AAB\u0005\u0003\t\u0003a\t!L\u0007\u0005\u00034AR!I\u0002\u0006\u0003!!\u0001\u0004B+\u0004\u000b\u0015!A!B\u0005\u0003\t\u0005a\t!\f\u0016\u0005\u0007a9Qt\u0002\u0003\u0001\u0011\u001fi1!B\u0001\t\u000ba)\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0012C\u0007\u0004\u000b\u0005Aa\u0001\u0007\u0004Q\u0007\u0003iz\u0001\u0002\u0001\t\u00155\u0019Q!\u0001E\u00071\u001b\u00016!A\u0011\u0004\u000b\u0005A!\u0001\u0007\u0002R\u0007%!q!C\u0001\t\u000f5\t\u0001rB\u0007\u0002\u0011!i\u0011\u0001\"\u0002.B\u0011\u0019\u0001tCO\t\t\u0001Ay!\u0004\u0003\u0006\u0003!)A\u0012\u0001\r\u0006!\u000e\u0001Qt\u0002\u0003\u0001\u0011#i1!B\u0001\t\ra1\u0001k!\u0001\"\u0007\u0015\t\u0001B\u0001\r\u0003#\u000e9AqC\u0005\u0002\u0011\u001di\u0011\u0001c\u0004\u000e\u0003!AQv\b\u0003\u000311iz\u0001\u0002\u0001\t\u00125\u0019Q!\u0001\u0005\u00071\u0019\u00016\u0001AO\b\t\u0001A!\"D\u0002\u0006\u0003!5\u0001T\u0002)\u0004\u0002\u0005\u001aQ!\u0001E\u00071\u001b\t6a\u0002\u0003\r\u0013\u0005!)!D\u0001\t\u00115\tAQAW\u000b\t\u0005AJ\"I\u0002\u0006\u0003!E\u0001\u0014C)\u0004\u0007\u0011e\u0011\"\u0001C\u0001[U!\u0011\u0001'\u0007\u001e\u0010\u0011\u0001\u00012D\u0007\u0004\u000b\u0005Ai\u0001'\u0004Q\u0007\u0001\t3!B\u0001\t\u0012aE\u0011kA\u0003\u0005\u001a%\tA\u0011A\u0007\u0002\t\u000biS\u0003B\u0002\u0019\u001du=A\u0001\u0001E\u000f\u001b\r)\u0011\u0001\u0003\u0002\u0019\u0005A\u001b\u0001!I\u0002\u0006\u0003!E\u0001\u0014C)\u0004\u000b\u0011q\u0011\"\u0001C\u0001\u001b\u0005Aq!L\u000b\u0005\u0007ayQt\u0002\u0003\u0001\u0011;i1!B\u0001\t\u0005a\u0011\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\u0012\u0003M\t#\u000e)AaD\u0005\u0002\t\u0003i\u0011\u0001C\u0004.U\u0011\u0019\u0001tDO\b\t\u0001A\t\"D\u0002\u0006\u0003!1\u0001D\u0002)\u0004\u0001u=A\u0001\u0001\u0005\u0011\u001b\r)\u0011\u0001#\u0004\u0019\u000eA\u001b\t!h\u0004\u0005\u0001!\u0005RbA\u0003\u0002\u0011\tA\"\u0001U\u0002\u0002C\r)\u0011\u0001\u0003\u0002\u0019\u0005E\u001b\u0011\u0002b\b\n\u0003!9Q\"\u0001\u0005\t\u001b\u0005!)!D\u0001\t\u000f5VAa\u0001\r\u0012C\r)\u0011\u0001#\u0004\u0019\u000eE\u001b1\u0001B\t\n\u0003\u0011\u0015Q&\u0006\u0003\u00021Giz\u0001\u0002\u0001\t\u001e5\u0019Q!\u0001\u0005\u00031\t\u00016\u0001A\u0011\u0004\u000b\u0005A\t\u0002'\u0005R\u0007\u0015!\u0019#C\u0001\u0005\u00025\t\u0001bBW\u000b\t-A\"#I\u0002\u0006\u0003!I\u0001$C)\u0004\u0007\u0011\u0011\u0012\"\u0001E\u000b[U!1\u0001\u0007\u000b\u001e\u0010\u0011\u0001\u0001RD\u0007\u0004\u000b\u0005A!\u0001\u0007\u0002Q\u0007\u0001\t3!B\u0001\t\u0012aE\u0011kA\u0003\u0005)%\tA\u0011A\u0007\u0002\u0011\u001d)l&b\u0017\u0005C\u0004A:!h\u0004\u0005\u0001!!QbA\u0003\u0002\u0011\u000fA:\u0001U\u0002\u0001;\u001f!\u0001\u0001C\u0003\u000e\u0007\u0015\t\u0001\u0002\u0002\r\u0005!\u000e\u0005Qt\u0002\u0003\u0001\u0011\u0019i1!B\u0001\t\na%\u0001kA\u0001\"\u0007\u0015\t\u0001B\u0001\r\u0003#\u000eaAqA\u0005\u0002\t\u0001i!\u0001\"\u0002\r\u00025\u0011A!\u0001G\u0001\u001b\t!\t\u0001$\u0001"})
public final class MarkdownConstraints {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final MarkdownConstraints BASE;
    public static final char BQ_CHAR = '>';
    private int[] indents;
    private char[] types;
    private boolean[] isExplicit;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(MarkdownConstraints.class);
        Companion companion = Companion = new Companion(null);
        BASE = new MarkdownConstraints(new int[0], new char[0], new boolean[0]);
        BQ_CHAR = (char)62;
    }

    public final int getIndent() {
        if (this.indents.length == 0) {
            return 0;
        }
        return this.indents[this.indents.length - 1];
    }

    public final boolean upstreamWith(@NotNull MarkdownConstraints other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return other.startsWith(this) && !this.containsListMarkers();
    }

    public final boolean extendsPrev(@NotNull MarkdownConstraints other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.startsWith(other) && !this.containsListMarkers(other.types.length);
    }

    public final boolean extendsList(@NotNull MarkdownConstraints other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (other.types.length == 0) {
            throw (Throwable)new IllegalArgumentException("List constraints should contain at least one item");
        }
        return this.startsWith(other) && !this.containsListMarkers(other.types.length - 1);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean startsWith(MarkdownConstraints other) {
        int n = this.indents.length;
        int m = other.indents.length;
        if (n < m) {
            return false;
        }
        int n2 = 0;
        int n3 = m - 1;
        if (n2 <= n3) {
            while (true) {
                void i;
                if (this.types[i] != other.types[i]) {
                    return false;
                }
                if (i == n3) break;
                ++i;
            }
        }
        return true;
    }

    private final boolean containsListMarkers() {
        return this.containsListMarkers(this.types.length);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsListMarkers(int upToIndex) {
        int n = 0;
        int n2 = upToIndex - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (this.types[i] != Companion.getBQ_CHAR() && this.isExplicit[i]) {
                    return true;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MarkdownConstraints fillImplicitsOnWhiteSpace(@NotNull TokensCache.Iterator iterator, int rawIndex, @NotNull MarkdownConstraints prevLineConstraints) {
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
        Intrinsics.checkParameterIsNotNull((Object)prevLineConstraints, (String)"prevLineConstraints");
        MarkdownConstraints result = this;
        int whitespaceLen = iterator.rawStart(rawIndex + 1) - iterator.rawStart(rawIndex);
        KotlinPackage.assert((whitespaceLen > 0 ? 1 : 0) != 0, (Object)"Token of zero length?");
        int eaten = 0;
        int n3 = this.indents.length;
        int m = prevLineConstraints.indents.length;
        if (n3 > 0 && this.types[n3 - 1] == Companion.getBQ_CHAR()) {
            ++eaten;
        }
        if ((n2 = n3) <= (n = m - 1)) {
            void i;
            while (prevLineConstraints.types[i] != Companion.getBQ_CHAR()) {
                int indentDelta = prevLineConstraints.indents[i] - (i == false ? 0 : prevLineConstraints.indents[i - true]);
                if (eaten + indentDelta > whitespaceLen) break;
                eaten += indentDelta;
                result = MarkdownConstraints.Companion.MarkdownConstraints(result, result.getIndent() + indentDelta, prevLineConstraints.types[i], false);
                if (i == n) break;
                ++i;
            }
        }
        return result;
    }

    @NotNull
    public final MarkdownConstraints addModifierIfNeeded(@Nullable IElementType type, @NotNull TokensCache.Iterator iterator) {
        Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
        MarkdownConstraints result = this;
        if (!MarkdownParserUtil.Companion.hasCodeBlockIndent(iterator, 0, this) && Companion.isConstraintType(type)) {
            IElementType iElementType = type;
            if (iElementType == null) {
                Intrinsics.throwNpe();
            }
            result = result.addModifier(iElementType, iterator, 0);
        }
        return result;
    }

    @NotNull
    public final MarkdownConstraints addModifier(@NotNull IElementType type, @NotNull TokensCache.Iterator iterator, int rawOffset) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
        char modifierChar = MarkdownConstraints.Companion.getModifierCharAtRawIndex(iterator, rawOffset);
        int lineStartOffset = MarkdownConstraints.Companion.calcLineStartOffset(iterator, rawOffset);
        int currentIndent = this.getIndent();
        int markerStartOffset = iterator.rawStart(rawOffset) - lineStartOffset;
        int whiteSpaceBefore = markerStartOffset - currentIndent;
        KotlinPackage.assert((whiteSpaceBefore == 0 || Intrinsics.areEqual((Object)iterator.rawLookup(rawOffset - 1), (Object)MarkdownTokenTypes.Companion.getWHITE_SPACE()) ? 1 : 0) != 0, (Object)"If some indent is present, it should have been whitespace");
        KotlinPackage.assert((whiteSpaceBefore < 4 ? 1 : 0) != 0, (Object)"Should not add modifier: indent of 4 is a code block");
        if (Intrinsics.areEqual((Object)type, (Object)MarkdownTokenTypes.Companion.getLIST_BULLET()) || Intrinsics.areEqual((Object)type, (Object)MarkdownTokenTypes.Companion.getLIST_NUMBER())) {
            int indentAddition = this.calcIndentAdditionForList(iterator, rawOffset);
            return MarkdownConstraints.Companion.MarkdownConstraints(this, currentIndent + whiteSpaceBefore + indentAddition, modifierChar, true);
        }
        if (Intrinsics.areEqual((Object)type, (Object)MarkdownTokenTypes.Companion.getBLOCK_QUOTE())) {
            return MarkdownConstraints.Companion.MarkdownConstraints(this, currentIndent + whiteSpaceBefore + 2, modifierChar, true);
        }
        throw (Throwable)new IllegalArgumentException("modifier must be either a list marker or a blockquote marker");
    }

    protected final int calcIndentAdditionForList(@NotNull TokensCache.Iterator iterator, int rawOffset) {
        Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
        int markerWidth = iterator.rawStart(rawOffset + 1) - iterator.rawStart(rawOffset);
        if (Intrinsics.areEqual((Object)iterator.rawLookup(1 + rawOffset), (Object)MarkdownTokenTypes.Companion.getWHITE_SPACE()) ^ true) {
            return markerWidth;
        }
        int whitespaceAfterLength = iterator.rawStart(2 + rawOffset) - iterator.rawStart(1 + rawOffset);
        if (whitespaceAfterLength >= 4) {
            return markerWidth + 1;
        }
        return markerWidth + whitespaceAfterLength;
    }

    @NotNull
    public String toString() {
        return "MdConstraints: " + KotlinPackage.String((char[])this.types) + "(" + this.getIndent() + ")";
    }

    private MarkdownConstraints(int[] indents, char[] types, boolean[] isExplicit) {
        this.indents = indents;
        this.types = types;
        this.isExplicit = isExplicit;
    }

    public static final /* synthetic */ void access$setIndents$0(MarkdownConstraints $this, @NotNull int[] nArray) {
        $this.indents = nArray;
    }

    public static final /* synthetic */ void access$setTypes$1(MarkdownConstraints $this, @NotNull char[] cArray) {
        $this.types = cArray;
    }

    public static final /* synthetic */ void access$setIsExplicit$2(MarkdownConstraints $this, @NotNull boolean[] blArray) {
        $this.isExplicit = blArray;
    }

    public /* synthetic */ MarkdownConstraints(@NotNull int[] indents, @NotNull char[] types, @NotNull boolean[] isExplicit, DefaultConstructorMarker $constructor_marker) {
        this(indents, types, isExplicit);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"x\u0006)I1i\\7qC:LwN\u001c\u0006\u0014\u001b\u0006\u00148\u000eZ8x]\u000e{gn\u001d;sC&tGo\u001d\u0006\u0004_J<'\u0002C5oi\u0016dG.\u001b6\u000b\u00115\f'o\u001b3po:Ta\u0001]1sg\u0016\u0014(bA!os*11n\u001c;mS:TAAQ!T\u000b*9q-\u001a;C\u0003N+%b\u0002\"R?\u000eC\u0015I\u0015\u0006\u0005\u0007\"\f'O\u0003\u0006hKR\u0014\u0015kX\"I\u0003JSa\u0001]1sK:$(\"\u00038fo&sG-\u001a8u\u0015\rIe\u000e\u001e\u0006\b]\u0016<H+\u001f9f\u0015-qWm^#ya2L7-\u001b;\u000b\u000f\t{w\u000e\\3b]*\u00192-\u00197d\u0019&tWm\u0015;beR|eMZ:fi*A\u0011\u000e^3sCR|'O\u0003\u0005Ji\u0016\u0014\u0018\r^8s\u0015-!vn[3og\u000e\u000b7\r[3\u000b\u0013I\fwo\u00144gg\u0016$(\u0002\u0006+pW\u0016t7oQ1dQ\u0016$\u0013\n^3sCR|'O\u0003\u0005ge>l')Y:f\u0015!\u0011\u0018m^%oI\u0016D(b\u00059sKZd\u0015N\\3D_:\u001cHO]1j]R\u001c(\"G4fi6{G-\u001b4jKJ\u001c\u0005.\u0019:BiJ\u000bw/\u00138eKbTQ!\u001b8eKbT\u0001#[:D_:\u001cHO]1j]R$\u0016\u0010]3\u000b\tQL\b/\u001a\u0006\r\u0013\u0016cW-\\3oiRK\b/\u001a;\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0006\u0015\u0019A1\u0001E\u0001\u0019\u0001)1\u0001\u0002\u0002\t\u00011\u0001Q!\u0001E\u0004\u000b\r!1\u0001C\u0002\r\u0001\u0015\u0011A1\u0001E\u0001\u000b\r!1\u0001c\u0003\r\u0001\u0015\u0019Aa\u0001E\b\u0019\u0001)1\u0001B\u0002\t\u00131\u0001Qa\u0001C\u0002\u0011-a\u0001!B\u0002\u0005\r!UA\u0002A\u0003\u0003\t\u0007AA\"B\u0002\u0005\u0003!\u0001B\u0002A\u0003\u0003\t\u0005A\u0001\u0003Bb\u0002\u0019\u000bI2!B\u0001\t\ba\u001dQ&\u0005\u0003d\ta!\u0011eA\u0003\u0002\u0011\tA\"!V\u0002\n\u000b\u0011!A!C\u0001\t\t1\u0005Qb\u0001C\u0005\u0013\u0005AA!L\t\u0005GRAR!I\u0002\u0006\u0003!%\u0001\u0014B+\u0004\u0013\u0015!A!B\u0005\u0002\t\u0005a\t!D\u0002\u0005\r%\tA!AW5\t\u0005A\n!h\u0004\u0005\u0001!5QbA\u0003\u0002\u0011\tA\"\u0001U\u0002\u0001;\u001f!\u0001\u0001C\u0004\u000e\u0007\u0015\t\u0001\"\u0002\r\u0006!\u000e\u0005Qt\u0002\u0003\u0001\u0011!i1!B\u0001\t\na%\u0001kA\u0001\u001e\u0010\u0011\u0001\u0001\u0012C\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0007\t3!B\u0001\t\u0005a\u0011\u0011kA\u0006\u0005\u0002%\t\u0001\u0002B\u0007\u0002\u0011\u0011i\u0011\u0001\"\u0002\u000e\u0003\u0011\tQ\"\u0001C\u0001[\u007f!\u0011\u0001g\u0005\u001e\u0010\u0011\u0001\u0001BC\u0007\u0004\u000b\u0005Ai\u0001'\u0004Q\u0007\u0001iz\u0001\u0002\u0001\t\u00185\u0019Q!\u0001\u0005\u00061\u0015\u00016\u0011A\u0011\u0004\u000b\u0005AQ\u0001G\u0003R\u0007\u001d!\u0019\"C\u0001\u0005\u00065\t\u0001bB\u0007\u0002\t\u000bi#\u0006B\u0002\u0019\u001au=A\u0001\u0001\u0005\u000b\u001b\r)\u0011\u0001#\u0004\u0019\u000eA\u001b\u0001!h\u0004\u0005\u0001!iQbA\u0003\u0002\u0011\u0015AR\u0001UB\u0001;\u001f!\u0001\u0001c\u0007\u000e\u0007\u0015\t\u0001B\u0001\r\u0003!\u000e\t\u0011eA\u0003\u0002\u0011\tA\"!U\u0002\n\t3I\u0011\u0001\u0003\u0003\u000e\u0003!9Q\"\u0001C\u0003\u001b\u0005AA!l\u0010\u0005\u0003aqQt\u0002\u0003\u0001\u0011)i1!B\u0001\t\u000ea5\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001RD\u0007\u0004\u000b\u0005AQ\u0001G\u0003Q\u0007\u0003\t3!B\u0001\t\na%\u0011kA\u0004\u0005\u001d%\tA!A\u0007\u0002\u0011\u001di\u0011\u0001\"\u0002.-\u0011\u0019\u0001dDO\t\t\u0001Ay\"\u0004\u0003\u0006\u0003!=A\u0012\u0001M\b!\u000e\u0001\u0011eA\u0003\u0002\u0011\u0017AZ!U\u0002\u0006\t=I\u0011\u0001\"\u0001\u000e\u0003!AQ\u0007\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final MarkdownConstraints getBASE() {
            return BASE;
        }

        public final char getBQ_CHAR() {
            return BQ_CHAR;
        }

        private final MarkdownConstraints MarkdownConstraints(MarkdownConstraints parent, int newIndent, char newType, boolean newExplicit) {
            int n = parent.indents.length;
            int[] _indents = new int[n + 1];
            char[] _types = new char[n + 1];
            boolean[] _isExplicit = new boolean[n + 1];
            System.arraycopy(parent.indents, 0, _indents, 0, n);
            System.arraycopy(parent.types, 0, _types, 0, n);
            System.arraycopy(parent.isExplicit, 0, _isExplicit, 0, n);
            _indents[n] = newIndent;
            _types[n] = newType;
            _isExplicit[n] = newExplicit;
            return new MarkdownConstraints(_indents, _types, _isExplicit, null);
        }

        public final boolean isConstraintType(@Nullable IElementType type) {
            return Intrinsics.areEqual((Object)type, (Object)MarkdownTokenTypes.Companion.getLIST_NUMBER()) || Intrinsics.areEqual((Object)type, (Object)MarkdownTokenTypes.Companion.getLIST_BULLET()) || Intrinsics.areEqual((Object)type, (Object)MarkdownTokenTypes.Companion.getBLOCK_QUOTE());
        }

        @NotNull
        public final MarkdownConstraints fromBase(@NotNull TokensCache.Iterator iterator, int rawIndex, @NotNull MarkdownConstraints prevLineConstraints) {
            IElementType type;
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            Intrinsics.checkParameterIsNotNull((Object)prevLineConstraints, (String)"prevLineConstraints");
            int myStartOffset = iterator.rawStart(rawIndex);
            MarkdownConstraints result = this.getBASE();
            boolean isAlignedWithPrev = true;
            int offset = rawIndex;
            while (!(Intrinsics.areEqual((Object)(type = iterator.rawLookup(offset)), (Object)MarkdownTokenTypes.Companion.getWHITE_SPACE()) ^ true && !this.isConstraintType(type) || MarkdownParserUtil.Companion.hasCodeBlockIndent(iterator, offset, result))) {
                if (type == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)type, (Object)MarkdownTokenTypes.Companion.getWHITE_SPACE())) {
                    if (isAlignedWithPrev) {
                        result = result.fillImplicitsOnWhiteSpace(iterator, offset, prevLineConstraints);
                    }
                } else {
                    MarkdownConstraints newConstraints = result.addModifier(type, iterator, offset);
                    isAlignedWithPrev = prevLineConstraints.startsWith(newConstraints);
                    result = newConstraints;
                }
                ++offset;
            }
            return result;
        }

        private final int calcLineStartOffset(TokensCache.Iterator iterator, int rawOffset) {
            int index = rawOffset - 1;
            IElementType type;
            while ((type = iterator.rawLookup(index)) != null) {
                if (Intrinsics.areEqual((Object)type, (Object)MarkdownTokenTypes.Companion.getEOL())) {
                    return iterator.rawStart(index + 1);
                }
                --index;
            }
            return 0;
        }

        private final char getModifierCharAtRawIndex(TokensCache.Iterator iterator, int index) {
            IElementType type = iterator.rawLookup(index);
            if (Intrinsics.areEqual((Object)type, (Object)MarkdownTokenTypes.Companion.getBLOCK_QUOTE())) {
                return this.getBQ_CHAR();
            }
            String s = iterator.rawText(index);
            KotlinPackage.assert$default((s != null ? 1 : 0) != 0, null, (int)2);
            if (Intrinsics.areEqual((Object)type, (Object)MarkdownTokenTypes.Companion.getLIST_NUMBER())) {
                String string = s;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                return string.charAt(s.length() - 1);
            }
            if (Intrinsics.areEqual((Object)type, (Object)MarkdownTokenTypes.Companion.getLIST_BULLET())) {
                String string = s;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                return string.charAt(0);
            }
            throw (Throwable)new IllegalArgumentException("modifier must be either a list marker or a blockquote marker");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

