/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.JarCopyingFileSystem;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JarFileSystem
extends ArchiveFileSystem
implements JarCopyingFileSystem,
LocalFileProvider {
    public static final String PROTOCOL = "jar";
    public static final String PROTOCOL_PREFIX = "jar://";
    public static final String JAR_SEPARATOR = "!/";

    public static JarFileSystem getInstance() {
        return (JarFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    @Nullable
    public VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryFile) {
        return entryFile == null ? null : this.getLocalByEntry(entryFile);
    }

    @Nullable
    public VirtualFile getJarRootForLocalFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/JarFileSystem", "getJarRootForLocalFile"));
        }
        return this.getRootByLocal(file);
    }

    @Override
    @Nullable
    public VirtualFile getLocalVirtualFileFor(@Nullable VirtualFile entryVFile) {
        return this.getVirtualFileForJar(entryVFile);
    }

    @Override
    @Nullable
    public VirtualFile findLocalVirtualFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/JarFileSystem", "findLocalVirtualFileByPath"));
        }
        if (!path.contains(JAR_SEPARATOR)) {
            path = path + JAR_SEPARATOR;
        }
        return this.findFileByPath(path);
    }
}

