/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.FileTypeIndentOptionsProvider;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.psi.codeStyle.ProviderForCommittedDocument;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ClassMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSettings
extends CommonCodeStyleSettings
implements Cloneable,
JDOMExternalizable {
    public static final int MAX_RIGHT_MARGIN = 1000;
    private static final Logger LOG = Logger.getInstance((String)("#" + CodeStyleSettings.class.getName()));
    private final ClassMap<CustomCodeStyleSettings> myCustomSettings = new ClassMap();
    @NonNls
    private static final String ADDITIONAL_INDENT_OPTIONS = "ADDITIONAL_INDENT_OPTIONS";
    @NonNls
    private static final String FILETYPE = "fileType";
    private CommonCodeStyleSettingsManager myCommonSettingsManager = new CommonCodeStyleSettingsManager(this);
    public boolean USE_SAME_INDENTS = false;
    public boolean IGNORE_SAME_INDENTS_FOR_LANGUAGES = false;
    public boolean AUTODETECT_INDENTS = true;
    @Deprecated
    public final CommonCodeStyleSettings.IndentOptions JAVA_INDENT_OPTIONS = new CommonCodeStyleSettings.IndentOptions();
    @Deprecated
    public final CommonCodeStyleSettings.IndentOptions JSP_INDENT_OPTIONS = new CommonCodeStyleSettings.IndentOptions();
    @Deprecated
    public final CommonCodeStyleSettings.IndentOptions XML_INDENT_OPTIONS = new CommonCodeStyleSettings.IndentOptions();
    public final CommonCodeStyleSettings.IndentOptions OTHER_INDENT_OPTIONS = new CommonCodeStyleSettings.IndentOptions();
    private final Map<FileType, CommonCodeStyleSettings.IndentOptions> myAdditionalIndentOptions = new LinkedHashMap<FileType, CommonCodeStyleSettings.IndentOptions>();
    private static final String ourSystemLineSeparator = SystemProperties.getLineSeparator();
    public String LINE_SEPARATOR;
    public String FIELD_NAME_PREFIX = "";
    public String STATIC_FIELD_NAME_PREFIX = "";
    public String PARAMETER_NAME_PREFIX = "";
    public String LOCAL_VARIABLE_NAME_PREFIX = "";
    public String FIELD_NAME_SUFFIX = "";
    public String STATIC_FIELD_NAME_SUFFIX = "";
    public String PARAMETER_NAME_SUFFIX = "";
    public String LOCAL_VARIABLE_NAME_SUFFIX = "";
    public boolean PREFER_LONGER_NAMES = true;
    public final TypeToNameMap FIELD_TYPE_TO_NAME = new TypeToNameMap();
    public final TypeToNameMap STATIC_FIELD_TYPE_TO_NAME = new TypeToNameMap();
    @NonNls
    public final TypeToNameMap PARAMETER_TYPE_TO_NAME = new TypeToNameMap();
    public final TypeToNameMap LOCAL_VARIABLE_TYPE_TO_NAME = new TypeToNameMap();
    public boolean GENERATE_FINAL_LOCALS = false;
    public boolean GENERATE_FINAL_PARAMETERS = false;
    public String VISIBILITY = "public";
    public boolean PARENTHESES_AROUND_METHOD_ARGUMENTS = true;
    public boolean USE_EXTERNAL_ANNOTATIONS = false;
    public boolean INSERT_OVERRIDE_ANNOTATION = true;
    public boolean REPEAT_SYNCHRONIZED = true;
    public boolean LAYOUT_STATIC_IMPORTS_SEPARATELY = true;
    public boolean USE_FQ_CLASS_NAMES = false;
    @Deprecated
    public boolean USE_FQ_CLASS_NAMES_IN_JAVADOC = true;
    public boolean USE_SINGLE_CLASS_IMPORTS = true;
    public boolean INSERT_INNER_CLASS_IMPORTS = false;
    public int CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = 5;
    public int NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = 3;
    public final PackageEntryTable PACKAGES_TO_USE_IMPORT_ON_DEMAND = new PackageEntryTable();
    public final PackageEntryTable IMPORT_LAYOUT_TABLE = new PackageEntryTable();
    public int STATIC_FIELDS_ORDER_WEIGHT = 1;
    public int FIELDS_ORDER_WEIGHT = 2;
    public int CONSTRUCTORS_ORDER_WEIGHT = 3;
    public int STATIC_METHODS_ORDER_WEIGHT = 4;
    public int METHODS_ORDER_WEIGHT = 5;
    public int STATIC_INNER_CLASSES_ORDER_WEIGHT = 6;
    public int INNER_CLASSES_ORDER_WEIGHT = 7;
    @Deprecated
    public int RIGHT_MARGIN = 120;
    public boolean WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN = false;
    public boolean ENABLE_JAVADOC_FORMATTING = true;
    public boolean JD_ALIGN_PARAM_COMMENTS = true;
    public boolean JD_ALIGN_EXCEPTION_COMMENTS = true;
    public boolean JD_ADD_BLANK_AFTER_PARM_COMMENTS = false;
    public boolean JD_ADD_BLANK_AFTER_RETURN = false;
    public boolean JD_ADD_BLANK_AFTER_DESCRIPTION = true;
    public boolean JD_P_AT_EMPTY_LINES = true;
    public boolean JD_KEEP_INVALID_TAGS = true;
    public boolean JD_KEEP_EMPTY_LINES = true;
    public boolean JD_DO_NOT_WRAP_ONE_LINE_COMMENTS = false;
    public boolean JD_USE_THROWS_NOT_EXCEPTION = true;
    public boolean JD_KEEP_EMPTY_PARAMETER = true;
    public boolean JD_KEEP_EMPTY_EXCEPTION = true;
    public boolean JD_KEEP_EMPTY_RETURN = true;
    public boolean JD_LEADING_ASTERISKS_ARE_ENABLED = true;
    public boolean JD_PRESERVE_LINE_FEEDS = false;
    public boolean JD_PARAM_DESCRIPTION_ON_NEW_LINE = false;
    public boolean XML_KEEP_WHITESPACES = false;
    public int XML_ATTRIBUTE_WRAP = 1;
    public int XML_TEXT_WRAP = 1;
    public boolean XML_KEEP_LINE_BREAKS = true;
    public boolean XML_KEEP_LINE_BREAKS_IN_TEXT = true;
    public int XML_KEEP_BLANK_LINES = 2;
    public boolean XML_ALIGN_ATTRIBUTES = true;
    public boolean XML_ALIGN_TEXT = false;
    public boolean XML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE = false;
    public boolean XML_SPACE_AFTER_TAG_NAME = false;
    public boolean XML_SPACE_INSIDE_EMPTY_TAG = false;
    public boolean XML_KEEP_WHITE_SPACES_INSIDE_CDATA = false;
    public int XML_WHITE_SPACE_AROUND_CDATA = 0;
    public boolean HTML_KEEP_WHITESPACES = false;
    public int HTML_ATTRIBUTE_WRAP = 1;
    public int HTML_TEXT_WRAP = 1;
    public boolean HTML_KEEP_LINE_BREAKS = true;
    public boolean HTML_KEEP_LINE_BREAKS_IN_TEXT = true;
    public int HTML_KEEP_BLANK_LINES = 2;
    public boolean HTML_ALIGN_ATTRIBUTES = true;
    public boolean HTML_ALIGN_TEXT = false;
    public boolean HTML_SPACE_AROUND_EQUALITY_IN_ATTRINUTE = false;
    public boolean HTML_SPACE_AFTER_TAG_NAME = false;
    public boolean HTML_SPACE_INSIDE_EMPTY_TAG = false;
    @NonNls
    public String HTML_ELEMENTS_TO_INSERT_NEW_LINE_BEFORE = "body,div,p,form,h1,h2,h3";
    @NonNls
    public String HTML_ELEMENTS_TO_REMOVE_NEW_LINE_BEFORE = "br";
    @NonNls
    public String HTML_DO_NOT_INDENT_CHILDREN_OF = "html,body,thead,tbody,tfoot";
    public int HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES = 0;
    @NonNls
    public String HTML_KEEP_WHITESPACES_INSIDE = "span,pre,textarea";
    @NonNls
    public String HTML_INLINE_ELEMENTS = "a,abbr,acronym,b,basefont,bdo,big,br,cite,cite,code,dfn,em,font,i,img,input,kbd,label,q,s,samp,select,span,strike,strong,sub,sup,textarea,tt,u,var";
    @NonNls
    public String HTML_DONT_ADD_BREAKS_IF_INLINE_CONTENT = "title,h1,h2,h3,h4,h5,h6,p";
    public boolean JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST = false;
    public boolean FORMATTER_TAGS_ENABLED = false;
    public String FORMATTER_ON_TAG = "@formatter:on";
    public String FORMATTER_OFF_TAG = "@formatter:off";
    public volatile boolean FORMATTER_TAGS_ACCEPT_REGEXP = false;
    private volatile Pattern myFormatterOffPattern = null;
    private volatile Pattern myFormatterOnPattern = null;
    private CodeStyleSettings myParentSettings;
    private boolean myLoadedAdditionalIndentOptions;

    public CodeStyleSettings() {
        this(true);
    }

    public CodeStyleSettings(boolean loadExtensions) {
        super(null);
        this.initTypeToName();
        this.initImportsByDefault();
        if (loadExtensions) {
            CodeStyleSettingsProvider[] codeStyleSettingsProviders;
            for (CodeStyleSettingsProvider provider : codeStyleSettingsProviders = (CodeStyleSettingsProvider[])Extensions.getExtensions(CodeStyleSettingsProvider.EXTENSION_POINT_NAME)) {
                this.addCustomSettings(provider.createCustomSettings(this));
            }
        }
    }

    private void initImportsByDefault() {
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "java.awt", false));
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "javax.swing", false));
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_IMPORTS_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "javax", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "java", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
    }

    private void initTypeToName() {
        CodeStyleSettings.initGeneralLocalVariable(this.PARAMETER_TYPE_TO_NAME);
        CodeStyleSettings.initGeneralLocalVariable(this.LOCAL_VARIABLE_TYPE_TO_NAME);
        this.PARAMETER_TYPE_TO_NAME.addPair("*Exception", "e");
    }

    private static void initGeneralLocalVariable(@NonNls TypeToNameMap map) {
        map.addPair("int", "i");
        map.addPair("byte", "b");
        map.addPair("char", "c");
        map.addPair("long", "l");
        map.addPair("short", "i");
        map.addPair("boolean", "b");
        map.addPair("double", "v");
        map.addPair("float", "v");
        map.addPair("java.lang.Object", "o");
        map.addPair("java.lang.String", "s");
    }

    public void setParentSettings(CodeStyleSettings parent) {
        this.myParentSettings = parent;
    }

    public CodeStyleSettings getParentSettings() {
        return this.myParentSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCustomSettings(CustomCodeStyleSettings settings) {
        if (settings != null) {
            ClassMap<CustomCodeStyleSettings> classMap = this.myCustomSettings;
            synchronized (classMap) {
                this.myCustomSettings.put(settings.getClass(), (Object)settings);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/codeStyle/CodeStyleSettings", "getCustomSettings"));
        }
        ClassMap<CustomCodeStyleSettings> classMap = this.myCustomSettings;
        synchronized (classMap) {
            return (T)((CustomCodeStyleSettings)this.myCustomSettings.get(aClass));
        }
    }

    public CodeStyleSettings clone() {
        CodeStyleSettings clone = new CodeStyleSettings();
        clone.copyFrom(this);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCustomSettingsFrom(@NotNull CodeStyleSettings from) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/psi/codeStyle/CodeStyleSettings", "copyCustomSettingsFrom"));
        }
        ClassMap<CustomCodeStyleSettings> classMap = this.myCustomSettings;
        synchronized (classMap) {
            this.myCustomSettings.clear();
            for (CustomCodeStyleSettings customCodeStyleSettings : from.getCustomSettingsValues()) {
                this.addCustomSettings((CustomCodeStyleSettings)customCodeStyleSettings.clone());
            }
            this.FIELD_TYPE_TO_NAME.copyFrom(from.FIELD_TYPE_TO_NAME);
            this.STATIC_FIELD_TYPE_TO_NAME.copyFrom(from.STATIC_FIELD_TYPE_TO_NAME);
            this.PARAMETER_TYPE_TO_NAME.copyFrom(from.PARAMETER_TYPE_TO_NAME);
            this.LOCAL_VARIABLE_TYPE_TO_NAME.copyFrom(from.LOCAL_VARIABLE_TYPE_TO_NAME);
            this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.copyFrom(from.PACKAGES_TO_USE_IMPORT_ON_DEMAND);
            this.IMPORT_LAYOUT_TABLE.copyFrom(from.IMPORT_LAYOUT_TABLE);
            this.OTHER_INDENT_OPTIONS.copyFrom(from.OTHER_INDENT_OPTIONS);
            this.myAdditionalIndentOptions.clear();
            for (Map.Entry entry : from.myAdditionalIndentOptions.entrySet()) {
                CommonCodeStyleSettings.IndentOptions options = (CommonCodeStyleSettings.IndentOptions)entry.getValue();
                this.myAdditionalIndentOptions.put((FileType)entry.getKey(), (CommonCodeStyleSettings.IndentOptions)options.clone());
            }
            this.myCommonSettingsManager = from.myCommonSettingsManager.clone(this);
        }
    }

    public void copyFrom(CodeStyleSettings from) {
        CodeStyleSettings.copyPublicFields(from, this);
        this.copyCustomSettingsFrom(from);
    }

    public String getLineSeparator() {
        return this.LINE_SEPARATOR != null ? this.LINE_SEPARATOR : ourSystemLineSeparator;
    }

    @Nullable
    public Pattern getFormatterOffPattern() {
        if (this.myFormatterOffPattern == null && this.FORMATTER_TAGS_ENABLED && this.FORMATTER_TAGS_ACCEPT_REGEXP) {
            this.myFormatterOffPattern = this.getPatternOrDisableRegexp(this.FORMATTER_OFF_TAG);
        }
        return this.myFormatterOffPattern;
    }

    public void setFormatterOffPattern(@Nullable Pattern formatterOffPattern) {
        this.myFormatterOffPattern = formatterOffPattern;
    }

    @Nullable
    public Pattern getFormatterOnPattern() {
        if (this.myFormatterOffPattern == null && this.FORMATTER_TAGS_ENABLED && this.FORMATTER_TAGS_ACCEPT_REGEXP) {
            this.myFormatterOnPattern = this.getPatternOrDisableRegexp(this.FORMATTER_ON_TAG);
        }
        return this.myFormatterOnPattern;
    }

    public void setFormatterOnPattern(@Nullable Pattern formatterOnPattern) {
        this.myFormatterOnPattern = formatterOnPattern;
    }

    @Nullable
    private Pattern getPatternOrDisableRegexp(@NotNull String markerText) {
        if (markerText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markerText", "com/intellij/psi/codeStyle/CodeStyleSettings", "getPatternOrDisableRegexp"));
        }
        try {
            return Pattern.compile(markerText);
        }
        catch (PatternSyntaxException pse) {
            LOG.error("Loaded regexp pattern is invalid: '" + markerText + "', error message: " + pse.getMessage());
            this.FORMATTER_TAGS_ACCEPT_REGEXP = false;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Collection<CustomCodeStyleSettings> getCustomSettingsValues() {
        ClassMap<CustomCodeStyleSettings> classMap = this.myCustomSettings;
        // MONITORENTER : classMap
        Collection<CustomCodeStyleSettings> collection = Collections.unmodifiableCollection(this.myCustomSettings.values());
        // MONITOREXIT : classMap
        if (collection != null) return collection;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CodeStyleSettings", "getCustomSettingsValues"));
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        if (this.LAYOUT_STATIC_IMPORTS_SEPARATELY) {
            boolean found = false;
            for (PackageEntry entry : this.IMPORT_LAYOUT_TABLE.getEntries()) {
                if (entry != PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) continue;
                found = true;
                break;
            }
            if (!found) {
                PackageEntry last;
                PackageEntry packageEntry = last = this.IMPORT_LAYOUT_TABLE.getEntryCount() == 0 ? null : this.IMPORT_LAYOUT_TABLE.getEntryAt(this.IMPORT_LAYOUT_TABLE.getEntryCount() - 1);
                if (last != PackageEntry.BLANK_LINE_ENTRY) {
                    this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
                }
                this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
            }
        }
        for (CustomCodeStyleSettings settings : this.getCustomSettingsValues()) {
            settings.readExternal(element);
            settings.importLegacySettings();
        }
        List list = element.getChildren(ADDITIONAL_INDENT_OPTIONS);
        if (list != null) {
            for (Object o : list) {
                Element additionalIndentElement;
                String fileTypeId;
                if (!(o instanceof Element) || (fileTypeId = (additionalIndentElement = (Element)o).getAttributeValue(FILETYPE)) == null || fileTypeId.isEmpty()) continue;
                FileType target = FileTypeManager.getInstance().getFileTypeByExtension(fileTypeId);
                if (FileTypes.UNKNOWN == target || FileTypes.PLAIN_TEXT == target || target.getDefaultExtension().isEmpty()) {
                    target = new TempFileType(fileTypeId);
                }
                CommonCodeStyleSettings.IndentOptions options = CodeStyleSettings.getDefaultIndentOptions(target);
                options.readExternal(additionalIndentElement);
                this.registerAdditionalIndentOptions(target, options);
            }
        }
        this.myCommonSettingsManager.readExternal(element);
        if (this.USE_SAME_INDENTS) {
            this.IGNORE_SAME_INDENTS_FOR_LANGUAGES = true;
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        CodeStyleSettings parentSettings = new CodeStyleSettings();
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter((Object)this, (Object)parentSettings));
        ArrayList<CustomCodeStyleSettings> customSettings = new ArrayList<CustomCodeStyleSettings>(this.getCustomSettingsValues());
        Collections.sort(customSettings, new Comparator<CustomCodeStyleSettings>(){

            @Override
            public int compare(CustomCodeStyleSettings o1, CustomCodeStyleSettings o2) {
                return o1.getTagName().compareTo(o2.getTagName());
            }
        });
        for (CustomCodeStyleSettings settings : customSettings) {
            Object parentCustomSettings = parentSettings.getCustomSettings(settings.getClass());
            if (parentCustomSettings == null) {
                throw new WriteExternalException("Custom settings are null for " + settings.getClass());
            }
            settings.writeExternal(element, (CustomCodeStyleSettings)parentCustomSettings);
        }
        FileType[] fileTypes = this.myAdditionalIndentOptions.keySet().toArray(new FileType[this.myAdditionalIndentOptions.keySet().size()]);
        Arrays.sort(fileTypes, new Comparator<FileType>(){

            @Override
            public int compare(FileType o1, FileType o2) {
                return o1.getDefaultExtension().compareTo(o2.getDefaultExtension());
            }
        });
        for (FileType fileType : fileTypes) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.myAdditionalIndentOptions.get(fileType);
            Element additionalIndentOptions = new Element(ADDITIONAL_INDENT_OPTIONS);
            indentOptions.serialize(additionalIndentOptions, CodeStyleSettings.getDefaultIndentOptions(fileType));
            additionalIndentOptions.setAttribute(FILETYPE, fileType.getDefaultExtension());
            if (additionalIndentOptions.getChildren().isEmpty()) continue;
            element.addContent(additionalIndentOptions);
        }
        this.myCommonSettingsManager.writeExternal(element);
    }

    private static CommonCodeStyleSettings.IndentOptions getDefaultIndentOptions(FileType fileType) {
        FileTypeIndentOptionsProvider[] providers;
        for (FileTypeIndentOptionsProvider provider : providers = (FileTypeIndentOptionsProvider[])Extensions.getExtensions(FileTypeIndentOptionsProvider.EP_NAME)) {
            if (!provider.getFileType().equals(fileType)) continue;
            return CodeStyleSettings.getFileTypeIndentOptions(provider);
        }
        return new CommonCodeStyleSettings.IndentOptions();
    }

    @Override
    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        return this.OTHER_INDENT_OPTIONS;
    }

    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@Nullable FileType fileType) {
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getLanguageIndentOptions(fileType);
        if (indentOptions != null) {
            return indentOptions;
        }
        if (this.USE_SAME_INDENTS || fileType == null) {
            return this.OTHER_INDENT_OPTIONS;
        }
        if (!this.myLoadedAdditionalIndentOptions) {
            this.loadAdditionalIndentOptions();
        }
        if ((indentOptions = this.myAdditionalIndentOptions.get(fileType)) != null) {
            return indentOptions;
        }
        return this.OTHER_INDENT_OPTIONS;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByFile(@Nullable PsiFile file) {
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptionsByFile(file, null);
        if (indentOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CodeStyleSettings", "getIndentOptionsByFile"));
        }
        return indentOptions;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByFile(@Nullable PsiFile file, @Nullable TextRange formatRange) {
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getIndentOptionsByFile(file, formatRange, false, null);
        if (indentOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CodeStyleSettings", "getIndentOptionsByFile"));
        }
        return indentOptions;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByFile(@Nullable PsiFile file, @Nullable TextRange formatRange, boolean ignoreDocOptions, @Nullable Processor<FileIndentOptionsProvider> providerProcessor) {
        if (file != null && file.isValid()) {
            CommonCodeStyleSettings.IndentOptions options;
            boolean isFullReformat = CodeStyleSettings.isFileFullyCoveredByRange(file, formatRange);
            if (!ignoreDocOptions && !isFullReformat && (options = CommonCodeStyleSettings.IndentOptions.retrieveFromAssociatedDocument(file)) != null) {
                FileIndentOptionsProvider provider = options.getFileIndentOptionsProvider();
                if (providerProcessor != null && provider != null) {
                    providerProcessor.process((Object)provider);
                }
                CommonCodeStyleSettings.IndentOptions indentOptions = options;
                if (indentOptions == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CodeStyleSettings", "getIndentOptionsByFile"));
                }
                return indentOptions;
            }
            boolean committedDocumentNeeded = false;
            for (FileIndentOptionsProvider provider : (FileIndentOptionsProvider[])Extensions.getExtensions(FileIndentOptionsProvider.EP_NAME)) {
                if (isFullReformat && !provider.useOnFullReformat()) continue;
                committedDocumentNeeded |= provider instanceof ProviderForCommittedDocument;
                CommonCodeStyleSettings.IndentOptions indentOptions = provider.getIndentOptions(this, file);
                if (indentOptions == null) continue;
                if (providerProcessor != null) {
                    providerProcessor.process((Object)provider);
                }
                indentOptions.setFileIndentOptionsProvider(provider);
                CodeStyleSettings.logIndentOptions(file, provider, indentOptions);
                CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
                if (indentOptions2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CodeStyleSettings", "getIndentOptionsByFile"));
                }
                return indentOptions2;
            }
            CommonCodeStyleSettings.IndentOptions options2 = this.getIndentOptions(file.getFileType());
            if (committedDocumentNeeded) {
                CodeStyleSettings.markOptionsInaccurateIfDocumentUncommitted(options2, file);
            }
            CommonCodeStyleSettings.IndentOptions indentOptions = options2;
            if (indentOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CodeStyleSettings", "getIndentOptionsByFile"));
            }
            return indentOptions;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = this.OTHER_INDENT_OPTIONS;
        if (indentOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CodeStyleSettings", "getIndentOptionsByFile"));
        }
        return indentOptions;
    }

    private static void markOptionsInaccurateIfDocumentUncommitted(@NotNull CommonCodeStyleSettings.IndentOptions options, @NotNull PsiFile file) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/psi/codeStyle/CodeStyleSettings", "markOptionsInaccurateIfDocumentUncommitted"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/CodeStyleSettings", "markOptionsInaccurateIfDocumentUncommitted"));
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance(file.getProject());
        Document document = manager.getDocument(file);
        if (document != null && !manager.isCommitted(document)) {
            options.setRecalculateForCommittedDocument(true);
        }
    }

    public static boolean isRecalculateForCommittedDocument(@NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/psi/codeStyle/CodeStyleSettings", "isRecalculateForCommittedDocument"));
        }
        return options.isRecalculateForCommittedDocument();
    }

    private static boolean isFileFullyCoveredByRange(@NotNull PsiFile file, @Nullable TextRange formatRange) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/CodeStyleSettings", "isFileFullyCoveredByRange"));
        }
        return formatRange != null && file.getTextRange().equals((Object)formatRange);
    }

    private static void logIndentOptions(@NotNull PsiFile file, @NotNull FileIndentOptionsProvider provider, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/CodeStyleSettings", "logIndentOptions"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/codeStyle/CodeStyleSettings", "logIndentOptions"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/psi/codeStyle/CodeStyleSettings", "logIndentOptions"));
        }
        LOG.debug("Indent options returned by " + provider.getClass().getName() + " for " + file.getName() + ": indent size=" + options.INDENT_SIZE + ", use tabs=" + options.USE_TAB_CHARACTER + ", tab size=" + options.TAB_SIZE);
    }

    @Nullable
    private CommonCodeStyleSettings.IndentOptions getLanguageIndentOptions(@Nullable FileType fileType) {
        if (fileType == null || !(fileType instanceof LanguageFileType)) {
            return null;
        }
        Language lang = ((LanguageFileType)fileType).getLanguage();
        CommonCodeStyleSettings langSettings = this.getCommonSettings(lang);
        return langSettings == this ? null : langSettings.getIndentOptions();
    }

    public boolean isSmartTabs(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).SMART_TABS;
    }

    public int getIndentSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).INDENT_SIZE;
    }

    public int getContinuationIndentSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).CONTINUATION_INDENT_SIZE;
    }

    public int getLabelIndentSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).LABEL_INDENT_SIZE;
    }

    public boolean getLabelIndentAbsolute(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).LABEL_INDENT_ABSOLUTE;
    }

    public int getTabSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).TAB_SIZE;
    }

    public boolean useTabCharacter(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).USE_TAB_CHARACTER;
    }

    public boolean isGenerateFinalLocals() {
        return this.GENERATE_FINAL_LOCALS;
    }

    public boolean isGenerateFinalParameters() {
        return this.GENERATE_FINAL_PARAMETERS;
    }

    private void registerAdditionalIndentOptions(FileType fileType, CommonCodeStyleSettings.IndentOptions options) {
        boolean exist = false;
        for (FileType existing : this.myAdditionalIndentOptions.keySet()) {
            if (!Comparing.strEqual((String)existing.getDefaultExtension(), (String)fileType.getDefaultExtension())) continue;
            exist = true;
            break;
        }
        if (!exist) {
            this.myAdditionalIndentOptions.put(fileType, options);
        }
    }

    public CommonCodeStyleSettings.IndentOptions getAdditionalIndentOptions(FileType fileType) {
        if (!this.myLoadedAdditionalIndentOptions) {
            this.loadAdditionalIndentOptions();
        }
        return this.myAdditionalIndentOptions.get(fileType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAdditionalIndentOptions() {
        Map<FileType, CommonCodeStyleSettings.IndentOptions> map = this.myAdditionalIndentOptions;
        synchronized (map) {
            FileTypeIndentOptionsProvider[] providers;
            this.myLoadedAdditionalIndentOptions = true;
            for (FileTypeIndentOptionsProvider provider : providers = (FileTypeIndentOptionsProvider[])Extensions.getExtensions(FileTypeIndentOptionsProvider.EP_NAME)) {
                if (this.myAdditionalIndentOptions.containsKey(provider.getFileType())) continue;
                this.registerAdditionalIndentOptions(provider.getFileType(), CodeStyleSettings.getFileTypeIndentOptions(provider));
            }
        }
    }

    private static CommonCodeStyleSettings.IndentOptions getFileTypeIndentOptions(FileTypeIndentOptionsProvider provider) {
        try {
            return provider.createIndentOptions();
        }
        catch (AbstractMethodError error) {
            LOG.error("Plugin uses obsolete API.", (Throwable)new ExtensionException(provider.getClass()));
            return new CommonCodeStyleSettings.IndentOptions();
        }
    }

    public void clearCodeStyleSettings() {
        CodeStyleSettings cleanSettings = new CodeStyleSettings();
        this.copyFrom(cleanSettings);
        this.myAdditionalIndentOptions.clear();
        this.myLoadedAdditionalIndentOptions = false;
    }

    public CommonCodeStyleSettings getCommonSettings(Language lang) {
        return this.myCommonSettingsManager.getCommonSettings(lang);
    }

    public CommonCodeStyleSettings getCommonSettings(String langName) {
        return this.myCommonSettingsManager.getCommonSettings(langName);
    }

    public int getRightMargin(@Nullable Language language) {
        CommonCodeStyleSettings langSettings;
        if (language != null && (langSettings = this.getCommonSettings(language)) != null && langSettings.RIGHT_MARGIN >= 0) {
            return langSettings.RIGHT_MARGIN;
        }
        return this.getDefaultRightMargin();
    }

    public void setRightMargin(@Nullable Language language, int rightMargin) {
        CommonCodeStyleSettings langSettings;
        if (language != null && (langSettings = this.getCommonSettings(language)) != null) {
            langSettings.RIGHT_MARGIN = rightMargin;
            return;
        }
        this.setDefaultRightMargin(rightMargin);
    }

    public int getDefaultRightMargin() {
        return this.RIGHT_MARGIN;
    }

    public void setDefaultRightMargin(int rightMargin) {
        this.RIGHT_MARGIN = rightMargin;
    }

    public boolean isWrapOnTyping(@Nullable Language language) {
        CommonCodeStyleSettings langSettings;
        if (language != null && (langSettings = this.getCommonSettings(language)) != null && langSettings.WRAP_ON_TYPING != CommonCodeStyleSettings.WrapOnTyping.DEFAULT.intValue) {
            return langSettings.WRAP_ON_TYPING == CommonCodeStyleSettings.WrapOnTyping.WRAP.intValue;
        }
        return this.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN;
    }

    private static class TempFileType
    implements FileType {
        private final String myExtension;

        private TempFileType(@NotNull String extension) {
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/psi/codeStyle/CodeStyleSettings$TempFileType", "<init>"));
            }
            this.myExtension = extension;
        }

        @Override
        @NotNull
        public String getName() {
            if ("TempFileType" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CodeStyleSettings$TempFileType", "getName"));
            }
            return "TempFileType";
        }

        @Override
        @NotNull
        public String getDescription() {
            if ("TempFileType" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CodeStyleSettings$TempFileType", "getDescription"));
            }
            return "TempFileType";
        }

        @Override
        @NotNull
        public String getDefaultExtension() {
            String string = this.myExtension;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CodeStyleSettings$TempFileType", "getDefaultExtension"));
            }
            return string;
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/CodeStyleSettings$TempFileType", "getCharset"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/psi/codeStyle/CodeStyleSettings$TempFileType", "getCharset"));
            }
            return null;
        }
    }

    public static class TypeToNameMap
    implements JDOMExternalizable {
        private final List<String> myPatterns = new ArrayList<String>();
        private final List<String> myNames = new ArrayList<String>();

        public void addPair(String pattern, String name) {
            this.myPatterns.add(pattern);
            this.myNames.add(name);
        }

        public String nameByType(String type) {
            for (int i = 0; i < this.myPatterns.size(); ++i) {
                String pattern = this.myPatterns.get(i);
                if (!(StringUtil.startsWithChar((CharSequence)pattern, (char)'*') ? type.endsWith(pattern.substring(1)) : type.equals(pattern))) continue;
                return this.myNames.get(i);
            }
            return null;
        }

        public void readExternal(@NonNls Element element) throws InvalidDataException {
            this.myPatterns.clear();
            this.myNames.clear();
            for (Object o : element.getChildren("pair")) {
                Element e = (Element)o;
                String pattern = e.getAttributeValue("type");
                String name = e.getAttributeValue("name");
                if (pattern == null || name == null) {
                    throw new InvalidDataException();
                }
                this.myPatterns.add(pattern);
                this.myNames.add(name);
            }
        }

        public void writeExternal(Element parentNode) throws WriteExternalException {
            for (int i = 0; i < this.myPatterns.size(); ++i) {
                String pattern = this.myPatterns.get(i);
                String name = this.myNames.get(i);
                Element element = new Element("pair");
                parentNode.addContent(element);
                element.setAttribute("type", pattern);
                element.setAttribute("name", name);
            }
        }

        public void copyFrom(TypeToNameMap from) {
            assert (from != this);
            this.myPatterns.clear();
            this.myPatterns.addAll(from.myPatterns);
            this.myNames.clear();
            this.myNames.addAll(from.myNames);
        }

        public boolean equals(Object other) {
            if (other instanceof TypeToNameMap) {
                TypeToNameMap otherMap = (TypeToNameMap)other;
                return this.myPatterns.equals(otherMap.myPatterns) && this.myNames.equals(otherMap.myNames);
            }
            return false;
        }

        public int hashCode() {
            int code = 0;
            for (String myPattern : this.myPatterns) {
                code += myPattern.hashCode();
            }
            for (String myName : this.myNames) {
                code += myName.hashCode();
            }
            return code;
        }
    }
}

