/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenBaseModifiableModelsProvider;

public class MavenDefaultModifiableModelsProvider
extends MavenBaseModifiableModelsProvider {
    private final LibraryTable.ModifiableModel myLibrariesModel;

    public MavenDefaultModifiableModelsProvider(Project project) {
        super(project);
        this.myLibrariesModel = ProjectLibraryTable.getInstance((Project)this.myProject).getModifiableModel();
    }

    @Override
    protected ModifiableArtifactModel doGetArtifactModel() {
        return (ModifiableArtifactModel)new ReadAction<ModifiableArtifactModel>(){

            protected void run(@NotNull Result<ModifiableArtifactModel> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/importing/MavenDefaultModifiableModelsProvider$1", "run"));
                }
                result.setResult((Object)ArtifactManager.getInstance((Project)MavenDefaultModifiableModelsProvider.this.myProject).createModifiableModel());
            }
        }.execute().getResultObject();
    }

    @Override
    protected ModifiableModuleModel doGetModuleModel() {
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            ModifiableModuleModel modifiableModuleModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
            return modifiableModuleModel;
        }
        finally {
            accessToken.finish();
        }
    }

    @Override
    protected ModifiableRootModel doGetRootModel(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/importing/MavenDefaultModifiableModelsProvider", "doGetRootModel"));
        }
        return (ModifiableRootModel)new ReadAction<ModifiableRootModel>(){

            protected void run(@NotNull Result<ModifiableRootModel> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/importing/MavenDefaultModifiableModelsProvider$2", "run"));
                }
                result.setResult((Object)ModuleRootManager.getInstance((Module)module).getModifiableModel());
            }
        }.execute().getResultObject();
    }

    @Override
    protected ModifiableFacetModel doGetFacetModel(Module module) {
        return FacetManager.getInstance((Module)module).createModifiableModel();
    }

    @Override
    public LibraryTable.ModifiableModel getProjectLibrariesModel() {
        return this.myLibrariesModel;
    }

    @Override
    public Library[] getAllLibraries() {
        return this.myLibrariesModel.getLibraries();
    }

    @Override
    public Library getLibraryByName(String name) {
        return this.myLibrariesModel.getLibraryByName(name);
    }

    @Override
    public Library createLibrary(String name) {
        return this.myLibrariesModel.createLibrary(name);
    }

    @Override
    public void removeLibrary(Library library) {
        this.myLibrariesModel.removeLibrary(library);
    }

    @Override
    protected Library.ModifiableModel doGetLibraryModel(Library library) {
        return library.getModifiableModel();
    }

    @Override
    public void commit() {
        ((ProjectRootManagerEx)ProjectRootManager.getInstance((Project)this.myProject)).mergeRootsChangesDuring(new Runnable(){

            @Override
            public void run() {
                MavenDefaultModifiableModelsProvider.this.processExternalArtifactDependencies();
                for (Library.ModifiableModel each : MavenDefaultModifiableModelsProvider.this.myLibraryModels.values()) {
                    each.commit();
                }
                MavenDefaultModifiableModelsProvider.this.myLibrariesModel.commit();
                Collection rootModels = MavenDefaultModifiableModelsProvider.this.myRootModels.values();
                ModifiableRootModel[] rootModels1 = rootModels.toArray(new ModifiableRootModel[rootModels.size()]);
                for (ModifiableRootModel model : rootModels1) {
                    assert (!model.isDisposed()) : "Already disposed: " + model;
                }
                if (MavenDefaultModifiableModelsProvider.this.myModuleModel != null) {
                    ModifiableModelCommitter.multiCommit((ModifiableRootModel[])rootModels1, (ModifiableModuleModel)MavenDefaultModifiableModelsProvider.this.myModuleModel);
                }
                for (ModifiableFacetModel each : MavenDefaultModifiableModelsProvider.this.myFacetModels.values()) {
                    each.commit();
                }
                if (MavenDefaultModifiableModelsProvider.this.myArtifactModel != null) {
                    MavenDefaultModifiableModelsProvider.this.myArtifactModel.commit();
                }
            }
        });
    }

    @Override
    public void dispose() {
        for (ModifiableRootModel each : this.myRootModels.values()) {
            each.dispose();
        }
        this.myModuleModel.dispose();
        if (this.myArtifactModel != null) {
            this.myArtifactModel.dispose();
        }
    }

    @Override
    public ModalityState getModalityStateForQuestionDialogs() {
        return ModalityState.NON_MODAL;
    }
}

