/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.ProjectModelModifier;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler;

public class MavenProjectModelModifier
extends ProjectModelModifier {
    private final Project myProject;
    private final MavenProjectsManager myProjectsManager;
    private MavenProjectIndicesManager myIndicesManager;

    public MavenProjectModelModifier(Project project, MavenProjectsManager projectsManager, MavenProjectIndicesManager manager) {
        this.myProject = project;
        this.myProjectsManager = projectsManager;
        this.myIndicesManager = manager;
    }

    @Nullable
    public Promise<Void> addModuleDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addModuleDependency"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addModuleDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addModuleDependency"));
        }
        MavenProject toProject = this.myProjectsManager.findProject(to);
        if (toProject == null) {
            return null;
        }
        MavenId mavenId = toProject.getMavenId();
        return this.addDependency(Collections.singletonList(from), mavenId, scope);
    }

    private Promise<Void> addDependency(@NotNull Collection<Module> fromModules, final @NotNull MavenId mavenId, final @NotNull DependencyScope scope) {
        if (fromModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromModules", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addDependency"));
        }
        if (mavenId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenId", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addDependency"));
        }
        final ArrayList<MavenDomProjectModel> models = new ArrayList<MavenDomProjectModel>(fromModules.size());
        ArrayList<XmlFile> files = new ArrayList<XmlFile>(fromModules.size());
        ArrayList<MavenProject> projectToUpdate = new ArrayList<MavenProject>(fromModules.size());
        for (Module from : fromModules) {
            if (!this.myProjectsManager.isMavenizedModule(from)) {
                return null;
            }
            MavenProject fromProject = this.myProjectsManager.findProject(from);
            if (fromProject == null) {
                return null;
            }
            MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel(this.myProject, fromProject.getFile());
            if (model == null) {
                return null;
            }
            models.add(model);
            files.add(DomUtil.getFile((DomElement)model));
            projectToUpdate.add(fromProject);
        }
        new WriteCommandAction(this.myProject, "Add Maven Dependency", PsiUtilCore.toPsiFileArray(files)){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier$1", "run"));
                }
                for (MavenDomProjectModel model : models) {
                    Document document;
                    MavenDomDependency dependency = MavenDomUtil.createDomDependency(model, null, mavenId);
                    String mavenScope = MavenProjectModelModifier.getMavenScope(scope);
                    if (mavenScope != null) {
                        dependency.getScope().setStringValue(mavenScope);
                    }
                    if ((document = PsiDocumentManager.getInstance((Project)MavenProjectModelModifier.this.myProject).getDocument((PsiFile)DomUtil.getFile((DomElement)model))) == null) continue;
                    FileDocumentManager.getInstance().saveDocument(document);
                }
            }
        }.execute();
        return this.myProjectsManager.forceUpdateProjects(projectToUpdate);
    }

    @Nullable
    public Promise<Void> addExternalLibraryDependency(@NotNull Collection<Module> modules, @NotNull ExternalLibraryDescriptor descriptor, @NotNull DependencyScope scope) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addExternalLibraryDependency"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addExternalLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addExternalLibraryDependency"));
        }
        for (Module module : modules) {
            if (this.myProjectsManager.isMavenizedModule(module)) continue;
            return null;
        }
        String version = this.selectVersion(descriptor);
        MavenId mavenId = new MavenId(descriptor.getLibraryGroupId(), descriptor.getLibraryArtifactId(), version);
        return this.addDependency(modules, mavenId, scope);
    }

    @Nullable
    private String selectVersion(@NotNull ExternalLibraryDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "selectVersion"));
        }
        Set<String> versions = this.myIndicesManager.getVersions(descriptor.getLibraryGroupId(), descriptor.getLibraryArtifactId());
        ArrayList<String> suitableVersions = new ArrayList<String>();
        String minVersion = descriptor.getMinVersion();
        String maxVersion = descriptor.getMaxVersion();
        for (String version : versions) {
            if (minVersion != null && VersionComparatorUtil.compare((String)minVersion, (String)version) > 0 || maxVersion != null && VersionComparatorUtil.compare((String)version, (String)maxVersion) >= 0) continue;
            suitableVersions.add(version);
        }
        if (suitableVersions.isEmpty()) {
            return null;
        }
        return (String)Collections.max(suitableVersions, VersionComparatorUtil.COMPARATOR);
    }

    @Nullable
    public Promise<Void> addLibraryDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addLibraryDependency"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/idea/maven/importing/MavenProjectModelModifier", "addLibraryDependency"));
        }
        String name = library.getName();
        if (name != null && name.startsWith("Maven: ")) {
            String mavenCoordinates = StringUtil.trimStart((String)name, (String)"Maven: ");
            return this.addDependency(Collections.singletonList(from), RepositoryAttachHandler.getMavenId(mavenCoordinates), scope);
        }
        return null;
    }

    @Nullable
    private static String getMavenScope(DependencyScope scope) {
        switch (scope) {
            case RUNTIME: {
                return "runtime";
            }
            case TEST: {
                return "test";
            }
            case PROVIDED: {
                return "provided";
            }
        }
        return null;
    }
}

