/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.util.containers.HashMap;
import icons.MavenIcons;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public abstract class RepositoryLibraryDescription {
    protected static final ExtensionPointName<RepositoryLibraryDescription> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.idea.maven.repositoryLibrary");
    protected static final MavenRepositoryInfo mavenCentralRepository = new MavenRepositoryInfo("central", "Maven Central repository", "http://repo1.maven.org/maven2");
    protected static final MavenRepositoryInfo jbossCommunityRepository = new MavenRepositoryInfo("jboss.community", "JBoss Community repository", "http://repository.jboss.org/nexus");
    private static final List<MavenRepositoryInfo> defaultRemoteRepositories = Arrays.asList(mavenCentralRepository, jbossCommunityRepository);
    private static Map<String, RepositoryLibraryDescription> registeredLibraries;

    public static <C extends RepositoryLibraryDescription> C ofClass(Class<C> clazz) {
        return (C)((RepositoryLibraryDescription)EP_NAME.findExtension(clazz));
    }

    @NotNull
    public static synchronized RepositoryLibraryDescription findDescription(final @NotNull RepositoryLibraryProperties properties) {
        String id;
        RepositoryLibraryDescription description;
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "findDescription"));
        }
        if (registeredLibraries == null) {
            registeredLibraries = new HashMap();
            for (RepositoryLibraryDescription description2 : (RepositoryLibraryDescription[])EP_NAME.getExtensions()) {
                String id2 = description2.getGroupId() + ":" + description2.getArtifactId();
                RepositoryLibraryDescription existDescription = registeredLibraries.get(id2);
                if (existDescription != null && existDescription.getWeight() < description2.getWeight()) continue;
                registeredLibraries.put(id2, description2);
            }
        }
        if ((description = registeredLibraries.get(id = properties.getGroupId() + ":" + properties.getArtifactId())) != null) {
            RepositoryLibraryDescription repositoryLibraryDescription = description;
            if (repositoryLibraryDescription == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "findDescription"));
            }
            return repositoryLibraryDescription;
        }
        RepositoryLibraryDescription repositoryLibraryDescription = new RepositoryLibraryDescription(){

            @Override
            @NotNull
            public String getGroupId() {
                String string = properties.getGroupId();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription$1", "getGroupId"));
                }
                return string;
            }

            @Override
            @NotNull
            public String getArtifactId() {
                String string = properties.getArtifactId();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription$1", "getArtifactId"));
                }
                return string;
            }

            @Override
            @NotNull
            public String getDisplayName() {
                String string = properties.getGroupId() + ":" + properties.getArtifactId();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription$1", "getDisplayName"));
                }
                return string;
            }

            @Override
            @NotNull
            public Icon getIcon() {
                Icon icon = MavenIcons.MavenLogo;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription$1", "getIcon"));
                }
                return icon;
            }
        };
        if (repositoryLibraryDescription == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "findDescription"));
        }
        return repositoryLibraryDescription;
    }

    @NotNull
    public abstract String getGroupId();

    @NotNull
    public abstract String getArtifactId();

    @NotNull
    public abstract String getDisplayName();

    @NotNull
    public abstract Icon getIcon();

    @Nullable
    public DependencyScope getSuggestedScope() {
        return null;
    }

    @NotNull
    public List<MavenRepositoryInfo> getRemoteRepositories() {
        List<MavenRepositoryInfo> list = defaultRemoteRepositories;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription", "getRemoteRepositories"));
        }
        return list;
    }

    public int getWeight() {
        return 1000;
    }

    public RepositoryLibraryProperties createDefaultProperties() {
        return new RepositoryLibraryProperties(this.getGroupId(), this.getArtifactId(), "LATEST");
    }
}

