/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryPropertiesEditorBase;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryType;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesDialog;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryLibraryWithDescriptionEditor
extends LibraryPropertiesEditorBase<RepositoryLibraryProperties, RepositoryLibraryType> {
    public RepositoryLibraryWithDescriptionEditor(LibraryEditorComponent<RepositoryLibraryProperties> editorComponent) {
        super(editorComponent, (LibraryType)RepositoryLibraryType.getInstance(), null);
    }

    public void apply() {
    }

    protected void edit() {
        RepositoryLibraryProperties properties = (RepositoryLibraryProperties)this.myEditorComponent.getProperties();
        boolean wasGeneratedName = RepositoryLibraryType.getInstance().getDescription(properties).equals(this.myEditorComponent.getLibraryEditor().getName());
        RepositoryLibraryPropertiesModel model = new RepositoryLibraryPropertiesModel(properties.getVersion(), RepositoryUtils.libraryHasSources(this.myEditorComponent.getLibraryEditor()), RepositoryUtils.libraryHasJavaDocs(this.myEditorComponent.getLibraryEditor()));
        RepositoryLibraryPropertiesDialog dialog = new RepositoryLibraryPropertiesDialog(this.myEditorComponent.getProject(), model, RepositoryLibraryDescription.findDescription(properties), true);
        if (!dialog.showAndGet()) {
            return;
        }
        ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).changeVersion(model.getVersion());
        if (wasGeneratedName) {
            this.myEditorComponent.renameLibrary(RepositoryLibraryType.getInstance().getDescription(properties));
        }
        this.myEditorComponent.getLibraryEditor().removeAllRoots();
        this.myEditorComponent.getLibraryEditor().addRoots(RepositoryUtils.download(this.myEditorComponent.getProject(), model.isDownloadSources(), model.isDownloadJavaDocs(), properties));
    }
}

