/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.cli.common.KotlinVersion;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.CompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItem;
import org.jetbrains.kotlin.config.CompilerRunnerConstants;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.jps.JpsKotlinCompilerSettings;
import org.jetbrains.kotlin.jps.build.BuildPackage$KotlinBuilder$c79545ad;
import org.jetbrains.kotlin.jps.build.GeneratedFile;
import org.jetbrains.kotlin.jps.build.GeneratedJvmClass;
import org.jetbrains.kotlin.jps.build.JpsJsModuleUtils;
import org.jetbrains.kotlin.jps.build.JpsUtils;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinBuilderModuleScriptGenerator;
import org.jetbrains.kotlin.jps.build.KotlinJpsCompilerArgumentsProvider;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.jps.build.TeamcityStatisticsLogger;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheProviderImpl;
import org.jetbrains.kotlin.jps.incremental.IncrementalPackage$IncrementalCacheImpl$6579148b;
import org.jetbrains.kotlin.jps.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.load.kotlin.header.HeaderPackage;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.incremental.cache.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.cache.IncrementalCacheProvider;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.utils.LibraryUtils;
import org.jetbrains.kotlin.utils.PathUtil;
import org.jetbrains.kotlin.utils.UtilsPackage;
import org.jetbrains.org.objectweb.asm.ClassReader;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u001b\u0016)i1j\u001c;mS:\u0014U/\u001b7eKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004UB\u001c(\"\u00022vS2$'BE'pIVdW\rT3wK2\u0014U/\u001b7eKJT1\"\u001b8de\u0016lWM\u001c;bY*1A(\u001b8jizR\u0001c\u001d;bi&\u001cH/[2t\u0019><w-\u001a:\u000b1Q+\u0017-\\2jif\u001cF/\u0019;jgRL7m\u001d'pO\u001e,'OC\u0004d_:$X\r\u001f;\u000b\u001d\r{W\u000e]5mK\u000e{g\u000e^3yi*)1\r[;oW*YQj\u001c3vY\u0016\u001c\u0005.\u001e8l\u0015A!\u0017N\u001d;z\r&dWm\u001d%pY\u0012,'O\u0003\tESJ$\u0018PR5mKNDu\u000e\u001c3fe*A!-^5mI\u0016\u00148O\u0003\rKCZ\f7k\\;sG\u0016\u0014vn\u001c;EKN\u001c'/\u001b9u_JTAA[1wC*\tRj\u001c3vY\u0016\u0014U/\u001b7e)\u0006\u0014x-\u001a;\u000b\u001d=,H\u000f];u\u0007>t7/^7fe*qq*\u001e;qkR\u001cuN\\:v[\u0016\u0014(\u0002C#ySR\u001cu\u000eZ3\u000b75{G-\u001e7f\u0019\u00164X\r\u001c\"vS2$WM\u001d\u0013Fq&$8i\u001c3f\u0015\u0005ju\u000eZ;mK2+g/\u001a7Ck&dG-\u001a:%\u001fV$\b/\u001e;D_:\u001cX/\\3s\u00155\u0011W/\u001b7e\r&t\u0017n\u001d5fI*!QK\\5u\u0015-\u0019w.\u001c9jY\u0016$vNS:\u000b\u001f\r|W.\\8o\u0003J<W/\\3oiNTqcQ8n[>t7i\\7qS2,'/\u0011:hk6,g\u000e^:\u000b\u0007\rd\u0017N\u0003\u0004d_6lwN\u001c\u0006\nCJ<W/\\3oiNT1\"\u001a8wSJ|g.\\3oi*\u00192i\\7qS2,'/\u00128wSJ|g.\\3oi*q1m\\7qS2,'OU;o]\u0016\u0014(\u0002E7fgN\fw-Z\"pY2,7\r^8s\u0015]iUm]:bO\u0016\u001cu\u000e\u001c7fGR|'/\u00113baR,'OC\u0004qe>TWm\u0019;\u000b\u0015)\u00038\u000f\u0015:pU\u0016\u001cGOC\u0003n_\u0012,GN\u0003\rPkR\u0004X\u000f^%uK6\u001c8i\u001c7mK\u000e$xN]%na2TQeS8uY&t')^5mI\u0016\u0014H%T3tg\u0006<WmQ8mY\u0016\u001cGo\u001c:BI\u0006\u0004H/\u001a:\u000b\u0019\r|W\u000e]5mKR{'J^7\u000b!\u0005dGnQ8na&dW\r\u001a$jY\u0016\u001c(BC'vi\u0006\u0014G.Z*fi*!a)\u001b7f\u0015\tIwN\u0003\bgS2,7\u000fV8D_6\u0004\u0018\u000e\\3\u000b\u00115+H\u000e^5NCBT1aY8n\u0015!Ig\u000e^3mY&T'\u0002B;uS2T!bY8oi\u0006Lg.\u001a:t\u0015\r\u0019V\r\u001e\u0006\u001bG>\u0004\u0018PS:MS\n\u0014\u0018M]=GS2,7/\u00134OK\u0016$W\r\u001a\u0006\u0019GJ,\u0017\r^3D_6\u0004\u0018\u000e\\3F]ZL'o\u001c8nK:$(\"E5oGJ,W.\u001a8uC2\u001c\u0015m\u00195fg*\u0019Q*\u00199\u000b!%s7M]3nK:$\u0018\r\\\"bG\",'\u0002\u00027pC\u0012TQaY1dQ\u0016TA\u0003Z8D_6\u0004\u0018\u000e\\3N_\u0012,H.Z\"ik:\\'\u0002F%oGJ,W.\u001a8uC2\u001c\u0015m\u00195f\u00136\u0004HNC\u000ehKR\u001cu.\u001c9jY\u0006\u0014G.\u001a$jY\u0016,\u0005\u0010^3og&|gn\u001d\u0006\n\u0003J\u0014\u0018-\u001f'jgRTaa\u0015;sS:<'\"E4fi\u001e+g.\u001a:bi\u0016$g)\u001b7fg*\u0019r.\u001e;qkRLE/Z7D_2dWm\u0019;pe*!A*[:u\u001559UM\\3sCR,GMR5mK*\u0011r-\u001a;Qe\u0016\u001cXM\u001c;bE2,g*Y7f\u0015\u0011a\u0017M\\4\u000b'I,w-[:uKJ|U\u000f\u001e9vi&#X-\\:\u000b\u001d\u001d,g.\u001a:bi\u0016$g)\u001b7fg*\u0011R\u000f\u001d3bi\u0016T\u0015M^1NCB\u0004\u0018N\\4t\u0015E\u0019w.\u001c9jY\u0006$\u0018n\u001c8FeJ|'o\u001d\u0006\b\u0005>|G.Z1o\u0015A9WM\\3sCR,Gm\u00117bgN,7OC\tHK:,'/\u0019;fI*3Xn\u00117bgNTA$\u001e9eCR,7j\u001c;mS:Len\u0019:f[\u0016tG/\u00197DC\u000eDWMC\u000bSK\u000e|W\u000e]5mCRLwN\u001c#fG&\u001c\u0018n\u001c8\u000bU%s7M]3nK:$\u0018\r\\\"bG\",\u0017*\u001c9mII+7m\\7qS2\fG/[8o\t\u0016\u001c\u0017n]5p]*I1i\\7qC:LwN\u001c{\u0004\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)!\u0001\"\u0001\t\u0005\u0015\u0011Aa\u0001E\u0004\u000b\r!9\u0001C\u0002\r\u0001\u0015\u0019AA\u0001\u0005\u0006\u0019\u0001)!\u0001\u0002\u0002\t\u000b\u0015\u0019Aq\u0001\u0005\u0007\u0019\u0001)1\u0001B\u0002\t\u000f1\u0001QA\u0001\u0003\u0004\u0011#)1\u0001\"\u0004\t\u00111\u0001QA\u0001C\u0007\u0011')1\u0001b\u0004\t\u00131\u0001Qa\u0001C\u0004\u0011)a\u0001!B\u0002\u0005\t!YA\u0002A\u0003\u0004\t\u0011A9\u0002\u0004\u0001\u0006\u0005\u0011\u001d\u0001\u0002D\u0003\u0003\t\u000fAa!\u0002\u0002\u0005\u0007!9QA\u0001C\u0007\u0011!)!\u0001b\u0002\t\u001a\u0015\t\u00012A\u0003\u0004\t3AY\u0002\u0004\u0001\u0006\u0005\u0011\t\u0001rD\u0003\u0003\t7A\u0001#\u0002\u0002\u0005\u001d!\u0005Ra\u0001C\u000f\u0011=a\u0001!\u0002\u0002\u0005\u0003!\u0011Ra\u0001C\u0010\u0011Ga\u0001!B\u0002\u0005\u0006!\u0019B\u0002A\u0003\u0003\t\rAI#B\u0002\u0005#!!B\u0002A\u0003\u0004\t?AQ\u0003\u0004\u0001\u0006\u0005\u0011}\u0001\"F\u0003\u0003\t;Aq\"\u0002\u0002\u0005 !\rRA\u0001\u0003\u0003\u0011W)!\u0001B\t\t)\u0015\u0019A\u0011\u0004\u0005\u0018\u0019\u0001)\u0011\u0001c\u0005\u0006\u0005\u0011-\u0002\u0002G\u0003\u0004\tYAy\u0003\u0004\u0001\u0006\u0003!MRA\u0001\u0003\u0018\u0011i)!\u0001b\f\t6\u0015\u0011A\u0001\u0007\u0005\u001c\u000b\r!\t\u0004C\r\r\u0001\u0015\u0011A1\u0006E\u001b\u000b\t!\u0019\u0004c\u000e\u0006\u0005\u0011E\u0002\"G\u0003\u0004\t3AY\u0004\u0004\u0001\u0006\u0005\u0011\t\u0001RH\u0003\u0003\toA\u0019!\u0002\u0002\u00059!\u001dQA\u0001C\u001d\u0011})1\u0001B\u000f\t=1\u0001QA\u0001C\u001a\u0011w)!\u0001b\u0001\t\b\u0015\u0019AQ\b\u0005!\u0019\u0001)1\u0001b\r\tC1\u0001Qa\u0001C\r\u0011\u0007b\u0001!\u0002\u0002\u00054!\tSa\u0001C\r\u0011\rb\u0001!B\u0002\u0005\u0005!\u001dC\u0002A\u0003\u0003\tgA1%\u0002\u0002\u0005,!%SA\u0001C#\u0011\u0007*1\u0001\"\u0007\tO1\u0001Qa\u0001\u0003\u0003\u0011!b\u0001!B\u0002\u0005?!IC\u0002A\u0003\u0003\t{A\u0019\u0006B\u0002\r\u0006AQ\u0013DA\u0003\u0002\u0011\u0011a\"\u0006H\n.\u0017\u0011\tG\u0001'\u0003\"\u0005\u0015\t\u0001\u0012B+\u0004\t\u0015\u0019A\u0011B\u0005\u0002\u0011\u0015i{\u0007B\u0006\u0019\u0006u5A\u0001\u0001E\u0006\u001b\t)\u0011\u0001c\u0003Q\u0007\u0001ij\u0001\u0002\u0001\t\u000e5\u0011Q!\u0001\u0005\u0007!\u000e\u0005QT\u0004\u0003\u0001\u0011\u001fi!\"B\u0001\t\u000f%\u0019\u0011BA\u0003\u0002\u0011!I1!\u0003\u0002\u0006\u0003!E\u0001kA\u0001\u001e\u000e\u0011\u0001\u0001RC\u0007\u0003\u000b\u0005A\u0011\u0002UB\u0002C\t)\u0011\u0001c\u0005R\u0007-!)!C\u0001\t\u00155\t\u0001RC\u0007\u0002\u0011-i\u0011\u0001c\u0006\u000e\u0003!aQ\u0006\u0006\u0003\f15iz\u0001\u0002\u0001\t\f5\u0019Q!\u0001E\u0006\u0019\u0003\u00016\u0001A\u0011\u0003\u000b\u0005AQ\"U\u0002\u0006\t5I\u0011\u0001\u0002\u0001\u000e\u0003!UQF\u000f\u0003\u000219ij\u0001\u0002\u0001\t\u000e5\u0011Q!\u0001\u0005\u0007!\u000e\u0001QT\u0002\u0003\u0001\u0011;i!!B\u0001\t\u001fA\u001b\t!(\u0004\u0005\u0001!\tRBA\u0003\u0002\u0011A\u00016!AO\u0007\t\u0001A)#\u0004\u0002\u0006\u0003!\u0005\u0002ka\u0001\u001e\u000e\u0011\u0001\u0001rE\u0007\u0003\u000b\u0005A\u0019\u0003U\u0002\u0003C\r)\u0011\u0001\u0003\n\r\u0002E\u001bQ\u0002\u0002\b\n\u0003!\u0015R\"\u0001\u0005\f\u001b\u0005A1#D\u0001\t(5\t\u0001\u0002F\u0007\u0002\u0011Si+\u001e\u0001\u0003\u00021Yi*\u0002\u0002\u0001\t.51Q!\u0001\u0005\u0016\u0013\rI!!B\u0001\t.A\u001b\u0001!(\u0004\u0005\u0001!5QBA\u0003\u0002\u0011\u0019\u00016\u0011AO\u0007\t\u0001Ai\"\u0004\u0002\u0006\u0003!y\u0001kA\u0001\u001e\u000e\u0011\u0001\u00012B\u0007\u0003\u000b\u0005AY\u0001UB\u0002;;!\u0001\u0001c\u0004\u000e\u0015\u0015\t\u0001bB\u0005\u0004\u0013\t)\u0011\u0001\u0003\u0005\n\u0007%\u0011Q!\u0001E\t!\u000e\u0011QT\u0002\u0003\u0001\u0011Ei!!B\u0001\t!A\u001b)!(\b\u0005\u0001!ERBC\u0003\u0002\u0011eI1!\u0003\u0002\u0006\u0003!E\u0011bA\u0005\u0003\u000b\u0005Ai\u0003U\u0002\u0004;\u001b!\u0001\u0001#\n\u000e\u0005\u0015\t\u0001\u0012\u0005)\u0004\b\u0005\u001aQ!\u0001\u0005\u0013\u0019\u0003\t6a\u0005\u0003\u0017\u0013\u0005A)#D\u0001\t55\t\u0001bC\u0007\u0002\u0011Mi\u0011\u0001#\u0006\u000e\u0003!]Q\"\u0001E\u0014\u001b\u0005A)$D\u0001\t)5fB!\u0001\r\u001d;\u001b!\u0001\u0001#\u0004\u000e\u0005\u0015\t\u0001B\u0002)\u0004\u0001u5A\u0001\u0001E\u0014\u001b\t)\u0011\u0001c\tQ\u0007\u0003\t#!B\u0001\t\u001bE\u001bq\u0001\u0002\u000f\n\u0003\u0011\u0001Q\"\u0001\u0005\f\u001b\u0005AI#L\u000e\u0005\u0003aeRT\u0004\u0003\u0001\u0011ui!\"B\u0001\t7%\u0019\u0011BA\u0003\u0002\u0011#I1!\u0003\u0002\u0006\u0003!m\u0002k\u0001\u0001\"\u0005\u0015\t\u0001\u0002E)\u0004\u000b\u0011e\u0012\"\u0001E\u0014\u001b\u0005Aa$l#\u0002\t\u0005Az$(\u0006\u0005\u0001!5RBB\u0003\u0002\u0011UI1!\u0003\u0002\u0006\u0003!5\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001RB\u0007\u0003\u000b\u0005Aa\u0001UB\u0001;\u001b!\u0001\u0001#\b\u000e\u0005\u0015\t\u0001b\u0004)\u0004\u0003u5A\u0001\u0001E\u0006\u001b\t)\u0011\u0001c\u0003Q\u0007\u0007ij\u0002\u0002\u0001\t\u00105QQ!\u0001\u0005\b\u0013\rI!!B\u0001\t\u0011%\u0019\u0011BA\u0003\u0002\u0011#\u00016AAO\u0007\t\u0001A\u0011#\u0004\u0002\u0006\u0003!\u0001\u0002k!\u0002\u001e\u001e\u0011\u0001\u0001\u0012G\u0007\u000b\u000b\u0005A\u0011$C\u0002\n\u0005\u0015\t\u0001\u0012C\u0005\u0004\u0013\t)\u0011\u0001#\fQ\u0007\rij\u0002\u0002\u0001\t;5QQ!\u0001\u0005\u001c\u0013\rI!!B\u0001\t\u0012%\u0019\u0011BA\u0003\u0002\u0011}\u00016qAO\u0007\t\u0001A)#\u0004\u0002\u0006\u0003!\u0005\u0002k\u0001\u0003\u001e\u000e\u0011\u0001\u0001rE\u0007\u0003\u000b\u0005A\u0019\u0003UB\u0005C\r)\u0011\u0001\u0003\n\r\u0002E\u001bq\u0003b\u0010\n\u0003!\u0015R\"\u0001\u0005\u001b\u001b\u0005A1\"D\u0001\t'5\t\u0001RC\u0007\u0002\u0011/i\u0011\u0001c\n\u000e\u0003!UR\"\u0001\u0005\u001f\u001b\u0005AA#D\u0001\t*5nAa\u0003M!C\u0019)\u0011\u0001c\u0010\n\u0007%\u0011Q!\u0001\u0005!#\u000e\u0019A\u0011I\u0005\u0002\u0011\u0003j\u000b\u0005B\u0001\u0019Eu5A\u0001\u0001E\u0007\u001b\t)\u0011\u0001\u0003\u0004Q\u0007\u0001ij\u0001\u0002\u0001\tF5\u0011Q!\u0001\u0005\u0013!\u000e\u0005\u0011EB\u0003\u0002\u0011\u0005J1!\u0003\u0002\u0006\u0003!\r\u0013kA\u0004\u0005E%\t\u0001BI\u0007\u0002\u0011-i\u0011\u0001#\n.\u0014\u0011Y\u0001\u0004J\u0011\u0003\u000b\u0005A\u0001%U\u0002\u0004\t\u0011J\u0011\u0001C\u0012.B\u0011\t\u0001$JO\u0007\t\u0001A)\"\u0004\u0002\u0006\u0003!I\u0001k\u0001\u0001\u001e\u0016\u0011\u0001\u00012J\u0007\u0007\u000b\u0005A\u0011%C\u0002\n\u0005\u0015\t\u00012\t)\u0004\u0002\u0005\u0012Q!\u0001\u0005\u000e#\u000e9A!J\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0007\u000e\u0003!\u0011SV6\u0001\u0005\u0003a1ST\u0002\u0003\u0001\u0011\u001bi!!B\u0001\t\rA\u001b\u0001!(\u0004\u0005\u0001!5SBA\u0003\u0002\u0011\u000f\u00026\u0011AO\u0007\t\u0001AY!\u0004\u0002\u0006\u0003!-\u0001kA\u0001\u001e\u001e\u0011\u0001\u0001rB\u0007\u000b\u000b\u0005Aq!C\u0002\n\u0005\u0015\t\u0001\u0002C\u0005\u0004\u0013\t)\u0011\u0001#\u0005Q\u0007\u0007ij\u0002\u0002\u0001\t25QQ!\u0001\u0005\u001a\u0013\rI!!B\u0001\t\u0012%\u0019\u0011BA\u0003\u0002\u0011[\u00016AAO\u000b\t\u0001Ay%\u0004\u0004\u0006\u0003!\t\u0013bA\u0005\u0003\u000b\u0005AA\u0005UB\u0003C\t)\u0011\u0001C\u0007R\u0007=!a%C\u0001\u0005\u00015\t\u0001bC\u0007\u0002\t\u0003i\u0011\u0001#\u0006\u000e\u0003!]Q\"\u0001E\u001b\u001b\u0005A!%\f\u001a\u0005\u0003aEST\u0002\u0003\u0001\u0011\u001bj!!B\u0001\tHA\u001b\u0001!(\b\u0005\u0001!iRBC\u0003\u0002\u0011mI1!\u0003\u0002\u0006\u0003!E\u0011bA\u0005\u0003\u000b\u0005Aq\u0004UB\u0001;+!\u0001\u0001c\u0014\u000e\r\u0015\t\u0001\"I\u0005\u0004\u0013\t)\u0011\u0001\u0003\u0013Q\u0007\u0005\t#!B\u0001\tJE\u001b\u0011\u0002\"\u0015\n\u0003!)S\"\u0001C\u0001\u001b\u0005Aa$D\u0001\tEUZQA\u0003\u0003d\u0002a!\u0011EA\u0003\u0002\u0011\u000b\t6a\u0001\u0003\u0005\u0013\u0005!\u0001\u0001"})
public final class KotlinBuilder
extends ModuleLevelBuilder {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final String KOTLIN_BUILDER_NAME = "Kotlin Builder";
    private static final Logger LOG;
    private final TeamcityStatisticsLogger statisticsLogger = new TeamcityStatisticsLogger();
    public static final Companion Companion;
    @Deprecated
    public static final Companion OBJECT$;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinBuilder.class);
        OBJECT$ = Companion = org.jetbrains.kotlin.jps.build.KotlinBuilder$Companion.access$init$1();
        KOTLIN_BUILDER_NAME = KOTLIN_BUILDER_NAME;
        LOG = Logger.getInstance((String)"#org.jetbrains.jps.cmdline.BuildSession");
    }

    @NotNull
    public String getPresentableName() {
        return Companion.getKOTLIN_BUILDER_NAME();
    }

    @NotNull
    public ArrayList<String> getCompilableFileExtensions() {
        return KotlinPackage.arrayListOf((Object[])new String[]{"kt"});
    }

    @NotNull
    public ModuleLevelBuilder.ExitCode build(@JetValueParameter(name="context") @NotNull CompileContext context, @JetValueParameter(name="chunk") @NotNull ModuleChunk chunk, @JetValueParameter(name="dirtyFilesHolder") @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @JetValueParameter(name="outputConsumer") @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) {
        IncrementalCacheImpl.RecompilationDecision recompilationDecision;
        boolean bl;
        ModuleBuildTarget it;
        Iterable $receiver;
        BuildDataManager dataManager;
        MessageCollectorAdapter messageCollector;
        block21: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
            Intrinsics.checkParameterIsNotNull(dirtyFilesHolder, (String)"dirtyFilesHolder");
            Intrinsics.checkParameterIsNotNull((Object)outputConsumer, (String)"outputConsumer");
            String historyLabel = context.getBuilderParameter("history label");
            if (historyLabel != null) {
                KotlinBuilder.Companion.getLOG().info("Label in local history: " + historyLabel);
            }
            messageCollector = new MessageCollectorAdapter(context);
            if (!JpsUtils.isJsKotlinModule(chunk.representativeTarget()) && !((Boolean)JavaBuilder.IS_ENABLED.get((UserDataHolder)context, (Object)true)).booleanValue()) {
                CompilerMessageLocation compilerMessageLocation = CompilerMessageLocation.NO_LOCATION;
                Intrinsics.checkExpressionValueIsNotNull((Object)compilerMessageLocation, (String)"NO_LOCATION");
                messageCollector.report(CompilerMessageSeverity.INFO, "Kotlin JPS plugin is disabled", compilerMessageLocation);
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            dataManager = context.getProjectDescriptor().dataManager;
            Iterable iterable = chunk.getTargets();
            for (Object element : $receiver) {
                it = (ModuleBuildTarget)element;
                BuildDataPaths buildDataPaths = dataManager.getDataPaths();
                BuildTarget buildTarget = (BuildTarget)it;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildTarget, (String)"it");
                if (!IncrementalPackage$IncrementalCacheImpl$6579148b.getKotlinCacheVersion(buildDataPaths, buildTarget).isIncompatible()) continue;
                bl = true;
                break block21;
            }
            bl = false;
        }
        if (bl) {
            $receiver = chunk.getTargets();
            for (Object element : $receiver) {
                it = (ModuleBuildTarget)element;
                BuildTarget buildTarget = (BuildTarget)it;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildTarget, (String)"it");
                IncrementalPackage$IncrementalCacheImpl$6579148b.getKotlinCache(dataManager, buildTarget).clean();
            }
            return ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED;
        }
        if (!dirtyFilesHolder.hasDirtyFiles() && !dirtyFilesHolder.hasRemovedFiles() || !BuildPackage$KotlinBuilder$c79545ad.hasKotlinDirtyOrRemovedFiles(dirtyFilesHolder, chunk)) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        String string = "Kotlin JPS plugin version " + KotlinVersion.VERSION;
        CompilerMessageLocation compilerMessageLocation = CompilerMessageLocation.NO_LOCATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerMessageLocation, (String)"NO_LOCATION");
        messageCollector.report(CompilerMessageSeverity.INFO, string, compilerMessageLocation);
        Map incrementalCaches2 = UtilsPackage.keysToMap(chunk.getTargets(), (Function1)new Function1<ModuleBuildTarget, IncrementalCacheImpl>(dataManager){
            final /* synthetic */ BuildDataManager $dataManager;

            @NotNull
            public final IncrementalCacheImpl invoke(@JetValueParameter(name="it") ModuleBuildTarget it) {
                BuildTarget buildTarget = (BuildTarget)it;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildTarget, (String)"it");
                return IncrementalPackage$IncrementalCacheImpl$6579148b.getKotlinCache(this.$dataManager, buildTarget);
            }
            {
                this.$dataManager = buildDataManager;
                super(1);
            }
        });
        CompilerEnvironment environment = this.createCompileEnvironment(incrementalCaches2);
        if (!environment.success()) {
            environment.reportErrorsTo(messageCollector);
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        JpsProject project = context.getProjectDescriptor().getProject();
        CommonCompilerArguments commonArguments = JpsKotlinCompilerSettings.getCommonCompilerArguments(project);
        commonArguments.verbose = true;
        Set<File> allCompiledFiles = BuildPackage$KotlinBuilder$c79545ad.getAllCompiledFilesContainer(context);
        MultiMap<ModuleBuildTarget, File> filesToCompile = KotlinSourceFileCollector.getDirtySourceFiles(dirtyFilesHolder);
        long start = System.nanoTime();
        CommonCompilerArguments commonCompilerArguments = commonArguments;
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCompilerArguments, (String)"commonArguments");
        MultiMap<ModuleBuildTarget, File> multiMap = filesToCompile;
        Intrinsics.checkExpressionValueIsNotNull(multiMap, (String)"filesToCompile");
        JpsProject jpsProject = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsProject, (String)"project");
        OutputItemsCollectorImpl outputItemCollector = this.doCompileModuleChunk(allCompiledFiles, chunk, commonCompilerArguments, context, dirtyFilesHolder, environment, multiMap, incrementalCaches2, messageCollector, jpsProject);
        this.statisticsLogger.registerStatistic(chunk, System.nanoTime() - start);
        if (outputItemCollector == null) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        Boolean compilationErrors = (Boolean)Utils.ERRORS_DETECTED_KEY.get((UserDataHolder)context, (Object)false);
        List<GeneratedFile> generatedFiles = this.getGeneratedFiles(chunk, outputItemCollector);
        this.registerOutputItems(outputConsumer, generatedFiles);
        if (JpsUtils.isJsKotlinModule(chunk.representativeTarget())) {
            recompilationDecision = IncrementalCacheImpl.RecompilationDecision.DO_NOTHING;
        } else {
            List<GeneratedFile> list = generatedFiles;
            if (list == null) {
                throw new TypeCastException("kotlin.List<org.jetbrains.kotlin.jps.build.GeneratedFile> cannot be cast to kotlin.List<org.jetbrains.kotlin.jps.build.GeneratedJvmClass>");
            }
            List<GeneratedFile> generatedClasses = list;
            recompilationDecision = this.updateKotlinIncrementalCache(compilationErrors, incrementalCaches2, generatedClasses);
            boolean bl2 = compilationErrors;
            MultiMap<ModuleBuildTarget, File> multiMap2 = filesToCompile;
            Intrinsics.checkExpressionValueIsNotNull(multiMap2, (String)"filesToCompile");
            this.updateJavaMappings(chunk, bl2, context, dirtyFilesHolder, multiMap2, generatedClasses);
        }
        if (compilationErrors.booleanValue()) {
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        if (JpsUtils.isJsKotlinModule(chunk.representativeTarget())) {
            JpsProject jpsProject2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsProject2, (String)"project");
            this.copyJsLibraryFilesIfNeeded(chunk, jpsProject2);
        }
        if (IncrementalCompilation.ENABLED) {
            IncrementalCacheImpl.RecompilationDecision recompilationDecision2 = recompilationDecision;
            if (Intrinsics.areEqual((Object)((Object)recompilationDecision2), (Object)((Object)IncrementalCacheImpl.RecompilationDecision.RECOMPILE_ALL_IN_CHUNK_AND_DEPENDANTS))) {
                allCompiledFiles.clear();
                FSOperations.markDirtyRecursively((CompileContext)context, (ModuleChunk)chunk);
            } else if (Intrinsics.areEqual((Object)((Object)recompilationDecision2), (Object)((Object)IncrementalCacheImpl.RecompilationDecision.RECOMPILE_OTHER_IN_CHUNK_AND_DEPENDANTS))) {
                try {
                    Class.forName("org.jetbrains.jps.incremental.fs.CompilationRound");
                    FSOperations.markDirtyRecursively((CompileContext)context, (CompilationRound)CompilationRound.NEXT, (ModuleChunk)chunk, (FileFilter)new FileFilter(allCompiledFiles){
                        final /* synthetic */ Set $allCompiledFiles;

                        public final boolean accept(@JetValueParameter(name="file") File file) {
                            return this.$allCompiledFiles.contains(file) ^ true;
                        }
                        {
                            this.$allCompiledFiles = set;
                        }
                    });
                }
                catch (ClassNotFoundException e) {
                    allCompiledFiles.clear();
                    FSOperations.markDirtyRecursively((CompileContext)context, (ModuleChunk)chunk);
                }
            } else if (Intrinsics.areEqual((Object)((Object)recompilationDecision2), (Object)((Object)IncrementalCacheImpl.RecompilationDecision.RECOMPILE_OTHER_KOTLIN_IN_CHUNK))) {
                FSOperations.markDirty((CompileContext)context, (ModuleChunk)chunk, (FileFilter)new FileFilter(allCompiledFiles){
                    final /* synthetic */ Set $allCompiledFiles;

                    public final boolean accept(@JetValueParameter(name="file") File file) {
                        return KotlinSourceFileCollector.isKotlinSourceFile(file) && this.$allCompiledFiles.contains(file) ^ true;
                    }
                    {
                        this.$allCompiledFiles = set;
                    }
                });
            }
            return ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED;
        }
        return ModuleLevelBuilder.ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollectorImpl doCompileModuleChunk(@JetValueParameter(name="allCompiledFiles") Set<File> allCompiledFiles, @JetValueParameter(name="chunk") ModuleChunk chunk, @JetValueParameter(name="commonArguments") CommonCompilerArguments commonArguments, @JetValueParameter(name="context") CompileContext context, @JetValueParameter(name="dirtyFilesHolder") DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @JetValueParameter(name="environment") CompilerEnvironment environment, @JetValueParameter(name="filesToCompile") MultiMap<ModuleBuildTarget, File> filesToCompile, @JetValueParameter(name="incrementalCaches") Map<ModuleBuildTarget, ? extends IncrementalCacheImpl> incrementalCaches2, @JetValueParameter(name="messageCollector") MessageCollectorAdapter messageCollector, @JetValueParameter(name="project") JpsProject project) {
        if (JpsUtils.isJsKotlinModule(chunk.representativeTarget())) {
            return this.compileToJs(chunk, commonArguments, environment, messageCollector, project);
        }
        if (IncrementalCompilation.ENABLED) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                IncrementalCacheImpl cache;
                List list;
                void destination;
                void $receiver;
                void $receiver2;
                if (incrementalCaches2.get(target) == null) {
                    Intrinsics.throwNpe();
                }
                Iterable iterable = dirtyFilesHolder.getRemovedFiles((BuildTarget)target);
                Iterable iterable2 = filesToCompile.get((Object)target);
                void var16_16 = $receiver2;
                Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
                for (Object item : $receiver) {
                    void it;
                    String string = (String)item;
                    list = destination;
                    File file = new File((String)it);
                    list.add(file);
                }
                list = (List)destination;
                List removedAndDirtyFiles = KotlinPackage.plus((Iterable)iterable2, (Iterable)list);
                cache.markOutputClassesDirty(removedAndDirtyFiles);
            }
        }
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        doCompileModuleChunk.1 concatenate$ = doCompileModuleChunk.1.INSTANCE$;
        for (KotlinJpsCompilerArgumentsProvider argumentProvider : ServiceLoader.load(KotlinJpsCompilerArgumentsProvider.class)) {
            String[] stringArray = commonArguments.pluginOptions;
            ModuleBuildTarget moduleBuildTarget = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
            commonArguments.pluginOptions = concatenate$.invoke(stringArray, argumentProvider.getExtraArguments(moduleBuildTarget, context));
            String[] stringArray2 = commonArguments.pluginClasspaths;
            ModuleBuildTarget moduleBuildTarget2 = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget2, (String)"representativeTarget");
            commonArguments.pluginClasspaths = concatenate$.invoke(stringArray2, argumentProvider.getClasspath(moduleBuildTarget2, context));
            String string = "Plugin loaded: " + argumentProvider.getClass().getSimpleName();
            CompilerMessageLocation compilerMessageLocation = CompilerMessageLocation.NO_LOCATION;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilerMessageLocation, (String)"NO_LOCATION");
            messageCollector.report(CompilerMessageSeverity.INFO, string, compilerMessageLocation);
        }
        return this.compileToJvm(allCompiledFiles, chunk, commonArguments, context, dirtyFilesHolder, environment, filesToCompile, messageCollector);
    }

    private final CompilerEnvironment createCompileEnvironment(@JetValueParameter(name="incrementalCaches") Map<ModuleBuildTarget, ? extends IncrementalCache> incrementalCaches2) {
        Services compilerServices = new Services.Builder().register(IncrementalCacheProvider.class, new IncrementalCacheProviderImpl(incrementalCaches2)).build();
        CompilerEnvironment compilerEnvironment = CompilerEnvironment.getEnvironmentFor(PathUtil.getKotlinPathsForJpsPluginOrJpsTests(), createCompileEnvironment.1.INSTANCE$, compilerServices);
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerEnvironment, (String)"CompilerEnvironment.getE\u2026ompilerServices\n        )");
        return compilerEnvironment;
    }

    private final List<GeneratedFile> getGeneratedFiles(@JetValueParameter(name="chunk") ModuleChunk chunk, @JetValueParameter(name="outputItemCollector") OutputItemsCollectorImpl outputItemCollector) {
        HashMap<File, ModuleBuildTarget> sourceToTarget = new HashMap<File, ModuleBuildTarget>();
        if (chunk.getTargets().size() > 1) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                for (File file : KotlinSourceFileCollector.getAllKotlinSourceFiles(target)) {
                    sourceToTarget.put(file, target);
                }
            }
        }
        ArrayList<GeneratedFile> result = new ArrayList<GeneratedFile>();
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        for (SimpleOutputItem outputItem : outputItemCollector.getOutputs()) {
            ModuleBuildTarget target = null;
            Collection<File> sourceFiles = outputItem.getSourceFiles();
            File outputFile = outputItem.getOutputFile();
            if (!sourceFiles.isEmpty()) {
                target = (ModuleBuildTarget)sourceToTarget.get(sourceFiles.iterator().next());
            }
            if (target == null) {
                target = representativeTarget;
            }
            if (KotlinPackage.endsWith$default((String)outputFile.getName(), (String)".class", (boolean)false, (int)2)) {
                ModuleBuildTarget moduleBuildTarget = target;
                if (moduleBuildTarget == null) {
                    Intrinsics.throwNpe();
                }
                Collection<File> collection = sourceFiles;
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"sourceFiles");
                File file = outputFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputFile");
                result.add(new GeneratedJvmClass(moduleBuildTarget, collection, file));
                continue;
            }
            ModuleBuildTarget moduleBuildTarget = target;
            if (moduleBuildTarget == null) {
                Intrinsics.throwNpe();
            }
            Collection<File> collection = sourceFiles;
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"sourceFiles");
            File file = outputFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputFile");
            result.add(new GeneratedFile(moduleBuildTarget, collection, file));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateJavaMappings(@JetValueParameter(name="chunk") ModuleChunk chunk, @JetValueParameter(name="compilationErrors") boolean compilationErrors, @JetValueParameter(name="context") CompileContext context, @JetValueParameter(name="dirtyFilesHolder") DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @JetValueParameter(name="filesToCompile") MultiMap<ModuleBuildTarget, File> filesToCompile, @JetValueParameter(name="generatedClasses") List<? extends GeneratedJvmClass> generatedClasses) {
        Function2<GeneratedJvmClass, Mappings, Collection<? extends File>> getOldSourceFiles$ = new Function2<GeneratedJvmClass, Mappings, Collection<? extends File>>(filesToCompile, dirtyFilesHolder){
            final /* synthetic */ MultiMap $filesToCompile;
            final /* synthetic */ DirtyFilesHolder $dirtyFilesHolder;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Collection<File> invoke(@JetValueParameter(name="generatedClass") @NotNull GeneratedJvmClass generatedClass, @JetValueParameter(name="previousMappings") @NotNull Mappings previousMappings) {
                List list;
                void destination;
                void $receiver;
                void $receiver2;
                Intrinsics.checkParameterIsNotNull((Object)generatedClass, (String)"generatedClass");
                Intrinsics.checkParameterIsNotNull((Object)previousMappings, (String)"previousMappings");
                if (!KotlinPackage.endsWith$default((String)((GeneratedFile)generatedClass).getOutputFile().getName(), (String)(PackageClassUtils.PACKAGE_CLASS_NAME_SUFFIX + ".class"), (boolean)false, (int)2)) {
                    return KotlinPackage.emptySet();
                }
                LocalFileKotlinClass kotlinClass = generatedClass.getOutputClass();
                if (!HeaderPackage.isCompatiblePackageFacadeKind((KotlinClassHeader)kotlinClass.getClassHeader())) {
                    return KotlinPackage.emptySet();
                }
                String classInternalName = JvmClassName.byClassId((ClassId)kotlinClass.getClassId()).getInternalName();
                Collection oldClassSources = previousMappings.getClassSources(previousMappings.getName(classInternalName));
                if (oldClassSources == null) {
                    return KotlinPackage.emptySet();
                }
                THashSet sources = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                sources.addAll(oldClassSources);
                sources.removeAll(this.$filesToCompile.get((Object)((GeneratedFile)generatedClass).getTarget()));
                Iterable iterable = this.$dirtyFilesHolder.getRemovedFiles((BuildTarget)((GeneratedFile)generatedClass).getTarget());
                THashSet tHashSet = sources;
                void var8_9 = $receiver2;
                Collection collection = new ArrayList<E>(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
                for (T item : $receiver) {
                    void it;
                    String string = (String)item;
                    list = destination;
                    File file = new File((String)it);
                    list.add(file);
                }
                list = (List)destination;
                tHashSet.removeAll((Collection)list);
                return (Collection)sources;
            }
            {
                this.$filesToCompile = multiMap;
                this.$dirtyFilesHolder = dirtyFilesHolder;
                super(2);
            }
        };
        if (!IncrementalCompilation.ENABLED) {
            return;
        }
        Mappings previousMappings = context.getProjectDescriptor().dataManager.getMappings();
        Mappings delta = previousMappings.createDelta();
        Callbacks.Backend callback = delta.getCallback();
        for (GeneratedJvmClass generatedJvmClass : generatedClasses) {
            List list;
            void destination;
            void $receiver;
            void $receiver2;
            File outputFile = ((GeneratedFile)generatedJvmClass).getOutputFile();
            LocalFileKotlinClass outputClass = generatedJvmClass.getOutputClass();
            Mappings mappings = previousMappings;
            Intrinsics.checkExpressionValueIsNotNull((Object)mappings, (String)"previousMappings");
            List allSourcesIncludingOld = KotlinPackage.plus((Iterable)getOldSourceFiles$.invoke(generatedJvmClass, mappings), (Iterable)((GeneratedFile)generatedJvmClass).getSourceFiles());
            Iterable iterable = allSourcesIncludingOld;
            String string = FileUtil.toSystemIndependentName((String)outputFile.getAbsolutePath());
            Callbacks.Backend backend = callback;
            void var17_18 = $receiver2;
            Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                File file = (File)item;
                list = destination;
                String string2 = FileUtil.toSystemIndependentName((String)it.getAbsolutePath());
                list.add(string2);
            }
            list = (List)destination;
            backend.associate(string, (Collection)list, new ClassReader(outputClass.getFileContents()));
        }
        Collection collection = filesToCompile.values();
        Collection compiledInThisRound = compilationErrors ? (Collection)KotlinPackage.listOf() : collection;
        JavaBuilderUtil.updateMappings((CompileContext)context, (Mappings)delta, dirtyFilesHolder, (ModuleChunk)chunk, (Collection)collection, (Collection)compiledInThisRound);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerOutputItems(@JetValueParameter(name="outputConsumer") ModuleLevelBuilder.OutputConsumer outputConsumer, @JetValueParameter(name="generatedFiles") List<? extends GeneratedFile> generatedFiles) {
        for (GeneratedFile generatedFile : generatedFiles) {
            List list;
            void destination;
            void $receiver;
            void $receiver2;
            Iterable iterable = generatedFile.getSourceFiles();
            File file = generatedFile.getOutputFile();
            BuildTarget buildTarget = (BuildTarget)generatedFile.getTarget();
            ModuleLevelBuilder.OutputConsumer outputConsumer2 = outputConsumer;
            void var6_6 = $receiver2;
            Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                File file2 = (File)item;
                list = destination;
                String string = it.getPath();
                list.add(string);
            }
            list = (List)destination;
            outputConsumer2.registerOutputFile(buildTarget, file, (Collection)list);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IncrementalCacheImpl.RecompilationDecision updateKotlinIncrementalCache(@JetValueParameter(name="compilationErrors") boolean compilationErrors, @JetValueParameter(name="incrementalCaches") Map<ModuleBuildTarget, ? extends IncrementalCacheImpl> incrementalCaches2, @JetValueParameter(name="generatedClasses") List<? extends GeneratedJvmClass> generatedClasses) {
        void recompilationDecision;
        if (!IncrementalCompilation.ENABLED) {
            return IncrementalCacheImpl.RecompilationDecision.DO_NOTHING;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = IncrementalCacheImpl.RecompilationDecision.DO_NOTHING;
        for (GeneratedJvmClass generatedJvmClass : generatedClasses) {
            IncrementalCacheImpl incrementalCacheImpl = incrementalCaches2.get(((GeneratedFile)generatedJvmClass).getTarget());
            if (incrementalCacheImpl == null) {
                Intrinsics.throwNpe();
            }
            IncrementalCacheImpl.RecompilationDecision newDecision = incrementalCacheImpl.saveFileToCache(((GeneratedFile)generatedJvmClass).getSourceFiles(), generatedJvmClass.getOutputClass());
            recompilationDecision.element = ((IncrementalCacheImpl.RecompilationDecision)((Object)recompilationDecision.element)).merge(newDecision);
        }
        if (!compilationErrors) {
            Iterable iterable = incrementalCaches2.values();
            for (GeneratedJvmClass element : iterable) {
                IncrementalCacheImpl it = (IncrementalCacheImpl)((Object)element);
                IncrementalCacheImpl.RecompilationDecision newDecision = it.clearCacheForRemovedClasses();
                recompilationDecision.element = ((IncrementalCacheImpl.RecompilationDecision)((Object)recompilationDecision.element)).merge(newDecision);
            }
        }
        return (IncrementalCacheImpl.RecompilationDecision)((Object)recompilationDecision.element);
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollectorImpl compileToJs(@JetValueParameter(name="chunk") ModuleChunk chunk, @JetValueParameter(name="commonArguments") CommonCompilerArguments commonArguments, @JetValueParameter(name="environment") CompilerEnvironment environment, @JetValueParameter(name="messageCollector") MessageCollectorAdapter messageCollector, @JetValueParameter(name="project") JpsProject project) {
        OutputItemsCollectorImpl outputItemCollector = new OutputItemsCollectorImpl();
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        if (chunk.getModules().size() > 1) {
            List list;
            void destination;
            void $receiver;
            void $receiver2;
            Iterable iterable = chunk.getModules();
            StringBuilder stringBuilder = new StringBuilder().append("Circular dependencies are not supported. ").append("The following JS modules depend on each other: ");
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.WARNING;
            MessageCollectorAdapter messageCollectorAdapter = messageCollector;
            void var9_13 = $receiver2;
            Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                JpsModule jpsModule = (JpsModule)item;
                list = destination;
                String string = it.getName();
                list.add(string);
            }
            list = (List)destination;
            String string = stringBuilder.append(KotlinPackage.joinToString$default((Iterable)list, (String)", ", null, null, (int)0, null, null, (int)62)).append(". ").append("Kotlin is not compiled for these modules").toString();
            CompilerMessageLocation compilerMessageLocation = CompilerMessageLocation.NO_LOCATION;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilerMessageLocation, (String)"NO_LOCATION");
            messageCollectorAdapter.report(compilerMessageSeverity, string, compilerMessageLocation);
            return null;
        }
        List<File> sourceFiles = KotlinSourceFileCollector.getAllKotlinSourceFiles(representativeTarget);
        if (sourceFiles.isEmpty()) {
            return null;
        }
        File outputDir = KotlinBuilderModuleScriptGenerator.getOutputDirSafe(representativeTarget);
        String moduleName = representativeTarget.getModule().getName();
        File file = outputDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDir");
        String string = moduleName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"moduleName");
        File outputFile = JpsJsModuleUtils.getOutputFile(file, string);
        ModuleBuildTarget moduleBuildTarget = representativeTarget;
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
        List<String> libraryFiles = JpsJsModuleUtils.INSTANCE$.getLibraryFilesAndDependencies(moduleBuildTarget);
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.getCompilerSettings(project);
        K2JSCompilerArguments k2JsArguments = JpsKotlinCompilerSettings.getK2JsCompilerArguments(project);
        KotlinCompilerRunner.runK2JsCompiler(commonArguments, k2JsArguments, compilerSettings, messageCollector, environment, outputItemCollector, (Collection<File>)sourceFiles, libraryFiles, outputFile);
        return outputItemCollector;
    }

    private final void copyJsLibraryFilesIfNeeded(@JetValueParameter(name="chunk") ModuleChunk chunk, @JetValueParameter(name="project") JpsProject project) {
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        File outputDir = KotlinBuilderModuleScriptGenerator.getOutputDirSafe(representativeTarget);
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.getCompilerSettings(project);
        if (compilerSettings.getCopyJsLibraryFiles()) {
            String outputLibraryRuntimeDirectory = new File(outputDir, compilerSettings.getOutputDirectoryForJsLibraryFiles()).getAbsolutePath();
            ArrayList libraryFilesToCopy = KotlinPackage.arrayListOf((Object[])new String[0]);
            ModuleBuildTarget moduleBuildTarget = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
            JpsJsModuleUtils.INSTANCE$.getLibraryFiles(moduleBuildTarget, libraryFilesToCopy);
            List list = libraryFilesToCopy;
            String string = outputLibraryRuntimeDirectory;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputLibraryRuntimeDirectory");
            LibraryUtils.copyJsFilesFromLibraries(list, string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollectorImpl compileToJvm(@JetValueParameter(name="allCompiledFiles") Set<File> allCompiledFiles, @JetValueParameter(name="chunk") ModuleChunk chunk, @JetValueParameter(name="commonArguments") CommonCompilerArguments commonArguments, @JetValueParameter(name="context") CompileContext context, @JetValueParameter(name="dirtyFilesHolder") DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @JetValueParameter(name="environment") CompilerEnvironment environment, @JetValueParameter(name="filesToCompile") MultiMap<ModuleBuildTarget, File> filesToCompile, @JetValueParameter(name="messageCollector") MessageCollectorAdapter messageCollector) {
        OutputItemsCollectorImpl outputItemCollector = new OutputItemsCollectorImpl();
        if (chunk.getModules().size() > 1) {
            List list;
            void destination;
            void $receiver;
            void $receiver2;
            Iterable iterable = chunk.getModules();
            StringBuilder stringBuilder = new StringBuilder().append("Circular dependencies are only partially supported. ").append("The following modules depend on each other: ");
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.WARNING;
            MessageCollectorAdapter messageCollectorAdapter = messageCollector;
            void var11_14 = $receiver2;
            Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                JpsModule jpsModule = (JpsModule)item;
                list = destination;
                String string = it.getName();
                list.add(string);
            }
            list = (List)destination;
            String string = stringBuilder.append(KotlinPackage.joinToString$default((Iterable)list, (String)", ", null, null, (int)0, null, null, (int)62)).append(". ").append("Kotlin will compile them, but some strange effect may happen").toString();
            CompilerMessageLocation compilerMessageLocation = CompilerMessageLocation.NO_LOCATION;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilerMessageLocation, (String)"NO_LOCATION");
            messageCollectorAdapter.report(compilerMessageSeverity, string, compilerMessageLocation);
        }
        Collection collection = filesToCompile.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"filesToCompile.values()");
        allCompiledFiles.addAll(collection);
        Set<ModuleBuildTarget> processedTargetsWithRemoved = BuildPackage$KotlinBuilder$c79545ad.getProcessedTargetsWithRemovedFilesContainer(context);
        boolean haveRemovedFiles = false;
        for (ModuleBuildTarget target : chunk.getTargets()) {
            if (KotlinSourceFileCollector.getRemovedKotlinFiles(dirtyFilesHolder, target).isEmpty()) continue;
            ModuleBuildTarget moduleBuildTarget = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
            if (!processedTargetsWithRemoved.add(moduleBuildTarget)) continue;
            haveRemovedFiles = true;
        }
        File moduleFile = KotlinBuilderModuleScriptGenerator.generateModuleDescription(context, chunk, filesToCompile, haveRemovedFiles);
        if (moduleFile == null) {
            return null;
        }
        JpsProject project = context.getProjectDescriptor().getProject();
        K2JVMCompilerArguments k2JvmArguments = JpsKotlinCompilerSettings.getK2JvmCompilerArguments(project);
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.getCompilerSettings(project);
        KotlinCompilerRunner.runK2JvmCompiler(commonArguments, k2JvmArguments, compilerSettings, messageCollector, environment, moduleFile, outputItemCollector);
        moduleFile.delete();
        return outputItemCollector;
    }

    public void buildFinished(@JetValueParameter(name="context", type="?") @Nullable CompileContext context) {
        this.statisticsLogger.reportTotal();
    }

    public KotlinBuilder() {
        super(BuilderCategory.SOURCE_PROCESSOR);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"W\u0004)I1i\\7qC:LwN\u001c\u0006\u000e\u0017>$H.\u001b8Ck&dG-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1A\u001b9t\u0015\u0015\u0011W/\u001b7e\u0015\r\te.\u001f\u0006\u0014\u0017>#F*\u0013(`\u0005VKE\nR#S?:\u000bU*\u0012\u0006\u0007'R\u0014\u0018N\\4\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\fhKR\\u\n\u0016'J\u001d~\u0013U+\u0013'E\u000bJ{f*Q'F\u0015\rauj\u0012\u0006\u0007\u0019><w-\u001a:\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u001dy\u0007/\u001a8ba&T!\u0002Z5bO:|7\u000f^5d\u0015]Yw\u000e\u001e7j]:Rg/\u001c\u0018QY\u0006$hm\u001c:n)f\u0004XM\u0003\u0004hKRduj\u0012;\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0006\u0015\u0011A1\u0001\u0005\u0004\u000b\r!!\u0001#\u0001\r\u0001\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001)\u0011\u0001\u0003\u0002\u0006\u0007\u0011\u001d\u0001r\u0001\u0007\u0001\u000b\r!9\u0001#\u0003\r\u0001\u0015\t\u0001\"B\u0003\u0003\t\u0015AY!\u0002\u0002\u0005\f!%Q!\u0001E\b\u000b\t!i\u0001\u0003\u0005\u0006\u0005\u00119\u0001\u0012C\u0003\u0003\t\u001fA\u0011\"B\u0002\u0005\u0011!9A\u0002A\u0003\u0003\t!Aq\u0001Bb\u0002\u0019\rI\"!B\u0001\t\t5\u0002Ba\u0019\u000b\u0019\t\u0005\u0012Q!\u0001E\u0005+\u000eIQ\u0001\u0002\u0003\u0005\u0013\u0005Aa\u0001$\u0001\u000e\u0007\u00111\u0011\"\u0001\u0005\u0007[U!\u0011\r\u0002M\u0007C\u001d)\u0011\u0001#\u0005\u0011\u0014U\u0019Q!\u0001E\t\u0019\u0003)6!C\u0003\u0005\t\u001bI\u0011\u0001C\u0005\r\u00025\u0019AAC\u0005\u0002\u0011%)\u0004\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final String getKOTLIN_BUILDER_NAME() {
            return KOTLIN_BUILDER_NAME;
        }

        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Companion access$init$1() {
            return new Companion();
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"Z\u0006)9R*Z:tC\u001e,7i\u001c7mK\u000e$xN]!eCB$XM\u001d\u0006\u000e\u0017>$H.\u001b8Ck&dG-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1A\u001b9t\u0015\u0015\u0011W/\u001b7e\u0015AiUm]:bO\u0016\u001cu\u000e\u001c7fGR|'OC\u0002dY&TaaY8n[>t'\u0002C7fgN\fw-Z:\u000b\rqJg.\u001b;?\u0015\u001d\u0019wN\u001c;fqRTabQ8na&dWmQ8oi\u0016DHOC\u0006j]\u000e\u0014X-\\3oi\u0006d'\u0002B6j]\u0012T\u0001b]3wKJLG/\u001f\u0006\u0018\u0007>l\u0007/\u001b7fe6+7o]1hKN+g/\u001a:jifTAaS5oI*a!)^5mI6+7o]1hK*\t\")^5mI6+7o]1hK\u0012Z\u0015N\u001c3\u000b-I,g\u000eZ3s\u0019>\u001c\u0017\r^5p]&3g*Z3eK\u0012T\u0001\u0002\\8dCRLwN\u001c\u0006\u0018\u0007>l\u0007/\u001b7fe6+7o]1hK2{7-\u0019;j_:Taa\u0015;sS:<'\u0002\u00026bm\u0006TA\u0001\\1oO*1!/\u001a9peRTq!\\3tg\u0006<WM\u0003\u0003V]&$H8\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0007\u0011\u0011\u0001\u0012\u0001\u0007\u0001\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\u0011A!\u0001\u0005\u0005\u000b\t!9\u0001#\u0003\u0006\u0005\u0011!\u0001\"B\u0003\u0004\t\u0013A9\u0001\u0004\u0001\u0006\u0005\u0011\u0005\u0001RA\u0003\u0003\t\u0017Aq!B\u0002\u0005\r!5A\u0002A\u0003\u0003\t\u0019Ai!B\u0002\u0005\n!EA\u0002A\u0003\u0003\t\u0019AQ!B\u0002\u0005\u0011!MA\u0002A\u0003\u0004\t#A\u0011\u0002\u0004\u0001\u0006\u0005\u0011A\u0001BC\u0003\u0003\t\u0013A\t\"B\u0002\u0005\n!]A\u0002A\u0003\u0002\u0011\t)1\u0001B\u0006\t\u00191\u0001Q!\u0001E\r\u000b\t!A\u0002C\u0007\u0006\u0005\u0011e\u0001\u0002D\u0003\u0003\t\u0013A9\"B\u0002\u0005\u0017!uA\u0002\u0001\u0003\u0004\u0019\rI\"!B\u0001\t\u000b5ZA!\u0019\u0003\u0019\r\u0005\u0012Q!\u0001E\u0007+\u000e!Qa\u0001\u0003\u0007\u0013\u0005Aq!L\n\u0005\u0003a=QT\u0002\u0003\u0001\u0011!i!!B\u0001\t\u0010A\u001b\u0001!\t\u0002\u0006\u0003!I\u0011kA\u0003\u0005\u0010%\t\u00012C\u0007\u0002\u0011)i3\u0003B\u0001\u0019\u0016u5A\u0001\u0001\u0005\f\u001b\t)\u0011\u0001#\u0006Q\u0007\u0001\t#!B\u0001\t\u0018E\u001bQ\u0001\"\u0006\n\u0003!iQ\"\u0001E\u000e[\u0019\"1\u0002g\u0007\u001e\u000e\u0011\u0001\u0001\u0002C\u0007\u0003\u000b\u0005Ay\u0001U\u0002\u0001;\u001b!\u0001\u0001\u0003\b\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0002u5A\u0001\u0001\u0005\f\u001b\t)\u0011\u0001#\u0006Q\u0007\u0005\t#!B\u0001\t\u001dE\u001b\u0011\u0002b\u0007\n\u0003\u0011\u0001Q\"\u0001\u0005\u000b\u001b\u0005AQ\"D\u0001\t\u001cU&Rq\u0005\u0003d\u0002a-QT\u0002\u0003\u0001\u0011\u0019i!!B\u0001\t\u000eA\u001b\u0001!\t\u0002\u0006\u0003!\u0019\u0011kA\u0003\u0005\f%\tA\u0001A\u0007\u0002\u0011\u001d\u0001"})
    public static final class MessageCollectorAdapter
    implements MessageCollector {
        public static final /* synthetic */ KClass $kotlinClass;
        private final CompileContext context;

        static {
            $kotlinClass = Reflection.createKotlinClass(MessageCollectorAdapter.class);
        }

        @Override
        public void report(@JetValueParameter(name="severity") @NotNull CompilerMessageSeverity severity, @JetValueParameter(name="message") @NotNull String message, @JetValueParameter(name="location") @NotNull CompilerMessageLocation location) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            String prefix = "";
            if (Intrinsics.areEqual((Object)((Object)severity), (Object)((Object)CompilerMessageSeverity.EXCEPTION))) {
                prefix = CompilerRunnerConstants.INTERNAL_ERROR_PREFIX;
            }
            this.context.processMessage((BuildMessage)new CompilerMessage(CompilerRunnerConstants.KOTLIN_COMPILER_NAME, this.kind(severity), prefix + message + this.renderLocationIfNeeded(location), location.getPath(), (long)(-1), (long)(-1), (long)(-1), (long)location.getLine(), (long)location.getColumn()));
        }

        private final String renderLocationIfNeeded(@JetValueParameter(name="location") CompilerMessageLocation location) {
            if (Intrinsics.areEqual((Object)location, (Object)CompilerMessageLocation.NO_LOCATION)) {
                return "";
            }
            String pathname = "" + location.getPath();
            return new File(pathname).exists() ? "" : " (" + location + ")";
        }

        private final BuildMessage.Kind kind(@JetValueParameter(name="severity") CompilerMessageSeverity severity) {
            BuildMessage.Kind kind;
            CompilerMessageSeverity compilerMessageSeverity = severity;
            if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.INFO))) {
                kind = BuildMessage.Kind.INFO;
            } else if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.ERROR)) || Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.EXCEPTION))) {
                kind = BuildMessage.Kind.ERROR;
            } else if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.WARNING))) {
                kind = BuildMessage.Kind.WARNING;
            } else if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.LOGGING))) {
                kind = BuildMessage.Kind.PROGRESS;
            } else {
                throw (Throwable)new IllegalArgumentException("Unsupported severity: " + (Object)((Object)severity));
            }
            return kind;
        }

        public MessageCollectorAdapter(@JetValueParameter(name="context") @NotNull CompileContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }
    }
}

