/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit4.ClassAwareSuiteMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.internal.runners.SuiteMethod;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

class IdeaSuite
extends Suite {
    private final String myName;
    static /* synthetic */ Class class$org$junit$runners$ParentRunner;
    static /* synthetic */ Class class$org$junit$runners$Suite;
    static /* synthetic */ Class class$org$junit$internal$runners$JUnit38ClassRunner;

    public IdeaSuite(List runners, String name) throws InitializationError {
        super(null, runners);
        this.myName = name;
    }

    public IdeaSuite(RunnerBuilder builder, Class[] classes, String name) throws InitializationError {
        super(builder, classes);
        this.myName = name;
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription((String)this.myName, (Annotation[])this.getTestClass().getAnnotations());
        try {
            Method getFilteredChildrenMethod = (class$org$junit$runners$ParentRunner == null ? (class$org$junit$runners$ParentRunner = IdeaSuite.class$("org.junit.runners.ParentRunner")) : class$org$junit$runners$ParentRunner).getDeclaredMethod("getFilteredChildren", new Class[0]);
            getFilteredChildrenMethod.setAccessible(true);
            Collection filteredChildren = (Collection)getFilteredChildrenMethod.invoke((Object)this, new Object[0]);
            Iterator iterator = filteredChildren.iterator();
            while (iterator.hasNext()) {
                Object child = iterator.next();
                description.addChild(this.describeChild((Runner)child));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return description;
    }

    protected Description describeChild(Runner child) {
        Description superDescription = super.describeChild(child);
        if (child instanceof ClassAwareSuiteMethod) {
            Description description = Description.createSuiteDescription((Class)((ClassAwareSuiteMethod)child).getKlass());
            ArrayList children = superDescription.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                description.addChild((Description)children.get(i));
            }
            return description;
        }
        return superDescription;
    }

    protected List getChildren() {
        Object child;
        ArrayList children = new ArrayList(super.getChildren());
        HashSet<String> allNames = new HashSet<String>();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            child = iterator.next();
            allNames.add(this.describeChild((Runner)child).getDisplayName());
        }
        iterator = children.iterator();
        while (iterator.hasNext()) {
            child = iterator.next();
            if (!IdeaSuite.isSuite(child)) continue;
            this.skipSuiteComponents(allNames, child);
        }
        iterator = children.iterator();
        while (iterator.hasNext()) {
            child = iterator.next();
            if (IdeaSuite.isSuite(child) || allNames.contains(this.describeChild((Runner)child).getDisplayName())) continue;
            iterator.remove();
        }
        return children;
    }

    private static boolean isSuite(Object child) {
        return child instanceof Suite && !(child instanceof Parameterized) || child instanceof SuiteMethod;
    }

    private void skipSuiteComponents(Set allNames, Object child) {
        try {
            if (child instanceof Suite) {
                Method getChildrenMethod = (class$org$junit$runners$Suite == null ? (class$org$junit$runners$Suite = IdeaSuite.class$("org.junit.runners.Suite")) : class$org$junit$runners$Suite).getDeclaredMethod("getChildren", new Class[0]);
                getChildrenMethod.setAccessible(true);
                List tests = (List)getChildrenMethod.invoke(child, new Object[0]);
                Iterator suiteIterator = tests.iterator();
                while (suiteIterator.hasNext()) {
                    String displayName = this.describeChild((Runner)suiteIterator.next()).getDisplayName();
                    if (!allNames.contains(displayName)) continue;
                    allNames.remove(displayName);
                }
            } else if (child instanceof SuiteMethod) {
                Method getChildrenMethod = (class$org$junit$internal$runners$JUnit38ClassRunner == null ? (class$org$junit$internal$runners$JUnit38ClassRunner = IdeaSuite.class$("org.junit.internal.runners.JUnit38ClassRunner")) : class$org$junit$internal$runners$JUnit38ClassRunner).getDeclaredMethod("getTest", new Class[0]);
                getChildrenMethod.setAccessible(true);
                Test test = (Test)getChildrenMethod.invoke(child, new Object[0]);
                if (test instanceof TestSuite) {
                    Enumeration tests = ((TestSuite)test).tests();
                    while (tests.hasMoreElements()) {
                        String testDescription;
                        Test t = (Test)tests.nextElement();
                        if (!(t instanceof TestSuite) || !allNames.contains(testDescription = ((TestSuite)t).getName())) continue;
                        allNames.remove(testDescription);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

