/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.HasCondition;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsCatchScope;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import com.google.dart.compiler.util.AstUtil;
import org.jetbrains.annotations.NotNull;

public class JsCatch
extends SourceInfoAwareJsNode
implements HasCondition {
    protected final JsCatchScope scope;
    private JsBlock body;
    private JsExpression condition;
    private JsParameter param;

    public JsCatch(JsScope parent, @NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "com/google/dart/compiler/backend/js/ast/JsCatch", "<init>"));
        }
        assert (parent != null);
        this.scope = new JsCatchScope(parent, ident);
        this.param = new JsParameter(this.scope.findName(ident));
    }

    public JsCatch(JsScope parent, @NotNull String ident, @NotNull JsStatement catchBody) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "com/google/dart/compiler/backend/js/ast/JsCatch", "<init>"));
        }
        if (catchBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "catchBody", "com/google/dart/compiler/backend/js/ast/JsCatch", "<init>"));
        }
        this(parent, ident);
        this.body = catchBody instanceof JsBlock ? (JsBlock)catchBody : new JsBlock(catchBody);
    }

    public JsBlock getBody() {
        return this.body;
    }

    @Override
    public JsExpression getCondition() {
        return this.condition;
    }

    public JsParameter getParameter() {
        return this.param;
    }

    public JsScope getScope() {
        return this.scope;
    }

    public void setBody(JsBlock body2) {
        this.body = body2;
    }

    @Override
    public void setCondition(JsExpression condition2) {
        this.condition = condition2;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitCatch(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.param);
        if (this.condition != null) {
            visitor2.accept(this.condition);
        }
        visitor2.accept(this.body);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.param = v.accept(this.param);
            if (this.condition != null) {
                this.condition = v.accept(this.condition);
            }
            this.body = v.acceptStatement(this.body);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsCatch deepCopy() {
        JsCatchScope scopeCopy = this.scope.copy();
        JsBlock bodyCopy = AstUtil.deepCopy(this.body);
        JsExpression conditionCopy = AstUtil.deepCopy(this.condition);
        JsParameter paramCopy = AstUtil.deepCopy(this.param);
        JsCatch jsCatch = new JsCatch(scopeCopy, bodyCopy, conditionCopy, paramCopy).withMetadataFrom(this);
        if (jsCatch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsCatch", "deepCopy"));
        }
        return jsCatch;
    }

    private JsCatch(JsCatchScope scope2, JsBlock body2, JsExpression condition2, JsParameter param) {
        this.scope = scope2;
        this.body = body2;
        this.condition = condition2;
        this.param = param;
    }
}

