/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.common.Symbol;
import com.google.dart.compiler.util.AstUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsNameRef
extends JsExpressionImpl
implements HasName {
    private String ident;
    private JsName name;
    private JsExpression qualifier;

    public JsNameRef(@NotNull JsName name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/google/dart/compiler/backend/js/ast/JsNameRef", "<init>"));
        }
        this.name = name2;
    }

    public JsNameRef(@NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "com/google/dart/compiler/backend/js/ast/JsNameRef", "<init>"));
        }
        this.ident = ident;
    }

    public JsNameRef(@NotNull String ident, JsExpression qualifier) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "com/google/dart/compiler/backend/js/ast/JsNameRef", "<init>"));
        }
        this.ident = ident;
        this.qualifier = qualifier;
    }

    public JsNameRef(@NotNull String ident, @NotNull String qualifier) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "com/google/dart/compiler/backend/js/ast/JsNameRef", "<init>"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/google/dart/compiler/backend/js/ast/JsNameRef", "<init>"));
        }
        this(ident, (JsExpression)new JsNameRef(qualifier));
    }

    public JsNameRef(@NotNull JsName name2, JsExpression qualifier) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/google/dart/compiler/backend/js/ast/JsNameRef", "<init>"));
        }
        this.name = name2;
        this.qualifier = qualifier;
    }

    @NotNull
    public String getIdent() {
        String string = this.name == null ? this.ident : this.name.getIdent();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsNameRef", "getIdent"));
        }
        return string;
    }

    @Override
    @Nullable
    public JsName getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Symbol getSymbol() {
        return this.name;
    }

    @Nullable
    public JsExpression getQualifier() {
        return this.qualifier;
    }

    @Override
    public boolean isLeaf() {
        return this.qualifier == null;
    }

    public void resolve(JsName name2) {
        this.name = name2;
        this.ident = null;
    }

    public void setQualifier(JsExpression qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitNameRef(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        if (this.qualifier != null) {
            visitor2.accept(this.qualifier);
        }
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx) && this.qualifier != null) {
            this.qualifier = v.accept(this.qualifier);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsNameRef deepCopy() {
        JsExpression qualifierCopy = AstUtil.deepCopy(this.qualifier);
        if (this.name != null) {
            JsNameRef jsNameRef = new JsNameRef(this.name, qualifierCopy);
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsNameRef", "deepCopy"));
            }
            return jsNameRef;
        }
        JsNameRef jsNameRef = new JsNameRef(this.ident, qualifierCopy).withMetadataFrom(this);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsNameRef", "deepCopy"));
        }
        return jsNameRef;
    }
}

