/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.inline.CoveringTryCatchNodeProcessor;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.InlinePackage;
import org.jetbrains.kotlin.codegen.inline.IntervalMetaInfo;
import org.jetbrains.kotlin.codegen.inline.LocalVarNodeWrapper;
import org.jetbrains.kotlin.codegen.inline.MaxLocalsCalculator;
import org.jetbrains.kotlin.codegen.inline.SimpleInterval;
import org.jetbrains.kotlin.codegen.inline.TryBlockCluster;
import org.jetbrains.kotlin.codegen.inline.TryCatchBlockNodeInfo;
import org.jetbrains.kotlin.codegen.inline.TryCatchBlockNodePosition;
import org.jetbrains.kotlin.codegen.inline.TryCatchPosition;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.util.Printer;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class InternalFinallyBlockInliner
extends CoveringTryCatchNodeProcessor {
    @NotNull
    private final MethodNode inlineFun;

    public static void processInlineFunFinallyBlocks(@NotNull MethodNode inlineFun, int lambdaTryCatchBlockNodes, int finallyParamOffset) {
        if (inlineFun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlineFun", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "processInlineFunFinallyBlocks"));
        }
        int index2 = 0;
        ArrayList<TryCatchBlockNodeInfo> inlineFunTryBlockInfo = new ArrayList<TryCatchBlockNodeInfo>();
        for (TryCatchBlockNode block : inlineFun.tryCatchBlocks) {
            inlineFunTryBlockInfo.add(new TryCatchBlockNodeInfo(block, index2++ < lambdaTryCatchBlockNodes));
        }
        ArrayList<LocalVarNodeWrapper> localVars = new ArrayList<LocalVarNodeWrapper>();
        for (LocalVariableNode var : inlineFun.localVariables) {
            localVars.add(new LocalVarNodeWrapper(var));
        }
        if (InternalFinallyBlockInliner.hasFinallyBlocks(inlineFunTryBlockInfo)) {
            new InternalFinallyBlockInliner(inlineFun, inlineFunTryBlockInfo, localVars, finallyParamOffset).processInlineFunFinallyBlocks();
        }
    }

    private InternalFinallyBlockInliner(@NotNull MethodNode inlineFun, @NotNull List<TryCatchBlockNodeInfo> inlineFunTryBlockInfo, @NotNull List<LocalVarNodeWrapper> localVariableInfo, int finallyParamOffset) {
        if (inlineFun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlineFun", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "<init>"));
        }
        if (inlineFunTryBlockInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlineFunTryBlockInfo", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "<init>"));
        }
        if (localVariableInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localVariableInfo", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "<init>"));
        }
        super(finallyParamOffset);
        this.inlineFun = inlineFun;
        for (TryCatchBlockNodeInfo block : inlineFunTryBlockInfo) {
            this.getTryBlocksMetaInfo().addNewInterval(block);
        }
        for (LocalVarNodeWrapper wrapper : localVariableInfo) {
            this.getLocalVarsMetaInfo().addNewInterval(wrapper);
        }
    }

    private int initAndGetVarIndexForNonLocalReturnValue() {
        MaxLocalsCalculator tempCalcNode = new MaxLocalsCalculator(327680, this.inlineFun.access, this.inlineFun.desc, null);
        this.inlineFun.accept((MethodVisitor)tempCalcNode);
        return tempCalcNode.getMaxLocals();
    }

    private void processInlineFunFinallyBlocks() {
        int nextTempNonLocalVarIndex = this.initAndGetVarIndexForNonLocalReturnValue();
        InsnList instructions = this.inlineFun.instructions;
        AbstractInsnNode curIns = instructions.getLast();
        while (curIns != null) {
            this.processInstruction(curIns, false);
            if (!InlineCodegenUtil.isReturnOpcode(curIns.getOpcode()) || !InlineCodegenUtil.isMarkedReturn(curIns)) {
                curIns = curIns.getPrevious();
                continue;
            }
            List<TryCatchBlockNodeInfo> currentCoveringNodesFromInnermost = this.sortTryCatchBlocks(new ArrayList<TryCatchBlockNodeInfo>(this.getTryBlocksMetaInfo().getCurrentIntervals()));
            InternalFinallyBlockInliner.checkCoveringBlocksInvariant(Lists.reverse(currentCoveringNodesFromInnermost));
            if (currentCoveringNodesFromInnermost.isEmpty() || currentCoveringNodesFromInnermost.get(currentCoveringNodesFromInnermost.size() - 1).getOnlyCopyNotProcess()) {
                curIns = curIns.getPrevious();
                continue;
            }
            AbstractInsnNode markedReturn = curIns;
            AbstractInsnNode instrInsertFinallyBefore = markedReturn.getPrevious();
            AbstractInsnNode nextPrev = instrInsertFinallyBefore.getPrevious();
            Type nonLocalReturnType = InlineCodegenUtil.getReturnType(markedReturn.getOpcode());
            List<TryBlockCluster<TryCatchBlockNodeInfo>> clustersFromInnermost = InlinePackage.doClustering(currentCoveringNodesFromInnermost);
            Iterator<TryBlockCluster<TryCatchBlockNodeInfo>> tryCatchBlockIterator = clustersFromInnermost.iterator();
            InternalFinallyBlockInliner.checkClusterInvariant(clustersFromInnermost);
            ArrayList<TryCatchBlockNodeInfo> additionalNodesToSplit = new ArrayList<TryCatchBlockNodeInfo>();
            while (tryCatchBlockIterator.hasNext()) {
                boolean generateAloadAstore;
                TryBlockCluster<TryCatchBlockNodeInfo> clusterToFindFinally = tryCatchBlockIterator.next();
                List<TryCatchBlockNodeInfo> clusterBlocks = clusterToFindFinally.getBlocks();
                TryCatchBlockNodeInfo nodeWithDefaultHandlerIfExists = clusterBlocks.get(clusterBlocks.size() - 1);
                FinallyBlockInfo finallyInfo = this.findFinallyBlockBody(nodeWithDefaultHandlerIfExists, this.getTryBlocksMetaInfo().getAllIntervals());
                if (finallyInfo == null) continue;
                if (nodeWithDefaultHandlerIfExists.getOnlyCopyNotProcess()) {
                    additionalNodesToSplit.addAll(clusterBlocks);
                    continue;
                }
                instructions.resetLabels();
                List<TryCatchBlockNodePosition> tryCatchBlockInlinedInFinally = this.findTryCatchBlocksInlinedInFinally(finallyInfo);
                MethodNode finallyBlockCopy = InlineCodegenUtil.createEmptyMethodNode();
                Label newFinallyStart = new Label();
                Label newFinallyEnd = new Label();
                Label insertedBlockEnd = new Label();
                boolean bl = generateAloadAstore = nonLocalReturnType != Type.VOID_TYPE && !finallyInfo.isEmpty();
                if (generateAloadAstore) {
                    finallyBlockCopy.visitVarInsn(nonLocalReturnType.getOpcode(54), nextTempNonLocalVarIndex);
                }
                finallyBlockCopy.visitLabel(newFinallyStart);
                Set<LabelNode> labelsInsideFinally = InternalFinallyBlockInliner.rememberOriginalLabelNodes(finallyInfo);
                for (AbstractInsnNode currentIns = finallyInfo.startIns; currentIns != finallyInfo.endInsExclusive; currentIns = currentIns.getNext()) {
                    boolean isInsOrJumpInsideFinally = !(currentIns instanceof JumpInsnNode) || labelsInsideFinally.contains(((JumpInsnNode)currentIns).label);
                    InternalFinallyBlockInliner.copyInstruction(nextTempNonLocalVarIndex, markedReturn, instrInsertFinallyBefore, nonLocalReturnType, finallyBlockCopy, currentIns, isInsOrJumpInsideFinally);
                }
                finallyBlockCopy.visitLabel(newFinallyEnd);
                if (generateAloadAstore) {
                    finallyBlockCopy.visitVarInsn(nonLocalReturnType.getOpcode(21), nextTempNonLocalVarIndex);
                    nextTempNonLocalVarIndex += nonLocalReturnType.getSize();
                }
                finallyBlockCopy.visitLabel(insertedBlockEnd);
                InlineCodegenUtil.insertNodeBefore(finallyBlockCopy, this.inlineFun, instrInsertFinallyBefore);
                this.updateExceptionTable(clusterBlocks, newFinallyStart, newFinallyEnd, tryCatchBlockInlinedInFinally, labelsInsideFinally, (LabelNode)insertedBlockEnd.info, additionalNodesToSplit);
            }
            for (curIns = markedReturn.getPrevious(); curIns != null && curIns != nextPrev; curIns = curIns.getPrevious()) {
                this.processInstruction(curIns, false);
            }
            if (instrInsertFinallyBefore.getPrevious() == nextPrev || curIns == null) continue;
            LabelNode startNode = new LabelNode();
            LabelNode endNode = new LabelNode();
            instructions.insert(curIns, (AbstractInsnNode)startNode);
            instructions.insert(markedReturn, (AbstractInsnNode)endNode);
            this.getLocalVarsMetaInfo().splitCurrentIntervals(new SimpleInterval(startNode, endNode), true);
        }
        this.substituteTryBlockNodes(this.inlineFun);
        this.substituteLocalVarTable(this.inlineFun);
    }

    private static void copyInstruction(int nextTempNonLocalVarIndex, @NotNull AbstractInsnNode curIns, @NotNull AbstractInsnNode instrInsertFinallyBefore, @NotNull Type nonLocalReturnType, @NotNull MethodNode finallyBlockCopy, @NotNull AbstractInsnNode currentIns, boolean isInsOrJumpInsideFinally) {
        if (curIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "curIns", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "copyInstruction"));
        }
        if (instrInsertFinallyBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instrInsertFinallyBefore", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "copyInstruction"));
        }
        if (nonLocalReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonLocalReturnType", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "copyInstruction"));
        }
        if (finallyBlockCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finallyBlockCopy", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "copyInstruction"));
        }
        if (currentIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentIns", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "copyInstruction"));
        }
        if (isInsOrJumpInsideFinally) {
            currentIns.accept((MethodVisitor)finallyBlockCopy);
        } else {
            finallyBlockCopy.instructions.add((AbstractInsnNode)new JumpInsnNode(currentIns.getOpcode(), ((JumpInsnNode)currentIns).label));
        }
    }

    private static void checkCoveringBlocksInvariant(@ReadOnly @NotNull List<TryCatchBlockNodeInfo> currentCoveringNodesFromOuterMost) {
        if (currentCoveringNodesFromOuterMost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentCoveringNodesFromOuterMost", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "checkCoveringBlocksInvariant"));
        }
        boolean isWasOnlyLocal = false;
        for (TryCatchBlockNodeInfo info : currentCoveringNodesFromOuterMost) {
            assert (!isWasOnlyLocal || info.getOnlyCopyNotProcess()) : "There are some problems with try-catch structure";
            isWasOnlyLocal = info.getOnlyCopyNotProcess();
        }
    }

    private static void checkClusterInvariant(List<TryBlockCluster<TryCatchBlockNodeInfo>> clusters) {
        boolean isWasOnlyLocal = false;
        for (TryBlockCluster cluster : Lists.reverse(clusters)) {
            TryCatchBlockNodeInfo info = (TryCatchBlockNodeInfo)cluster.getBlocks().get(0);
            assert (!isWasOnlyLocal || info.getOnlyCopyNotProcess());
            if (!info.getOnlyCopyNotProcess()) continue;
            isWasOnlyLocal = true;
        }
    }

    @NotNull
    private static Set<LabelNode> rememberOriginalLabelNodes(@NotNull FinallyBlockInfo finallyInfo) {
        if (finallyInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finallyInfo", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "rememberOriginalLabelNodes"));
        }
        HashSet<LabelNode> labelsInsideFinally = new HashSet<LabelNode>();
        for (AbstractInsnNode currentIns = finallyInfo.startIns; currentIns != finallyInfo.endInsExclusive; currentIns = currentIns.getNext()) {
            if (!(currentIns instanceof LabelNode)) continue;
            labelsInsideFinally.add((LabelNode)currentIns);
        }
        HashSet<LabelNode> hashSet = labelsInsideFinally;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "rememberOriginalLabelNodes"));
        }
        return hashSet;
    }

    private void updateExceptionTable(@NotNull List<TryCatchBlockNodeInfo> updatingClusterBlocks, @NotNull Label newFinallyStart, @NotNull Label newFinallyEnd, @NotNull List<TryCatchBlockNodePosition> tryCatchBlockPresentInFinally, @NotNull Set<LabelNode> labelsInsideFinally, @NotNull LabelNode insertedBlockEnd, @NotNull List<TryCatchBlockNodeInfo> patched) {
        TryBlockCluster singleCluster;
        if (updatingClusterBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatingClusterBlocks", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "updateExceptionTable"));
        }
        if (newFinallyStart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFinallyStart", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "updateExceptionTable"));
        }
        if (newFinallyEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFinallyEnd", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "updateExceptionTable"));
        }
        if (tryCatchBlockPresentInFinally == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryCatchBlockPresentInFinally", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "updateExceptionTable"));
        }
        if (labelsInsideFinally == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelsInsideFinally", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "updateExceptionTable"));
        }
        if (insertedBlockEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertedBlockEnd", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "updateExceptionTable"));
        }
        if (patched == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patched", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "updateExceptionTable"));
        }
        List<TryBlockCluster<TryCatchBlockNodePosition>> clusters = InlinePackage.doClustering(tryCatchBlockPresentInFinally);
        HashMap<LabelNode, TryBlockCluster<TryCatchBlockNodePosition>> handler2Cluster = new HashMap<LabelNode, TryBlockCluster<TryCatchBlockNodePosition>>();
        IntervalMetaInfo<TryCatchBlockNodeInfo> tryBlocksMetaInfo = this.getTryBlocksMetaInfo();
        for (TryBlockCluster<TryCatchBlockNodePosition> cluster : clusters) {
            TryCatchBlockNodePosition defaultHandler;
            List<TryCatchBlockNodePosition> clusterBlocks = cluster.getBlocks();
            TryCatchBlockNodePosition block0 = clusterBlocks.get(0);
            TryCatchPosition clusterPosition = block0.getPosition();
            if (clusterPosition == TryCatchPosition.INNER) {
                for (TryCatchBlockNodePosition position : clusterBlocks) {
                    assert (clusterPosition == position.getPosition()) : "Wrong inner tryCatchBlock structure";
                    TryCatchBlockNode tryCatchBlockNode = position.getNodeInfo().getNode();
                    assert (this.inlineFun.instructions.indexOf((AbstractInsnNode)tryCatchBlockNode.start) <= this.inlineFun.instructions.indexOf((AbstractInsnNode)tryCatchBlockNode.end));
                    TryCatchBlockNode additionalTryCatchBlock = new TryCatchBlockNode((LabelNode)tryCatchBlockNode.start.getLabel().info, (LabelNode)tryCatchBlockNode.end.getLabel().info, InternalFinallyBlockInliner.getNewOrOldLabel(tryCatchBlockNode.handler, labelsInsideFinally), tryCatchBlockNode.type);
                    assert (this.inlineFun.instructions.indexOf((AbstractInsnNode)additionalTryCatchBlock.start) <= this.inlineFun.instructions.indexOf((AbstractInsnNode)additionalTryCatchBlock.end));
                    tryBlocksMetaInfo.addNewInterval(new TryCatchBlockNodeInfo(additionalTryCatchBlock, true));
                }
                continue;
            }
            if (clusterPosition == TryCatchPosition.END) {
                defaultHandler = cluster.getDefaultHandler();
                assert (defaultHandler != null) : "Default handler should be present";
                handler2Cluster.put(defaultHandler.getHandler(), cluster);
                continue;
            }
            assert (clusterPosition == TryCatchPosition.START);
            defaultHandler = cluster.getDefaultHandler();
            assert (defaultHandler != null) : "Default handler should be present";
            TryBlockCluster endCluster = (TryBlockCluster)handler2Cluster.remove(defaultHandler.getHandler());
            assert (endCluster != null) : "Could find start cluster for  " + (Object)((Object)clusterPosition);
            Iterator<TryCatchBlockNodePosition> startBlockPositions = clusterBlocks.iterator();
            for (TryCatchBlockNodePosition endBlockPosition : endCluster.getBlocks()) {
                TryCatchBlockNodeInfo startNode = startBlockPositions.next().getNodeInfo();
                TryCatchBlockNodeInfo endNode = endBlockPosition.getNodeInfo();
                assert (Objects.equal((Object)startNode.getType(), (Object)endNode.getType())) : "Different handler types : " + startNode.getType() + " " + endNode.getType();
                this.getTryBlocksMetaInfo().split(endNode, new SimpleInterval((LabelNode)endNode.getNode().end.getLabel().info, (LabelNode)startNode.getStartLabel().getLabel().info), false);
            }
        }
        if (handler2Cluster.size() == 1 && ((TryCatchBlockNodePosition)(singleCluster = (TryBlockCluster)handler2Cluster.values().iterator().next()).getBlocks().get(0)).getPosition() == TryCatchPosition.END) {
            for (TryCatchBlockNodePosition endBlockPosition : singleCluster.getBlocks()) {
                TryCatchBlockNodeInfo endNode = endBlockPosition.getNodeInfo();
                this.getTryBlocksMetaInfo().split(endNode, new SimpleInterval((LabelNode)endNode.getNode().end.getLabel().info, (LabelNode)insertedBlockEnd.getLabel().info), false);
            }
            handler2Cluster.clear();
        }
        assert (handler2Cluster.isEmpty()) : "Unmatched clusters " + handler2Cluster.size();
        ArrayList<TryCatchBlockNodeInfo> toProcess = new ArrayList<TryCatchBlockNodeInfo>();
        toProcess.addAll(patched);
        toProcess.addAll(updatingClusterBlocks);
        patched.clear();
        SimpleInterval splitBy = new SimpleInterval((LabelNode)newFinallyStart.info, (LabelNode)newFinallyEnd.info);
        for (TryCatchBlockNodeInfo block : toProcess) {
            tryBlocksMetaInfo.split(block, splitBy, false);
            assert (!block.isEmpty()) : "Finally block should be non-empty";
            patched.add(block);
        }
        this.sortTryCatchBlocks(tryBlocksMetaInfo.getAllIntervals());
    }

    private static LabelNode getNewOrOldLabel(LabelNode oldHandler, @NotNull Set<LabelNode> labelsInsideFinally) {
        if (labelsInsideFinally == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelsInsideFinally", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "getNewOrOldLabel"));
        }
        if (labelsInsideFinally.contains(oldHandler)) {
            return (LabelNode)oldHandler.getLabel().info;
        }
        return oldHandler;
    }

    private static boolean hasFinallyBlocks(List<TryCatchBlockNodeInfo> inlineFunTryBlockInfo) {
        for (TryCatchBlockNodeInfo block : inlineFunTryBlockInfo) {
            if (block.getOnlyCopyNotProcess() || block.getNode().type != null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private FinallyBlockInfo findFinallyBlockBody(@NotNull TryCatchBlockNodeInfo tryCatchBlock, @ReadOnly @NotNull List<TryCatchBlockNodeInfo> tryCatchBlocks) {
        if (tryCatchBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryCatchBlock", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "findFinallyBlockBody"));
        }
        if (tryCatchBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryCatchBlocks", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "findFinallyBlockBody"));
        }
        if (tryCatchBlock.getOnlyCopyNotProcess()) {
            LabelNode start = new LabelNode();
            LabelNode end = new LabelNode();
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)start);
            insnList.add((AbstractInsnNode)end);
            return new FinallyBlockInfo((AbstractInsnNode)start, (AbstractInsnNode)end);
        }
        ArrayList<TryCatchBlockNodeInfo> sameDefaultHandler = new ArrayList<TryCatchBlockNodeInfo>();
        LabelNode defaultHandler = null;
        boolean afterStartBlock = false;
        for (TryCatchBlockNodeInfo block : tryCatchBlocks) {
            if (tryCatchBlock == block) {
                afterStartBlock = true;
            }
            if (!afterStartBlock || block.getNode().type != null || (InlineCodegenUtil.firstLabelInChain(tryCatchBlock.getNode().start) != InlineCodegenUtil.firstLabelInChain(block.getNode().start) || InlineCodegenUtil.firstLabelInChain(tryCatchBlock.getNode().end) != InlineCodegenUtil.firstLabelInChain(block.getNode().end)) && defaultHandler != InlineCodegenUtil.firstLabelInChain(block.getNode().handler)) continue;
            sameDefaultHandler.add(block);
            if (defaultHandler != null) continue;
            defaultHandler = InlineCodegenUtil.firstLabelInChain(block.getNode().handler);
        }
        if (sameDefaultHandler.isEmpty()) {
            return null;
        }
        TryCatchBlockNodeInfo nextIntervalWithSameDefaultHandler = (TryCatchBlockNodeInfo)sameDefaultHandler.get(1);
        LabelNode startFinallyChain = tryCatchBlock.getNode().end;
        AbstractInsnNode endFinallyChainExclusive = InternalFinallyBlockInliner.skipLastGotoIfNeeded((AbstractInsnNode)nextIntervalWithSameDefaultHandler.getNode().start);
        FinallyBlockInfo finallyInfo = new FinallyBlockInfo(startFinallyChain.getNext(), endFinallyChainExclusive);
        if (this.inlineFun.instructions.indexOf(finallyInfo.startIns) > this.inlineFun.instructions.indexOf(finallyInfo.endInsExclusive)) {
            throw new AssertionError((Object)("Inconsistent finally: block end occurs before start " + InternalFinallyBlockInliner.traceInterval(finallyInfo.endInsExclusive, finallyInfo.startIns)));
        }
        return finallyInfo;
    }

    @NotNull
    private static AbstractInsnNode skipLastGotoIfNeeded(@NotNull AbstractInsnNode lastFinallyInsExclusive) {
        if (lastFinallyInsExclusive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastFinallyInsExclusive", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "skipLastGotoIfNeeded"));
        }
        AbstractInsnNode prevLast = InternalFinallyBlockInliner.getPrevNoLineNumberOrLabel(lastFinallyInsExclusive, true);
        assert (prevLast != null) : "Empty finally block: " + lastFinallyInsExclusive;
        if (InlineCodegenUtil.isGoToTryCatchBlockEnd(prevLast)) {
            AbstractInsnNode abstractInsnNode = prevLast.getPrevious();
            if (abstractInsnNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "skipLastGotoIfNeeded"));
            }
            return abstractInsnNode;
        }
        AbstractInsnNode abstractInsnNode = lastFinallyInsExclusive;
        if (abstractInsnNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "skipLastGotoIfNeeded"));
        }
        return abstractInsnNode;
    }

    @NotNull
    private List<TryCatchBlockNodePosition> findTryCatchBlocksInlinedInFinally(@NotNull FinallyBlockInfo finallyInfo) {
        if (finallyInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finallyInfo", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "findTryCatchBlocksInlinedInFinally"));
        }
        ArrayList<TryCatchBlockNodePosition> result2 = new ArrayList<TryCatchBlockNodePosition>();
        HashMap<TryCatchBlockNodeInfo, TryCatchBlockNodePosition> processedBlocks = new HashMap<TryCatchBlockNodeInfo, TryCatchBlockNodePosition>();
        for (AbstractInsnNode curInstr = finallyInfo.startIns; curInstr != finallyInfo.endInsExclusive; curInstr = curInstr.getNext()) {
            if (!(curInstr instanceof LabelNode)) continue;
            LabelNode curLabel = (LabelNode)curInstr;
            List<TryCatchBlockNodeInfo> startedTryBlocks = this.getStartNodes(curLabel);
            for (TryCatchBlockNodeInfo block : startedTryBlocks) {
                assert (!processedBlocks.containsKey(block)) : "Try catch block already processed before start label!!! " + block;
                TryCatchBlockNodePosition info = new TryCatchBlockNodePosition(block, TryCatchPosition.START);
                processedBlocks.put(block, info);
                result2.add(info);
            }
            List<TryCatchBlockNodeInfo> endedTryBlocks = this.getEndNodes(curLabel);
            for (TryCatchBlockNodeInfo block : endedTryBlocks) {
                TryCatchBlockNodePosition info = (TryCatchBlockNodePosition)processedBlocks.get(block);
                if (info != null) {
                    assert (info.getPosition() == TryCatchPosition.START);
                    info.setPosition(TryCatchPosition.INNER);
                    continue;
                }
                info = new TryCatchBlockNodePosition(block, TryCatchPosition.END);
                processedBlocks.put(block, info);
                result2.add(info);
            }
        }
        ArrayList<TryCatchBlockNodePosition> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "findTryCatchBlocksInlinedInFinally"));
        }
        return arrayList;
    }

    private static void substituteReturnValueInFinally(int nonLocalVarIndex, @NotNull Type nonLocalReturnType, @NotNull MethodNode finallyBlockCopy, @NotNull Type localReturnType, boolean doPop) {
        if (nonLocalReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonLocalReturnType", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "substituteReturnValueInFinally"));
        }
        if (finallyBlockCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finallyBlockCopy", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "substituteReturnValueInFinally"));
        }
        if (localReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localReturnType", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "substituteReturnValueInFinally"));
        }
        if (doPop && localReturnType != Type.VOID_TYPE) {
            AsmUtil.pop((MethodVisitor)finallyBlockCopy, localReturnType);
        }
        if (nonLocalReturnType != Type.VOID_TYPE) {
            finallyBlockCopy.visitVarInsn(nonLocalReturnType.getOpcode(21), nonLocalVarIndex);
        }
    }

    @Nullable
    private static AbstractInsnNode getPrevNoLineNumberOrLabel(@NotNull AbstractInsnNode node2, boolean strict) {
        AbstractInsnNode result2;
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "getPrevNoLineNumberOrLabel"));
        }
        AbstractInsnNode abstractInsnNode = result2 = strict ? node2.getPrevious() : node2;
        while (InlineCodegenUtil.isLineNumberOrLabel(result2)) {
            result2 = result2.getPrevious();
        }
        return result2;
    }

    @Override
    public int instructionIndex(@NotNull AbstractInsnNode inst) {
        if (inst == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inst", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "instructionIndex"));
        }
        return this.inlineFun.instructions.indexOf(inst);
    }

    private static String traceInterval(AbstractInsnNode startNode, AbstractInsnNode stopNode) {
        Textifier p = new Textifier();
        TraceMethodVisitor visitor2 = new TraceMethodVisitor((Printer)p);
        while (startNode != stopNode) {
            startNode.accept((MethodVisitor)visitor2);
            startNode = startNode.getNext();
        }
        startNode.accept((MethodVisitor)visitor2);
        StringWriter out = new StringWriter();
        p.print(new PrintWriter(out));
        return out.toString();
    }

    private void flushCurrentState(@NotNull AbstractInsnNode curNonLocal) {
        if (curNonLocal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "curNonLocal", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner", "flushCurrentState"));
        }
        this.substituteTryBlockNodes(this.inlineFun);
        System.out.println("Will process instruction at : " + this.inlineFun.instructions.indexOf(curNonLocal) + " " + curNonLocal.toString());
        String text = InlineCodegenUtil.getNodeText(this.inlineFun);
        System.out.println(text);
    }

    private static class FinallyBlockInfo {
        final AbstractInsnNode startIns;
        final AbstractInsnNode endInsExclusive;

        private FinallyBlockInfo(@NotNull AbstractInsnNode inclusiveStart, @NotNull AbstractInsnNode exclusiveEnd) {
            if (inclusiveStart == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inclusiveStart", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner$FinallyBlockInfo", "<init>"));
            }
            if (exclusiveEnd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exclusiveEnd", "org/jetbrains/kotlin/codegen/inline/InternalFinallyBlockInliner$FinallyBlockInfo", "<init>"));
            }
            this.startIns = inclusiveStart;
            this.endInsExclusive = exclusiveEnd;
        }

        public boolean isEmpty() {
            AbstractInsnNode end;
            if (!(this.startIns instanceof LabelNode)) {
                return false;
            }
            for (end = this.endInsExclusive; end != this.startIns && end instanceof LabelNode; end = end.getPrevious()) {
            }
            return this.startIns == end;
        }
    }
}

