/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.converters;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.RunManagerSettings;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JetRunConfigurationSettingsFormatConverterProvider
extends ConverterProvider {
    protected JetRunConfigurationSettingsFormatConverterProvider() {
        super("kotlin-run-configuration-should-store-its-settings-as-java-run-configuration");
    }

    @NotNull
    public String getConversionDescription() {
        if ("Kotlin run configurations settings will be converted to Java run configurations format" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/converters/JetRunConfigurationSettingsFormatConverterProvider", "getConversionDescription"));
        }
        return "Kotlin run configurations settings will be converted to Java run configurations format";
    }

    @NotNull
    public ProjectConverter createConverter(@NotNull ConversionContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/converters/JetRunConfigurationSettingsFormatConverterProvider", "createConverter"));
        }
        ProjectConverter projectConverter = new ProjectConverter(){

            @NotNull
            public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
                ConversionProcessor<RunManagerSettings> conversionProcessor = new ConversionProcessor<RunManagerSettings>(){

                    public boolean isConversionNeeded(@NotNull RunManagerSettings settings) {
                        if (settings == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/kotlin/idea/converters/JetRunConfigurationSettingsFormatConverterProvider$1$1", "isConversionNeeded"));
                        }
                        for (Element runConfiguration : settings.getRunConfigurations()) {
                            if (!JetRunConfigurationSettingsFormatConverterProvider.isJetRunConfiguration(runConfiguration) || JetRunConfigurationSettingsFormatConverterProvider.getOldSettings(runConfiguration) == null) continue;
                            return true;
                        }
                        return false;
                    }

                    public void process(@NotNull RunManagerSettings settings) throws CannotConvertException {
                        if (settings == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/kotlin/idea/converters/JetRunConfigurationSettingsFormatConverterProvider$1$1", "process"));
                        }
                        for (Element runConfiguration : settings.getRunConfigurations()) {
                            Element oldSettings;
                            if (!JetRunConfigurationSettingsFormatConverterProvider.isJetRunConfiguration(runConfiguration) || (oldSettings = JetRunConfigurationSettingsFormatConverterProvider.getOldSettings(runConfiguration)) == null) continue;
                            for (Element optionObj : oldSettings.getChildren("option")) {
                                if (!(optionObj instanceof Element)) continue;
                                Element option = optionObj;
                                String optionName = option.getAttributeValue("name");
                                String optionValue = option.getAttributeValue("value");
                                if ("mainClassName".equals(optionName)) {
                                    runConfiguration.addContent(JetRunConfigurationSettingsFormatConverterProvider.createOption("MAIN_CLASS_NAME", optionValue));
                                    continue;
                                }
                                if ("programParameters".equals(optionName)) {
                                    runConfiguration.addContent(JetRunConfigurationSettingsFormatConverterProvider.createOption("PROGRAM_PARAMETERS", optionValue));
                                    continue;
                                }
                                if ("vmParameters".equals(optionName)) {
                                    runConfiguration.addContent(JetRunConfigurationSettingsFormatConverterProvider.createOption("VM_PARAMETERS", optionValue));
                                    continue;
                                }
                                if (!"workingDirectory".equals(optionName)) continue;
                                runConfiguration.addContent(JetRunConfigurationSettingsFormatConverterProvider.createOption("WORKING_DIRECTORY", optionValue));
                            }
                            runConfiguration.removeContent((Content)oldSettings);
                        }
                    }
                };
                if (conversionProcessor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/converters/JetRunConfigurationSettingsFormatConverterProvider$1", "createRunConfigurationsConverter"));
                }
                return conversionProcessor;
            }
        };
        if (projectConverter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/converters/JetRunConfigurationSettingsFormatConverterProvider", "createConverter"));
        }
        return projectConverter;
    }

    private static boolean isJetRunConfiguration(@NotNull Element runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "org/jetbrains/kotlin/idea/converters/JetRunConfigurationSettingsFormatConverterProvider", "isJetRunConfiguration"));
        }
        return "JetRunConfigurationType".equals(runConfiguration.getAttributeValue("type"));
    }

    @Nullable
    private static Element getOldSettings(@NotNull Element runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "org/jetbrains/kotlin/idea/converters/JetRunConfigurationSettingsFormatConverterProvider", "getOldSettings"));
        }
        return runConfiguration.getChild("JetRunConfigurationSettings");
    }

    @NotNull
    private static Element createOption(@NotNull String name2, @Nullable String value2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/idea/converters/JetRunConfigurationSettingsFormatConverterProvider", "createOption"));
        }
        Element option = new Element("option");
        option.setAttribute("name", name2);
        option.setAttribute("value", value2 == null ? "" : value2);
        Element element = option;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/converters/JetRunConfigurationSettingsFormatConverterProvider", "createOption"));
        }
        return element;
    }
}

