/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.js.JsPackage;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"<\u0006)y!j]'fi\u00064\u0015\u000e\\3Vi&d7OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0015\u0011,7m\\7qS2,'O\u0003\u0006oCZLw-\u0019;j_:T1!\u00118z\u001599W\r^\"mCN\u001ch)\u001d(b[\u0016TAAZ5mK*Ya+\u001b:uk\u0006dg)\u001b7f\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*9q\u000e]3oCBL'b\u0001<gg*1a)\u001d(b[\u0016TAA\\1nK*9!/\u001a7QCRD'BB*ue&twM\u0003\u0003kCZ\f'\u0002\u00027b]\u001eT!bZ3u\u00072\f7o]%e\u0015\u001d\u0019E.Y:t\u0013\u0012T!cZ3u\u001b>$W\u000f\\3ESJ,7\r^8ss*iq-\u001a;N_\u0012,H.\u001a(b[\u0016T\u0001cZ3u!\u0006\u001c7.Y4f\rFt\u0015-\\3\u000b+\u001d,GOU3mCRLg/\u001a+p%>|G\u000fU1uQ*9q-\u001a;S_>$(bD5t!\u0006\u001c7.Y4f\u0011\u0016\fG-\u001a:\u000b\u000f\t{w\u000e\\3b]r\r!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aq\u0001E\u0004\u0019\u0001)\u0011\u0001c\u0003\u0006\u0005\u0011%\u0001BB\u0003\u0003\t\u0015Ai!\u0002\u0002\u0005\f!9Qa\u0001\u0003\u0007\u0011\u0015a\u0001!\u0002\u0002\u0005\u0003!AQa\u0001\u0003\b\u0011\u001fa\u0001!\u0002\u0002\u0005\u000f!=QA\u0001\u0003\u0007\u0011\u0015)1\u0001b\u0002\t\u00131\u0001Q!\u0001E\n\u000b\t!\u0019\u0002\u0003\u0006\u0006\u0005\u0011Q\u0001\"C\u0003\u0004\t\u001dA1\u0002\u0004\u0001\u0006\u0005\u00119\u0001bC\u0003\u0004\t\u000fAi\u0002\u0004\u0001\u0005G\u0006a1!\u0007\u0002\u0006\u0003!!Qf\u0005\u0003\u00041\u0011ij\u0001\u0002\u0001\t\n5\u0011Q!\u0001E\u0007!\u000e\u0001\u0011EA\u0003\u0002\u0011\u001f\t6!\u0002\u0003\u0005\u0013\u0005A\u0001\"D\u0001\t\u00125\u001aB!\u0001\r\u0005;\u001b!\u0001\u0001#\u0005\u000e\u0005\u0015\t\u0001\"\u0003)\u0004\u0001\u0005\u0012Q!\u0001E\b#\u000e)A\u0001B\u0005\u0002\u0011!i\u0011\u0001#\u0006.'\u0011\u0019\u0001TCO\u0007\t\u0001AI!\u0004\u0002\u0006\u0003!5\u0001k\u0001\u0001\"\u0005\u0015\t\u0001bC)\u0004\u000b\u0011U\u0011\"\u0001E\f\u001b\u0005A\t\"L\n\u0005\u0003aUQT\u0002\u0003\u0001\u0011#i!!B\u0001\t\u0013A\u001b\u0001!\t\u0002\u0006\u0003!Y\u0011kA\u0003\u0005\u0016%\t\u0001rC\u0007\u0002\u0011+i3\u0003B\u0002\u0019\u0018u5A\u0001\u0001E\u0005\u001b\t)\u0011\u0001#\u0004Q\u0007\u0001\t#!B\u0001\t\u000eE\u001bQ\u0001b\u0006\n\u0003!EQ\"\u0001E\t[M!\u0011\u0001\u0007\u0007\u001e\u000e\u0011\u0001\u0001\u0012C\u0007\u0003\u000b\u0005A\u0011\u0002U\u0002\u0001C\t)\u0011\u0001C\u0005R\u0007\u0015!A\"C\u0001\t\u00165\t\u0001RC\u0017\u0014\t\rAJ\"(\u0004\u0005\u0001!%QBA\u0003\u0002\u0011\u001b\u00016\u0001A\u0011\u0003\u000b\u0005Ay!U\u0002\u0006\t3I\u0011\u0001\u0003\u0005\u000e\u0003!EQf\u0005\u0003\u000213ij\u0001\u0002\u0001\t\u00125\u0011Q!\u0001\u0005\n!\u000e\u0001\u0011EA\u0003\u0002\u0011\u001f\t6!\u0002C\r\u0013\u0005A\u0001\"D\u0001\t\u00165\u001aB!\u0001\r\u000e;\u001b!\u0001\u0001#\u0003\u000e\u0005\u0015\t\u0001R\u0002)\u0004\u0001\u0005\u0012Q!\u0001\u0005\n#\u000e)A!D\u0005\u0002\u0011+i\u0011\u0001#\u0005.'\u0011\t\u00014DO\u0007\t\u0001AI!\u0004\u0002\u0006\u0003!5\u0001k\u0001\u0001\"\u0005\u0015\t\u0001RB)\u0004\u000b\u0011m\u0011\"\u0001E\t\u001b\u0005A\t\"L\n\u0005\u0007aqQT\u0002\u0003\u0001\u0011\u0013i!!B\u0001\t\u000eA\u001b\u0001!\t\u0002\u0006\u0003!a\u0011kA\u0003\u0005\u001d%\tA\u0011A\u0007\u0002\u0011#i3\u0003B\u0001\u0019\u001du5A\u0001\u0001E\t\u001b\t)\u0011\u0001C\u0005Q\u0007\u0001\t#!B\u0001\t\u0019E\u001bQ\u0001\u0002\b\n\u0003\u0011\u0005Q\"\u0001E\u000bk\u0001\u0001"})
public final class JsMetaFileUtils {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final JsMetaFileUtils INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(JsMetaFileUtils.class);
        new JsMetaFileUtils();
    }

    @NotNull
    public final FqName getPackageFqName(@JetValueParameter(name="file") @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.getPackageFqName(this.getRelativeToRootPath(file));
    }

    @NotNull
    public final FqName getClassFqName(@JetValueParameter(name="file") @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.getClassFqName(this.getRelativeToRootPath(file));
    }

    @NotNull
    public final ClassId getClassId(@JetValueParameter(name="file") @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.getClassId(this.getRelativeToRootPath(file));
    }

    public final boolean isPackageHeader(@JetValueParameter(name="file") @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.isPackageHeader(this.getRelativeToRootPath(file));
    }

    @NotNull
    public final VirtualFile getModuleDirectory(@JetValueParameter(name="file") @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        VirtualFile virtualFile = this.getRoot(file).findChild(this.getModuleName(this.getRelativeToRootPath(file)));
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        return virtualFile;
    }

    private final String getRelativeToRootPath(@JetValueParameter(name="file") VirtualFile file) {
        String string = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)this.getRoot(file));
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    private final FqName getClassFqName(@JetValueParameter(name="relPath") String relPath) {
        String pathToFile = KotlinPackage.substringAfter$default((String)relPath, (char)VfsUtilCore.VFS_SEPARATOR_CHAR, null, (int)2);
        return new FqName(KotlinPackage.replace$default((String)KotlinPackage.substringBeforeLast$default((String)pathToFile, (char)'.', null, (int)2), (char)VfsUtilCore.VFS_SEPARATOR_CHAR, (char)'.', (boolean)false, (int)4));
    }

    private final ClassId getClassId(@JetValueParameter(name="relPath") String relPath) {
        FqName classFqName = this.getClassFqName(relPath);
        FqName packageFqName = this.getPackageFqName(relPath);
        String name2 = KotlinPackage.substringBeforeLast$default((String)classFqName.shortName().asString(), (char)'.', null, (int)2);
        return new ClassId(packageFqName, new FqName(name2), false);
    }

    private final FqName getPackageFqName(@JetValueParameter(name="relPath") String relPath) {
        String pathToFile = KotlinPackage.substringAfter$default((String)relPath, (char)VfsUtilCore.VFS_SEPARATOR_CHAR, null, (int)2);
        if (JsPackage.isDefaultPackageMetafile(pathToFile)) {
            FqName fqName2 = FqName.ROOT;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"FqName.ROOT");
            return fqName2;
        }
        String name2 = KotlinPackage.substringBeforeLast$default((String)pathToFile, (char)VfsUtilCore.VFS_SEPARATOR_CHAR, null, (int)2);
        return new FqName(KotlinPackage.replace$default((String)name2, (char)VfsUtilCore.VFS_SEPARATOR_CHAR, (char)'.', (boolean)false, (int)4));
    }

    private final String getModuleName(@JetValueParameter(name="relPath") String relPath) {
        return KotlinPackage.substringBefore$default((String)relPath, (char)VfsUtilCore.VFS_SEPARATOR_CHAR, null, (int)2);
    }

    private final boolean isPackageHeader(@JetValueParameter(name="relPath") String relPath) {
        FqName classFqName = INSTANCE$.getClassFqName(relPath);
        return JsPackage.isPackageClassFqName(classFqName);
    }

    private final VirtualFile getRoot(@JetValueParameter(name="file") VirtualFile file) {
        VirtualFile virtualFile;
        if (file.getParent() == null) {
            virtualFile = file;
        } else {
            VirtualFile virtualFile2 = file.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.getParent()");
            virtualFile = this.getRoot(virtualFile2);
        }
        return virtualFile;
    }

    JsMetaFileUtils() {
        INSTANCE$ = this;
    }
}

