/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.AsJavaPackage;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.highlighter.JetPsiChecker;
import org.jetbrains.kotlin.idea.project.TargetPlatform;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class DuplicateJvmSignatureAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        GlobalSearchScope moduleScope;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/highlighter/DuplicateJvmSignatureAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/kotlin/idea/highlighter/DuplicateJvmSignatureAnnotator", "annotate"));
        }
        if (!(element instanceof JetFile) && !(element instanceof JetDeclaration)) {
            return;
        }
        if (!ProjectRootsUtil.isInProjectSource(element)) {
            return;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof JetFile) || TargetPlatformDetector.getPlatform((JetFile)file) != TargetPlatform.JVM) {
            return;
        }
        Diagnostics otherDiagnostics = ResolvePackage.analyzeFully((JetElement)element).getDiagnostics();
        Diagnostics diagnostics = AsJavaPackage.getJvmSignatureDiagnostics(element, otherDiagnostics, moduleScope = ResolvePackage.getModuleInfo(element).contentScope());
        if (diagnostics == null) {
            return;
        }
        new JetPsiChecker().annotateElement(element, holder, diagnostics);
    }
}

