/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.Collection;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtils;
import org.jetbrains.kotlin.idea.configuration.KotlinJavaModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.framework.JavaRuntimePresentationProvider;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ReflectionNotFoundInspection;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtil;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetDoubleColonExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationPackage;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.utils.PathUtil;
import org.jetbrains.kotlin.utils.UtilsPackage;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={")\u0006)a\"+\u001a4mK\u000e$\u0018n\u001c8O_R4u.\u001e8e\u0013:\u001c\b/Z2uS>t'bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\t%$W-\u0019\u0006\fS:\u001c\b/Z2uS>t7O\u0003\rBEN$(/Y2u\u0017>$H.\u001b8J]N\u0004Xm\u0019;j_:Ta\u0001P5oSRt$\u0002\u00042vS2$g+[:ji>\u0014(B\u00025pY\u0012,'O\u0003\bQe>\u0014G.Z7t\u0011>dG-\u001a:\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u00159\u0019w\u000eZ3J]N\u0004Xm\u0019;j_:T!\"[:P]RCWM\u00127z\u0015\u001d\u0011un\u001c7fC:T\u0011\u0003U:j\u000b2,W.\u001a8u-&\u001c\u0018\u000e^8s\u0015\r\u00018/\u001b\u0006\u0010eVtgi\u001c:XQ>dWMR5mK*\u00112\u000f[8vY\u0012\u0014V\r]8si&sg)\u001b7f\u0015\u00111\u0017\u000e\\3\u000b\u000fA\u001b\u0018NR5mK*)\u0012\t\u001a3SK\u001adWm\u0019;KCJ\fV/[2l\r&D\bP\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001b\u0001\u0007\u0001\u000b\u0005AY!\u0002\u0002\u0005\b!1QA\u0001\u0003\u0005\u0011\u001b)1\u0001\"\u0003\t\u000b1\u0001Q!\u0001E\u0002\u000b\r!Y\u0001c\u0004\r\u0001\u0015\u0011A\u0001\u0002E\t\u000b\r!i\u0001\u0003\u0005\r\u0001\u0015\u0011AQ\u0002\u0005\t\u000b\t!I\u0001C\u0003\u0006\u0007\u00115\u0001R\u0003\u0007\u0001\u000b\t!i\u0001#\u0006\u0005\u00071\u0015\u0011DA\u0003\u0002\u0011\ra2\",\u000f\u0005\u0017a!QT\u0002\u0003\u0001\u0011\u0013i!!B\u0001\t\u000bA\u001b\u0001!(\u0004\u0005\u0001!9QBA\u0003\u0002\u0011\u0019\u00016\u0011A\u0011\u0003\u000b\u0005Aq!U\u0002\b\t\u0011I\u0011\u0001c\u0004\u000e\u0003!AQ\"\u0001C\u0001['!1\u0002G\u0005\"\u0005\u0015\t\u0001BB)\u0004\u0007\u0011I\u0011\"\u0001C\u0001[M!\u0011\u0001g\u0005\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005A\t\u0002U\u0002\u0001C\t)\u0011\u0001\u0003\u0004R\u0007\u0015!\u0019\"C\u0001\u0005\u00025\t\u0001\"C\u001b\f\u000b)!1\u001d\u0001M\u0004C\t)\u0011\u0001#\u0002R\u0007\r!9!C\u0001\u0005\u0001\u0001"})
public final class ReflectionNotFoundInspection
extends AbstractKotlinInspection {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(ReflectionNotFoundInspection.class);
    }

    public boolean runForWholeFile() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@JetValueParameter(name="holder") @NotNull ProblemsHolder holder, @JetValueParameter(name="isOnTheFly") boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"holder.getFile()");
        if (!this.shouldReportInFile(psiFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return new JetVisitorVoid(holder){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ ProblemsHolder $holder;

            static {
                $kotlinClass = Reflection.createKotlinClass(buildVisitor.1.class);
            }

            private final LocalQuickFix createQuickFix() {
                File pluginReflectJar = PathUtil.getKotlinPathsForIdeaPlugin().getReflectPath();
                if (pluginReflectJar.exists()) {
                    Object object;
                    block3: {
                        Object[] $receiver = Extensions.getExtensions(KotlinProjectConfigurator.EP_NAME);
                        for (int i = 0; i < $receiver.length; ++i) {
                            Object element = $receiver[i];
                            if (!(element instanceof KotlinJavaModuleConfigurator)) continue;
                            object = element;
                            break block3;
                        }
                        object = null;
                    }
                    KotlinJavaModuleConfigurator configurator = (KotlinJavaModuleConfigurator)object;
                    if (configurator != null) {
                        File file = pluginReflectJar;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"pluginReflectJar");
                        return new AddReflectJarQuickFix(configurator, file);
                    }
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            public void visitDoubleColonExpression(@JetValueParameter(name="expression") @NotNull JetDoubleColonExpression expression2) {
                void $receiver;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetType expectedType = (JetType)ResolvePackage.analyze$default(expression2, null, 1).get(BindingContext.EXPECTED_EXPRESSION_TYPE, expression2);
                if (expectedType != null && !ReflectionTypes.Companion.isReflectionType(expectedType)) {
                    return;
                }
                Object $receiver2 = (PsiElement)expression2;
                if (PsiTreeUtil.getParentOfType((PsiElement)$receiver2, JetAnnotationEntry.class, (boolean)true) != null) {
                    return;
                }
                $receiver2 = UtilsPackage.singletonOrEmptyList(this.createQuickFix());
                ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                String string = JetBundle.message("reflection.not.found", new Object[0]);
                PsiElement psiElement = expression2.getDoubleColonTokenReference();
                ProblemsHolder problemsHolder = this.$holder;
                Object object = $receiver2;
                void v0 = $receiver;
                if (v0 == null) {
                    throw new TypeCastException("kotlin.Collection<T> cannot be cast to java.util.Collection<T>");
                }
                Collection thisCollection = (Collection)v0;
                LocalQuickFix[] localQuickFixArray = thisCollection.toArray(new LocalQuickFix[thisCollection.size()]);
                if (localQuickFixArray == null) {
                    throw new TypeCastException("kotlin.Array<(out) T?>! cannot be cast to kotlin.Array<T>");
                }
                Object[] objectArray = localQuickFixArray;
                problemsHolder.registerProblem(psiElement, string, problemHighlightType, (LocalQuickFix[])objectArray);
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    private final boolean shouldReportInFile(@JetValueParameter(name="file") PsiFile file) {
        if (!(file instanceof JetFile) || !ProjectRootsUtil.isInProjectSource((PsiElement)file)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file));
        if (module == null || !ProjectStructureUtil.isJavaKotlinModule(module)) {
            return false;
        }
        ModuleDescriptor moduleDescriptor = ResolvePackage.findModuleDescriptor((JetElement)file);
        ClassId classId = JvmAbi.REFLECTION_FACTORY_IMPL;
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"JvmAbi.REFLECTION_FACTORY_IMPL");
        return DeserializationPackage.findClassAcrossModuleDependencies(moduleDescriptor, classId) == null;
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"9\b))\u0012\t\u001a3SK\u001adWm\u0019;KCJ\fV/[2l\r&D(\u0002\b*fM2,7\r^5p]:{GOR8v]\u0012Len\u001d9fGRLwN\u001c\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*!\u0011\u000eZ3b\u0015-Ign\u001d9fGRLwN\\:\u000b\u001b1{7-\u00197Rk&\u001c7NR5y\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*q1m\u001c3f\u0013:\u001c\b/Z2uS>t'B\u0002\u001fj]&$hH\u0003\u0007d_:4\u0017nZ;sCR|'O\u0003\u000fL_Rd\u0017N\u001c&bm\u0006lu\u000eZ;mK\u000e{gNZ5hkJ\fGo\u001c:\u000b\u001b\r|gNZ5hkJ\fG/[8o\u0015A\u0001H.^4j]J+g\r\\3di*\u000b'O\u0003\u0003GS2,'\u0002\u00026bm\u0006T!![8\u000b\u001f\u001d,GoQ8oM&<WO]1u_JT1cZ3u!2,x-\u001b8SK\u001adWm\u0019;KCJT\u0001\"\u00199qYf4\u0015\u000e\u001f\u0006\baJ|'.Z2u\u0015\u001d\u0001&o\u001c6fGRTqa\u001c9f]\u0006\u0004\u0018N\u0003\u0006eKN\u001c'/\u001b9u_JT\u0011\u0003\u0015:pE2,W\u000eR3tGJL\u0007\u000f^8s\u0015\u0011)f.\u001b;\u000b\u001b\u001d,GOR1nS2Lh*Y7f\u0015\u0019\u0019FO]5oO*9aj\u001c;Ok2d'bC1o]>$\u0018\r^5p]NTqc[8uY&tgF\u001b<n]Ac\u0017\r\u001e4pe6$\u0016\u0010]3\u000b\t1\fgn\u001a\u0006\bO\u0016$h*Y7f\r\bQ!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!\u0002\u0002\u0005\u0004!\u0019Qa\u0001\u0003\u0003\u0011\u0003a\u0001!B\u0002\u0005\u0006!\u0001A\u0002A\u0003\u0002\u0011\u0011)!\u0001b\u0002\t\n\u0015\u0011A\u0001\u0002\u0005\u0006\u000b\r!I\u0001c\u0002\r\u0001\u0015\u0011A1\u0001\u0005\b\u000b\r!Y\u0001#\u0004\r\u0001\u0015\t\u0001\u0012C\u0003\u0003\t\u001bA\u0011\"B\u0002\u0005\u000f!AA\u0002A\u0003\u0003\t\u0017Ai!\u0002\u0002\u0005\u000f!AQA\u0001\u0003\u0005\u00111)!\u0001B\u0005\t\u0017\u0015\u0019A1\u0003E\f\u0019\u0001)1\u0001\"\u0003\t\u001b1\u0001Q!\u0001\u0005\u0003\u000b\r!1\u0002c\u0007\r\u0001\u0015\u0011A1\u0003E\f\u000b\t!I\u0001C\u0007\u0006\u0007\u0011Y\u0001R\u0004\u0007\u0001\u000b\t!\t\u0001c\b\u0006\u0007\u0011m\u0001b\u0004\u0007\u0001\u000b\t!i\u0001#\t\u0006\u0005\u0011u\u0001R\u0004\u0003\u0001\u0019\rI\"!B\u0001\t\u000b5zA\u0001\u0019\u0003\u0019\r\u0005\u0012Q!\u0001\u0005\u0007+\u000eAQa\u0001\u0003\u0007\u0013\u0005A\u0001\"D\u0002\u0005\u0014%\t\u0001\u0002C\u0017\u0010\t\u0001$\u0001tB\u0011\u0003\u000b\u0005Ay!V\u0002\t\u000b\r!y!C\u0001\t\u00125\u0019AAC\u0005\u0002\u0011#i[\u0004B\u0006\u0019\u0016u5A\u0001\u0001\u0005\f\u001b\t)\u0011\u0001\u0003\u0006Q\u0007\u0001iz\u0001\u0002\u0001\t\u001a5\u0019Q!\u0001E\u000b\u0019\u0003\u00016\u0011A\u0011\u0003\u000b\u0005A9\"U\u0002\b\t+I\u0011\u0001\u0002\u0001\u000e\u0003!aQ\"\u0001E\r[O!1\u0002\u0007\b\"\u0019\u0015\t\u0001\"\u0004\t\u0011+\u0017)\u0011\u0001C\u0007\r\u0002E\u001b\u0011\u0001\u0002\bR\u0007\u0005!a\"U\u0002\u0004\t9I\u0011\u0001C\b.(\u0011Y\u0001$E\u0011\r\u000b\u0005AQ\u0002\u0005\t\u0016\f\u0015\t\u0001\"\u0004G\u0001#\u000e\tAAD)\u0004\u0003\u0011q\u0011kA\u0002\u0005#%\t\u0001bD\u001b\u001f\u000bu!1\u001d\u0001M\u0006;\u001b!\u0001\u0001\u0003\u0004\u000e\u0005\u0015\t\u0001B\u0002)\u0004\u0001u5A\u0001\u0001E\b\u001b\t)\u0011\u0001c\u0004Q\u0007\u0003\t#!B\u0001\t\u0007E\u001bq\u0001b\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\t\u001b\u0005A\t\u0002"})
    public static final class AddReflectJarQuickFix
    implements LocalQuickFix {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final KotlinJavaModuleConfigurator configurator;
        @NotNull
        private final File pluginReflectJar;

        static {
            $kotlinClass = Reflection.createKotlinClass(AddReflectJarQuickFix.class);
        }

        @NotNull
        public String getName() {
            return JetBundle.message("add.reflection.to.classpath", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="descriptor", type="?") @Nullable ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            for (Library library : KotlinRuntimeLibraryUtil.findKotlinLibraries(project)) {
                VirtualFile runtimeJar;
                if (JavaRuntimePresentationProvider.getRuntimeJar(library) == null) {
                    continue;
                }
                if (JavaRuntimePresentationProvider.getReflectJar(library) != null) continue;
                Library.ModifiableModel model = library.getModifiableModel();
                String libFilesDir = VfsUtilCore.virtualToIoFile((VirtualFile)runtimeJar).getParent();
                File reflectIoFile = new File(libFilesDir, PathUtil.KOTLIN_JAVA_REFLECT_JAR);
                if (reflectIoFile.exists()) {
                    model.addRoot(VfsUtil.getUrlForLibraryRoot((File)reflectIoFile), OrderRootType.CLASSES);
                } else {
                    File copied;
                    if (this.configurator.copyFileToDir(this.pluginReflectJar, libFilesDir) == null) {
                        Intrinsics.throwNpe();
                    }
                    model.addRoot(VfsUtil.getUrlForLibraryRoot((File)copied), OrderRootType.CLASSES);
                }
                model.commit();
                ConfigureKotlinInProjectUtils.showInfoNotification(PathUtil.KOTLIN_JAVA_REFLECT_JAR + " was added to the library " + library.getName());
            }
        }

        @NotNull
        public final KotlinJavaModuleConfigurator getConfigurator() {
            return this.configurator;
        }

        @NotNull
        public final File getPluginReflectJar() {
            return this.pluginReflectJar;
        }

        public AddReflectJarQuickFix(@JetValueParameter(name="configurator") @NotNull KotlinJavaModuleConfigurator configurator, @JetValueParameter(name="pluginReflectJar") @NotNull File pluginReflectJar) {
            Intrinsics.checkParameterIsNotNull((Object)configurator, (String)"configurator");
            Intrinsics.checkParameterIsNotNull((Object)pluginReflectJar, (String)"pluginReflectJar");
            this.configurator = configurator;
            this.pluginReflectJar = pluginReflectJar;
        }
    }
}

