/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.idea.projectView.JetClassOrObjectTreeNode;
import org.jetbrains.kotlin.idea.projectView.JetDeclarationTreeNode;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;

public class JetFileTreeNode
extends PsiFileNode {
    public JetFileTreeNode(Project project, JetFile value2, ViewSettings viewSettings) {
        super(project, (PsiFile)value2, viewSettings);
    }

    public Collection<AbstractTreeNode> getChildrenImpl() {
        JetFile file = (JetFile)this.getValue();
        if (file == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        if (this.getSettings().isShowMembers()) {
            List<JetDeclaration> declarations2 = file.getDeclarations();
            for (JetDeclaration declaration : declarations2) {
                if (declaration instanceof JetClassOrObject) {
                    result2.add((AbstractTreeNode)new JetClassOrObjectTreeNode(file.getProject(), (JetClassOrObject)declaration, this.getSettings()));
                    continue;
                }
                if (!this.getSettings().isShowMembers()) continue;
                result2.add((AbstractTreeNode)new JetDeclarationTreeNode(this.getProject(), declaration, this.getSettings()));
            }
        }
        return result2;
    }
}

