/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.SelectableTreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.kotlin.idea.JetIconProvider;
import org.jetbrains.kotlin.idea.projectView.JetClassOrObjectTreeNode;
import org.jetbrains.kotlin.idea.projectView.JetFileTreeNode;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;

public class JetProjectViewProvider
implements SelectableTreeStructureProvider,
DumbAware {
    private Project myProject;

    public JetProjectViewProvider(Project project) {
        this.myProject = project;
    }

    public Collection<AbstractTreeNode> modify(AbstractTreeNode parent, Collection<AbstractTreeNode> children2, ViewSettings settings) {
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        for (AbstractTreeNode child : children2) {
            Object childValue = child.getValue();
            if (childValue instanceof JetFile) {
                JetFile file = (JetFile)childValue;
                List<JetDeclaration> declarations2 = file.getDeclarations();
                JetClassOrObject mainClass = JetIconProvider.getMainClass(file);
                if (mainClass != null && declarations2.size() == 1) {
                    result2.add((AbstractTreeNode)new JetClassOrObjectTreeNode(file.getProject(), mainClass, settings));
                    continue;
                }
                result2.add((AbstractTreeNode)new JetFileTreeNode(file.getProject(), file, settings));
                continue;
            }
            result2.add(child);
        }
        return result2;
    }

    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        return null;
    }

    public PsiElement getTopLevelElement(PsiElement element) {
        PsiElement current;
        PsiFile file = element.getContainingFile();
        if (file == null || !(file instanceof JetFile)) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (!this.fileInRoots(virtualFile)) {
            return file;
        }
        for (current = element; current != null && !JetProjectViewProvider.isSelectable(current); current = current.getParent()) {
        }
        if (current instanceof JetFile) {
            String nameWithoutExtension;
            List<JetDeclaration> declarations2 = ((JetFile)current).getDeclarations();
            String string = nameWithoutExtension = virtualFile != null ? virtualFile.getNameWithoutExtension() : file.getName();
            if (declarations2.size() == 1 && declarations2.get(0) instanceof JetClassOrObject && nameWithoutExtension.equals(declarations2.get(0).getName())) {
                current = declarations2.get(0);
            }
        }
        return current != null ? current : file;
    }

    private static boolean isSelectable(PsiElement element) {
        if (element instanceof JetFile) {
            return true;
        }
        if (element instanceof JetDeclaration) {
            PsiElement parent = element.getParent();
            if (parent instanceof JetFile) {
                return true;
            }
            if (parent instanceof JetClassBody) {
                if ((parent = parent.getParent()) instanceof JetClassOrObject) {
                    return JetProjectViewProvider.isSelectable(parent);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean fileInRoots(VirtualFile file) {
        ProjectFileIndex index2 = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        return file != null && (index2.isInSourceContent(file) || index2.isInLibraryClasses(file) || index2.isInLibrarySource(file));
    }
}

