/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Sequence;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.CorePackage;
import org.jetbrains.kotlin.idea.quickfix.DeprecatedSyntaxFix;
import org.jetbrains.kotlin.idea.quickfix.LambdaToFunctionExpression;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralArgument;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.JetType;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\f\n)QB*Y7cI\u0006$vNR;oGRLwN\\#yaJ,7o]5p]*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'\u0002C9vS\u000e\\g-\u001b=\u000b'\u0011+\u0007O]3dCR,GmU=oi\u0006Dh)\u001b=\u000b\rqJg.\u001b;?\u0015e1WO\\2uS>tG*\u001b;fe\u0006dW\t\u001f9sKN\u001c\u0018n\u001c8\u000b9)+GOR;oGRLwN\u001c'ji\u0016\u0014\u0018\r\\#yaJ,7o]5p]*\u0019\u0001o]5\u000b7\u0019,hn\u0019;j_:d\u0015\u000e^3sC2\f%oZ;nK:$h*Y7f\u0015\u0019\u0019FO]5oO*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b=\u001d,GOR;oGRLwN\u001c'ji\u0016\u0014\u0018\r\\!sOVlWM\u001c;OC6,'\u0002H4fi\u001a+hn\u0019;j_:d\u0015\u000e^3sC2,\u0005\u0010\u001d:fgNLwN\u001c\u0006\re\u0016\u001cW-\u001b<feRK\b/\u001a\u0006\u0010O\u0016$(+Z2fSZ,'\u000fV=qK*Q!/\u001a;ve:$\u0016\u0010]3\u000b\u001b\u001d,GOU3ukJtG+\u001f9f\u0015a\u0019'/Z1uK\u001a+hn\u0019;j_:,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0011\u0015\u0016$h*Y7fI\u001a+hn\u0019;j_:T!dZ3u\rVt7\r^5p]2KG/\u001a:bY\u0006\u0013x-^7f]RT!DS3u\rVt7\r^5p]2KG/\u001a:bY\u0006\u0013x-^7f]RT!cZ3u\u0019\u0006l'\rZ1MC\n,GNT1nK*1!/\u001e8GSbTA!\u00168ji*i!*\u001a;FqB\u0014Xm]:j_:T\u0011C]3qY\u0006\u001cWmV5uQJ+G/\u001e:o\u0015)\u00018/\u001b$bGR|'/\u001f\u0006\u000e\u0015\u0016$\bk]5GC\u000e$xN]=\u001d\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Qa\u0001\u0003\u0003\u0011\ra\u0001!\u0002\u0002\u0005\u0003!)Qa\u0001C\u0004\u0011\u0013a\u0001!\u0002\u0002\u0005\b!%Q!\u0001E\u0002\u000b\r!Q\u0001\u0003\u0004\r\u0001\u0015\t\u0001RB\u0003\u0003\t\u0019Aq!\u0002\u0002\u0005\u000e!1Qa\u0001C\u0004\u0011-a\u0001!\u0002\u0002\u0005\b!YQa\u0001C\u0004\u00111a\u0001!\u0002\u0002\u0005\b!aQa\u0001\u0003\u0006\u00117a\u0001!B\u0002\u0005\b!qA\u0002A\u0003\u0004\t\u000fAy\u0002\u0004\u0001\u0006\u0005\u0011\u001d\u0001BD\u0003\u0003\t\u000fAy\u0002B\u0001\r\u0006e\u0011Q!\u0001\u0005\u0004[A!\u0001\r\u0002M\u0006C\r)\u0011\u0001c\u0003\r\u0002U\u001b\u0001\"B\u0002\u0005\f%\t\u0001bB\u0007\u0004\t\u001fI\u0011\u0001C\u0004.\u001f\u0011\u0001G\u0001\u0007\u0003\"\u0005\u0015\t\u0001\u0002B+\u0004\u0011\u0015\u0019A\u0001B\u0005\u0002\u0011\u0013i1\u0001\u0002\u0005\n\u0003!%Q\u0006\u0005\u0003a\taE\u0011eA\u0003\u0002\u0011\u0017a\t!V\u0002\t\u000b\r!\t\"C\u0001\t\u000f5\u0019A!C\u0005\u0002\u0011\u001di\u0003\u0003\u00021\u00051'\t3!B\u0001\t\f1\u0005Qk\u0001\u0005\u0006\u0007\u0011M\u0011\"\u0001\u0005\b\u001b\r!!\"C\u0001\t\u000f5NA!\u0001M\u000bC\t)\u0011\u0001c\u0004R\u0007\r!)\"C\u0001\t\u00115VA!\u0001M\fC\r)\u0011\u0001#\u0005\r\u0002E\u001b1\u0001b\u0006\n\u0003!IQV\u0003\u0003\u000213\t3!B\u0001\t\f1\u0005\u0011kA\u0002\u0005\u001a%\t\u0001bBW\n\t!AR\"\t\u0002\u0006\u0003!M\u0011kA\u0002\u0005\u001b%\tA\u0001A\u0017\u0019\t\u0005)\"!B\u0001\t\u0015auQT\u0002\u0003\u0001\u0011=i!!B\u0001\t\u0016A\u001b\t!\t\u0002\u0006\u0003!M\u0011kA\u0004\u0005\u001e%\tA\u0001A\u0007\u0002\u0011-i\u0011\u0001c\u00066*\u0015\u001dBa9\u0001\u0019\bu5A\u0001\u0001\u0005\u0005\u001b\t)\u0011\u0001\u0003\u0003Q\u0007\u0001\t#!B\u0001\t\u0006E\u001bQ\u0001b\u0002\n\u0003\u0011\u0001Q\"\u0001E\u0005"})
public final class LambdaToFunctionExpression
implements DeprecatedSyntaxFix {
    public static final /* synthetic */ KClass $kotlinClass;
    @Nullable
    private final String functionLiteralArgumentName;
    @Nullable
    private final String receiverType;
    @Nullable
    private final String returnType;
    @NotNull
    private final JetFunctionLiteralExpression functionLiteralExpression;

    static {
        $kotlinClass = Reflection.createKotlinClass(LambdaToFunctionExpression.class);
    }

    @Nullable
    public final String getFunctionLiteralArgumentName() {
        return this.functionLiteralArgumentName;
    }

    @Nullable
    public final String getReceiverType() {
        return this.receiverType;
    }

    @Nullable
    public final String getReturnType() {
        return this.returnType;
    }

    @Override
    public void runFix() {
        PsiElement replacedFunctionExpression;
        if (!JetPsiUtil.isDeprecatedLambdaSyntax(this.functionLiteralExpression)) {
            return;
        }
        JetNamedFunction newFunctionExpression = this.createFunctionExpression();
        JetFunctionLiteralArgument literalArgument = this.getFunctionLiteralArgument();
        PsiElement psiElement = replacedFunctionExpression = literalArgument == null ? this.functionLiteralExpression.replace(newFunctionExpression) : (PsiElement)((JetValueArgument)KotlinPackage.last(CorePackage.moveInsideParenthesesAndReplaceWith(literalArgument, (JetExpression)newFunctionExpression, this.functionLiteralArgumentName).getValueArguments())).getArgumentExpression();
        if (psiElement == null) {
            throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetExpression");
        }
        JetExpression jetExpression = JetPsiUtil.deparenthesize((JetExpression)psiElement);
        if (jetExpression == null) {
            throw new TypeCastException("org.jetbrains.kotlin.psi.JetExpression! cannot be cast to org.jetbrains.kotlin.psi.JetNamedFunction");
        }
        JetNamedFunction functionExpression = (JetNamedFunction)jetExpression;
        ShortenReferences.process$default(ShortenReferences.Companion.getDEFAULT(), KotlinPackage.filterNotNull((Iterable)KotlinPackage.listOf((Object[])new JetTypeReference[]{functionExpression.getReceiverTypeReference(), functionExpression.getTypeReference()})), null, 2);
    }

    /*
     * WARNING - void declaration
     */
    private final JetFunctionLiteralArgument getFunctionLiteralArgument() {
        void $receiver;
        PsiElement psiElement = (PsiElement)this.functionLiteralExpression;
        boolean strict = false;
        JetFunctionLiteralArgument argument = (JetFunctionLiteralArgument)PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetFunctionLiteralArgument.class, (boolean)strict);
        if (argument != null && Intrinsics.areEqual((Object)argument.getFunctionLiteral(), (Object)this.functionLiteralExpression)) {
            return argument;
        }
        return null;
    }

    private final void replaceWithReturn(@JetValueParameter(name="$receiver") JetExpression $receiver, @JetValueParameter(name="psiFactory") JetPsiFactory psiFactory) {
        if ($receiver instanceof JetReturnExpression) {
            return;
        }
        $receiver.replace((PsiElement)PsiPackage.createExpressionByPattern(psiFactory, "return $0", $receiver));
    }

    /*
     * WARNING - void declaration
     */
    private final String getLambdaLabelName() {
        void $receiver;
        PsiElement psiElement = (PsiElement)this.functionLiteralExpression;
        boolean strict = false;
        JetLabeledExpression labeledExpression = (JetLabeledExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetLabeledExpression.class, (boolean)strict);
        if (labeledExpression != null && Intrinsics.areEqual((Object)JetPsiUtil.deparenthesize(labeledExpression.getBaseExpression()), (Object)this.functionLiteralExpression)) {
            return labeledExpression.getLabelName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final JetNamedFunction createFunctionExpression() {
        PsiElement psiElement;
        String string;
        StringBuilder stringBuilder;
        JetFunctionLiteral functionLiteral;
        JetPsiFactory psiFactory;
        block19: {
            block18: {
                String string2;
                String it;
                String $receiver;
                StringBuilder stringBuilder2;
                String string3;
                StringBuilder stringBuilder3;
                String parameterList2;
                String functionName;
                block17: {
                    block16: {
                        psiFactory = PsiPackage.JetPsiFactory((PsiElement)this.functionLiteralExpression);
                        functionLiteral = this.functionLiteralExpression.getFunctionLiteral();
                        functionName = this.getLambdaLabelName();
                        JetParameterList jetParameterList = functionLiteral.getValueParameterList();
                        parameterList2 = jetParameterList != null ? jetParameterList.getText() : null;
                        stringBuilder3 = new StringBuilder().append("fun ");
                        string3 = this.receiverType;
                        if (string3 == null) break block16;
                        String string4 = string3;
                        stringBuilder2 = stringBuilder3;
                        it = $receiver;
                        string2 = it + ".";
                        stringBuilder3 = stringBuilder2;
                        string3 = string2;
                        if (string3 != null) break block17;
                    }
                    string3 = "";
                }
                StringBuilder stringBuilder4 = stringBuilder3.append(string3);
                String string5 = functionName;
                if (string5 == null) {
                    string5 = "";
                }
                StringBuilder stringBuilder5 = stringBuilder4.append(string5);
                String string6 = parameterList2;
                if (string6 == null) {
                    string6 = "()";
                }
                stringBuilder = stringBuilder5.append(string6);
                string = this.returnType;
                if (string == null) break block18;
                $receiver = string;
                stringBuilder2 = stringBuilder;
                it = $receiver;
                string2 = ": " + it;
                stringBuilder = stringBuilder2;
                string = string2;
                if (string != null) break block19;
            }
            string = "";
        }
        String functionDeclaration = stringBuilder.append(string).toString();
        JetNamedFunction functionWithEmptyBody = psiFactory.createFunction(functionDeclaration + " {}");
        JetBlockExpression jetBlockExpression = functionLiteral.getBodyExpression();
        if (jetBlockExpression == null) {
            return functionWithEmptyBody;
        }
        JetBlockExpression blockExpression = jetBlockExpression;
        List<JetElement> statements = blockExpression.getStatements();
        if (statements.isEmpty()) {
            return functionWithEmptyBody;
        }
        if (statements.size() == 1) {
            return psiFactory.createFunction(functionDeclaration + " = " + ((JetElement)KotlinPackage.first(statements)).getText());
        }
        if (this.returnType != null) {
            Unit unit;
            void destination;
            void $receiver;
            void $receiver2;
            Iterable iterable = statements;
            void var10_12 = $receiver2;
            Collection collection = new ArrayList();
            for (Object element : $receiver) {
                if (!(element instanceof JetExpression)) continue;
                destination.add(element);
            }
            JetExpression jetExpression = (JetExpression)KotlinPackage.lastOrNull((List)((List)destination));
            if (jetExpression != null) {
                this.replaceWithReturn(jetExpression, psiFactory);
                unit = Unit.INSTANCE$;
            } else {
                unit = null;
            }
        }
        if ((psiElement = functionLiteral.getArrow()) == null) {
            psiElement = functionLiteral.getLBrace();
        }
        PsiElement fromElement = psiElement;
        PsiElement toElement = functionLiteral.getRBrace();
        String bodyText2 = KotlinPackage.joinToString$default((Sequence)KotlinPackage.map((Sequence)KotlinPackage.takeWhile((Sequence)PsiUtilPackage.siblings$default(fromElement, false, false, 1), (Function1)((Function1)new Function1<PsiElement, Boolean>(toElement){
            final /* synthetic */ PsiElement $toElement;

            public final boolean invoke(@JetValueParameter(name="it") @NotNull PsiElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)this.$toElement) ^ true;
            }
            {
                this.$toElement = psiElement;
                super(1);
            }
        })), (Function1)createFunctionExpression.bodyText.2.INSTANCE$), (String)"", null, null, (int)0, null, null, (int)62);
        return psiFactory.createFunction(functionDeclaration + "{ " + bodyText2 + "}");
    }

    @NotNull
    public final JetFunctionLiteralExpression getFunctionLiteralExpression() {
        return this.functionLiteralExpression;
    }

    /*
     * WARNING - void declaration
     */
    public LambdaToFunctionExpression(@JetValueParameter(name="functionLiteralExpression") @NotNull JetFunctionLiteralExpression functionLiteralExpression) {
        String string;
        String string2;
        JetType it;
        LambdaToFunctionExpression lambdaToFunctionExpression;
        void value22;
        Intrinsics.checkParameterIsNotNull((Object)functionLiteralExpression, (String)"functionLiteralExpression");
        this.functionLiteralExpression = functionLiteralExpression;
        BindingContext bindingContext2 = ResolvePackage.analyze$default(this.functionLiteralExpression, null, 1);
        JetType functionLiteralType = bindingContext2.getType(this.functionLiteralExpression);
        boolean bl = functionLiteralType != null && KotlinBuiltIns.isFunctionOrExtensionFunctionType(functionLiteralType);
        if (KotlinPackage.getASSERTIONS_ENABLED() && value22 == false) {
            String message = "Broken function type for expression: " + this.getFunctionLiteralExpression().getText() + ", at: " + DiagnosticUtils.atLocation(this.getFunctionLiteralExpression());
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        LambdaToFunctionExpression lambdaToFunctionExpression2 = this;
        JetType jetType = KotlinBuiltIns.getReceiverType(functionLiteralType);
        if (jetType != null) {
            void $receiver;
            JetType value22 = jetType;
            lambdaToFunctionExpression = lambdaToFunctionExpression2;
            it = (JetType)$receiver;
            string2 = IdeDescriptorRenderers.SOURCE_CODE.renderType(it);
            lambdaToFunctionExpression2 = lambdaToFunctionExpression;
            string = string2;
        } else {
            string = null;
        }
        lambdaToFunctionExpression2.receiverType = string;
        JetType $receiver = KotlinBuiltIns.getReturnTypeFromFunctionType(functionLiteralType);
        lambdaToFunctionExpression = this;
        it = $receiver;
        lambdaToFunctionExpression.returnType = string2 = KotlinBuiltIns.isUnit(it) ? (String)null : IdeDescriptorRenderers.SOURCE_CODE.renderType(it);
        JetFunctionLiteralArgument jetFunctionLiteralArgument = this.getFunctionLiteralArgument();
        this.functionLiteralArgumentName = jetFunctionLiteralArgument != null ? CorePackage.getFunctionLiteralArgumentName(jetFunctionLiteralArgument, bindingContext2) : null;
    }
}

