/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.PsiPackage;

public class MoveWhenElseBranchFix
extends JetIntentionAction<JetWhenExpression> {
    public MoveWhenElseBranchFix(@NotNull JetWhenExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/MoveWhenElseBranchFix", "<init>"));
        }
        super(element);
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("move.when.else.branch.to.the.end.action", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/MoveWhenElseBranchFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("move.when.else.branch.to.the.end.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/MoveWhenElseBranchFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/MoveWhenElseBranchFix", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        return JetPsiUtil.checkWhenExpressionHasSingleElse((JetWhenExpression)this.element);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/MoveWhenElseBranchFix", "invoke"));
        }
        JetWhenEntry elseEntry = null;
        JetWhenEntry lastEntry = null;
        for (JetWhenEntry entry : ((JetWhenExpression)this.element).getEntries()) {
            if (entry.isElse()) {
                elseEntry = entry;
            }
            lastEntry = entry;
        }
        assert (elseEntry != null) : "isAvailable should check whether there is only one else branch";
        int cursorOffset = editor.getCaretModel().getOffset() - elseEntry.getTextOffset();
        PsiElement insertedBranch = ((JetWhenExpression)this.element).addAfter((PsiElement)elseEntry, (PsiElement)lastEntry);
        ((JetWhenExpression)this.element).addAfter(PsiPackage.JetPsiFactory((PsiElement)file).createNewLine(), (PsiElement)lastEntry);
        ((JetWhenExpression)this.element).deleteChildRange((PsiElement)elseEntry, (PsiElement)elseEntry);
        JetWhenEntry insertedWhenEntry = (JetWhenEntry)CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)insertedBranch);
        editor.getCaretModel().moveToOffset(insertedWhenEntry.getTextOffset() + cursorOffset);
    }

    public static JetSingleIntentionActionFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public JetIntentionAction createAction(Diagnostic diagnostic) {
                PsiElement element = diagnostic.getPsiElement();
                JetWhenExpression whenExpression2 = (JetWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JetWhenExpression.class, (boolean)false);
                if (whenExpression2 == null) {
                    return null;
                }
                return new MoveWhenElseBranchFix(whenExpression2);
            }
        };
    }
}

