/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.util.ui.ColumnInfo;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetValVar;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetExpressionCodeFragment;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetTypeCodeFragment;
import org.jetbrains.kotlin.psi.PsiPackage;

public abstract class JetCallableParameterTableModel
extends ParameterTableModelBase<JetParameterInfo, ParameterTableModelItemBase<JetParameterInfo>> {
    private final Project project;
    private final JetMethodDescriptor methodDescriptor;

    protected JetCallableParameterTableModel(JetMethodDescriptor methodDescriptor, PsiElement context2, ColumnInfo ... columnInfos) {
        super(context2, context2, columnInfos);
        this.methodDescriptor = methodDescriptor;
        this.project = context2.getProject();
    }

    @Nullable
    public JetParameterInfo getReceiver() {
        return null;
    }

    protected ParameterTableModelItemBase<JetParameterInfo> createRowItem(@Nullable JetParameterInfo parameterInfo) {
        if (parameterInfo == null) {
            parameterInfo = new JetParameterInfo(this.methodDescriptor.getBaseDescriptor(), -1, "", null, null, null, JetValVar.None, null);
        }
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory(this.project);
        JetTypeCodeFragment paramTypeCodeFragment = psiFactory.createTypeCodeFragment(parameterInfo.getTypeText(), this.myTypeContext);
        JetExpression defaultValueForCall = parameterInfo.getDefaultValueForCall();
        JetExpressionCodeFragment defaultValueCodeFragment = psiFactory.createExpressionCodeFragment(defaultValueForCall != null ? defaultValueForCall.getText() : "", this.myDefaultValueContext);
        return new ParameterTableModelItemBase<JetParameterInfo>(parameterInfo, (PsiCodeFragment)paramTypeCodeFragment, (PsiCodeFragment)defaultValueCodeFragment){

            public boolean isEllipsisType() {
                return false;
            }
        };
    }

    public static boolean isTypeColumn(ColumnInfo column) {
        return column instanceof ParameterTableModelBase.TypeColumn;
    }

    public static boolean isNameColumn(ColumnInfo column) {
        return column instanceof ParameterTableModelBase.NameColumn;
    }

    public static boolean isDefaultValueColumn(ColumnInfo column) {
        return column instanceof ParameterTableModelBase.DefaultValueColumn;
    }
}

