/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.structureView;

import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.structureView.JetStructureViewElement;
import org.jetbrains.kotlin.idea.structureView.KotlinInheritedMembersNodeProvider;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;

public class JetStructureViewModel
extends StructureViewModelBase {
    private static final Collection<NodeProvider> NODE_PROVIDERS = Arrays.asList(new NodeProvider[]{new KotlinInheritedMembersNodeProvider()});
    private static final Sorter[] sorters = new Sorter[]{Sorter.ALPHA_SORTER};

    public JetStructureViewModel(@NotNull JetFile jetFile) {
        if (jetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetFile", "org/jetbrains/kotlin/idea/structureView/JetStructureViewModel", "<init>"));
        }
        super((PsiFile)jetFile, (StructureViewTreeElement)new JetStructureViewElement(jetFile));
        this.withSuitableClasses(new Class[]{JetDeclaration.class});
    }

    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        Collection<NodeProvider> collection = NODE_PROVIDERS;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/JetStructureViewModel", "getNodeProviders"));
        }
        return collection;
    }

    @NotNull
    public Sorter[] getSorters() {
        if (sorters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/JetStructureViewModel", "getSorters"));
        }
        return sorters;
    }
}

