/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifiableCodeBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetTypeParameterList;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.JetWithExpressionInitializer;
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersPackage;

public class JetNamedFunction
extends JetTypeParameterListOwnerStub<KotlinFunctionStub>
implements JetFunction,
JetWithExpressionInitializer,
PsiModifiableCodeBlock {
    public JetNamedFunction(@NotNull ASTNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetNamedFunction", "<init>"));
        }
        super(node2);
    }

    public JetNamedFunction(@NotNull KotlinFunctionStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetNamedFunction", "<init>"));
        }
        super(stub, JetStubElementTypes.FUNCTION);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetNamedFunction", "accept"));
        }
        return visitor2.visitNamedFunction(this, data2);
    }

    public boolean hasTypeParameterListBeforeFunctionName() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (stub != null) {
            return stub.hasTypeParameterListBeforeFunctionName();
        }
        return this.hasTypeParameterListBeforeFunctionNameByTree();
    }

    private boolean hasTypeParameterListBeforeFunctionNameByTree() {
        JetTypeParameterList typeParameterList = this.getTypeParameterList();
        if (typeParameterList == null) {
            return false;
        }
        PsiElement nameIdentifier = this.getNameIdentifier();
        if (nameIdentifier == null) {
            return true;
        }
        return nameIdentifier.getTextOffset() > typeParameterList.getTextOffset();
    }

    @Override
    public boolean hasBlockBody() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (stub != null) {
            return stub.hasBlockBody();
        }
        return this.getEqualsToken() == null;
    }

    @IfNotParsed
    @Nullable
    public PsiElement getFunKeyword() {
        return this.findChildByType(JetTokens.FUN_KEYWORD);
    }

    @Override
    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(JetTokens.EQ);
    }

    @Override
    @Nullable
    public JetExpression getInitializer() {
        return (JetExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)this.getEqualsToken(), JetExpression.class);
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @Override
    @Nullable
    public JetParameterList getValueParameterList() {
        return (JetParameterList)this.getStubOrPsiChild(JetStubElementTypes.VALUE_PARAMETER_LIST);
    }

    @Override
    @NotNull
    public List<JetParameter> getValueParameters() {
        JetParameterList list = this.getValueParameterList();
        List<JetParameter> list2 = list != null ? list.getParameters() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetNamedFunction", "getValueParameters"));
        }
        return list2;
    }

    @Override
    @Nullable
    public JetExpression getBodyExpression() {
        return (JetExpression)this.findChildByClass(JetExpression.class);
    }

    @Override
    public boolean hasBody() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (stub != null) {
            return stub.hasBody();
        }
        return this.getBodyExpression() != null;
    }

    @Override
    public boolean hasDeclaredReturnType() {
        return this.getTypeReference() != null;
    }

    @Override
    @Nullable
    public JetTypeReference getReceiverTypeReference() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (stub != null) {
            if (!stub.isExtension()) {
                return null;
            }
            List childTypeReferences = this.getStubOrPsiChildrenAsList(JetStubElementTypes.TYPE_REFERENCE);
            if (!childTypeReferences.isEmpty()) {
                return (JetTypeReference)childTypeReferences.get(0);
            }
            return null;
        }
        return this.getReceiverTypeRefByTree();
    }

    @Nullable
    private JetTypeReference getReceiverTypeRefByTree() {
        IElementType tt;
        for (PsiElement child = this.getFirstChild(); child != null && (tt = child.getNode().getElementType()) != JetTokens.LPAR && tt != JetTokens.COLON; child = child.getNextSibling()) {
            if (!(child instanceof JetTypeReference)) continue;
            return (JetTypeReference)child;
        }
        return null;
    }

    @Override
    @Nullable
    public JetTypeReference getTypeReference() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getStub();
        if (stub != null) {
            int returnTypeIndex;
            List typeReferences = this.getStubOrPsiChildrenAsList(JetStubElementTypes.TYPE_REFERENCE);
            int n = returnTypeIndex = stub.isExtension() ? 1 : 0;
            if (returnTypeIndex >= typeReferences.size()) {
                return null;
            }
            return (JetTypeReference)typeReferences.get(returnTypeIndex);
        }
        return TypeRefHelpersPackage.getTypeReference(this);
    }

    @Override
    @Nullable
    public JetTypeReference setTypeReference(@Nullable JetTypeReference typeRef) {
        return TypeRefHelpersPackage.setTypeReference(this, (PsiElement)this.getValueParameterList(), typeRef);
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(JetTokens.COLON);
    }

    @Override
    public boolean isLocal() {
        PsiElement parent = this.getParent();
        return !(parent instanceof JetFile) && !(parent instanceof JetClassBody);
    }

    public boolean shouldChangeModificationCount(PsiElement place) {
        return false;
    }
}

