/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

class InlineChecker
implements CallChecker {
    private final SimpleFunctionDescriptor descriptor;
    private final Set<CallableDescriptor> inlinableParameters;
    private final boolean isEffectivelyPublicApiFunction;

    public InlineChecker(@NotNull SimpleFunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "<init>"));
        }
        this.inlinableParameters = new LinkedHashSet<CallableDescriptor>();
        assert (InlineUtil.isInline(descriptor2)) : "This extension should be created only for inline functions: " + descriptor2;
        this.descriptor = descriptor2;
        this.isEffectivelyPublicApiFunction = DescriptorUtilPackage.getIsEffectivelyPublicApi(descriptor2);
        for (ValueParameterDescriptor param : descriptor2.getValueParameters()) {
            if (!InlineChecker.isInlinableParameter(param)) continue;
            this.inlinableParameters.add(param);
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null && InlineChecker.isInlinableParameter(receiverParameter)) {
            this.inlinableParameters.add(receiverParameter);
        }
    }

    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context2) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "check"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "check"));
        }
        JetExpression expression2 = context2.call.getCalleeExpression();
        if (expression2 == null) {
            return;
        }
        F targetDescriptor = resolvedCall.getResultingDescriptor();
        this.checkCallWithReceiver(context2, (CallableDescriptor)targetDescriptor, resolvedCall.getDispatchReceiver(), expression2);
        this.checkCallWithReceiver(context2, (CallableDescriptor)targetDescriptor, resolvedCall.getExtensionReceiver(), expression2);
        if (this.inlinableParameters.contains(targetDescriptor) && !InlineChecker.isInsideCall(expression2)) {
            context2.trace.report(Errors.USAGE_IS_NOT_INLINABLE.on(expression2, expression2, this.descriptor));
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCall.getValueArguments().entrySet()) {
            ResolvedValueArgument value2 = entry.getValue();
            ValueParameterDescriptor valueDescriptor = entry.getKey();
            if (value2 instanceof DefaultValueArgument) continue;
            for (ValueArgument argument : value2.getArguments()) {
                this.checkValueParameter(context2, (CallableDescriptor)targetDescriptor, argument, valueDescriptor);
            }
        }
        this.checkVisibility((CallableDescriptor)targetDescriptor, expression2, context2);
        this.checkRecursion(context2, (CallableDescriptor)targetDescriptor, expression2);
    }

    private static boolean isInsideCall(JetExpression expression2) {
        JetToken token;
        JetExpression parent = JetPsiUtil.getParentCallIfPresent(expression2);
        if (parent instanceof JetBinaryExpression && ((token = JetPsiUtil.getOperationToken((JetOperationExpression)parent)) == JetTokens.EQ || token == JetTokens.ANDAND || token == JetTokens.OROR)) {
            return false;
        }
        return parent != null;
    }

    private void checkValueParameter(@NotNull BasicCallResolutionContext context2, @NotNull CallableDescriptor targetDescriptor, @NotNull ValueArgument targetArgument, @NotNull ValueParameterDescriptor targetParameterDescriptor) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        if (targetArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetArgument", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        if (targetParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetParameterDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        JetExpression argumentExpression = targetArgument.getArgumentExpression();
        if (argumentExpression == null) {
            return;
        }
        CallableDescriptor argumentCallee = InlineChecker.getCalleeDescriptor(context2, argumentExpression, false);
        if (argumentCallee != null && this.inlinableParameters.contains(argumentCallee)) {
            if (InlineUtil.isInline(targetDescriptor) && InlineChecker.isInlinableParameter(targetParameterDescriptor)) {
                if (InlineUtil.allowsNonLocalReturns(argumentCallee) && !InlineUtil.allowsNonLocalReturns(targetParameterDescriptor)) {
                    context2.trace.report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on(argumentExpression, argumentExpression, argumentCallee, this.descriptor));
                } else {
                    this.checkNonLocalReturn(context2, argumentCallee, argumentExpression);
                }
            } else {
                context2.trace.report(Errors.USAGE_IS_NOT_INLINABLE.on(argumentExpression, argumentExpression, this.descriptor));
            }
        }
    }

    private void checkCallWithReceiver(@NotNull BasicCallResolutionContext context2, @NotNull CallableDescriptor targetDescriptor, @NotNull ReceiverValue receiver, @Nullable JetExpression expression2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkCallWithReceiver"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkCallWithReceiver"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkCallWithReceiver"));
        }
        if (!receiver.exists()) {
            return;
        }
        CallableDescriptor varDescriptor = null;
        JetExpression receiverExpression = null;
        if (receiver instanceof ExpressionReceiver) {
            receiverExpression = ((ExpressionReceiver)receiver).getExpression();
            varDescriptor = InlineChecker.getCalleeDescriptor(context2, receiverExpression, true);
        } else if (receiver instanceof ExtensionReceiver) {
            ExtensionReceiver extensionReceiver = (ExtensionReceiver)receiver;
            CallableDescriptor extension = extensionReceiver.getDeclarationDescriptor();
            varDescriptor = extension.getExtensionReceiverParameter();
            assert (varDescriptor != null) : "Extension should have receiverParameterDescriptor: " + extension;
            receiverExpression = expression2;
        }
        if (this.inlinableParameters.contains(varDescriptor)) {
            this.checkLambdaInvokeOrExtensionCall(context2, varDescriptor, targetDescriptor, receiverExpression);
        }
    }

    @Nullable
    private static CallableDescriptor getCalleeDescriptor(@NotNull BasicCallResolutionContext context2, @NotNull JetExpression expression2, boolean unwrapVariableAsFunction) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "getCalleeDescriptor"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "getCalleeDescriptor"));
        }
        if (!(expression2 instanceof JetSimpleNameExpression) && !(expression2 instanceof JetThisExpression)) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> thisCall = CallUtilPackage.getResolvedCall(expression2, context2.trace.getBindingContext());
        if (unwrapVariableAsFunction && thisCall instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)((Object)thisCall)).getVariableCall().getResultingDescriptor();
        }
        return thisCall != null ? thisCall.getResultingDescriptor() : null;
    }

    private void checkLambdaInvokeOrExtensionCall(@NotNull BasicCallResolutionContext context2, @NotNull CallableDescriptor lambdaDescriptor, @NotNull CallableDescriptor callDescriptor, @NotNull JetExpression receiverExpression) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        if (lambdaDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        if (callDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        if (receiverExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverExpression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        boolean inlinableCall = InlineChecker.isInvokeOrInlineExtension(callDescriptor);
        if (!inlinableCall) {
            context2.trace.report(Errors.USAGE_IS_NOT_INLINABLE.on(receiverExpression, receiverExpression, this.descriptor));
        } else {
            this.checkNonLocalReturn(context2, lambdaDescriptor, receiverExpression);
        }
    }

    public void checkRecursion(@NotNull BasicCallResolutionContext context2, @NotNull CallableDescriptor targetDescriptor, @NotNull JetElement expression2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkRecursion"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkRecursion"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkRecursion"));
        }
        if (targetDescriptor.getOriginal() == this.descriptor) {
            context2.trace.report(Errors.RECURSION_IN_INLINE.on(expression2, expression2, this.descriptor));
        }
    }

    private static boolean isInlinableParameter(@NotNull ParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "isInlinableParameter"));
        }
        return InlineUtil.isInlineLambdaParameter(descriptor2) && !descriptor2.getType().isMarkedNullable();
    }

    private static boolean isInvokeOrInlineExtension(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "isInvokeOrInlineExtension"));
        }
        if (!(descriptor2 instanceof SimpleFunctionDescriptor)) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        boolean isInvoke = descriptor2.getName().equals(OperatorConventions.INVOKE) && containingDeclaration instanceof ClassDescriptor && KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(((ClassDescriptor)containingDeclaration).getDefaultType());
        return isInvoke || InlineUtil.isInline(descriptor2);
    }

    private void checkVisibility(@NotNull CallableDescriptor declarationDescriptor, @NotNull JetElement expression2, @NotNull BasicCallResolutionContext context2) {
        boolean declarationDescriptorIsPublicApi;
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkVisibility"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkVisibility"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkVisibility"));
        }
        boolean bl = declarationDescriptorIsPublicApi = DescriptorUtilPackage.getIsEffectivelyPublicApi(declarationDescriptor) || this.isDefinedInInlineFunction(declarationDescriptor);
        if (this.isEffectivelyPublicApiFunction && !declarationDescriptorIsPublicApi && declarationDescriptor.getVisibility() != Visibilities.LOCAL) {
            context2.trace.report(Errors.INVISIBLE_MEMBER_FROM_INLINE.on(expression2, declarationDescriptor, this.descriptor));
        }
    }

    private boolean isDefinedInInlineFunction(@NotNull DeclarationDescriptorWithVisibility startDescriptor) {
        if (startDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "isDefinedInInlineFunction"));
        }
        DeclarationDescriptorWithVisibility parent = startDescriptor;
        while (parent != null) {
            if (parent.getContainingDeclaration() == this.descriptor) {
                return true;
            }
            parent = DescriptorUtils.getParentOfType(parent, DeclarationDescriptorWithVisibility.class);
        }
        return false;
    }

    private void checkNonLocalReturn(@NotNull BasicCallResolutionContext context2, @NotNull CallableDescriptor inlinableParameterDescriptor, @NotNull JetExpression parameterUsage) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkNonLocalReturn"));
        }
        if (inlinableParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlinableParameterDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkNonLocalReturn"));
        }
        if (parameterUsage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterUsage", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkNonLocalReturn"));
        }
        if (!InlineUtil.allowsNonLocalReturns(inlinableParameterDescriptor)) {
            return;
        }
        if (!InlineUtil.checkNonLocalReturnUsage(this.descriptor, parameterUsage, context2.trace)) {
            context2.trace.report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on(parameterUsage, parameterUsage, inlinableParameterDescriptor, this.descriptor));
        }
    }
}

