/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.kotlinSignature;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.components.ExternalAnnotationResolver;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationOwner;
import org.jetbrains.kotlin.load.java.structure.JavaLiteralAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaMember;
import org.jetbrains.kotlin.name.FqName;

public class SignaturesUtil {
    private SignaturesUtil() {
    }

    @Nullable
    public static String getKotlinSignature(@NotNull ExternalAnnotationResolver externalAnnotationResolver, @NotNull JavaMember member) {
        if (externalAnnotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalAnnotationResolver", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesUtil", "getKotlinSignature"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesUtil", "getKotlinSignature"));
        }
        JavaAnnotation newAnnotation = SignaturesUtil.findAnnotationWithExternal(externalAnnotationResolver, member, JvmAnnotationNames.KOTLIN_SIGNATURE);
        if (newAnnotation != null) {
            return SignaturesUtil.extractKotlinSignatureArgument(newAnnotation);
        }
        JavaAnnotation oldAnnotation = SignaturesUtil.findAnnotationWithExternal(externalAnnotationResolver, member, JvmAnnotationNames.OLD_KOTLIN_SIGNATURE);
        if (oldAnnotation != null) {
            return SignaturesUtil.extractKotlinSignatureArgument(oldAnnotation);
        }
        return null;
    }

    @Nullable
    private static String extractKotlinSignatureArgument(@NotNull JavaAnnotation annotation2) {
        Object value2;
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesUtil", "extractKotlinSignatureArgument"));
        }
        JavaAnnotationArgument argument = annotation2.findArgument(JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME);
        if (argument instanceof JavaLiteralAnnotationArgument && (value2 = ((JavaLiteralAnnotationArgument)argument).getValue()) instanceof String) {
            return StringUtil.unescapeStringCharacters((String)((String)value2));
        }
        return null;
    }

    @Nullable
    public static JavaAnnotation findAnnotationWithExternal(@NotNull ExternalAnnotationResolver externalAnnotationResolver, @NotNull JavaAnnotationOwner owner, @NotNull FqName name2) {
        if (externalAnnotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalAnnotationResolver", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesUtil", "findAnnotationWithExternal"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesUtil", "findAnnotationWithExternal"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesUtil", "findAnnotationWithExternal"));
        }
        JavaAnnotation annotation2 = owner.findAnnotation(name2);
        if (annotation2 != null) {
            return annotation2;
        }
        return externalAnnotationResolver.findExternalAnnotation(owner, name2);
    }
}

